/*
 * Decompiled with CFR 0.152.
 */
package com.xm.activity.main.devlist.adapter;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;
import com.manager.db.DevDataCenter;
import com.manager.db.XMDevInfo;
import com.xm.activity.main.devlist.contract.XMDeviceListContract;
import com.xm.ui.widget.ListSelectItem;
import demo.xm.com.libxmfunsdk.R;
import java.util.List;

public class XMDeviceListAdapter
extends RecyclerView.Adapter<ViewHolder> {
    private List<String> devList;
    private XMDeviceListContract.IXMDeviceListView ixmDeviceListView;

    public XMDeviceListAdapter(XMDeviceListContract.IXMDeviceListView ixmDeviceListView) {
        this.ixmDeviceListView = ixmDeviceListView;
    }

    @NonNull
    public ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        return new ViewHolder(LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.funsdk_xm_adapter_dev_list, parent, false));
    }

    public void onBindViewHolder(@NonNull ViewHolder holder, int position) {
        String devId = this.devList.get(position);
        XMDevInfo xmDevInfo = DevDataCenter.getInstance().getDevInfo(devId);
        if (xmDevInfo != null) {
            holder.lsiDevInfo.setTitle(xmDevInfo.getDevName());
            holder.lsiDevInfo.setTip(xmDevInfo.getDevId());
            holder.lsiDevInfo.setRightText((CharSequence)("\u5728\u7ebf\u72b6\u6001:" + xmDevInfo.getDevState()));
        }
    }

    public int getItemCount() {
        return this.devList == null ? 0 : this.devList.size();
    }

    public void setData(List<String> devList) {
        this.devList = devList;
        this.notifyDataSetChanged();
    }

    class ViewHolder
    extends RecyclerView.ViewHolder {
        ListSelectItem lsiDevInfo;

        public ViewHolder(View itemView) {
            super(itemView);
            this.lsiDevInfo = (ListSelectItem)itemView.findViewById(R.id.lsi_dev_info);
            this.lsiDevInfo.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    String devId = (String)XMDeviceListAdapter.this.devList.get(ViewHolder.this.getAdapterPosition());
                    XMDeviceListAdapter.this.ixmDeviceListView.onDevItemClick(v, devId, ViewHolder.this.getAdapterPosition());
                }
            });
        }
    }
}

