/*
 * Decompiled with CFR 0.152.
 */
package com.xm.activity.device.devset.ability.view;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.xm.activity.base.XMBaseActivity;
import com.xm.activity.device.devset.ability.contract.XMDevAbilityContract;
import com.xm.activity.device.devset.ability.data.AbilityInfo;
import com.xm.activity.device.devset.ability.presenter.XMDevAbilityPresenter;
import com.xm.ui.widget.ListSelectItem;
import com.xm.ui.widget.XTitleBar;
import demo.xm.com.libxmfunsdk.R;

public class XMDevAbilityActivity
extends XMBaseActivity<XMDevAbilityPresenter>
implements XMDevAbilityContract.IXMDevAbilityView {
    private XTitleBar xTitleBar;
    private RecyclerView rvDevAbility;
    private DevAbilityAdapter devAbilityAdapter;

    @Override
    public XMDevAbilityPresenter getPresenter() {
        return new XMDevAbilityPresenter(this);
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.funsdk_xm_activity_dev_ability);
        this.initView();
        this.initData();
    }

    private void initView() {
        this.xTitleBar = (XTitleBar)this.findViewById(R.id.xb_dev_ability_title);
        this.xTitleBar.setLeftClick((XTitleBar.OnLeftClickListener)this);
        this.rvDevAbility = (RecyclerView)this.findViewById(R.id.rv_dev_ability);
        this.rvDevAbility.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager((Context)this));
        this.showWaitDialog();
        ((XMDevAbilityPresenter)this.presenter).updateDevAbility();
    }

    private void initData() {
        this.devAbilityAdapter = new DevAbilityAdapter();
        this.rvDevAbility.setAdapter((RecyclerView.Adapter)this.devAbilityAdapter);
    }

    @Override
    public void onUpdateDevAbilityResult(boolean isSuccess) {
        this.hideWaitDialog();
        if (isSuccess) {
            this.devAbilityAdapter.notifyDataSetChanged();
        }
    }

    @Override
    public Activity getActivity() {
        return this;
    }

    class DevAbilityAdapter
    extends RecyclerView.Adapter<ViewHodler> {
        DevAbilityAdapter() {
        }

        @NonNull
        public ViewHodler onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
            return new ViewHodler(LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.funsdk_xm_adapter_dev_ability, null));
        }

        public void onBindViewHolder(@NonNull ViewHodler holder, int position) {
            AbilityInfo abilityInfo = ((XMDevAbilityPresenter)XMDevAbilityActivity.this.presenter).getAbilityEnable(position);
            if (abilityInfo != null) {
                holder.lstDevAbility.setTitle(abilityInfo.getChildName());
                holder.lstDevAbility.setRightText((CharSequence)(abilityInfo.isEnable() + ""));
                holder.lstDevAbility.setTip(abilityInfo.getParentName());
            }
        }

        public int getItemCount() {
            return ((XMDevAbilityPresenter)XMDevAbilityActivity.this.presenter).getAbilityCount();
        }

        class ViewHodler
        extends RecyclerView.ViewHolder {
            ListSelectItem lstDevAbility;

            public ViewHodler(View itemView) {
                super(itemView);
                this.lstDevAbility = (ListSelectItem)itemView.findViewById(R.id.list_dev_ability);
            }
        }
    }
}

