/*
 * Decompiled with CFR 0.152.
 */
package com.xm.activity.base;

import android.app.Activity;
import android.app.ActivityOptions;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.widget.ArrayAdapter;
import android.widget.CheckBox;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.SeekBar;
import android.widget.Spinner;
import android.widget.SpinnerAdapter;
import android.widget.Toast;
import androidx.annotation.Nullable;
import androidx.fragment.app.Fragment;
import com.lib.FunSDK;
import com.manager.XMFunSDKManager;
import com.manager.base.BaseManager;
import com.utils.StatusBarUtils;
import com.utils.XUtils;
import com.xm.activity.base.XMBaseActivity;
import com.xm.activity.base.XMBasePresenter;
import com.xm.ui.widget.ImageCheckObject;
import com.xm.ui.widget.SpinnerSelectItem;
import com.xm.ui.widget.dialog.LoadingDialog;
import com.xm.ui.widget.icseelogoview.animcontroller.ICSeeLogoAnimController;
import demo.xm.com.libxmfunsdk.R;
import java.io.Serializable;
import pl.droidsonroids.gif.GifImageView;

public abstract class XMBaseFragment<T extends XMBasePresenter>
extends Fragment {
    protected T presenter;
    protected View rootLayout;
    private LoadingDialog waitDialog = null;
    protected int screenWidth;
    protected int screenHeight;

    public abstract T getPresenter();

    public XMBaseFragment() {
        this.initPresenter();
    }

    public void onAttach(Context context) {
        super.onAttach(context);
        this.initPresenter();
    }

    private void initPresenter() {
        if (this.presenter == null) {
            this.presenter = this.getPresenter();
            if (this.presenter == null) {
                class SimplePresenter
                extends XMBasePresenter {
                    SimplePresenter() {
                    }

                    protected BaseManager getManager() {
                        return null;
                    }
                }
                this.presenter = new SimplePresenter();
            }
        }
    }

    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.screenWidth = XUtils.getScreenWidth((Activity)this.getActivity());
        this.screenHeight = XUtils.getScreenHeight((Activity)this.getActivity());
        ((XMBasePresenter)this.presenter).setLifeCycle(XMBasePresenter.LIFE_CYCLE.CREATE);
    }

    @Nullable
    public View onCreateView(LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        if (XMFunSDKManager.getInstance().isXMStatusBar()) {
            this.initStatusBar();
        }
        return this.rootLayout;
    }

    public void onResume() {
        super.onResume();
        ((XMBasePresenter)this.presenter).setLifeCycle(XMBasePresenter.LIFE_CYCLE.START);
    }

    public void onPause() {
        super.onPause();
        ((XMBasePresenter)this.presenter).setLifeCycle(XMBasePresenter.LIFE_CYCLE.STOP);
    }

    public void onStop() {
        super.onStop();
        ((XMBasePresenter)this.presenter).setLifeCycle(XMBasePresenter.LIFE_CYCLE.STOP);
        this.hideLoadingDlg();
    }

    public void onDestroy() {
        super.onDestroy();
        ((XMBasePresenter)this.presenter).setLifeCycle(XMBasePresenter.LIFE_CYCLE.DESTROY);
    }

    protected void showToast(String content, int duration) {
        if (this.getActivity() instanceof XMBaseActivity) {
            ((XMBaseActivity)this.getActivity()).showToast(content, duration);
        } else if (this.getContext() != null) {
            Toast.makeText((Context)this.getContext(), (CharSequence)content, (int)duration).show();
        }
    }

    protected String translation(String content) {
        if (this.getActivity() instanceof XMBaseActivity) {
            ((XMBaseActivity)this.getActivity()).translation(content);
        }
        return FunSDK.TS((String)content);
    }

    public void turnToActivity(Class _class, View view) {
        Intent intent = new Intent(this.getContext(), _class);
        if (this.presenter != null) {
            intent.putExtra("devId", ((XMBasePresenter)this.presenter).getDevId());
        }
        if (view != null) {
            view.setTransitionName(_class.getSimpleName());
            ActivityOptions activityOptions = ActivityOptions.makeSceneTransitionAnimation((Activity)this.getActivity(), (View)view, (String)_class.getSimpleName());
            this.startActivity(intent, activityOptions.toBundle());
        } else {
            this.startActivity(intent);
        }
    }

    public void turnToActivity(Class _class) {
        Intent intent = new Intent(this.getContext(), _class);
        if (this.presenter != null) {
            intent.putExtra("devId", ((XMBasePresenter)this.presenter).getDevId());
        }
        this.startActivity(intent);
    }

    public void turnToActivity(Class _class, Bundle data) {
        Intent intent = new Intent(this.getContext(), _class);
        intent.putExtras(data);
        if (this.presenter != null) {
            intent.putExtra("devId", ((XMBasePresenter)this.presenter).getDevId());
        }
        this.startActivity(intent);
    }

    public void turnToActivity(Class _class, String key, Bundle data) {
        if (this.getActivity() instanceof XMBaseActivity) {
            ((XMBaseActivity)this.getActivity()).turnToActivity(_class, key, data);
        } else {
            Intent intent = new Intent(this.getContext(), _class);
            intent.putExtra(key, data);
            if (this.presenter != null) {
                intent.putExtra("devId", ((XMBasePresenter)this.presenter).getDevId());
            }
            this.startActivity(intent);
        }
    }

    public void turnToActivity(Class _class, Object[][] objects) {
        Intent intent = new Intent((Context)this.getActivity(), _class);
        if (objects != null) {
            for (int i = 0; i < objects.length; ++i) {
                if (objects[i][1] instanceof Integer) {
                    intent.putExtra((String)objects[i][0], (Serializable)((Integer)objects[i][1]));
                    continue;
                }
                if (objects[i][1] instanceof String) {
                    intent.putExtra((String)objects[i][0], (String)objects[i][1]);
                    continue;
                }
                if (objects[i][1] instanceof Boolean) {
                    intent.putExtra((String)objects[i][0], (Serializable)((Boolean)objects[i][1]));
                    continue;
                }
                if (objects[i][1] instanceof Double) {
                    intent.putExtra((String)objects[i][0], (Serializable)((Double)objects[i][1]));
                    continue;
                }
                if (!(objects[i][1] instanceof Float)) continue;
                intent.putExtra((String)objects[i][0], (Serializable)((Float)objects[i][1]));
            }
        }
        if (this.presenter != null) {
            intent.putExtra("devId", ((XMBasePresenter)this.presenter).getDevId());
        }
        this.startActivity(intent);
    }

    public void showLoadingDlg() {
        if (this.getActivity() instanceof XMBaseActivity) {
            ((XMBaseActivity)this.getActivity()).showWaitDialog();
        } else {
            try {
                ICSeeLogoAnimController iAnimController = new ICSeeLogoAnimController();
                iAnimController.createAnim((View)new GifImageView(this.getContext()));
                this.waitDialog = LoadingDialog.getInstance((Context)this.getContext());
                this.waitDialog.setPromptTextColor(this.getResources().getColor(R.color.default_normal_text_color));
                this.waitDialog.setCancelable(true);
                this.waitDialog.show(this.getActivity().getString(R.string.waiting));
            }
            catch (NoClassDefFoundError e) {
                e.printStackTrace();
            }
        }
    }

    public void hideLoadingDlg() {
        if (this.getActivity() instanceof XMBaseActivity) {
            ((XMBaseActivity)this.getActivity()).hideWaitDialog();
        } else if (this.waitDialog != null) {
            this.waitDialog.dismiss();
        }
    }

    protected ViewGroup getRootLayout() {
        View v;
        if (this.rootLayout == null && (v = this.getActivity().getCurrentFocus()) != null) {
            ViewParent vp = v.getParent();
            if (vp == null) {
                this.rootLayout = (ViewGroup)v;
            } else {
                this.rootLayout = (ViewGroup)vp;
                while ((vp = vp.getParent()) != null) {
                    this.rootLayout = (ViewGroup)vp;
                }
            }
        }
        return (ViewGroup)this.rootLayout;
    }

    protected int getViewIntValue(int id2) {
        View v = this.rootLayout.findViewById(id2);
        return this.getViewIntValue(v);
    }

    protected int getViewIntValue(View v) {
        if (v == null) {
            return 0;
        }
        if (v instanceof EditText) {
            EditText v0 = (EditText)v;
            return Integer.valueOf(v0.getText().toString());
        }
        if (v instanceof CheckBox) {
            CheckBox v0 = (CheckBox)v;
            return v0.isChecked() ? 1 : 0;
        }
        if (v instanceof SeekBar) {
            SeekBar v0 = (SeekBar)v;
            return v0.getProgress();
        }
        if (v instanceof ImageView) {
            Object iv = v.getTag();
            if (iv instanceof ImageCheckObject) {
                return ((ImageCheckObject)iv).GetValue();
            }
        } else if (v instanceof Spinner) {
            Spinner sp = (Spinner)v;
            Object iv = v.getTag();
            if (iv != null && iv instanceof int[]) {
                int[] values = (int[])iv;
                int i = sp.getSelectedItemPosition();
                if (i >= 0 && i < values.length) {
                    return values[i];
                }
                return 0;
            }
        }
        return 0;
    }

    protected int initSpinnerText(int id2, String[] texts, int[] values) {
        if (this.rootLayout == null) {
            return 0;
        }
        ArrayAdapter adapter = new ArrayAdapter((Context)this.getActivity(), 17367048, (Object[])texts);
        adapter.setDropDownViewResource(0x1090009);
        View view = this.rootLayout.findViewById(id2);
        Spinner sp = view instanceof SpinnerSelectItem ? ((SpinnerSelectItem)view).getSpinner() : (Spinner)view;
        sp.setAdapter((SpinnerAdapter)adapter);
        if (values == null) {
            values = new int[texts.length];
            for (int i = 0; i < texts.length; ++i) {
                values[i] = i;
            }
        }
        sp.setTag((Object)values);
        return 0;
    }

    protected int initSpinnerText(View view, String[] texts, int[] values) {
        ArrayAdapter adapter = new ArrayAdapter((Context)this.getActivity(), 17367048, (Object[])texts);
        adapter.setDropDownViewResource(0x1090009);
        Spinner sp = view instanceof SpinnerSelectItem ? ((SpinnerSelectItem)view).getSpinner() : (Spinner)view;
        sp.setAdapter((SpinnerAdapter)adapter);
        if (values == null) {
            values = new int[texts.length];
            for (int i = 0; i < texts.length; ++i) {
                values[i] = i;
            }
        }
        sp.setTag((Object)values);
        return 0;
    }

    protected int setViewValue(int id2, int value) {
        View v = this.rootLayout.findViewById(id2);
        if (v == null) {
            return 0;
        }
        if (v instanceof EditText) {
            EditText v0 = (EditText)v;
            v0.setText((CharSequence)String.valueOf(value));
        } else if (v instanceof CheckBox) {
            CheckBox v0 = (CheckBox)v;
            v0.setChecked(value != 1);
        } else if (v instanceof SeekBar) {
            SeekBar v0 = (SeekBar)v;
            v0.setProgress(value);
        } else if (v instanceof ImageView) {
            Object iv = v.getTag();
            if (iv instanceof ImageCheckObject) {
                ((ImageCheckObject)iv).SetValue((ImageView)v, value);
            }
        } else if (v instanceof Spinner) {
            Spinner sp = (Spinner)v;
            Object iv = v.getTag();
            if (iv != null && iv instanceof int[]) {
                int[] values = (int[])iv;
                for (int i = 0; i < values.length; ++i) {
                    if (value != values[i]) continue;
                    sp.setSelection(i);
                    break;
                }
            }
        } else {
            System.err.println("SetIntValue:" + id2);
            return -1;
        }
        return 0;
    }

    protected int setViewValue(View v, int value) {
        if (v == null) {
            return 0;
        }
        if (v instanceof EditText) {
            EditText v0 = (EditText)v;
            v0.setText((CharSequence)String.valueOf(value));
        } else if (v instanceof CheckBox) {
            CheckBox v0 = (CheckBox)v;
            v0.setChecked(value != 1);
        } else if (v instanceof SeekBar) {
            SeekBar v0 = (SeekBar)v;
            v0.setProgress(value);
        } else if (v instanceof ImageView) {
            Object iv = v.getTag();
            if (iv instanceof ImageCheckObject) {
                ((ImageCheckObject)iv).SetValue((ImageView)v, value);
            }
        } else if (v instanceof Spinner) {
            Spinner sp = (Spinner)v;
            Object iv = v.getTag();
            if (iv != null && iv instanceof int[]) {
                int[] values = (int[])iv;
                for (int i = 0; i < values.length; ++i) {
                    if (value != values[i]) continue;
                    sp.setSelection(i);
                    break;
                }
            }
        } else {
            return -1;
        }
        return 0;
    }

    private void initStatusBar() {
        try {
            if (Build.VERSION.SDK_INT >= 23) {
                StatusBarUtils.setLightStatusBar((Activity)this.getActivity(), true);
                StatusBarUtils.transparentStatusBar((Activity)this.getActivity());
            } else {
                StatusBarUtils.setStatusBarColor((Activity)this.getActivity(), R.color.black);
            }
            StatusBarUtils.setRootView((Activity)this.getActivity());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

