/*
 * Decompiled with CFR 0.152.
 */
package com.utils;

import android.graphics.ImageFormat;
import android.media.Image;
import android.util.Log;
import java.nio.ByteBuffer;
import java.util.Arrays;

public class ImageYuvUtils {
    public static final int YUV420P = 0;
    public static final int YUV420SP = 1;
    public static final int NV21 = 2;
    private static final String TAG = "ImageUtil";

    public static byte[] getBytesFromImageAsType(Image image, int type, int degree) {
        try {
            int i;
            Image.Plane[] planes = image.getPlanes();
            int width = image.getWidth();
            int height = image.getHeight();
            byte[] yuvBytes = new byte[width * height * ImageFormat.getBitsPerPixel((int)35) / 8];
            int dstIndex = 0;
            byte[] uBytes = new byte[width * height / 4];
            byte[] vBytes = new byte[width * height / 4];
            int uIndex = 0;
            int vIndex = 0;
            for (i = 0; i < planes.length; ++i) {
                int k;
                int j;
                int pixelsStride = planes[i].getPixelStride();
                int rowStride = planes[i].getRowStride();
                ByteBuffer buffer = planes[i].getBuffer();
                byte[] bytes = new byte[buffer.capacity()];
                buffer.get(bytes);
                int srcIndex = 0;
                if (i == 0) {
                    for (j = 0; j < height; ++j) {
                        System.arraycopy(bytes, srcIndex, yuvBytes, dstIndex, width);
                        srcIndex += rowStride;
                        dstIndex += width;
                    }
                    continue;
                }
                if (i == 1) {
                    for (j = 0; j < height / 2; ++j) {
                        for (k = 0; k < width / 2; ++k) {
                            uBytes[uIndex++] = bytes[srcIndex];
                            srcIndex += pixelsStride;
                        }
                        if (pixelsStride == 2) {
                            srcIndex += rowStride - width;
                            continue;
                        }
                        if (pixelsStride != 1) continue;
                        srcIndex += rowStride - width / 2;
                    }
                    continue;
                }
                if (i != 2) continue;
                for (j = 0; j < height / 2; ++j) {
                    for (k = 0; k < width / 2; ++k) {
                        vBytes[vIndex++] = bytes[srcIndex];
                        srcIndex += pixelsStride;
                    }
                    if (pixelsStride == 2) {
                        srcIndex += rowStride - width;
                        continue;
                    }
                    if (pixelsStride != 1) continue;
                    srcIndex += rowStride - width / 2;
                }
            }
            switch (type) {
                case 0: {
                    System.arraycopy(uBytes, 0, yuvBytes, dstIndex, uBytes.length);
                    System.arraycopy(vBytes, 0, yuvBytes, dstIndex + uBytes.length, vBytes.length);
                    if (degree != 0) {
                        return ImageYuvUtils.rotateYUV420P(yuvBytes, width, height, degree);
                    }
                    return yuvBytes;
                }
                case 1: {
                    for (i = 0; i < vBytes.length; ++i) {
                        yuvBytes[dstIndex++] = uBytes[i];
                        yuvBytes[dstIndex++] = vBytes[i];
                    }
                    return yuvBytes;
                }
                case 2: {
                    for (i = 0; i < vBytes.length; ++i) {
                        yuvBytes[dstIndex++] = vBytes[i];
                        yuvBytes[dstIndex++] = uBytes[i];
                    }
                    return yuvBytes;
                }
            }
        }
        catch (Exception e) {
            Log.i((String)TAG, (String)e.toString());
        }
        return null;
    }

    public static void rotateYUV420P90(byte[] srcY, byte[] srcU, byte[] srcV, byte[] dstY, byte[] dstU, byte[] dstV, int width, int height) {
        int dstIndex = 0;
        int srcIndex = 0;
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                dstIndex = x * height + height - y - 1;
                dstY[dstIndex] = srcY[srcIndex++];
            }
        }
        int uvHeight = height / 2;
        int uvWidth = width / 2;
        int dstUVIndex = 0;
        int srcUVIndex = 0;
        for (int y = 0; y < uvHeight; ++y) {
            for (int x = 0; x < uvWidth; ++x) {
                dstUVIndex = x * uvHeight + uvHeight - y - 1;
                dstU[dstUVIndex] = srcU[srcUVIndex];
                dstV[dstUVIndex] = srcV[srcUVIndex];
                ++srcUVIndex;
            }
        }
    }

    public static void rotateYUV420P180(byte[] srcY, byte[] srcU, byte[] srcV, byte[] dstY, byte[] dstU, byte[] dstV, int width, int height) {
        int dstIndex = 0;
        int srcIndex = 0;
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                dstIndex = (height - y - 1) * width + width - x - 1;
                dstY[dstIndex] = srcY[srcIndex++];
            }
        }
        int uvHeight = height / 2;
        int uvWidth = width / 2;
        int dstUVIndex = 0;
        int srcUVIndex = 0;
        for (int y = 0; y < uvHeight; ++y) {
            for (int x = 0; x < uvWidth; ++x) {
                dstUVIndex = (uvHeight - y - 1) * uvWidth + uvWidth - x - 1;
                dstU[dstUVIndex] = srcU[srcUVIndex];
                dstV[dstUVIndex] = srcV[srcUVIndex];
                ++srcUVIndex;
            }
        }
    }

    public static void rotateYUV420P270(byte[] srcY, byte[] srcU, byte[] srcV, byte[] dstY, byte[] dstU, byte[] dstV, int width, int height) {
        int dstIndex = 0;
        int srcIndex = 0;
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                dstIndex = (width - x - 1) * height + y;
                dstY[dstIndex] = srcY[srcIndex++];
            }
        }
        int uvHeight = height / 2;
        int uvWidth = width / 2;
        int dstUVIndex = 0;
        int srcUVIndex = 0;
        for (int y = 0; y < uvHeight; ++y) {
            for (int x = 0; x < uvWidth; ++x) {
                dstUVIndex = (uvWidth - x - 1) * uvHeight + y;
                dstU[dstUVIndex] = srcU[srcUVIndex];
                dstV[dstUVIndex] = srcV[srcUVIndex];
                ++srcUVIndex;
            }
        }
    }

    public static byte[] rotateYUV420P(byte[] src, int width, int height, float degree) {
        byte[] dst = new byte[width * height * ImageFormat.getBitsPerPixel((int)35) / 8];
        byte[] pSrcY = Arrays.copyOfRange(src, 0, width * height);
        byte[] pSrcU = Arrays.copyOfRange(src, width * height, width * height + width * height / 4);
        byte[] pSrcV = Arrays.copyOfRange(src, width * height + width * height / 4, width * height * 3 / 2);
        byte[] pDstY = new byte[width * height];
        byte[] pDstU = new byte[width * height / 4];
        byte[] pDstV = new byte[width * height / 4];
        if (degree == 90.0f) {
            ImageYuvUtils.rotateYUV420P90(pSrcY, pSrcU, pSrcV, pDstY, pDstU, pDstV, width, height);
        } else if (degree == 180.0f) {
            ImageYuvUtils.rotateYUV420P180(pSrcY, pSrcU, pSrcV, pDstY, pDstU, pDstV, width, height);
        } else if (degree == 270.0f) {
            ImageYuvUtils.rotateYUV420P270(pSrcY, pSrcU, pSrcV, pDstY, pDstU, pDstV, width, height);
        }
        System.arraycopy(pDstY, 0, dst, 0, pDstY.length);
        System.arraycopy(pDstU, 0, dst, pDstY.length, pDstU.length);
        System.arraycopy(pDstV, 0, dst, pDstY.length + pDstU.length, pDstV.length);
        return dst;
    }

    public static byte[] mirrorYUV420P(byte[] yuvData, int width, int height) {
        int j;
        int i;
        byte[] mirroredYuvData = new byte[width * height * 3 / 2];
        int uvSize = width * height / 4;
        for (i = 0; i < height; ++i) {
            for (j = width - 1; j >= 0; --j) {
                mirroredYuvData[i * width + j] = yuvData[i * width + (width - 1 - j)];
            }
        }
        for (i = 0; i < height / 2; ++i) {
            for (j = width / 2 - 1; j >= 0; --j) {
                mirroredYuvData[width * height + i * width / 2 + j] = yuvData[width * height + i * width / 2 + (width / 2 - 1 - j)];
            }
        }
        for (i = 0; i < height / 2; ++i) {
            for (j = width / 2 - 1; j >= 0; --j) {
                mirroredYuvData[width * height + uvSize + i * width / 2 + j] = yuvData[width * height + uvSize + i * width / 2 + (width / 2 - 1 - j)];
            }
        }
        return mirroredYuvData;
    }
}

