/*
 * Decompiled with CFR 0.152.
 */
package com.utils;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class BaseThreadPool {
    private static ScheduledExecutorService fixedThreadPool;
    private static ExecutorService singleThreadExecutor;
    private static BaseThreadPool instance;
    private static int length;

    private BaseThreadPool() {
    }

    public static BaseThreadPool getInstance() {
        if (null == instance) {
            instance = new BaseThreadPool();
        }
        if (null == fixedThreadPool) {
            fixedThreadPool = Executors.newScheduledThreadPool(length);
        }
        if (null == singleThreadExecutor) {
            singleThreadExecutor = Executors.newSingleThreadExecutor();
        }
        return instance;
    }

    public void doTask(Runnable task, long s1, long s2) {
        if (null == fixedThreadPool) {
            fixedThreadPool = Executors.newScheduledThreadPool(length);
        }
        fixedThreadPool.scheduleAtFixedRate(task, s1, s2, TimeUnit.SECONDS);
    }

    public void cancelTask() {
        if (fixedThreadPool != null) {
            fixedThreadPool.shutdown();
            fixedThreadPool = null;
        }
    }

    public void doTaskBySinglePool(Thread task) {
        this.doTaskBySinglePool(task, 5);
    }

    public void doTaskBySinglePool(Thread task, int priority) {
        if (priority > 10 || priority < 1) {
            priority = 5;
        }
        task.setPriority(priority);
        singleThreadExecutor.execute(task);
    }

    static {
        length = 2;
    }
}

