/*
 * Decompiled with CFR 0.152.
 */
package com.manager.push;

import android.content.Context;
import android.os.Message;
import com.basic.G;
import com.lib.FunSDK;
import com.lib.IFunSDKResult;
import com.lib.Mps.MpsClient;
import com.lib.Mps.SMCInitInfo;
import com.lib.MsgContent;
import com.lib.sdk.bean.StringUtils;
import com.manager.account.XMAccountManager;
import com.manager.base.BaseManager;
import com.manager.db.DevDataCenter;
import com.manager.db.XMDevInfo;
import com.utils.LogUtils;
import com.utils.XUtils;
import demo.xm.com.libxmfunsdk.R;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class XMPushManager
extends BaseManager
implements IFunSDKResult {
    public static final int LINK_COUNT = 200;
    public static final int UNLINK_COUNT = 200;
    public static final int UNINIT_PUSH = 0;
    public static final int PUSH_TYPE_XM = 1;
    public static final int PUSH_TYPE_GOOGLE = 2;
    public static final int PUSH_TYPE_HUAWEI = 3;
    public static final int PUSH_TYPE_XG = 4;
    public static final int PUSH_TYPE_WECHAT = 5;
    public static final int PUSH_TYPE_LINE = 6;
    public static final int PUSH_TYPE_XIAOMI = 7;
    public static final int PUSH_TYPE_VIVO = 8;
    public static final int PUSH_TYPE_OPPO = 9;
    public static final int PUSH_TYPE_HONOR = 10;
    public static final int PUSH_TYPE_GOOGLE_V2 = 11;
    public static final String PUSH_LEVEL_FULL = "Full";
    public static final String PUSH_LEVEL_IMPORTANT = "Important";
    public static final String PUSH_LEVEL_NO = "No";
    public static final String PREFIX_TYPE_GOOGLE = "Google:";
    public static final String PREFIX_TYPE_GOOGLEV2 = "GoogleV2:";
    public static final String PREFIX_TYPE_HUAWEI = "HuaWeiV2:";
    public static final String PREFIX_TYPE_XIAOMI = "XiaoMi:";
    public static final String PREFIX_TYPE_VIVO = "ViVo:";
    public static final String PREFIX_TYPE_OPPO = "Oppo:";
    public static final String PREFIX_TYPE_HONOR = "Honor:";
    public static final String PREFIX_TYPE_SAMSUNG = "SamsungPush:";
    public static final String TYPE_LOCAL_ALARM = "LocalAlarm";
    public static final String TYPE_MOTION_DETECT = "MotionDetect";
    public static final String TYPE_VIDEO_MOTION = "VideoMotion";
    public static final String TYPE_LOSS_DETECT = "LossDetect";
    public static final String TYPE_VIDEO_LOSS = "VideoLoss";
    public static final String TYPE_BLIND_DETECT = "BlindDetect";
    public static final String TYPE_VIDEO_BLIND = "VideoBlind";
    public static final String TYPE_IPC_ALARM = "IPCAlarm";
    public static final String TYPE_LOCAL_IO = "LocalIO";
    public static final String TYPE_STORAGE_WRITE_ERROR = "StorageWriteError";
    public static final String TYPE_STORAGE_READ_ERROR = "StorageReadError";
    public static final String TYPE_STORAGE_FAILURE = "StorageFailure";
    public static final String TYPE_STORAGE_LOW_SPACE = "StorageLowSpace";
    public static final String TYPE_STORRAGE_LOW_SPACE = "StorrageLowSpace";
    public static final String TYPE_STORAGE_NOT_EXIST = "StorageNotExist";
    public static final String TYPE_SERIAL_ALARM = "SerialAlarm";
    public static final String TYPE_CONS_SENSOR_ALARM = "ConsSensorAlarm";
    public static final String TYPE_HUMAN_DETECT = "HumanDetect";
    public static final String TYPE_PET_DETECT = "PetDetect";
    public static final String TYPE_FACE_DETECTION = "FaceDetection";
    public static final String TYPE_FACE_DETECT = "FaceDetect";
    public static final String TYPE_FACE_RECOGNITION = "FaceRecognition";
    public static final String TYPE_FACE_RECFACE = "recface";
    public static final String TYPE_OFF_DUTY = "offduty";
    public static final String TYPE_CRY_DETECT = "CryDetect";
    public static final String TYPE_VOLUME_ALARM = "VolumeDetect";
    public static final String TYPE_BIRD_ALARM = "BirdAlarm";
    public static final String TYPE_REMOTE_SNAP = "RemoteSnap";
    public static final String TYPE_NET_IP_CONFLICT = "NetIPConflict";
    public static final String TYPE_SPEED_ALARM = "SpeedAlarm";
    public static final String TYPE_GSENSOR_ALARM = "GSensorAlarm";
    public static final String TYPE_PIR_ALARM = "PIRAlarm";
    public static final String TYPE_RECEIVED_CALL = "TYPE_RECEIVED_CALL";
    public static final String TYPE_INTERVAL_WAKE = "IntervalWakeAlarm";
    public static final String TYPE_DOOR_LOCK_NOTIFY = "DoorLockNotify";
    public static final String TYPE_DOOR_LOCK_ALARM = "DoorLockAlarm";
    public static final String TYPE_DOOR_BELL = "DoorLockCall";
    public static final String TYPE_RESERVER_WAKE = "ReserveWakeAlarm";
    public static final String TYPE_FORCE_DISMANTLE = "ForceDismantleAlarm";
    public static final String TYPE_LOW_BATTERY = "LowBatteryAlarm";
    public static final String TYPE_VIDEO_ANALYZE = "VideoAnalyze";
    public static final String TYPE_HUMANE = "appEventHumanDetectAlarm";
    public static final String TYPE_NOTICE_MSG = "Door_Noice_Msg";
    public static final String TYPE_EXCEPTION_MSG = "Exception_Message";
    public static final String TYPE_REMOTE_CALL_ALARM = "RemoteCallAlarm";
    public static final String TYPE_FEED_ERROR = "FeedAlarm";
    public static final String TYPE_FEED_LIMIT_ERROR = "FeedLimitError";
    public static final String TYPE_FEED_STORAGE_ALARM = "FeedStorageAlarm";
    public static final String TYPE_FOOD_SHORTAGE = "FoodShortage";
    public static final String TYPE_GRAIN_BLOACK = "GrainBloack";
    public static final String MSG_TYPE_DOOR_BELL = "DoorBell";
    public static final String MSG_TYPE_PASS_WD = "Passwd";
    public static final String MSG_TYPE_FINGER_PRINT = "FingerPrint";
    public static final String MSG_TYPE_CARD = "Card";
    public static final String MSG_TYPE_KEY = "Key";
    public static final String MSG_TYPE_FINGER_PRINT_ERROR = "FingerPrintError";
    public static final String MSG_TYPE_PASS_WD_ERROR = "PasswdError";
    public static final String MSG_TYPE_CARD_ERROR = "CardError";
    public static final String MSG_TYPE_FORCE_DEL_ALARM = "ForceDelAlarm";
    public static final String MSG_TYPE_TRESPASSING = "Trespassing";
    public static final String MSG_TYPE_FORCE = "Force";
    public static final String MSG_TYPE_STAY_AWAY = "StayAlarm";
    public static final String MSG_TYPE_LOW_BATTERY = "LowBattery";
    public static final String MSG_TYPE_DOOR_LOCK_OPEN_COUNT = "DoorLockOpenCount";
    public static final String MSG_TYPE_FACE = "Face";
    public static final String MSG_TYPE_TRIAL_ERROR = "TrialError";
    public static final String MSG_TYPE_DOOR_CLOSE = "HasBeenClose";
    public static final String MSG_TYPE_DOOR_OPEN = "HasBeenOpen";
    public static final String MSG_TYPE_REMOTE = "Remote";
    public static final String MSG_TYPE_FACE_ERROR = "FaceError";
    public static final String MSG_TYPE_ADD_USER = "AddUser";
    public static final String MSG_TYPE_DEL_USER = "DelUser";
    public static final String MSG_TYPE_ADD_ALL_USER = "DelAllUser";
    public static final String MSG_TYPE_INIT_USER = "InitUser";
    public static final String MSG_TYPE_BB_LOW_BATTERY = "BBLowBattery";
    public static final String MSG_TYPE_UNLATCHED = "Unlatched";
    public static final String MSG_TYPE_DOOR_UNLOCKED = "DoorUnlocked";
    public static final String MSG_TYPE_DOOR_TOO_TIGHT = "DoorTooTight";
    public static final String MSG_TYPE_FORGOT_REMOVE_KEY = "ForgotRemoveKey";
    public static final String MSG_TYPE_LOCK_DOOR_REMINDER = "LockDoorReminder";
    public static final String MSG_TYPE_KNOCK_REMINDER = "KnockReminder";
    public static final String MSG_TYPE_SOS_REMINDER = "SOSReminder";
    public static final String MSG_TYPE_CONSTANTLY_OPEN_ACTIVATED = "ConstantlyOpenActivated";
    public static final String MSG_TYPE_CONSTANTLY_OPEN_CANCENLLED = "ConstantlyOpenCancelled";
    public static final String MSG_TYPE_TIMED_LOCK_REMINDER = "TimedLockReminder";
    public static final String MSG_TYPE_ACTIVE_VIEW_REMINDER = "ActiveViewReminder";
    public static final String MSG_TYPE_LOCK_CORE_COVER_OPEN = "LockCoreCoverOpen";
    public static final String MSG_TYPE_LOCK_CORE_COVER_CLOSE = "LockCoreCoverClose";
    public static final String MSG_TYPE_DISINFECTION_LAMP_TURN_ON = "DisinfectionLampTurnOn";
    public static final String MSG_TYPE_DISINFECTION_LAMP_TURN_OFF = "DisinfectionLampTurnOff";
    public static final String MSG_TYPE_DOOR_HOLE_NOT_ALIGNED = "DoorHoleNotAligned";
    public static final String MSG_TYPE_DOOR_NOT_CLOSED_PROPERLY = "DoorNotClosedProperly";
    public static final String MSG_TYPE_LOCKED_INSIDE = "LockedInside";
    public static final String MSG_TYPE_UNLOCKED_INSIDE = "UnLockedInside";
    public static final String MSG_TYPE_DOOR_STILL_OPEN = "DoorStillOpen";
    public static final String MSG_TYPE_ADD_FINGER_PRINGT = "AddFingerPrint";
    public static final String MSG_TYPE_ADD_PASSWD = "AddPasswd";
    public static final String MSG_TYPE_ADD_CARD = "AddCard";
    public static final String MSG_TYPE_ADD_TELE_CONTROL = "AddTelecontrol";
    public static final String MSG_TYPE_ADD_KEY = "AddKey";
    public static final String MSG_TYPE_ADD_PUPIL = "AddPupil";
    public static final String MSG_TYPE_ADD_PALM_VEIN = "AddPalmVein";
    public static final String MSG_TYPE_ADD_FINGER_VEIN = "AddFingerVein";
    public static final String MSG_TYPE_ADD_FACE = "AddFace";
    public static final String MSG_ADD_REMOTE_USER = "AddRemoteUser";
    public static final String MSG_ADD_PALM_PRINT_USER = "AddPalmPrintUser";
    public static final String MSG_ADD_IRIS_USER = "AddIrisUser";
    public static final String MSG_ADD_TEMPORARY_USER = "AddTemporaryUser";
    public static final String MSG_TYPE_DEL_FINGER_PRINT = "DelFingerPrint";
    public static final String MSG_TYPE_DEL_PASSWD = "DelPasswd";
    public static final String MSG_TYPE_DEL_CARD = "DelCard";
    public static final String MSG_TYPE_DEL_TEL_CONTROL = "DelTelecontrol";
    public static final String MSG_TYPE_DEL_KEY = "DelKey";
    public static final String MSG_TYPE_DEL_PUPIL = "DelPupil";
    public static final String MSG_TYPE_DEL_PALM_VEIN = "DelPalmVein";
    public static final String MSG_TYPE_DEL_FINGER_VEIN = "DelFingerVein";
    public static final String MSG_TYPE_DEL_FACE = "DelFace";
    public static final String MSG_TYPE_DEL_REMOTE_USER = "DelRemoteUser";
    public static final String MSG_TYPE_DEL_PALM_PRINT_USER = "DelPalmPrintUser";
    public static final String MSG_TYPE_DEL_IRIS_USER = "DelIrisUser";
    public static final String MSG_TYPE_DEL_TEMPORARY_USER = "DelTemporaryUser";
    public static final String MSG_TYPE_FINGER_VEIN_ERROR = "FingerVeinError";
    public static final String MSG_TYPE_KEY_ERROR = "KeyError";
    public static final String MSG_TYPE_ALL_UNLOCK_ERROR = "AllUnlockError";
    public static final String MSG_TYPE_REMOTR_ERROR = "RemoteError";
    public static final String MSG_TYPE_PALM_PRINT_ERROR = "PalmprintError";
    public static final String MSG_TYPE_PALM_VEIN_ERROR = "PalmVeinError";
    public static final String MSG_TYPE_IRIS_ERROR = "IrisError";
    public static final String MSG_TYPE_IRIS_TRY_UNLOCK = "IrisTryUnlock";
    public static final String MSG_TYPE_FINGER_VEIN_TRY_UNLOCK = "FingerVeinTryUnlock";
    public static final String MSG_TYPE_PALM_VEIN_TRY_UNLOCK = "PalmVeinTryUnlock";
    public static final String MSG_TYPE_HIGH_TRMPERATURE_ALARM = "HighTemperatureAlarm";
    public static final String MSG_TYPE_SMOKE_ALARM = "SmokeAlarm";
    public static final String MSG_TYPE_FACE_TRY_UNLOCK = "FaceTryUnlock";
    public static final String MSG_TYPE_PALM_PRINT_TRY_UNLOCK = "PalmprintTryUnlock";
    public static final String MSG_TYPE_FINGER_TRY_UNLOCK = "FingerTryUnlock";
    public static final String MSG_TYPE_PASSWORD_TRY_UNLOCK = "PasswordTryUnlock";
    public static final String MSG_TYPE_CARD_TRY_UNLOCK = "CardTryUnlock";
    public static final String MSG_TYPE_SYSTEM_LOCK = "SystemLock";
    public static final String MSG_TYPE_FIRE_ALARM = "FireAlarm";
    public static final String MSG_TYPE_STRANGERS_ALARM = "StrangersAlarm";
    public static final String MSG_TYPE_FAKE_FACE_ALARM = "FakeFaceAlarm";
    public static final String MSG_TYPE_BEING_FOLLOWED = "BeingFollowed";
    public static final String MSG_TYPE_ABNORMAL_ALARM = "AbnormalAlarm";
    public static final String MSG_TYPE_TRIANGLE_TONGUE_ABNORMAL = "TriangleTongueAbnormal";
    public static final String MSG_TYPE_OBLIQUE_ABNORMAL = "ObliqueTongueAbnormal";
    public static final String MSG_TYPE_FULLY_OPEN_SENSOR_ABNORMAL = "FullyOpenSensorAbnormal";
    public static final String MSG_TYPE_FULLY_CLOSE_SENSOR_ABNORMAL = "FullyCloseSensorAbnormal";
    public static final String MSG_TYPE_RESET_SENSOR_ABNORMAL = "ResetSensorAbnormal";
    public static final String MSG_TYPE_EMERGENCY_UNLOCK = "EmergencyUnLock";
    public static final String MSG_TYPE_DEFAULT_UNLOCK = "DefaultUnLock";
    public static final String MSG_TYPE_IN_DR_HANDLE_UNLOCK = "InDrHandleUnLock";
    public static final String MSG_TYPE_IN_DR_BUTTON_UNLOCK = "InDrButtonUnLock";
    public static final String MSG_TYPE_PALM_PRINT_UNLOCK = "PalmprintUnLock";
    public static final String MSG_TYPE_IRIS_UNLOCK = "IrisUnLock";
    public static final String MSG_TYPE_TEMP_UNLOCK = "TempUnLock";
    public static final String MSG_TYPE_FINGER_VEIN_UNLOCK = "FingerVeinUnLock";
    public static final String MSG_TYPE_PALM_VEIN_UNLOCK = "PalmVeinUnLock";
    public static final String MSG_TYPE_HAS_BEEN_OPEN = "HasBeenOpen";
    public static final String MSG_TYPE_HAS_BEEN_CLOSE = "HasBeenClose";
    public static final String MSG_TYPE_IN_DR_BUTTON_LOCK = "InDrButtonLock";
    public static final String MSG_TYPE_IN_DR_HANDLE_LOCK = "InDrHandleLock";
    public static final String MSG_TYPE_DOOR_LOCK_OPEN = "DoorLockOpen";
    public static final String MSG_TYPE_DOOR_LOCK_CLOSE = "DoorLockClose";
    public static final String MSG_TYPE_SOS_CALL = "SOSCall";
    public static final String MSG_TYPE_STAY_CALL = "StayCall";
    public static final String TYPE_REMOTE_FAMILY_CALL_OFF = "FamilyCallOff";
    public static final String MSG_TYPE_FAMILY_CALL = "FamilyCall";
    public static final String MSG_TYPE_FAMILY_CALL_CANCEL = "DeviceTerminatedCall";
    public static final String MSG_TYPE_WINDOW_ALARM = "WindowAlarm";
    public static final String MSG_TYPE_MASTER_KEY_UNLOCK = "MasterKeyUnLock";
    public static final String MSG_TYPE_GAS_LEAKAGE = "GasLeakage";
    public static final String MSG_TYPE_DEPLOYMENT_ALARM = "DeploymentAlarm";
    public static final String MSG_TYPE_REMOTE_LOCKING = "RemoteLocking";
    public static final String MSG_TYPE_BLIND = "Blind";
    public static final String MSG_TYPE_PIR_HUMAN = "PIRHuman";
    public static final String MSG_TYPE_EXPRESS_DELIVERY = "ExpressDelivery";
    public static final String MSG_TYPE_TELE_CONTROL_UNLOCK = "TelecontrolUnLock";
    public static final String MSG_TYPE_PUPIL_UNLOCK = "PupilUnlock";
    public static final String MSG_TYPE_COMBINATION_UNLOCK = "CombinationUnLock";
    public static final String MSG_TYPE_MECHANICAL_UNLOCK = "MechanicalUnlock";
    public static final String MSG_TYPE_VIRTUAL_PASSWD = "VirtualPasswd";
    public static final String TYPE_TIME_ALBUM = "TimeAlbum";
    public static final String TYPE_PACKAGE_ALARM = "Package";
    public static final String MSG_TYPE_VIDEO_TALK = "IncomingCall";
    public static final String TYPE_PARKING_PROTECTION = "ParkingProtection";
    public static final String TYPE_FIRE_DETECT = "FireDetection";
    public static final String TYPE_PLAYBACK_QUICKLY = "TimeMicrocosm";
    public static final String TYPE_FALL_DOWN_DETECTION = "FallDownDetection";
    public static final String TYPE_HUNT_ALARM = "HuntAlarm";
    private OnXMPushLinkListener onXMPushLinkListener;
    private int userId;
    private int pushType = 0;
    private String tokenId;
    private String tokenType;
    private AtomicInteger countUnLink;

    public XMPushManager() {
        this(null);
    }

    public XMPushManager(OnXMPushLinkListener listener) {
        this.onXMPushLinkListener = listener;
        this.init();
        this.pushType = DevDataCenter.getInstance().getPushType();
        SMCInitInfo info = DevDataCenter.getInstance().getSmcInitInfo();
        if (info != null) {
            this.tokenId = G.ToString((byte[])info.st_2_token);
            this.tokenType = G.ToString((byte[])info.st_5_appType);
        }
        this.countUnLink = new AtomicInteger();
    }

    public void setOnXMPushLinkListener(OnXMPushLinkListener listener) {
        this.onXMPushLinkListener = listener;
    }

    public boolean initFunSDKPush(Context context, SMCInitInfo info, int pushType) {
        if (info != null) {
            this.pushType = pushType;
            this.tokenId = G.ToString((byte[])info.st_2_token);
            if (StringUtils.isStringNULL(this.tokenId)) {
                return false;
            }
            this.tokenType = G.ToString((byte[])info.st_5_appType);
            if (StringUtils.isStringNULL(this.tokenType)) {
                this.tokenType = this.getPlatformPushTokenType(context, pushType);
                if (StringUtils.isStringNULL(this.tokenType)) {
                    return false;
                }
                G.SetValue((byte[])info.st_5_appType, (String)this.tokenType);
            }
            DevDataCenter.getInstance().setSmcInitInfo(info);
            DevDataCenter.getInstance().setPushType(pushType);
            LogUtils.debugInfo("[APP_PUSH]->", "push userId:" + this.userId);
            int iret = MpsClient.Init((int)this.userId, (byte[])G.ObjToBytes((Object)info), (int)0);
            return iret >= 0;
        }
        return false;
    }

    public boolean initFunSDKPush(Context context, String token) {
        if (StringUtils.isStringNULL(token)) {
            return false;
        }
        SMCInitInfo info = new SMCInitInfo();
        G.SetValue((byte[])info.st_2_token, (String)token);
        G.SetValue((byte[])info.st_5_appType, (String)"Android");
        return this.initFunSDKPush(context, info, 1);
    }

    public boolean setPlatformPushToken(Context context, int pushType, String token) {
        if (context == null) {
            return false;
        }
        if (StringUtils.isStringNULL(token)) {
            return false;
        }
        try {
            this.tokenId = !StringUtils.isStringNULL(this.tokenId) ? this.tokenId + "&&" + token : token;
            this.tokenType = !StringUtils.isStringNULL(this.tokenType) ? this.tokenType + "&&" + this.getPlatformPushTokenType(context, pushType) : this.getPlatformPushTokenType(context, pushType);
            SMCInitInfo smcInitInfo = DevDataCenter.getInstance().getSmcInitInfo();
            if (smcInitInfo != null) {
                G.SetValue((byte[])smcInitInfo.st_2_token, (String)this.tokenId);
                G.SetValue((byte[])smcInitInfo.st_5_appType, (String)this.tokenType);
            }
            DevDataCenter.getInstance().setPushType(pushType);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public String getPlatformPushTokenType(Context context, int pushType) {
        String prefix;
        if (context == null) {
            return "";
        }
        switch (pushType) {
            case 2: {
                prefix = PREFIX_TYPE_GOOGLE;
                break;
            }
            case 3: {
                prefix = PREFIX_TYPE_HUAWEI;
                break;
            }
            case 9: {
                prefix = PREFIX_TYPE_OPPO;
                break;
            }
            case 8: {
                prefix = PREFIX_TYPE_VIVO;
                break;
            }
            case 7: {
                prefix = PREFIX_TYPE_XIAOMI;
                break;
            }
            case 10: {
                prefix = PREFIX_TYPE_HONOR;
                break;
            }
            case 11: {
                prefix = PREFIX_TYPE_GOOGLEV2;
                break;
            }
            case 1: {
                return "Android";
            }
            default: {
                return "";
            }
        }
        prefix = prefix + XUtils.getPackageName(context);
        return prefix;
    }

    public void linkAlarm(String devId, int seq) {
        this.linkAlarm(devId, null, null, seq);
    }

    public void linkAlarm(String devId, String rules, int seq) {
        this.linkAlarm(devId, null, rules, seq);
    }

    public void linkAlarm(String devId, String devName, String rules, int seq) {
        if (this.userId != 0) {
            XMDevInfo xmDevInfo;
            if (StringUtils.isStringNULL(devName) && (xmDevInfo = DevDataCenter.getInstance().getDevInfo(devId)) != null) {
                devName = xmDevInfo.getDevName();
            }
            if (StringUtils.isStringNULL(rules) || !StringUtils.isJsonStr(rules)) {
                try {
                    JSONObject jsonObject = new JSONObject();
                    JSONObject ruleJson = new JSONObject();
                    ruleJson.put("Level", (Object)PUSH_LEVEL_FULL);
                    jsonObject.put("rules", (Object)ruleJson);
                    rules = jsonObject.toString();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            MpsClient.DevAlarmSubscribe((int)this.userId, (String)devId, (String)devName, (String)rules, (String)"", (String)this.tokenId, (String)this.tokenType, (int)seq);
        }
    }

    public void unLinkAlarm(String devId, int seq) {
        if (this.userId != 0) {
            MpsClient.UnlinkDevGeneral((int)this.userId, (String)devId, (String)this.tokenId, (int)0, (int)seq);
        }
    }

    public void unLinkAlarmAbnormal(String devId, int seq) {
        if (this.userId != 0) {
            MpsClient.UnlinkDevGeneral((int)this.userId, (String)devId, (String)this.tokenId, (int)0, (int)seq);
        }
    }

    public void linkAllAlarm(String[] devIds, String[] rules) {
        if (devIds == null) {
            return;
        }
        StringBuffer sbDevId = new StringBuffer();
        StringBuffer sbDevName = new StringBuffer();
        String sbRule = "";
        for (String devId : devIds) {
            if (devId == null) continue;
            sbDevId.append(devId);
            sbDevId.append(";");
            XMDevInfo xmDevInfo = DevDataCenter.getInstance().getDevInfo(devId);
            if (xmDevInfo == null) continue;
            sbDevName.append(xmDevInfo.getDevName());
            sbDevName.append(";");
        }
        if (rules != null) {
            if (rules.length != devIds.length) {
                LogUtils.debugInfo("[APP_PUSH]->", "\u5f53\u524d\u6279\u91cf\u8ba2\u9605\u7684\u89c4\u5219\u548c\u8bbe\u5907\u6570\u91cf\u4e0d\u5339\u914d\uff01\u8bf7\u68c0\u67e5\u4ee3\u7801\u662f\u5426\u5b58\u5728\u95ee\u9898\uff01");
                return;
            }
            StringBuffer sbRules = new StringBuffer();
            for (String rule : rules) {
                if (!StringUtils.isJsonStr(rule) || StringUtils.isStringNULL(rule)) {
                    try {
                        JSONObject jsonObject = new JSONObject();
                        JSONObject ruleJson = new JSONObject();
                        ruleJson.put("Level", (Object)PUSH_LEVEL_FULL);
                        jsonObject.put("rules", (Object)ruleJson);
                        sbRules.append(jsonObject.toString());
                    }
                    catch (Exception exception) {}
                } else {
                    sbRules.append(rule);
                }
                sbRules.append(";");
            }
            sbRule = sbRules.toString();
        }
        MpsClient.BatchDevAlarmSubscribe((int)this.userId, (String)sbDevId.toString(), (String)sbDevName.toString(), (String)sbRule, (String)"", (String)this.tokenId, (String)this.tokenType, (int)0);
    }

    public void unLinkAllAlarm() {
        List<String> devList;
        if (this.tokenId == null) {
            if (this.onXMPushLinkListener != null) {
                this.onXMPushLinkListener.onAllUnLinkResult(false);
            }
            return;
        }
        if (this.userId == 0) {
            this.userId = FunSDK.GetId((int)this.userId, (IFunSDKResult)this);
        }
        if ((devList = XMAccountManager.getInstance().getDevList()) != null) {
            int unLinkCount = 0;
            int seq = 0;
            StringBuffer unLinkAlarmSns = new StringBuffer();
            for (int i = 0; i < devList.size(); ++i) {
                String devId = devList.get(i);
                if (devId != null) {
                    XMDevInfo xmDevInfo = DevDataCenter.getInstance().getDevInfo(devId);
                    if (xmDevInfo != null && xmDevInfo.getDevState() == 0) continue;
                    unLinkAlarmSns.append(devId);
                    unLinkAlarmSns.append(";");
                }
                if (++unLinkCount < 200) continue;
                this.countUnLink.incrementAndGet();
                MpsClient.UnLinkDevsBatch((int)this.userId, (String)unLinkAlarmSns.toString(), (String)(this.tokenId == null ? "" : this.tokenId), (int)0, (int)seq);
                System.out.println("unlink:1" + unLinkAlarmSns.toString());
                unLinkAlarmSns = new StringBuffer();
                unLinkCount = 0;
            }
            if (unLinkAlarmSns.length() > 0) {
                this.countUnLink.incrementAndGet();
                MpsClient.UnLinkDevsBatch((int)this.userId, (String)unLinkAlarmSns.toString(), (String)(this.tokenId == null ? "" : this.tokenId), (int)0, (int)seq);
                System.out.println("unlink:2" + unLinkAlarmSns.toString());
            }
        }
        if (this.countUnLink.get() == 0 && this.onXMPushLinkListener != null) {
            this.onXMPushLinkListener.onAllUnLinkResult(false);
        }
    }

    public void unLinkAllAlarm(List<String> devList) {
        if (this.tokenId == null) {
            if (this.onXMPushLinkListener != null) {
                this.onXMPushLinkListener.onAllUnLinkResult(false);
            }
            return;
        }
        if (this.userId == 0) {
            this.userId = FunSDK.GetId((int)this.userId, (IFunSDKResult)this);
        }
        if (devList != null) {
            int unLinkCount = 0;
            int seq = 0;
            StringBuffer unLinkAlarmSns = new StringBuffer();
            for (int i = 0; i < devList.size(); ++i) {
                String devId = devList.get(i);
                if (devId != null) {
                    XMDevInfo xmDevInfo = DevDataCenter.getInstance().getDevInfo(devId);
                    unLinkAlarmSns.append(devId);
                    unLinkAlarmSns.append(";");
                }
                if (++unLinkCount < 200) continue;
                this.countUnLink.incrementAndGet();
                MpsClient.UnLinkDevsBatch((int)this.userId, (String)unLinkAlarmSns.toString(), (String)(this.tokenId == null ? "" : this.tokenId), (int)0, (int)seq);
                System.out.println("unlink:1" + unLinkAlarmSns.toString());
                unLinkAlarmSns = new StringBuffer();
                unLinkCount = 0;
            }
            if (unLinkAlarmSns.length() > 0) {
                this.countUnLink.incrementAndGet();
                MpsClient.UnLinkDevsBatch((int)this.userId, (String)unLinkAlarmSns.toString(), (String)(this.tokenId == null ? "" : this.tokenId), (int)0, (int)seq);
                System.out.println("unlink:2" + unLinkAlarmSns.toString());
            }
        }
        if (this.countUnLink.get() == 0 && this.onXMPushLinkListener != null) {
            this.onXMPushLinkListener.onAllUnLinkResult(false);
        }
    }

    public void isAlarmLinked(String devId) {
        MpsClient.GetDevAlarmSubStatusByToken((int)this.userId, (String)devId, (String)this.tokenId, (int)0);
    }

    public void recvAlarmJsonData(String alarmJson, int seq) {
        if (this.userId != 0) {
            MpsClient.OnRecvAlarmJsonData((int)this.userId, (String)alarmJson, (int)seq);
        }
    }

    public void getWeChatAlarmState(String devId, int seq) {
        if (this.userId != 0) {
            FunSDK.SysWXAlarmStateCheck((int)this.userId, (String)devId, (int)seq);
        }
    }

    public void openWeChatPush(String devId, int seq) {
        if (this.userId != 0) {
            FunSDK.SysOpenWXAlarmListen((int)this.userId, (String)devId, (int)seq);
        }
    }

    public void closeWeChatPush(String devId, int seq) {
        if (this.userId != 0) {
            FunSDK.SysCloseWXAlarmListen((int)this.userId, (String)devId, (int)seq);
        }
    }

    public void getThirdPushState(String devId, int pushType) {
        if (this.userId != 0 && pushType == 6) {
            FunSDK.SysThirdPartyAlarmStateCheck((int)this.userId, (String)devId, (String)"line", (int)6);
        }
    }

    public void openThirdPush(String devId, int pushType) {
        if (this.userId != 0 && pushType == 6) {
            FunSDK.SysThirdPartyOpenAlarmListen((int)this.userId, (String)devId, (String)"line", (int)6);
        }
    }

    public void closeThirdPush(String devId, int pushType) {
        if (this.userId != 0 && pushType == 6) {
            FunSDK.SysThirdPartyCloseAlarmListen((int)this.userId, (String)devId, (String)"line", (int)6);
        }
    }

    public int getPushType() {
        return DevDataCenter.getInstance().getPushType();
    }

    public int OnFunSDKResult(Message msg, MsgContent ex) {
        switch (msg.what) {
            case 6000: {
                if (this.onXMPushLinkListener == null) break;
                this.onXMPushLinkListener.onPushLink(this.pushType, ex.str, ex.seq, msg.arg1);
                break;
            }
            case 6001: {
                if (this.onXMPushLinkListener == null) break;
                this.onXMPushLinkListener.onPushUnLink(this.pushType, ex.str, ex.seq, msg.arg1);
                break;
            }
            case 6019: {
                this.dealWithLinkDevsBatch(ex.str, msg.arg1 >= 0);
                break;
            }
            case 6020: {
                this.dealWithUnlinkDevsBatch(ex.str, msg.arg1 >= 0);
                if (this.countUnLink.decrementAndGet() > 0 || this.onXMPushLinkListener == null) break;
                this.onXMPushLinkListener.onAllUnLinkResult(true);
                break;
            }
            case 6007: 
            case 6008: {
                if (this.onXMPushLinkListener == null) break;
                this.onXMPushLinkListener.onAlarmInfo(this.pushType, ex.str, msg, ex);
                break;
            }
            case 6011: {
                if (this.onXMPushLinkListener == null) break;
                this.onXMPushLinkListener.onPushInit(this.pushType, msg.arg1);
                break;
            }
            case 6005: {
                if (this.onXMPushLinkListener == null) break;
                this.onXMPushLinkListener.onLinkDisconnect(this.pushType, ex.str);
                break;
            }
            case 1: {
                break;
            }
            case 5064: 
            case 5066: {
                if (this.onXMPushLinkListener == null) break;
                this.onXMPushLinkListener.onWeChatState(ex.str, msg.arg1 >= 0 ? 1 : 0, msg.arg1);
                break;
            }
            case 5065: {
                if (this.onXMPushLinkListener == null) break;
                this.onXMPushLinkListener.onWeChatState(ex.str, msg.arg1 >= 0 ? 0 : 1, msg.arg1);
                break;
            }
            case 5083: 
            case 5085: {
                if (this.onXMPushLinkListener == null) break;
                this.onXMPushLinkListener.onThirdPushState(ex.str, ex.seq, msg.arg1 >= 0 ? 1 : 0, msg.arg1);
                break;
            }
            case 5084: {
                if (this.onXMPushLinkListener == null) break;
                this.onXMPushLinkListener.onThirdPushState(ex.str, ex.seq, msg.arg1 >= 0 ? 0 : 1, msg.arg1);
                break;
            }
            case 6022: {
                boolean isLinked = false;
                if (ex.pData == null) break;
                String data = G.ToString((byte[])ex.pData);
                if (!StringUtils.isStringNULL(ex.str)) {
                    try {
                        JSONObject jsonObject = new JSONObject(data);
                        if (jsonObject.has("AlarmCenter") && (jsonObject = jsonObject.getJSONObject("AlarmCenter")) != null && jsonObject.has("Body")) {
                            JSONArray jsonArray = jsonObject.getJSONArray("Body");
                            if (jsonArray == null || jsonArray.length() == 0) {
                                isLinked = false;
                            }
                            if ((jsonObject = jsonArray.getJSONObject(0)).has("Token")) {
                                JSONArray tokens = jsonObject.getJSONArray("Token");
                                isLinked = tokens != null && tokens.length() != 0;
                            }
                        }
                    }
                    catch (JSONException e) {
                        e.printStackTrace();
                    }
                    if (this.onXMPushLinkListener != null) {
                        this.onXMPushLinkListener.onIsPushLinkedFromServer(this.pushType, ex.str, isLinked);
                    }
                }
                LogUtils.debugInfo("[APP_PUSH]->", ex.str + data);
                break;
            }
        }
        if (this.onXMPushLinkListener != null) {
            this.onXMPushLinkListener.onFunSDKResult(msg, ex);
        }
        return 0;
    }

    @Override
    public boolean init() {
        this.userId = FunSDK.GetId((int)this.userId, (IFunSDKResult)this);
        return true;
    }

    @Override
    public void unInit() {
        if (this.userId != 0) {
            FunSDK.UnRegUser((int)this.userId);
            this.userId = 0;
        }
    }

    private void dealWithLinkDevsBatch(String linkAllAlarmSn, boolean isSuccess) {
        if (!StringUtils.isStringNULL(linkAllAlarmSn)) {
            String[] devSns = linkAllAlarmSn.split(";");
            List<String> devSnList = Arrays.asList(devSns);
            for (String devId : devSnList) {
                if (this.onXMPushLinkListener == null) continue;
                this.onXMPushLinkListener.onPushLink(this.pushType, devId, 0, isSuccess ? 0 : -1);
            }
        }
    }

    private void dealWithUnlinkDevsBatch(String unlinkAllAlarmSn, boolean isSuccess) {
        if (!StringUtils.isStringNULL(unlinkAllAlarmSn)) {
            String[] devSns = unlinkAllAlarmSn.split(";");
            List<String> devSnList = Arrays.asList(devSns);
            for (String devId : devSnList) {
                if (this.onXMPushLinkListener == null) continue;
                this.onXMPushLinkListener.onPushUnLink(this.pushType, devId, 0, isSuccess ? 0 : -1);
            }
        }
    }

    public static String getAlarmName(Context context, String event) {
        return XMPushManager.getAlarmName(context, event, null, null, false);
    }

    public static String getAlarmName(Context context, String event, String msg, String msgType, boolean isShowMsg) {
        if (context == null) {
            return "";
        }
        String alarmNameByMsgType = XMPushManager.getAlarmNameByMsgType(context, msgType, msg, isShowMsg);
        if (!StringUtils.isStringNULL(alarmNameByMsgType)) {
            return alarmNameByMsgType;
        }
        switch (event) {
            case "IPCAlarm": {
                return context.getString(R.string.libfunsdk_alarm_type_ipc_alarm);
            }
            case "LocalIO": {
                return context.getString(R.string.libfunsdk_alarm_type_local_alarm);
            }
            case "StorageLowSpace": 
            case "StorrageLowSpace": {
                return context.getString(R.string.libfunsdk_alarm_type_storage_low_space);
            }
            case "StorageNotExist": {
                return context.getString(R.string.libfunsdk_alarm_type_storage_not_exist);
            }
            case "LocalAlarm": {
                return context.getString(R.string.libfunsdk_alarm_type_call);
            }
            case "PIRAlarm": {
                return context.getString(R.string.libfunsdk_alarm_type_pir);
            }
            case "IntervalWakeAlarm": {
                return context.getString(R.string.libfunsdk_alarm_type_interval_wake);
            }
            case "ReserveWakeAlarm": {
                return context.getString(R.string.libfunsdk_alarm_type_reserver_wake);
            }
            case "ForceDismantleAlarm": {
                return context.getString(R.string.libfunsdk_alarm_type_force_dismantle);
            }
            case "LowBatteryAlarm": {
                return context.getString(R.string.alarm_msg_low_battery);
            }
            case "DoorLockCall": {
                if (msgType != null) {
                    return XMPushManager.getDoorLockCallName(context, msgType, msg, isShowMsg);
                }
                return context.getString(R.string.libfunsdk_alarm_type_door_bell);
            }
            case "DoorLockAlarm": {
                if (msgType != null) {
                    return XMPushManager.getDoorAlarmName(context, msgType, msg, isShowMsg);
                }
                return context.getString(R.string.libfunsdk_alarm_type_door_lock_alarm);
            }
            case "DoorLockOpen": {
                if (msgType != null) {
                    return XMPushManager.getDoorLockOpenName(context, msgType, msg, isShowMsg);
                }
                return context.getString(R.string.alarm_msg_door_lock_open);
            }
            case "DoorLockClose": {
                if (msgType != null) {
                    return XMPushManager.getDoorLockCloseName(context, msgType, msg, isShowMsg);
                }
                return context.getString(R.string.alarm_msg_door_lock_close);
            }
            case "DoorLockNotify": {
                if (msgType != null) {
                    return XMPushManager.getDoorNotifyName(context, msgType, msg, isShowMsg);
                }
                return context.getString(R.string.libfunsdk_alarm_type_door_lock_notify);
            }
            case "Exception_Message": {
                return context.getString(R.string.libfunsdk_alarm_type_exception_msg);
            }
            case "Door_Noice_Msg": {
                return context.getString(R.string.libfunsdk_alarm_type_notice_msg);
            }
            case "MotionDetect": 
            case "VideoMotion": {
                return context.getString(R.string.libfunsdk_alarm_type_motion_detect);
            }
            case "VideoAnalyze": {
                return context.getString(R.string.libfunsdk_alarm_type_analyze);
            }
            case "appEventHumanDetectAlarm": 
            case "HumanDetect": {
                return context.getString(R.string.alarm_msg_human_detection);
            }
            case "RemoteCallAlarm": {
                return context.getString(R.string.libfunsdk_alarm_type_remote_call);
            }
            case "LossDetect": 
            case "VideoLoss": {
                return context.getString(R.string.libfunsdk_alarm_type_video_loss);
            }
            case "BlindDetect": 
            case "VideoBlind": {
                return context.getString(R.string.libfunsdk_alarm_type_video_blind);
            }
            case "RemoteSnap": {
                return context.getString(R.string.libfunsdk_alarm_type_remote_snap);
            }
            case "FaceDetection": 
            case "FaceDetect": {
                return context.getString(R.string.libfunsdk_alarm_type_face_detect);
            }
            case "PetDetect": {
                return context.getString(R.string.alarm_msg_pet_detection);
            }
            case "FaceRecognition": 
            case "recface": {
                return context.getString(R.string.libfunsdk_alarm_type_face_recognition);
            }
            case "StorageWriteError": {
                return context.getString(R.string.libfunsdk_alarm_type_storage_write_error);
            }
            case "StorageReadError": {
                return context.getString(R.string.libfunsdk_alarm_type_sotrage_read_error);
            }
            case "TYPE_RECEIVED_CALL": {
                return context.getString(R.string.libfunsdk_alarm_type_answer);
            }
            case "FeedAlarm": {
                return context.getString(R.string.libfunsdk_alarm_type_feed_error);
            }
            case "FeedLimitError": {
                return context.getString(R.string.libfunsdk_alarm_type_feed_limit_error);
            }
            case "FeedStorageAlarm": {
                return context.getString(R.string.pet_feed_history);
            }
            case "FoodShortage": {
                return context.getString(R.string.libfunsdk_alarm_type_food_shortage);
            }
            case "GrainBloack": {
                return context.getString(R.string.libfunsdk_alarm_type_grain_block);
            }
            case "offduty": {
                return context.getString(R.string.alarm_msg_offduty);
            }
            case "BirdAlarm": {
                return context.getString(R.string.alarm_msg_bird_alarm);
            }
            case "CryDetect": {
                return context.getString(R.string.alarm_msg_cry_detect);
            }
            case "VolumeDetect": {
                return context.getString(R.string.alarm_msg_volume_detect);
            }
            case "TimeAlbum": {
                return context.getString(R.string.alarm_msg_time_album);
            }
            case "Package": {
                return context.getString(R.string.alarm_msg_package_alarm);
            }
            case "ParkingProtection": {
                return context.getString(R.string.alarm_msg_fall_parking_protection);
            }
            case "FireDetection": {
                return context.getString(R.string.alarm_msg_fire_detection);
            }
            case "TimeMicrocosm": {
                return context.getString(R.string.alarm_msg_time_microcosm);
            }
            case "FallDownDetection": {
                return context.getString(R.string.alarm_msg_fall_down_detection);
            }
            case "HuntAlarm": {
                return context.getString(R.string.alarm_msg_hunt_alarm);
            }
        }
        return event;
    }

    private static String getAlarmNameByMsgType(Context context, String msgType, String msg, boolean isShowMsg) {
        if (context == null) {
            return "";
        }
        String result1 = XMPushManager.getDoorLockCallName(context, msgType, msg, isShowMsg);
        if (!StringUtils.contrast(context.getString(R.string.libfunsdk_alarm_type_door_bell), result1)) {
            return result1;
        }
        String result2 = XMPushManager.getDoorAlarmName(context, msgType, msg, isShowMsg);
        if (!StringUtils.contrast(context.getString(R.string.libfunsdk_alarm_type_door_lock_alarm), result2)) {
            return result2;
        }
        String result3 = XMPushManager.getDoorLockOpenName(context, msgType, msg, isShowMsg);
        if (!StringUtils.contrast(context.getString(R.string.alarm_msg_door_lock_open), result3)) {
            return result3;
        }
        String result4 = XMPushManager.getDoorLockCloseName(context, msgType, msg, isShowMsg);
        if (!StringUtils.contrast(context.getString(R.string.alarm_msg_door_lock_close), result4)) {
            return result4;
        }
        String result5 = XMPushManager.getDoorNotifyName(context, msgType, msg, isShowMsg);
        if (!StringUtils.contrast(context.getString(R.string.libfunsdk_alarm_type_door_lock_notify), result5)) {
            return result5;
        }
        return "";
    }

    private static String getDoorNotifyName(Context context, String msgType, String msg, boolean isShowMsg) {
        if (context == null) {
            return "";
        }
        if (msgType != null) {
            switch (msgType) {
                case "Passwd": {
                    if (isShowMsg && !StringUtils.isStringNULL(msg)) {
                        return msg + context.getString(R.string.libfunsdk_alarm_type_pass_wd_open);
                    }
                    return context.getString(R.string.libfunsdk_alarm_type_pass_wd_open);
                }
                case "FingerPrint": {
                    if (isShowMsg && !StringUtils.isStringNULL(msg)) {
                        return msg + context.getString(R.string.libfunsdk_alarm_type_finger_open);
                    }
                    return context.getString(R.string.libfunsdk_alarm_type_finger_open);
                }
                case "Card": {
                    if (isShowMsg && !StringUtils.isStringNULL(msg)) {
                        return msg + context.getString(R.string.libfunsdk_alarm_type_card_open);
                    }
                    return context.getString(R.string.libfunsdk_alarm_type_card_open);
                }
                case "Key": {
                    return context.getString(R.string.alarm_msg_door_key_unlock);
                }
                case "Face": {
                    if (!StringUtils.isStringNULL(msg)) {
                        return msg + context.getString(R.string.alarm_msg_door_face_unlock);
                    }
                    return context.getString(R.string.alarm_msg_door_face_unlock);
                }
                case "DeviceTerminatedCall": {
                    return context.getString(R.string.libfunsdk_alarm_type_device_terminated_call);
                }
                case "DoorLockOpenCount": {
                    return context.getString(R.string.libfunsdk_alarm_type_open_count);
                }
                case "LowBattery": {
                    return context.getString(R.string.alarm_msg_low_battery);
                }
                case "HasBeenClose": {
                    return context.getString(R.string.alarm_msg_door_been_closed);
                }
                case "HasBeenOpen": {
                    return context.getString(R.string.alarm_msg_door_been_opend);
                }
                case "Remote": {
                    return context.getString(R.string.libfunsdk_alarm_type_remote);
                }
                case "FaceError": {
                    return context.getString(R.string.libfunsdk_alarm_type_face_error);
                }
                case "AddUser": {
                    return context.getString(R.string.alarm_msg_add_user);
                }
                case "DelUser": {
                    return context.getString(R.string.alarm_msg_del_user);
                }
                case "DelAllUser": {
                    return context.getString(R.string.alarm_msg_del_all_user);
                }
                case "InitUser": {
                    return context.getString(R.string.alarm_msg_init_user);
                }
                case "BBLowBattery": {
                    return context.getString(R.string.alarm_msg_bb_low_battery);
                }
                case "Unlatched": {
                    return context.getString(R.string.alarm_msg_door_latch);
                }
                case "DoorUnlocked": {
                    return context.getString(R.string.alarm_msg_door_unlocked);
                }
                case "DoorTooTight": {
                    return context.getString(R.string.alarm_msg_door_too_tight);
                }
                case "ForgotRemoveKey": {
                    return context.getString(R.string.alarm_msg_door_forgot_remove_key);
                }
                case "LockDoorReminder": {
                    return context.getString(R.string.alarm_msg_lock_door_reminder);
                }
                case "KnockReminder": {
                    return context.getString(R.string.alarm_msg_door_knock_reminder);
                }
                case "SOSReminder": {
                    return context.getString(R.string.alarm_msg_door_sos_reminder);
                }
                case "ConstantlyOpenActivated": {
                    return context.getString(R.string.alarm_msg_door_normally_open);
                }
                case "ConstantlyOpenCancelled": {
                    return context.getString(R.string.alarm_msg_door_normally_open_canceld);
                }
                case "TimedLockReminder": {
                    return context.getString(R.string.alarm_msg_door_timed_lock_reminder);
                }
                case "ActiveViewReminder": {
                    return context.getString(R.string.alarm_msg_door_active_view_reminder);
                }
                case "LockCoreCoverOpen": {
                    return context.getString(R.string.alarm_msg_door_lock_core_open);
                }
                case "LockCoreCoverClose": {
                    return context.getString(R.string.alarm_msg_door_lock_core_close);
                }
                case "DisinfectionLampTurnOn": {
                    return context.getString(R.string.alarm_msg_door_disinfection_lamp_opened);
                }
                case "DisinfectionLampTurnOff": {
                    return context.getString(R.string.alarm_msg_door_disinfection_lamp_closed);
                }
                case "DoorHoleNotAligned": {
                    return context.getString(R.string.alarm_msg_door_holes_not_aligned);
                }
                case "DoorNotClosedProperly": {
                    return context.getString(R.string.alarm_msg_door_not_closed_properly);
                }
                case "LockedInside": {
                    return context.getString(R.string.alarm_msg_door_locked_inside);
                }
                case "UnLockedInside": {
                    return context.getString(R.string.alarm_msg_door_unlocked_inside);
                }
                case "DoorStillOpen": {
                    return context.getString(R.string.alarm_msg_door_still_open);
                }
                case "AddFingerPrint": {
                    return context.getString(R.string.alarm_msg_add_fingerprint);
                }
                case "AddPasswd": {
                    return context.getString(R.string.alarm_msg_add_passwd);
                }
                case "AddCard": {
                    return context.getString(R.string.alarm_msg_add_card);
                }
                case "AddTelecontrol": {
                    return context.getString(R.string.alarm_msg_add_telecontrol);
                }
                case "AddKey": {
                    return context.getString(R.string.alarm_msg_add_key);
                }
                case "AddPupil": {
                    return context.getString(R.string.alarm_msg_add_pupil);
                }
                case "AddPalmVein": {
                    return context.getString(R.string.alarm_msg_add_palmVein);
                }
                case "AddFingerVein": {
                    return context.getString(R.string.alarm_msg_add_fingerVein);
                }
                case "AddFace": {
                    return context.getString(R.string.alarm_msg_add_face);
                }
                case "AddRemoteUser": {
                    return context.getString(R.string.alarm_msg_add_remote_user);
                }
                case "AddPalmPrintUser": {
                    return context.getString(R.string.alarm_msg_add_palmprint_user);
                }
                case "AddIrisUser": {
                    return context.getString(R.string.alarm_msg_add_iris_user);
                }
                case "AddTemporaryUser": {
                    return context.getString(R.string.alarm_msg_add_temporary_user);
                }
                case "DelFingerPrint": {
                    return context.getString(R.string.alarm_msg_del_fingerprint);
                }
                case "DelPasswd": {
                    return context.getString(R.string.alarm_msg_del_passwd);
                }
                case "DelCard": {
                    return context.getString(R.string.alarm_msg_del_card);
                }
                case "DelTelecontrol": {
                    return context.getString(R.string.alarm_msg_del_telecontrol);
                }
                case "DelKey": {
                    return context.getString(R.string.alarm_msg_del_key);
                }
                case "DelPupil": {
                    return context.getString(R.string.alarm_msg_del_pupil);
                }
                case "DelPalmVein": {
                    return context.getString(R.string.alarm_msg_del_palmvein);
                }
                case "DelFingerVein": {
                    return context.getString(R.string.alarm_msg_del_fingervein);
                }
                case "DelFace": {
                    return context.getString(R.string.alarm_msg_del_face);
                }
                case "DelRemoteUser": {
                    return context.getString(R.string.alarm_msg_delete_remote_user);
                }
                case "DelPalmPrintUser": {
                    return context.getString(R.string.alarm_msg_delete_palmprint_user);
                }
                case "DelIrisUser": {
                    return context.getString(R.string.alarm_msg_delete_iris_user);
                }
                case "DelTemporaryUser": {
                    return context.getString(R.string.alarm_msg_delete_temporary_user);
                }
            }
            return context.getString(R.string.libfunsdk_alarm_type_door_lock_notify);
        }
        return context.getString(R.string.libfunsdk_alarm_type_door_lock_notify);
    }

    public static String getDoorLockCallName(Context context, String msgType, String msg, boolean isShowMsg) {
        if (context == null) {
            return "";
        }
        if (msgType != null) {
            switch (msgType) {
                case "DoorBell": {
                    return context.getString(R.string.alarm_msg_door_door_bell);
                }
                case "SOSCall": {
                    return context.getString(R.string.alarm_msg_door_sos_call);
                }
                case "StayCall": {
                    return context.getString(R.string.alarm_msg_door_stay_call);
                }
                case "FamilyCall": {
                    return context.getString(R.string.alarm_msg_door_family_fall);
                }
                case "FamilyCallOff": {
                    return context.getString(R.string.alarm_msg_family_call_off);
                }
            }
            return context.getString(R.string.libfunsdk_alarm_type_door_bell);
        }
        return context.getString(R.string.libfunsdk_alarm_type_door_bell);
    }

    private static String getDoorLockOpenName(Context context, String msgType, String msg, boolean isShowMsg) {
        if (context == null) {
            return "";
        }
        if (msgType != null) {
            switch (msgType) {
                case "FingerPrint": {
                    if (isShowMsg && !StringUtils.isStringNULL(msg)) {
                        return msg + context.getString(R.string.alarm_msg_door_finger_print_unlock);
                    }
                    return context.getString(R.string.alarm_msg_door_finger_print_unlock);
                }
                case "Passwd": {
                    if (isShowMsg && !StringUtils.isStringNULL(msg)) {
                        return msg + context.getString(R.string.alarm_msg_door_passwd_unlock);
                    }
                    return context.getString(R.string.alarm_msg_door_passwd_unlock);
                }
                case "Card": {
                    if (isShowMsg && !StringUtils.isStringNULL(msg)) {
                        return msg + context.getString(R.string.alarm_msg_door_card_unlock);
                    }
                    return context.getString(R.string.alarm_msg_door_card_unlock);
                }
                case "EmergencyUnLock": {
                    return context.getString(R.string.alarm_msg_door_emergency_unlock);
                }
                case "DefaultUnLock": {
                    return context.getString(R.string.alarm_msg_door_default_unlock);
                }
                case "InDrHandleUnLock": {
                    return context.getString(R.string.alarm_msg_door_in_dr_handle_unlock);
                }
                case "InDrButtonUnLock": {
                    return context.getString(R.string.alarm_msg_door_in_dr_button_unlock);
                }
                case "Key": {
                    return context.getString(R.string.alarm_msg_door_key_unlock);
                }
                case "Face": {
                    return context.getString(R.string.alarm_msg_door_face_unlock);
                }
                case "PalmprintUnLock": {
                    return context.getString(R.string.alarm_msg_door_palmprint_unlock);
                }
                case "IrisUnLock": {
                    return context.getString(R.string.alarm_msg_door_iris_unlock);
                }
                case "TempUnLock": {
                    return context.getString(R.string.alarm_msg_door_temp_unlock);
                }
                case "FingerVeinUnLock": {
                    return context.getString(R.string.alarm_msg_door_finger_vein_unlock);
                }
                case "PalmVeinUnLock": {
                    return context.getString(R.string.alarm_msg_door_palm_vein_unlock);
                }
                case "Remote": {
                    return context.getString(R.string.alarm_msg_door_remote_unlock);
                }
                case "HasBeenOpen": {
                    return context.getString(R.string.alarm_msg_door_been_opend);
                }
                case "TelecontrolUnLock": {
                    return context.getString(R.string.alarm_msg_door_telecontrol_unlock);
                }
                case "PupilUnlock": {
                    return context.getString(R.string.alarm_msg_door_pupil_unlock);
                }
                case "CombinationUnLock": {
                    return context.getString(R.string.alarm_msg_door_combination_unlock);
                }
                case "MechanicalUnlock": {
                    return context.getString(R.string.alarm_msg_door_mechanical_unlock);
                }
                case "VirtualPasswd": {
                    return context.getString(R.string.alarm_msg_door_virtual_passwd);
                }
            }
            return context.getString(R.string.alarm_msg_door_lock_open);
        }
        return context.getString(R.string.alarm_msg_door_lock_open);
    }

    private static String getDoorLockCloseName(Context context, String msgType, String msg, boolean isShowMsg) {
        if (context == null) {
            return "";
        }
        if (msgType != null) {
            switch (msgType) {
                case "HasBeenClose": {
                    return context.getString(R.string.alarm_msg_door_been_closed);
                }
                case "InDrButtonLock": {
                    return context.getString(R.string.alarm_msg_door_in_dr_button_locked);
                }
                case "InDrHandleLock": {
                    return context.getString(R.string.alarm_msg_door_in_dr_handle_locked);
                }
            }
            return context.getString(R.string.alarm_msg_door_lock_close);
        }
        return context.getString(R.string.alarm_msg_door_lock_close);
    }

    private static String getDoorAlarmName(Context context, String msgType, String msg, boolean isShowMsg) {
        if (context == null) {
            return "";
        }
        if (msgType != null) {
            switch (msgType) {
                case "CardError": {
                    return context.getString(R.string.libfunsdk_alarm_type_card_open_error);
                }
                case "PasswdError": {
                    return context.getString(R.string.libfunsdk_alarm_type_pass_wd_open_error);
                }
                case "FingerPrintError": {
                    return context.getString(R.string.libfunsdk_alarm_type_finger_open_error);
                }
                case "ForceDelAlarm": {
                    return context.getString(R.string.libfunsdk_alarm_type_force_del_alarm);
                }
                case "Trespassing": {
                    return context.getString(R.string.libfunsdk_alarm_type_trespassing);
                }
                case "Force": {
                    if (isShowMsg && !StringUtils.isStringNULL(msg)) {
                        return msg + context.getString(R.string.libfunsdk_alarm_type_force);
                    }
                    return context.getString(R.string.libfunsdk_alarm_type_force);
                }
                case "StayAlarm": {
                    return context.getString(R.string.libfunsdk_alarm_type_stay_away);
                }
                case "TrialError": {
                    return context.getString(R.string.libfunsdk_alarm_type_trial_error);
                }
                case "FaceError": {
                    return context.getString(R.string.alarm_msg_door_face_error);
                }
                case "FingerVeinError": {
                    return context.getString(R.string.alarm_msg_door_finger_vein_error);
                }
                case "KeyError": {
                    return context.getString(R.string.alarm_msg_door_key_error);
                }
                case "AllUnlockError": {
                    return context.getString(R.string.alarm_msg_door_allo_key_error);
                }
                case "RemoteError": {
                    return context.getString(R.string.alarm_msg_door_remote_error);
                }
                case "PalmprintError": {
                    return context.getString(R.string.alarm_msg_door_palmprint_error);
                }
                case "PalmVeinError": {
                    return context.getString(R.string.alarm_msg_door_palm_vein_error);
                }
                case "IrisError": {
                    return context.getString(R.string.alarm_msg_door_iris_error);
                }
                case "IrisTryUnlock": {
                    return context.getString(R.string.alarm_msg_door_iris_try_unlock_error);
                }
                case "FingerVeinTryUnlock": {
                    return context.getString(R.string.alarm_msg_door_finger_vein_try_unlock);
                }
                case "PalmVeinTryUnlock": {
                    return context.getString(R.string.alarm_msg_door_palm_vein_try_unlock);
                }
                case "HighTemperatureAlarm": {
                    return context.getString(R.string.alarm_msg_door_hight_tem_alarm);
                }
                case "SmokeAlarm": {
                    return context.getString(R.string.alarm_msg_door_smoke_alarm);
                }
                case "FaceTryUnlock": {
                    return context.getString(R.string.alarm_msg_door_face_try_unlock);
                }
                case "PalmprintTryUnlock": {
                    return context.getString(R.string.alarm_msg_door_palmprint_try_unlock);
                }
                case "FingerTryUnlock": {
                    return context.getString(R.string.alarm_msg_door_finger_try_unlock);
                }
                case "PasswordTryUnlock": {
                    return context.getString(R.string.alarm_msg_door_password_try_unlock);
                }
                case "CardTryUnlock": {
                    return context.getString(R.string.alarm_msg_door_card_try_unlock);
                }
                case "SystemLock": {
                    return context.getString(R.string.alarm_msg_door_system_lock);
                }
                case "FireAlarm": {
                    return context.getString(R.string.alarm_msg_door_fire_alarm);
                }
                case "StrangersAlarm": {
                    return context.getString(R.string.alarm_msg_door_strangers_alarm);
                }
                case "FakeFaceAlarm": {
                    return context.getString(R.string.alarm_msg_door_fake_face_alarm);
                }
                case "BeingFollowed": {
                    return context.getString(R.string.alarm_msg_door_being_follower);
                }
                case "AbnormalAlarm": {
                    return context.getString(R.string.alarm_msg_door_abnormal_alarm);
                }
                case "TriangleTongueAbnormal": {
                    return context.getString(R.string.alarm_msg_door_triangle_tongue_abnormal);
                }
                case "ObliqueTongueAbnormal": {
                    return context.getString(R.string.alarm_msg_door_oblique_tongue_abnormal);
                }
                case "FullyOpenSensorAbnormal": {
                    return context.getString(R.string.alarm_msg_door_fully_open_sensor_abnormal);
                }
                case "FullyCloseSensorAbnormal": {
                    return context.getString(R.string.alarm_msg_door_fully_close_sensor_abnormal);
                }
                case "ResetSensorAbnormal": {
                    return context.getString(R.string.alarm_msg_door_reset_sensor_abnormal);
                }
                case "WindowAlarm": {
                    return context.getString(R.string.alarm_msg_door_window_alarm);
                }
                case "MasterKeyUnLock": {
                    return context.getString(R.string.alarm_msg_door_master_key_unlock);
                }
                case "GasLeakage": {
                    return context.getString(R.string.alarm_msg_door_gas_leakage);
                }
                case "DeploymentAlarm": {
                    return context.getString(R.string.alarm_msg_door_deployment_alarm);
                }
                case "RemoteLocking": {
                    return context.getString(R.string.alarm_msg_door_remote_locking);
                }
                case "Blind": {
                    return context.getString(R.string.alarm_msg_door_obstruction_alert);
                }
                case "PIRHuman": {
                    return context.getString(R.string.alarm_msg_door_dynamic_humanoid_detection);
                }
                case "ExpressDelivery": {
                    return context.getString(R.string.alarm_msg_door_express_delivery);
                }
            }
            return context.getString(R.string.libfunsdk_alarm_type_door_lock_alarm);
        }
        return context.getString(R.string.libfunsdk_alarm_type_door_lock_alarm);
    }

    public static interface OnXMPushLinkListener {
        public void onPushInit(int var1, int var2);

        public void onPushLink(int var1, String var2, int var3, int var4);

        public void onPushUnLink(int var1, String var2, int var3, int var4);

        public void onIsPushLinkedFromServer(int var1, String var2, boolean var3);

        public void onAlarmInfo(int var1, String var2, Message var3, MsgContent var4);

        public void onLinkDisconnect(int var1, String var2);

        public void onWeChatState(String var1, int var2, int var3);

        public void onThirdPushState(String var1, int var2, int var3, int var4);

        public void onAllUnLinkResult(boolean var1);

        public void onFunSDKResult(Message var1, MsgContent var2);
    }
}

