/*
 * Decompiled with CFR 0.152.
 */
package com.manager.mqtt;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import androidx.annotation.NonNull;
import com.alibaba.fastjson.JSONObject;
import com.lib.FunSDK;
import com.lib.IFunSDKResult;
import com.lib.MsgContent;
import com.manager.mqtt.MqttInfo;
import com.utils.LogUtils;
import com.utils.XUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class XMMqttManager
implements IFunSDKResult {
    private Context context;
    private boolean isPrintLog;
    private boolean isMqttInit;
    private boolean isReconnecting;
    private int heartbeatTime = 10000;
    private static XMMqttManager xmMqttManager;
    private int userId;
    private static final String DEFAULT_SERVER_KEY = "MQTT_SERVER";
    private static final String DEFAULT_URL = "jfmq-v2.xmcsrv.net";
    private static final int DEFAULT_PORT = 1883;
    private HashMap<Object, XMMqttListener> xmMqttListenerHashMap;

    private XMMqttManager(Context context) {
        this.context = context;
        this.userId = FunSDK.GetId((int)this.userId, (IFunSDKResult)this);
    }

    private void init() {
        this.userId = FunSDK.GetId((int)this.userId, (IFunSDKResult)this);
    }

    public static XMMqttManager getInstance(Context context) {
        if (xmMqttManager == null) {
            xmMqttManager = new XMMqttManager(context);
        }
        xmMqttManager.init();
        return xmMqttManager;
    }

    public void setPrintLog(boolean isPrintLog) {
        this.isPrintLog = isPrintLog;
    }

    public void initMqttServerParam(String serverKey, String url, int serverPort) {
        if (serverKey == null) {
            serverKey = DEFAULT_SERVER_KEY;
        }
        if (url == null) {
            url = DEFAULT_URL;
        }
        if (serverPort == 0) {
            serverPort = 1883;
        }
        FunSDK.SysSetServerIPPort((String)serverKey, (String)url, (int)serverPort);
    }

    public void initMqttServerParam() {
        FunSDK.SysSetServerIPPort((String)DEFAULT_SERVER_KEY, (String)DEFAULT_URL, (int)1883);
    }

    public void connectMqtt() {
        FunSDK.MQTTInit((int)this.userId, (String)XUtils.getPackageName(this.context), (int)this.heartbeatTime, (int)0);
    }

    public void closeMqtt() {
        if (this.isMqttConnected()) {
            FunSDK.MQTTUnInit((int)this.userId, (int)0);
        }
    }

    public boolean isMqttConnected() {
        return this.isMqttInit;
    }

    private MqttInfo createReceiveStringMsg(String stringMsg) {
        MqttInfo mqttInfo = new MqttInfo();
        mqttInfo.setConnect(true).setStrMsg(stringMsg).setState(4);
        return mqttInfo;
    }

    private MqttInfo createPrepareReconnect() {
        MqttInfo mqttInfo = new MqttInfo();
        mqttInfo.setPrepareReconnect(true).setConnect(false).setState(3);
        return mqttInfo;
    }

    private MqttInfo createConnectFailed(int errorId) {
        MqttInfo mqttInfo = new MqttInfo();
        mqttInfo.setConnect(false).setState(5).setErrorId(errorId);
        return mqttInfo;
    }

    private MqttInfo createUnInitResult(int errorId) {
        MqttInfo mqttInfo = new MqttInfo();
        mqttInfo.setConnect(false).setState(6).setErrorId(errorId);
        return mqttInfo;
    }

    private MqttInfo createReconnected() {
        MqttInfo mqttInfo = new MqttInfo();
        mqttInfo.setReconnect(true).setConnect(true).setState(2);
        return mqttInfo;
    }

    private MqttInfo createConnected() {
        MqttInfo mqttInfo = new MqttInfo();
        mqttInfo.setConnect(true).setState(1);
        return mqttInfo;
    }

    public void subscribe(@NonNull String topic, @NonNull List<String> objectList) {
        if (!this.isMqttInit) {
            LogUtils.debugInfo("[APP_MQTT]->", "mqtt\u5c1a\u672a\u521d\u59cb\u5316! \u65e0\u6cd5\u8ba2\u9605\u5f53\u524d\u4e3b\u9898\uff1a" + topic);
            return;
        }
        try {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("SubscribeInfo", (Object)topic);
            jsonObject.put("Sn", (Object)objectList.toArray());
            FunSDK.SubscribeInfoFromServer((int)this.userId, (String)jsonObject.toJSONString(), (int)0);
        }
        catch (Exception e) {
            LogUtils.debugInfo("[APP_MQTT]->", "mqtt\u8ba2\u9605\u51fa\u73b0\u5f02\u5e38\uff0c\u5f02\u5e38\u539f\u56e0\uff1a" + e.getMessage());
        }
    }

    public void unSubscribe(String topic, List<String> objectList) {
        if (!this.isMqttInit) {
            LogUtils.debugInfo("[APP_MQTT]->", "mqtt\u5c1a\u672a\u521d\u59cb\u5316! \u65e0\u6cd5\u53d6\u6d88\u8ba2\u9605\u5f53\u524d\u4e3b\u9898\uff1a" + topic);
            return;
        }
        try {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("SubscribeInfo", (Object)topic);
            jsonObject.put("Sn", (Object)objectList.toArray());
            FunSDK.UnSubscribeInfoFromServer((int)this.userId, (String)jsonObject.toJSONString(), (int)0);
        }
        catch (Exception e) {
            LogUtils.debugInfo("[APP_MQTT]->", "mqtt\u53d6\u6d88\u8ba2\u9605\u51fa\u73b0\u5f02\u5e38\uff0c\u5f02\u5e38\u539f\u56e0\uff1a" + e.getMessage());
        }
    }

    private void printLog(String log) {
        if (this.isPrintLog) {
            LogUtils.debugInfo("[APP_MQTT]->", log);
        }
    }

    public void release() {
        if (this.xmMqttListenerHashMap != null) {
            this.xmMqttListenerHashMap.clear();
            this.xmMqttListenerHashMap = null;
        }
        this.closeMqtt();
        xmMqttManager = null;
        if (this.userId != 0) {
            FunSDK.UnRegUser((int)this.userId);
            this.userId = 0;
        }
    }

    public void addXMMqttListener(XMMqttListener xmMqttListener) {
        if (xmMqttListener == null) {
            return;
        }
        if (this.xmMqttListenerHashMap == null) {
            this.xmMqttListenerHashMap = new HashMap();
        }
        this.xmMqttListenerHashMap.put(xmMqttListener.hashCode(), xmMqttListener);
    }

    private void dealWithMqttCallback(final MqttInfo mqttInfo) {
        new Handler(Looper.getMainLooper()).post(new Runnable(){

            @Override
            public void run() {
                if (XMMqttManager.this.xmMqttListenerHashMap != null) {
                    for (Map.Entry entry : XMMqttManager.this.xmMqttListenerHashMap.entrySet()) {
                        if (entry == null || entry.getValue() == null) continue;
                        ((XMMqttListener)entry.getValue()).onMqttInfo(mqttInfo);
                    }
                }
            }
        });
    }

    public int OnFunSDKResult(Message message, MsgContent msgContent) {
        switch (message.what) {
            case 8929: {
                int trueDataLength = message.arg1;
                String data = new String(msgContent.pData);
                String messageData = null;
                messageData = data.length() > trueDataLength ? data.substring(0, message.arg1) : data;
                this.dealWithMqttCallback(this.createReceiveStringMsg(messageData));
                break;
            }
            case 8921: {
                if (message.arg1 == 0) {
                    this.isMqttInit = true;
                    this.dealWithMqttCallback(this.createConnected());
                    LogUtils.debugInfo("[APP_MQTT]->", "MQTT\u521d\u59cb\u5316\u6210\u529f");
                    if (!this.isReconnecting) break;
                    this.isReconnecting = false;
                    this.dealWithMqttCallback(this.createReconnected());
                    break;
                }
                this.dealWithMqttCallback(this.createConnectFailed(message.arg1));
                break;
            }
            case 8928: {
                this.isReconnecting = true;
                this.closeMqtt();
                this.connectMqtt();
                break;
            }
            case 8930: {
                if (message.arg1 == 0) {
                    this.isMqttInit = false;
                    LogUtils.debugInfo("[APP_MQTT]->", "MQTT\u53cd\u521d\u59cb\u5316\u6210\u529f");
                }
                this.dealWithMqttCallback(this.createUnInitResult(message.arg1));
            }
        }
        return 0;
    }

    public void setHeartbeatTime(int heartbeatTime) {
        this.heartbeatTime = heartbeatTime;
    }

    public static interface XMMqttListener {
        public void onMqttInfo(MqttInfo var1);
    }
}

