/*
 * Decompiled with CFR 0.152.
 */
package com.manager.image;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import com.alibaba.fastjson.JSON;
import com.lib.Mps.MpsClient;
import com.lib.MsgContent;
import com.lib.cloud.CloudDirectory;
import com.lib.sdk.bean.StringUtils;
import com.lib.sdk.bean.alarm.AlarmInfo;
import com.lib.sdk.bean.cloudmedia.CloudMediaFileInfoBean;
import com.manager.image.BaseImageManager;
import com.utils.FileUtils;
import com.utils.XUtils;
import java.io.File;
import java.util.HashMap;
import java.util.concurrent.LinkedBlockingDeque;

public class CloudImageManager
extends BaseImageManager {
    public CloudImageManager(String videoThumbPath) {
        super(videoThumbPath);
    }

    public Bitmap downloadImage(AlarmInfo alarmInfo, int nType, int nSeq, int imgWidth, int imgHeight, BaseImageManager.OnImageManagerListener listener, boolean isDownloadFromDev) {
        Bitmap bitmap;
        if (alarmInfo == null || !alarmInfo.isHavePic() || alarmInfo.getId() == null) {
            if (listener != null) {
                listener.onDownloadResult(false, null, null, nType, nSeq);
            }
            return null;
        }
        if (StringUtils.isStringNULL(this.mSaveImageDir)) {
            if (listener != null) {
                listener.onDownloadResult(false, null, null, nType, nSeq);
            }
            return null;
        }
        String path = imgWidth > 0 ? this.mSaveImageDir + File.separator + this.mDevId + "_" + alarmInfo.getId() + "thumb.jpg" : this.mSaveImageDir + File.separator + this.mDevId + "_" + alarmInfo.getId() + ".jpg";
        if (FileUtils.isFileExist(path)) {
            if (this.mBitmapMaps == null) {
                this.mBitmapMaps = new HashMap();
            }
            if (imgWidth > 0) {
                this.mBitmapMaps.put(path, XUtils.createImageThumbnail(path));
            } else {
                this.mBitmapMaps.put(path, BitmapFactory.decodeFile((String)path));
            }
        }
        if ((bitmap = this.getPicBitmap(path)) != null) {
            if (listener != null) {
                listener.onDownloadResult(true, path, bitmap, nType, nSeq);
            }
            return bitmap;
        }
        BaseImageManager.DownItemData down = new BaseImageManager.DownItemData();
        down.mDownloadJsonData = alarmInfo.getOriginJson();
        down.mHeight = imgHeight;
        down.mWidth = imgWidth;
        down.mPath = path;
        down.mSeq = nSeq;
        down.mType = nType;
        down.mListener = listener;
        down.mChnId = alarmInfo.getChannel();
        if (imgWidth == 0 || imgHeight == 0) {
            this.downloadImage(down);
        } else {
            if (this.mDownloadQueue == null) {
                this.mDownloadQueue = new LinkedBlockingDeque();
            }
            if (this.mDownloadQueue.size() >= this.maxQueueSize) {
                this.mDownloadQueue.remove();
            }
            if (!this.mDownloadQueue.contains(down)) {
                this.mDownloadQueue.add(down);
            }
            if (!this.mIsDownloading && isDownloadFromDev) {
                this.downloadImageThumb();
            }
        }
        return null;
    }

    public Bitmap downloadImage(AlarmInfo alarmInfo, int nType, int nSeq, int imgWidth, int imgHeight) {
        return this.downloadImage(alarmInfo, nType, nSeq, imgWidth, imgHeight, this.mListener, true);
    }

    public Bitmap downloadImage(AlarmInfo alarmInfo, int nType, int imgWidth, int imgHeight, BaseImageManager.OnImageManagerListener listener) {
        return this.downloadImage(alarmInfo, nType, 0, imgWidth, imgHeight, listener, true);
    }

    public Bitmap downloadVideoThumb(CloudMediaFileInfoBean cloudMediaFileInfoBean, int seq, int imgWidth, int imgHeight, BaseImageManager.OnImageManagerListener listener, boolean isDownloadFromDev) {
        if (cloudMediaFileInfoBean == null || !StringUtils.contrast(cloudMediaFileInfoBean.getPicFlag(), "1")) {
            if (listener != null) {
                listener.onDownloadResult(false, null, null, 1, seq);
            }
            return null;
        }
        try {
            String path = imgWidth > 0 ? this.mSaveImageDir + File.separator + this.mDevId + "_" + cloudMediaFileInfoBean.getStartTimes() + cloudMediaFileInfoBean.getEndTimes() + "thumb.jpg" : this.mSaveImageDir + File.separator + this.mDevId + "_" + cloudMediaFileInfoBean.getStartTimes() + cloudMediaFileInfoBean.getEndTimes() + ".jpg";
            if (FileUtils.isFileExist(path)) {
                if (this.mBitmapMaps == null) {
                    this.mBitmapMaps = new HashMap();
                }
                Bitmap bitmap = imgWidth > 0 ? XUtils.dealBitmapAdaptationSize(path, imgWidth, imgHeight) : BitmapFactory.decodeFile((String)path);
                this.mBitmapMaps.put(path, bitmap);
                if (listener != null) {
                    listener.onDownloadResult(true, path, bitmap, 1, seq);
                }
                return bitmap;
            }
            Bitmap bitmap = this.getPicBitmap(path);
            if (bitmap != null) {
                if (listener != null) {
                    listener.onDownloadResult(true, path, bitmap, 1, seq);
                }
                return bitmap;
            }
            BaseImageManager.DownItemData down = new BaseImageManager.DownItemData();
            down.mDownloadJsonData = JSON.toJSONString((Object)cloudMediaFileInfoBean);
            down.mHeight = Math.max(imgHeight, 0);
            down.mWidth = Math.max(imgWidth, 0);
            down.mPath = path;
            down.mType = 1;
            down.mSeq = seq;
            down.mListener = listener;
            if (this.mDownloadQueue == null) {
                this.mDownloadQueue = new LinkedBlockingDeque();
            }
            if (!this.mDownloadQueue.contains(down)) {
                this.mDownloadQueue.add(down);
            }
            if (!this.mIsDownloading && isDownloadFromDev) {
                this.downloadImageThumb();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public Bitmap downloadVideoThumb(CloudMediaFileInfoBean cloudMediaFileInfoBean, int nSeq, int imgWidth, int imgHeight) {
        return this.downloadVideoThumb(cloudMediaFileInfoBean, nSeq, imgWidth, imgHeight, this.mListener, true);
    }

    public Bitmap downloadVideoThumb(CloudMediaFileInfoBean cloudMediaFileInfoBean, int imgWidth, int imgHeight, BaseImageManager.OnImageManagerListener listener) {
        return this.downloadVideoThumb(cloudMediaFileInfoBean, 0, imgWidth, imgHeight, listener, true);
    }

    private void downloadImage(BaseImageManager.DownItemData down) {
        if (this.mDownloadResultMap == null) {
            this.mDownloadResultMap = new HashMap();
        }
        this.mDownloadResultMap.put(down.mSeq, down);
        MpsClient.DownloadCloudAlarmImage((int)this.mUserId, (String)this.mDevId, (String)down.mPath, (String)down.mDownloadJsonData, (int)0, (int)down.mWidth, (int)down.mHeight, (int)down.mSeq);
        this.mIsDownloading = true;
    }

    private void downloadImageThumb() {
        if (this.mDownloadQueue == null || this.mDownloadQueue.isEmpty()) {
            this.mIsDownloading = false;
            return;
        }
        if (this.mDownloadResultMap == null) {
            this.mDownloadResultMap = new HashMap();
        }
        BaseImageManager.DownItemData down = (BaseImageManager.DownItemData)this.mDownloadQueue.poll();
        this.mDownloadResultMap.put(down.mSeq, down);
        if (down.mType == 2) {
            MpsClient.DownloadCloudAlarmImage((int)this.mUserId, (String)this.mDevId, (String)down.mPath, (String)down.mDownloadJsonData, (int)0, (int)down.mWidth, (int)down.mHeight, (int)down.mSeq);
        } else if (down.mType == 1) {
            CloudDirectory.DownloadThumbnail((int)this.mUserId, (String)this.mDevId, (String)down.mDownloadJsonData, (String)down.mPath, (int)down.mWidth, (int)down.mHeight, (int)down.mSeq);
        }
        this.mIsDownloading = true;
    }

    public Bitmap getPicBitmap(AlarmInfo alarmInfo, boolean isThumb) {
        if (alarmInfo == null) {
            return null;
        }
        String path = isThumb ? this.mSaveImageDir + File.separator + this.mDevId + "_" + alarmInfo.getId() + "thumb.jpg" : this.mSaveImageDir + File.separator + this.mDevId + "_" + alarmInfo.getId() + ".jpg";
        if (this.mBitmapMaps != null && this.mBitmapMaps.containsKey(path)) {
            return (Bitmap)this.mBitmapMaps.get(path);
        }
        return null;
    }

    public Bitmap getPicBitmap(CloudMediaFileInfoBean cloudMediaFileInfoBean, boolean isThumb) {
        if (cloudMediaFileInfoBean == null) {
            return null;
        }
        String path = isThumb ? this.mSaveImageDir + File.separator + this.mDevId + "_" + cloudMediaFileInfoBean.getStartTimes() + cloudMediaFileInfoBean.getEndTimes() + "thumb.jpg" : this.mSaveImageDir + File.separator + this.mDevId + "_" + cloudMediaFileInfoBean.getStartTimes() + cloudMediaFileInfoBean.getEndTimes() + ".jpg";
        return this.getPicBitmap(path);
    }

    public int OnFunSDKResult(Message message, MsgContent msgContent) {
        switch (message.what) {
            case 6004: 
            case 6028: 
            case 6204: {
                this.dealWithDownloadResult(message.arg1 >= 0, msgContent.str, msgContent.seq);
                this.mIsDownloading = false;
                this.downloadImageThumb();
                break;
            }
        }
        return 0;
    }

    private void dealWithDownloadResult(final boolean isSuccess, final String imgPath, final int seq) {
        new Handler(Looper.getMainLooper()).post(new Runnable(){

            @Override
            public void run() {
                if (isSuccess) {
                    Bitmap bitmap;
                    BaseImageManager.DownItemData downItemData;
                    if (CloudImageManager.this.mBitmapMaps == null) {
                        CloudImageManager.this.mBitmapMaps = new HashMap();
                    }
                    if ((downItemData = (BaseImageManager.DownItemData)CloudImageManager.this.mDownloadResultMap.get(seq)) != null && downItemData.mWidth > 0) {
                        bitmap = XUtils.dealBitmapAdaptationSize(imgPath, downItemData.mWidth, downItemData.mHeight);
                        CloudImageManager.this.mBitmapMaps.put(imgPath, bitmap);
                    } else {
                        bitmap = BitmapFactory.decodeFile((String)imgPath);
                        CloudImageManager.this.mBitmapMaps.put(imgPath, bitmap);
                    }
                    if (downItemData != null && downItemData.mListener != null) {
                        downItemData.mListener.onDownloadResult(true, imgPath, bitmap, downItemData.mType, seq);
                    } else if (CloudImageManager.this.mListener != null) {
                        if (downItemData != null) {
                            CloudImageManager.this.mListener.onDownloadResult(true, imgPath, bitmap, downItemData.mType, seq);
                        } else {
                            CloudImageManager.this.mListener.onDownloadResult(true, imgPath, bitmap, 2, seq);
                        }
                    }
                    CloudImageManager.this.mDownloadResultMap.remove(seq);
                } else {
                    BaseImageManager.DownItemData downItemData = (BaseImageManager.DownItemData)CloudImageManager.this.mDownloadResultMap.get(seq);
                    if (downItemData != null && downItemData.mListener != null) {
                        downItemData.mListener.onDownloadResult(false, null, null, 2, seq);
                    } else if (CloudImageManager.this.mListener != null) {
                        if (downItemData != null) {
                            CloudImageManager.this.mListener.onDownloadResult(false, imgPath, null, downItemData.mType, seq);
                        } else {
                            CloudImageManager.this.mListener.onDownloadResult(false, null, null, 2, seq);
                        }
                    }
                }
            }
        });
    }
}

