/*
 * Decompiled with CFR 0.152.
 */
package com.manager.device.media.playback;

import android.view.ViewGroup;
import com.lib.FunSDK;
import com.lib.sdk.bean.StringUtils;
import com.manager.device.media.MediaManager;
import com.manager.device.media.attribute.PlayerAttribute;

public class LocalRecordManager
extends MediaManager {
    public LocalRecordManager(ViewGroup playView, PlayerAttribute playerAttribute) {
        super(playView, playerAttribute);
    }

    public void start(String filePath) {
        super.start();
        if (this.playerAttribute != null && !StringUtils.contrast(filePath, this.playerAttribute.getRecordFileName())) {
            this.stopPlay();
        }
        this.playerAttribute.setRecordFileName(filePath);
        if (this.playerAttribute.getPlayHandle() != 0) {
            this.pausePlay();
        } else {
            if (this.playerAttribute.getRecordFileName() == null) {
                return;
            }
            int lPlayHandle = FunSDK.MediaLocRecordPlay((int)this.userId, (String)this.playerAttribute.getRecordFileName(), (Object)this.surfaceView, (int)0);
            this.playerAttribute.setPlayHandle(lPlayHandle);
            FunSDK.SetIntAttr((int)lPlayHandle, (int)10012, (int)100);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void seekToTime(int nTimes) {
        if (this.playerAttribute == null) {
            return;
        }
        PlayerAttribute playerAttribute = this.playerAttribute;
        synchronized (playerAttribute) {
            if (this.playerAttribute.getPlayHandle() != 0) {
                FunSDK.MediaSeekToTime((int)this.playerAttribute.getPlayHandle(), (int)nTimes, (int)0, (int)0);
            } else {
                this.start();
            }
        }
    }
}

