/*
 * Decompiled with CFR 0.152.
 */
package com.manager.device.media.monitor;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.view.ViewGroup;
import com.lib.FunSDK;
import com.lib.MsgContent;
import com.lib.sdk.bean.StringUtils;
import com.manager.device.media.MediaManager;
import com.manager.device.media.TalkManager;
import com.manager.device.media.attribute.PlayerAttribute;
import com.manager.device.media.audio.OnAudioDecibelListener;
import com.manager.device.media.monitor.MonitorManagerInterface;
import java.io.File;

public class MonitorManager
extends MediaManager
implements MonitorManagerInterface {
    public static final int TALK_TYPE_DEV = 0;
    public static final int TALK_TYPE_CHN = 1;
    public static final int TALK_TYPE_BROADCAST = 2;
    private TalkManager talkManager;
    private int talkType;
    private String saveThumbnailFileName;
    private OnAudioDecibelListener audioDecibelListener;
    private TalkManager.OnTalkListener talkListener;
    private boolean isRealTimeEnable;

    public MonitorManager(ViewGroup playView, PlayerAttribute playerAttribute) {
        super(playView, playerAttribute);
    }

    public void initTalk(Context context) {
        if (this.talkManager == null && context != null) {
            this.talkManager = new TalkManager(context, this.getDevId(), this);
            if (this.talkType == 0) {
                this.talkManager.setIPCTalk(false);
            } else if (this.talkType == 1) {
                this.talkManager.setIPCTalk(true);
                this.talkManager.setChnId(this.playerAttribute.getChnnel());
            } else if (this.talkType == 2) {
                this.talkManager.setIPCTalk(true);
                this.talkManager.setChnId(-1);
            }
            if (this.audioDecibelListener != null) {
                this.talkManager.setAudioDecibelListener(this.audioDecibelListener);
            }
        }
    }

    @Override
    public void startMonitor() {
        super.start();
        if (this.playerAttribute != null) {
            if (this.playerAttribute.getPlayHandle() == 0) {
                int playHandle = FunSDK.MediaRealPlay((int)this.userId, (String)this.playerAttribute.getDevId(), (int)this.playerAttribute.getChnnel(), (int)this.playerAttribute.getStreamType(), (Object)this.surfaceView, (int)0);
                if (this.playMode == 1) {
                    FunSDK.SetIntAttr((int)playHandle, (int)10015, (int)0);
                    FunSDK.SetIntAttr((int)playHandle, (int)10014, (int)this.userId);
                } else if (this.playMode == 2) {
                    FunSDK.SetIntAttr((int)playHandle, (int)10016, (int)this.userId);
                } else {
                    FunSDK.SetIntAttr((int)playHandle, (int)10015, (int)1);
                }
                FunSDK.SetIntAttr((int)playHandle, (int)10012, (int)100);
                this.playerAttribute.setPlayHandle(playHandle);
                this.setPlayState(28);
            } else {
                FunSDK.MediaPause((int)this.playerAttribute.getPlayHandle(), (int)0, (int)0);
                this.setPlayState(0);
            }
        }
    }

    @Override
    public void setTalkType(int talkType) {
        this.talkType = talkType;
    }

    public int getTalkType() {
        return this.talkType;
    }

    @Override
    public void startTalkByHalfDuplex(Context context) {
        this.initTalk(context);
        this.closeVoiceBySound();
        if (null != this.talkManager) {
            this.talkManager.startTalkByHalfDuplex();
        }
    }

    @Override
    public void stopTalkByHalfDuplex() {
        if (this.playerAttribute != null) {
            this.playerAttribute.setSound(true);
        }
        if (this.talkManager != null) {
            this.talkManager.stopTalkByHalfDuplex();
        }
    }

    @Override
    public void uploadTalk(boolean uploadTalk) {
        if (this.talkManager != null) {
            this.talkManager.uploadTalk(uploadTalk);
        }
    }

    @Override
    public void startTalkByDoubleDirection(Context context, boolean uploadTalk) {
        this.initTalk(context);
        this.closeVoiceBySound();
        if (this.talkManager != null) {
            this.talkManager.startTalkByDoubleDirection();
        }
    }

    @Override
    public void stopTalkByDoubleDirection() {
        if (this.talkManager != null) {
            this.talkManager.stopTalkByDoubleDirection();
        }
    }

    @Override
    public void doubleDirectionSound(Context context, boolean open) {
        this.initTalk(context);
        if (this.talkManager != null) {
            if (this.playerAttribute != null) {
                this.playerAttribute.setSound(open);
            }
            this.talkManager.doubleDirectionSound(open ? 100 : 0);
        }
    }

    @Override
    public void doubleDirectionUploadTalk(Context context, boolean uploadTalk) {
        this.initTalk(context);
        if (this.talkManager != null) {
            this.talkManager.uploadTalk(uploadTalk);
        }
    }

    @Override
    public boolean isTalking() {
        if (this.talkManager != null) {
            return this.talkManager.isTalking();
        }
        return false;
    }

    @Override
    public void destroyTalk() {
        if (this.talkManager != null) {
            this.talkManager.stopTalkThread();
            this.talkManager.sendStopTalkCommand();
        }
    }

    @Override
    public void setSaveThumbnailFileName(String fileName) {
        this.saveThumbnailFileName = fileName;
    }

    @Override
    public void setSaveThumbnailPath(String path) {
        this.saveThumbnailFileName = path + File.separator + this.playerAttribute.getDevId() + "_" + this.playerAttribute.getChnnel() + ".jpg";
    }

    @Override
    public void saveRealTimeStream(String devId, int channel, int streamType, String fileName, int seq) {
        FunSDK.DevSaveRealTimeStream((int)this.userId, (String)devId, (int)channel, (int)streamType, (String)fileName, (int)seq);
    }

    @Override
    public void startGetRealTimeStream() {
        if (this.playerAttribute != null && this.playerAttribute.getPlayHandle() == 0) {
            int playHandle = FunSDK.DevReturnRealStream((int)this.userId, (String)this.playerAttribute.getDevId(), (int)this.playerAttribute.getChnnel(), (int)this.playerAttribute.getStreamType(), (int)0);
            this.playerAttribute.setPlayHandle(playHandle);
        }
    }

    @Override
    public void closeGetRealTimeStream() {
        if (this.playerAttribute != null && this.playerAttribute.getPlayHandle() != 0) {
            FunSDK.DevCloseReturnRealStream((int)this.playerAttribute.getPlayHandle());
            this.playerAttribute.setPlayHandle(0);
            this.setPlayState(4);
        }
    }

    @Override
    public void setRealTimeEnable(boolean enable) {
        this.isRealTimeEnable = enable;
    }

    @Override
    public TalkManager getTalkManager() {
        return this.talkManager;
    }

    @Override
    public void onStartTalkResult(int errorId) {
        if (this.talkListener != null) {
            this.talkListener.onStartTalkResult(errorId);
        }
    }

    @Override
    public void onStopTalkResult(int errorId) {
        if (this.talkListener != null) {
            this.talkListener.onStopTalkResult(errorId);
        }
    }

    @Override
    public void onVoiceOperateResult(int operateType, int errorId) {
        if (this.talkListener != null) {
            this.talkListener.onVoiceOperateResult(operateType, errorId);
        }
    }

    @Override
    public void onTalkDisconnect() {
        if (this.talkListener != null) {
            this.talkListener.onTalkDisconnect();
        }
    }

    public void setTalkListener(TalkManager.OnTalkListener talkListener) {
        this.talkListener = talkListener;
    }

    @Override
    public int OnFunSDKResult(Message msg, MsgContent ex) {
        switch (msg.what) {
            case 5501: {
                if (msg.arg1 < 0 || ex.arg3 != 2) break;
                new Handler(Looper.getMainLooper()).postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        if (MonitorManager.this.isRealTimeEnable) {
                            FunSDK.MediaSetFluency((int)MonitorManager.this.playerAttribute.getPlayHandle(), (int)0, (int)0);
                        }
                    }
                }, 1000L);
                break;
            }
            case 5517: {
                if (StringUtils.isStringNULL(this.saveThumbnailFileName)) break;
                FunSDK.MediaGetThumbnail((int)ex.sender, (String)this.saveThumbnailFileName, (int)-1);
                break;
            }
            case 5528: {
                if (this.mediaManagerLs == null || !(this.mediaManagerLs instanceof MediaManager.OnSaveRealStreamDataListener)) break;
                ((MediaManager.OnSaveRealStreamDataListener)this.mediaManagerLs).onStartSave();
                break;
            }
            case 5529: {
                if (this.mediaManagerLs == null || !(this.mediaManagerLs instanceof MediaManager.OnSaveRealStreamDataListener)) break;
                ((MediaManager.OnSaveRealStreamDataListener)this.mediaManagerLs).onSaveFileSize(msg.arg1);
                break;
            }
            case 5537: {
                this.setPlayState(2);
                break;
            }
        }
        return super.OnFunSDKResult(msg, ex);
    }

    public void setOnAudioDecibelListener(OnAudioDecibelListener listener) {
        this.audioDecibelListener = listener;
    }
}

