/*
 * Decompiled with CFR 0.152.
 */
package com.manager.device.media.file;

import android.os.Message;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.basic.G;
import com.lib.FunSDK;
import com.lib.IFunSDKResult;
import com.lib.MsgContent;
import com.lib.sdk.bean.OPFileBean;
import com.lib.sdk.bean.OpSpecifyAudioBean;
import com.lib.sdk.bean.VoiceReplyBean;
import com.manager.device.media.file.DevAudioFileManagerInterface;
import java.nio.ByteBuffer;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class DevAudioFileManager
implements IFunSDKResult,
DevAudioFileManagerInterface {
    private static DevAudioFileManager instance;
    private static final int SEND_AUDIO_DATE_RATE = 32768;
    public static final int LOCAL_ALARM_AUDIO_FILE_IMPORT = 7;
    private int userId;
    private ByteBuffer audioBuffer;
    private int audioSize;
    private boolean isInit;
    private int uploadProgress;
    private String devId;
    private OnDevAudioFileManagerListener OnDevAudioFileManagerListener;

    private DevAudioFileManager() {
        this.userId = FunSDK.GetId((int)this.userId, (IFunSDKResult)this);
    }

    public static DevAudioFileManager getInstance() {
        if (null == instance) {
            instance = new DevAudioFileManager();
        }
        return instance;
    }

    @Override
    public boolean getAudioFileList(String devId) {
        if (devId == null) {
            return false;
        }
        OpSpecifyAudioBean opSpecifyAudioBean = new OpSpecifyAudioBean();
        opSpecifyAudioBean.setCmd("GetSpecifyAudioList");
        JSONObject sendObj = new JSONObject();
        sendObj.put("Name", (Object)"OpSpecifyAudio");
        sendObj.put("SessionID", (Object)"0x08");
        sendObj.put("OpSpecifyAudio", (Object)opSpecifyAudioBean);
        int iRet = FunSDK.DevCmdGeneral((int)this.userId, (String)devId, (int)3020, (String)"OpSpecifyAudio", (int)-1, (int)5000, (byte[])JSON.toJSONString((Object)sendObj).getBytes(), (int)1024, (int)0);
        return iRet >= 0;
    }

    @Override
    public boolean uploadAudioFileToDev(@NotNull String devId, int fileNumber, @NotNull byte[] audioData, int audioSize) {
        if (devId == null || audioData == null || fileNumber <= 0 || audioSize <= 0) {
            return false;
        }
        this.devId = devId;
        this.audioBuffer = ByteBuffer.allocate(audioSize);
        this.audioBuffer.put(audioData);
        this.audioBuffer.flip();
        this.audioSize = audioSize;
        OPFileBean opFileBean = new OPFileBean();
        opFileBean.setFileType(1);
        opFileBean.setFileSize(audioSize / 2);
        opFileBean.setFileName("customAlarmVoice.pcm");
        opFileBean.setFileNumber(fileNumber);
        opFileBean.setAction("Send");
        opFileBean.setFilePurpose(7);
        OPFileBean.Parameter parameter = opFileBean.getParameter();
        OPFileBean.Parameter.AudioFormat audioFormat = new OPFileBean.Parameter.AudioFormat();
        audioFormat.setBitRate(320);
        audioFormat.setSampleBit(16);
        audioFormat.setSampleRate(8000);
        parameter.setAudioFormat(audioFormat);
        parameter.setChannel(new int[]{0});
        JSONObject sendObj = new JSONObject();
        sendObj.put("OPFile", (Object)opFileBean);
        int iRet = FunSDK.DevStartFileTransfer((int)this.userId, (String)devId, (String)JSON.toJSONString((Object)sendObj), (int)5000, (int)0);
        return iRet >= 0;
    }

    @Override
    public boolean playDevVoice(String devId, int fileNumber) {
        if (fileNumber <= 0 || devId == null) {
            return false;
        }
        OpSpecifyAudioBean opSpecifyAudioBean = new OpSpecifyAudioBean();
        opSpecifyAudioBean.setCmd("PlaySpecifyAudio");
        opSpecifyAudioBean.setNumber(fileNumber);
        JSONObject sendObj = new JSONObject();
        sendObj.put("Name", (Object)"OpSpecifyAudio");
        sendObj.put("SessionID", (Object)"0x08");
        sendObj.put("OpSpecifyAudio", (Object)opSpecifyAudioBean);
        int iRet = FunSDK.DevCmdGeneral((int)this.userId, (String)devId, (int)3020, (String)"OpSpecifyAudio", (int)-1, (int)5000, (byte[])JSON.toJSONString((Object)sendObj).getBytes(), (int)1024, (int)0);
        return iRet >= 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendAudioDataToDev(String devId, int alreadySendLength) {
        ByteBuffer byteBuffer = this.audioBuffer;
        synchronized (byteBuffer) {
            int length = this.audioBuffer.position() + 32768 <= this.audioSize ? 32768 : this.audioSize - this.audioBuffer.position();
            byte[] sendData = new byte[length];
            this.audioBuffer.get(sendData, 0, length);
            boolean isEndData = alreadySendLength + length >= this.audioSize;
            FunSDK.DevFileDataTransfer((int)this.userId, (String)devId, (byte[])sendData, (int)(isEndData ? 1 : 0), (int)60000, (int)(isEndData ? -1 : (alreadySendLength += length)));
        }
    }

    public int OnFunSDKResult(Message message, MsgContent msgContent) {
        switch (message.what) {
            case 5152: {
                if (this.OnDevAudioFileManagerListener != null) {
                    this.OnDevAudioFileManagerListener.onInitResult(message.arg1 >= 0, message.arg1);
                }
                if (message.arg1 < 0) break;
                this.sendAudioDataToDev(this.devId, 0);
                break;
            }
            case 5153: {
                if (this.audioSize > 0) {
                    this.uploadProgress = msgContent.seq * 100 / this.audioSize;
                }
                if (message.arg1 >= 0) {
                    if (msgContent.seq != -1) {
                        this.sendAudioDataToDev(this.devId, msgContent.seq);
                        if (this.OnDevAudioFileManagerListener == null) break;
                        this.OnDevAudioFileManagerListener.onUploadDataProgressResult(true, this.uploadProgress, message.arg1);
                        break;
                    }
                    if (this.OnDevAudioFileManagerListener == null) break;
                    this.OnDevAudioFileManagerListener.onUploadEndResult();
                    break;
                }
                if (this.OnDevAudioFileManagerListener == null) break;
                this.OnDevAudioFileManagerListener.onUploadDataProgressResult(false, this.uploadProgress, message.arg1);
                break;
            }
            case 5154: {
                if (this.OnDevAudioFileManagerListener == null) break;
                this.OnDevAudioFileManagerListener.onUploadEndResult();
                break;
            }
            case 5131: {
                JSONObject object;
                String resultJson;
                if (!"OpSpecifyAudio".equals(msgContent.str) || (resultJson = G.ToStringJson((byte[])msgContent.pData)) == null || (object = JSON.parseObject((String)resultJson)) == null || !object.containsKey((Object)"Cmd")) break;
                String cmd = object.getString("Cmd");
                if ("GetSpecifyAudioList".equals(cmd)) {
                    String audioListJson;
                    if (message.arg1 >= 0 && object.containsKey((Object)"CustomAudioList") && (audioListJson = object.getString("CustomAudioList")) != null) {
                        List voiceReplyBeanList = JSON.parseArray((String)audioListJson, VoiceReplyBean.class);
                        if (this.OnDevAudioFileManagerListener == null) break;
                        this.OnDevAudioFileManagerListener.onGetAudioListResult(true, voiceReplyBeanList, 0);
                        break;
                    }
                    if (this.OnDevAudioFileManagerListener == null) break;
                    this.OnDevAudioFileManagerListener.onGetAudioListResult(false, null, message.arg1);
                    break;
                }
                if (!"PlaySpecifyAudio".equals(cmd) || this.OnDevAudioFileManagerListener == null) break;
                this.OnDevAudioFileManagerListener.onPlayDevVoiceResult(message.arg1 >= 0, message.arg1);
                break;
            }
        }
        if (this.OnDevAudioFileManagerListener != null) {
            this.OnDevAudioFileManagerListener.OnFunSDKResult(message, msgContent);
        }
        return 0;
    }

    public OnDevAudioFileManagerListener getOnDevAudioFileManagerListener() {
        return this.OnDevAudioFileManagerListener;
    }

    public void setOnDevAudioFileManagerListener(OnDevAudioFileManagerListener OnDevAudioFileManagerListener2) {
        this.OnDevAudioFileManagerListener = OnDevAudioFileManagerListener2;
    }

    public static interface OnDevAudioFileManagerListener
    extends IFunSDKResult {
        public void onInitResult(boolean var1, int var2);

        public void onUploadStartResult(boolean var1, int var2);

        public void onUploadDataProgressResult(boolean var1, int var2, int var3);

        public void onUploadEndResult();

        public void onPlayDevVoiceResult(boolean var1, int var2);

        public void onGetAudioListResult(boolean var1, List<VoiceReplyBean> var2, int var3);
    }
}

