/*
 * Decompiled with CFR 0.152.
 */
package com.manager.device.media.encode;

import android.content.Context;
import com.manager.device.media.audio.OnAudioDecibelListener;
import com.manager.device.media.audio.XMAudioManager;

public class AudioEncodeManager
extends XMAudioManager {
    private OnAudioEncodeListener onAudioEncodeListener;

    public AudioEncodeManager(Context context) {
        super(true);
        this.mContext = context;
    }

    public void setOnAudioEncodeListener(OnAudioEncodeListener onAudioEncodeListener) {
        this.onAudioEncodeListener = onAudioEncodeListener;
    }

    @Override
    public void sendAudioToDev(byte[] audioData, int dataLen) {
        if (this.onAudioEncodeListener != null) {
            this.onAudioEncodeListener.onAudioDataResult(audioData, dataLen);
        }
    }

    @Override
    public void setAudioDecibelListener(OnAudioDecibelListener onAudioDecibelListener) {
    }

    public void startAudioRecord() {
        this.canSendTalkDataToDevice = true;
        this.createThreadAndStart();
    }

    public void stopAudioRecord() {
        this.canSendTalkDataToDevice = false;
        this.stopTalkThread();
    }

    public void release() {
        this.stopAudioRecord();
        this.mContext = null;
    }

    public static interface OnAudioEncodeListener {
        public void onAudioDataResult(byte[] var1, int var2);
    }
}

