/*
 * Decompiled with CFR 0.152.
 */
package com.manager.device.media.calendar;

import android.os.Message;
import androidx.annotation.NonNull;
import com.basic.G;
import com.lib.FunSDK;
import com.lib.IFunSDKResult;
import com.lib.Mps.MpsClient;
import com.lib.MsgContent;
import com.lib.cloud.CloudDirectory;
import com.lib.cloud.MediaDates;
import com.lib.sdk.bean.OPSCalendarMonth;
import com.lib.sdk.bean.StringUtils;
import com.lib.sdk.bean.cloudmedia.CloudMediaDatesBean;
import com.manager.base.BaseManager;
import java.util.Calendar;
import java.util.HashMap;

public class MediaFileCalendarManager
extends BaseManager
implements IFunSDKResult {
    private int mediaType;
    private OPSCalendarMonth opsCalendar;
    private Calendar initCalendar;
    private int userId;
    private String devId;
    private HashMap<Object, Boolean> fileMaps;
    private OnMediaFileCalendarListener mediaFileCalendarListener;

    public MediaFileCalendarManager(OnMediaFileCalendarListener listener) {
        this.mediaFileCalendarListener = listener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void searchFile(@NonNull Calendar searchCalendar, int mediaType, int position, boolean isClearBeforeData) {
        if (searchCalendar == null) {
            return;
        }
        if (isClearBeforeData && this.fileMaps != null) {
            this.fileMaps.clear();
        }
        this.mediaType = mediaType;
        this.initCalendar = (Calendar)searchCalendar.clone();
        if (mediaType == 0) {
            MediaFileCalendarManager mediaFileCalendarManager = this;
            synchronized (mediaFileCalendarManager) {
                this.opsCalendar.setMonth(searchCalendar.get(2) + 1);
                this.opsCalendar.setYear(searchCalendar.get(1));
                FunSDK.DevCmdGeneral((int)this.userId, (String)this.devId, (int)1446, (String)"OPSCalendar", (int)-1, (int)10000, (byte[])this.opsCalendar.getSendMsg().getBytes(), (int)-1, (int)position);
            }
        }
        if (mediaType == 1) {
            OPSCalendarMonth oPSCalendarMonth = this.opsCalendar;
            synchronized (oPSCalendarMonth) {
                this.opsCalendar.setMonth(searchCalendar.get(2) + 1);
                this.opsCalendar.setYear(searchCalendar.get(1));
                int times = FunSDK.ToTimeType((int[])new int[]{searchCalendar.get(1), searchCalendar.get(2) + 1, searchCalendar.get(5), 0, 0, 0});
                CloudDirectory.SearchMediaByMoth((int)this.userId, (String)this.devId, (int)0, (String)"Main", (int)times, (int)position);
            }
        }
        if (mediaType == 2) {
            OPSCalendarMonth oPSCalendarMonth = this.opsCalendar;
            synchronized (oPSCalendarMonth) {
                this.opsCalendar.setMonth(searchCalendar.get(2) + 1);
                this.opsCalendar.setYear(searchCalendar.get(1));
                int times = FunSDK.ToTimeType((int[])new int[]{searchCalendar.get(1), searchCalendar.get(2) + 1, searchCalendar.get(5), 0, 0, 0});
                MpsClient.SearchAlarmByMoth((int)this.userId, (String)this.devId, (int)0, (String)"Main", (int)times, (int)position);
            }
        }
    }

    public void searchFile(@NonNull Calendar searchCalendar, int mediaType, int position) {
        this.searchFile(searchCalendar, mediaType, position, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int OnFunSDKResult(Message msg, MsgContent ex) {
        if (msg.arg1 < 0) {
            if (this.mediaFileCalendarListener != null) {
                this.mediaFileCalendarListener.onFailed(msg.what, msg.arg1);
            }
            return 0;
        }
        if (msg.what == 5131) {
            String json;
            if (ex.pData != null && !StringUtils.isStringNULL(json = G.ToString((byte[])ex.pData, (String)"UTF-8"))) {
                MediaFileCalendarManager mediaFileCalendarManager = this;
                synchronized (mediaFileCalendarManager) {
                    Calendar calendar = this.initCalendar == null ? Calendar.getInstance() : this.initCalendar.clone();
                    calendar.add(2, ex.seq);
                    this.opsCalendar.setMonth(calendar.get(2) + 1);
                    this.opsCalendar.setYear(calendar.get(1));
                    if (this.opsCalendar.parseJson(json) && this.mediaFileCalendarListener != null) {
                        this.mediaFileCalendarListener.onHaveFileData(this.fileMaps, ex.seq);
                    }
                }
            }
        } else if (msg.what == 6201) {
            if (null != ex.pData) {
                MediaDates dates = new MediaDates();
                G.BytesToObj((Object)dates, (byte[])ex.pData);
                for (int i = 0; i < dates.st_3_nItemCount; ++i) {
                    this.fileMaps.put(dates.st_4_date[i].getDate(), true);
                }
                if (this.mediaFileCalendarListener != null) {
                    this.mediaFileCalendarListener.onHaveFileData(this.fileMaps, ex.seq);
                }
            }
        } else if (msg.what == 6202) {
            this.opsCalendar.setRecordMap(new CloudMediaDatesBean().parseJson(ex.str));
            if (this.mediaFileCalendarListener != null) {
                this.mediaFileCalendarListener.onHaveFileData(this.fileMaps, ex.seq);
            }
        } else if (msg.what == 6014) {
            this.opsCalendar.setRecordMap(new CloudMediaDatesBean().parseJson(ex.str));
            if (this.mediaFileCalendarListener != null) {
                this.mediaFileCalendarListener.onHaveFileData(this.fileMaps, ex.seq);
            }
        }
        return 0;
    }

    public boolean init(String devId, Calendar initCalendar, String fileType) {
        this.devId = devId;
        this.initCalendar = initCalendar != null ? initCalendar : Calendar.getInstance();
        this.opsCalendar = new OPSCalendarMonth();
        this.opsCalendar.setEvent("*");
        this.opsCalendar.setFileType(fileType);
        this.opsCalendar.setRev("");
        this.fileMaps = this.opsCalendar.getRecordMap();
        return this.init();
    }

    @Override
    public boolean init() {
        this.userId = FunSDK.GetId((int)this.userId, (IFunSDKResult)this);
        return true;
    }

    @Override
    public void unInit() {
        FunSDK.UnRegUser((int)this.userId);
        this.userId = 0;
    }

    public static interface OnMediaFileCalendarListener {
        public void onHaveFileData(HashMap<Object, Boolean> var1, int var2);

        public void onFailed(int var1, int var2);
    }
}

