/*
 * Decompiled with CFR 0.152.
 */
package com.manager.device.media.audio;

import android.media.AudioRecord;
import android.os.SystemClock;
import com.manager.device.media.audio.OnAudioDecibelListener;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.ShortBuffer;

public class XMRecordingManagerV2 {
    public static final int BIT_RATE = 320;
    private boolean threadExitFlag = false;
    private AudioRecord audioRecord = null;
    private OnRecordingListener listener;
    private ShortBuffer audioDataBuffer;
    private long startRecoringTime;
    private int recordMaxTime = Integer.MAX_VALUE;
    private RecordingTread recordingTread;
    private int bufferSizeInBytes = 0;
    protected OnAudioDecibelListener mAudioDecibelLs;

    public XMRecordingManagerV2(OnRecordingListener listener, int recordMaxTime, boolean isRealTimeCallback) {
        this.listener = listener;
        if (isRealTimeCallback) {
            this.recordMaxTime = -1;
        } else {
            this.recordMaxTime = recordMaxTime;
            this.audioDataBuffer = ShortBuffer.allocate(0x100000 * recordMaxTime);
        }
    }

    public void setAudioDecibelListener(OnAudioDecibelListener listener) {
        this.mAudioDecibelLs = listener;
    }

    public boolean isRecording() {
        return this.recordingTread != null;
    }

    public boolean startRecording() {
        if (this.audioDataBuffer != null) {
            this.audioDataBuffer.clear();
        }
        if (this.recordingTread == null) {
            this.recordingTread = new RecordingTread();
            return this.recordingTread.startRecording();
        }
        return false;
    }

    public void stopRecording() {
        if (this.recordingTread != null) {
            this.recordingTread.stopRecording();
            this.recordingTread = null;
        }
    }

    private final int fixWave(short rawData) {
        int scaledData = ((rawData & 0xFFFF) - Short.MAX_VALUE) / 256;
        boolean var3 = false;
        int var5 = Math.abs(scaledData) - 127;
        boolean var4 = false;
        return Math.abs(var5) < 5 ? 127 : (scaledData - 127) * 5 + 127;
    }

    private void dealWithVolume(short[] audioData, int readSize) {
        double sum = 0.0;
        for (short buffer : audioData) {
            sum += (double)Math.abs(buffer);
        }
        sum = sum / (double)readSize / 2.0;
        double volume = 0.0;
        if (sum > 0.0) {
            volume = 20.0 * Math.log10(sum);
        }
        if (this.mAudioDecibelLs != null) {
            this.mAudioDecibelLs.onVolume(volume);
        }
    }

    private short[] bytesToShort(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        short[] shorts = new short[bytes.length / 2];
        ByteBuffer.wrap(bytes).order(ByteOrder.LITTLE_ENDIAN).asShortBuffer().get(shorts);
        return shorts;
    }

    public static interface OnRecordingListener {
        public void onRecording(int var1, short[] var2, int var3);

        public void onComplete(ShortBuffer var1, int var2);
    }

    class RecordingTread
    extends Thread {
        RecordingTread() {
        }

        public synchronized boolean startRecording() {
            if (!this.isAlive()) {
                XMRecordingManagerV2.this.threadExitFlag = false;
                int minBufSize = AudioRecord.getMinBufferSize((int)8000, (int)2, (int)2);
                XMRecordingManagerV2.this.audioRecord = new AudioRecord(1, 8000, 2, 2, minBufSize);
                if (XMRecordingManagerV2.this.audioRecord.getState() == 0) {
                    return false;
                }
                if (XMRecordingManagerV2.this.bufferSizeInBytes == 0) {
                    XMRecordingManagerV2.this.bufferSizeInBytes = minBufSize / 2;
                }
                XMRecordingManagerV2.this.startRecoringTime = System.currentTimeMillis();
                super.start();
                return true;
            }
            return false;
        }

        public synchronized void stopRecording() {
            XMRecordingManagerV2.this.threadExitFlag = true;
        }

        @Override
        public void run() {
            if (null == XMRecordingManagerV2.this.audioRecord) {
                return;
            }
            XMRecordingManagerV2.this.audioRecord.startRecording();
            short[] audioData = new short[XMRecordingManagerV2.this.bufferSizeInBytes];
            while (!XMRecordingManagerV2.this.threadExitFlag && XMRecordingManagerV2.this.audioRecord != null) {
                int recordingTime = (int)((System.currentTimeMillis() - XMRecordingManagerV2.this.startRecoringTime) / 1000L);
                int readSize = XMRecordingManagerV2.this.audioRecord.read(audioData, 0, XMRecordingManagerV2.this.bufferSizeInBytes);
                if (readSize > 0) {
                    int fixWave = XMRecordingManagerV2.this.fixWave(audioData[0]);
                    float value = ((float)(fixWave & 0xFF) - 128.0f) / 128.0f * 30.0f;
                    if (XMRecordingManagerV2.this.audioDataBuffer != null) {
                        XMRecordingManagerV2.this.audioDataBuffer.put(audioData);
                    }
                    if (XMRecordingManagerV2.this.recordMaxTime != -1 && recordingTime > XMRecordingManagerV2.this.recordMaxTime) {
                        XMRecordingManagerV2.this.threadExitFlag = true;
                        break;
                    }
                    if (XMRecordingManagerV2.this.listener != null && !XMRecordingManagerV2.this.threadExitFlag) {
                        XMRecordingManagerV2.this.listener.onRecording(recordingTime, audioData, readSize);
                    }
                    XMRecordingManagerV2.this.dealWithVolume(audioData, readSize);
                    continue;
                }
                SystemClock.sleep((long)5L);
            }
            if (XMRecordingManagerV2.this.audioRecord != null) {
                if (XMRecordingManagerV2.this.audioRecord.getState() == 3) {
                    XMRecordingManagerV2.this.audioRecord.stop();
                }
                XMRecordingManagerV2.this.audioRecord.release();
                XMRecordingManagerV2.this.audioRecord = null;
                if (XMRecordingManagerV2.this.listener != null && XMRecordingManagerV2.this.audioDataBuffer != null) {
                    int dataLength = XMRecordingManagerV2.this.audioDataBuffer.position();
                    XMRecordingManagerV2.this.audioDataBuffer.flip();
                    XMRecordingManagerV2.this.listener.onComplete(XMRecordingManagerV2.this.audioDataBuffer, dataLength);
                }
            }
            XMRecordingManagerV2.this.recordingTread = null;
        }
    }
}

