/*
 * Decompiled with CFR 0.152.
 */
package com.manager.device.idr;

import android.text.TextUtils;
import com.manager.device.idr.IDRManagerCallBack;
import com.manager.device.idr.IDRWake;
import java.util.HashMap;
import java.util.Map;

public class IDRDevListModel {
    private HashMap<String, IDRWake> mWakeUpHashMap = new HashMap();

    public IDRDevListModel(String[] devices) {
        if (devices == null || devices.length <= 0) {
            return;
        }
        for (int i = 0; i < devices.length; ++i) {
            this.mWakeUpHashMap.put(devices[i], new IDRWake(devices[i]));
        }
    }

    public int getIDRWakeState(String sn) {
        if (TextUtils.isEmpty((CharSequence)sn)) {
            return Integer.MIN_VALUE;
        }
        if (this.mWakeUpHashMap == null || !this.mWakeUpHashMap.containsKey(sn)) {
            return Integer.MIN_VALUE;
        }
        IDRWake idrWake = this.mWakeUpHashMap.get(sn);
        if (idrWake == null) {
            return Integer.MIN_VALUE;
        }
        return idrWake.getState();
    }

    public boolean cancelWakeUp(String sn) {
        if (TextUtils.isEmpty((CharSequence)sn)) {
            return false;
        }
        IDRWake idrWake = this.mWakeUpHashMap.get(sn);
        if (idrWake == null) {
            return false;
        }
        idrWake.cancelWakeUp();
        return true;
    }

    public boolean wakeUp(String sn, IDRManagerCallBack IDRManagerCallBack2) {
        if (TextUtils.isEmpty((CharSequence)sn)) {
            return false;
        }
        IDRWake idrWake = this.mWakeUpHashMap.get(sn);
        if (idrWake == null) {
            return false;
        }
        return idrWake.wakeUp(IDRManagerCallBack2);
    }

    public boolean getDevStateFromServer(String sn, IDRManagerCallBack IDRManagerCallBack2) {
        if (TextUtils.isEmpty((CharSequence)sn)) {
            return false;
        }
        IDRWake idrWake = this.mWakeUpHashMap.get(sn);
        if (idrWake == null) {
            return false;
        }
        return idrWake.getDevStateFromServer(IDRManagerCallBack2);
    }

    public boolean addDevice(String sn) {
        if (TextUtils.isEmpty((CharSequence)sn)) {
            return false;
        }
        if (this.mWakeUpHashMap == null) {
            this.mWakeUpHashMap = new HashMap();
        }
        if (!this.mWakeUpHashMap.containsKey(sn)) {
            this.mWakeUpHashMap.put(sn, new IDRWake(sn));
        }
        return true;
    }

    public boolean delDevice(String sn) {
        if (TextUtils.isEmpty((CharSequence)sn)) {
            return false;
        }
        if (this.mWakeUpHashMap == null || !this.mWakeUpHashMap.containsKey(sn)) {
            return false;
        }
        this.mWakeUpHashMap.remove(sn);
        return true;
    }

    public boolean refreshState(String sn, int state) {
        if (TextUtils.isEmpty((CharSequence)sn)) {
            return false;
        }
        if (this.mWakeUpHashMap == null || !this.mWakeUpHashMap.containsKey(sn)) {
            return false;
        }
        this.mWakeUpHashMap.get(sn).setState(state);
        return true;
    }

    public void destroy() {
        if (this.mWakeUpHashMap != null) {
            for (Map.Entry<String, IDRWake> entry : this.mWakeUpHashMap.entrySet()) {
                if (entry.getValue() == null) continue;
                entry.getValue().onDestroy();
            }
            this.mWakeUpHashMap.clear();
        }
    }
}

