/*
 * Decompiled with CFR 0.152.
 */
package com.manager.device.config.websocket;

import android.app.Application;
import android.content.Context;
import android.os.Handler;
import android.text.TextUtils;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.constant.DeviceConstant;
import com.lib.sdk.bean.StringUtils;
import com.manager.XMFunSDKManager;
import com.manager.db.DevDataCenter;
import com.manager.websocket.WebSocketInfo;
import com.manager.websocket.XMWebSocketManager;
import com.utils.LogUtils;
import com.utils.XUtils;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.TimeUnit;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.logging.HttpLoggingInterceptor;

public class DevStateNotifyManager
implements XMWebSocketManager.XMWebSocketListener {
    public static String DEV_STATE_NOTIFY_URL = "wss://viot-ws.xmcsrv.net/websocket/server";
    private static final int DEFAULT_PERIOD = 15;
    private int reConnectPeriod = 15;
    private int heartTimePeriod = 15;
    private static DevStateNotifyManager devStateNotifyManager;
    private static XMWebSocketManager xmWebSocketManager;
    private ReConnectHandler reConnectHandler;
    private Timer heartTimer;
    private boolean isReconnecting = false;
    private HashMap<String, Boolean> isSelfDelDevMap = new HashMap();
    private HashMap<String, Boolean> isSelfDelGroupMap = new HashMap();
    private WebSocketInfo webSocketInfo;
    private HashMap<Integer, OnDevStateNotifyListener> notifyListenerHashMap = new HashMap();

    private DevStateNotifyManager(Application application) {
        String loginToken = DevDataCenter.getInstance().getAccessToken();
        if (StringUtils.isStringNULL(loginToken)) {
            LogUtils.debugInfo("loginToken", "loginToken null");
        }
        String appId = XUtils.getPushToken((Context)application);
        HttpLoggingInterceptor logging = new HttpLoggingInterceptor();
        logging.setLevel(HttpLoggingInterceptor.Level.BODY);
        Interceptor authorization = chain -> {
            Request original = chain.request();
            Request request = original.newBuilder().addHeader("Content-Type", "application/json").addHeader("appId", appId).addHeader("appKey", XMFunSDKManager.getInstance().getAppKey()).addHeader("Authorization", TextUtils.isEmpty((CharSequence)loginToken) ? "" : loginToken).addHeader("Accept-Language", XUtils.getIoTLanguage()).method(original.method(), original.body()).build();
            return chain.proceed(request);
        };
        OkHttpClient okHttpClient = new OkHttpClient.Builder().connectTimeout(15L, TimeUnit.SECONDS).writeTimeout(15L, TimeUnit.SECONDS).readTimeout(15L, TimeUnit.SECONDS).addInterceptor((Interceptor)logging).addInterceptor(authorization).build();
        xmWebSocketManager = XMWebSocketManager.getInstance(application.getApplicationContext());
        xmWebSocketManager.setPrintLog(true);
        xmWebSocketManager.setClient(okHttpClient);
        xmWebSocketManager.addXMWebSocketListener(this);
        this.reConnectHandler = new ReConnectHandler(application.getApplicationContext());
    }

    public static synchronized DevStateNotifyManager getInstance(Application application) {
        if (devStateNotifyManager == null) {
            devStateNotifyManager = new DevStateNotifyManager(application);
        }
        return devStateNotifyManager;
    }

    public boolean webSocketIsConnect() {
        if (null == this.webSocketInfo) {
            return false;
        }
        return this.webSocketInfo.isConnect();
    }

    public void addNotifyListener(OnDevStateNotifyListener onDevStateNotifyListener) {
        if (onDevStateNotifyListener != null && this.notifyListenerHashMap != null && !this.notifyListenerHashMap.containsKey(onDevStateNotifyListener.hashCode())) {
            this.notifyListenerHashMap.put(onDevStateNotifyListener.hashCode(), onDevStateNotifyListener);
        }
    }

    public void removeNotifyListener(OnDevStateNotifyListener onDevStateNotifyListener) {
        if (this.notifyListenerHashMap != null && onDevStateNotifyListener != null && this.notifyListenerHashMap.containsKey(onDevStateNotifyListener.hashCode())) {
            this.notifyListenerHashMap.remove(onDevStateNotifyListener.hashCode());
        }
    }

    private void dealWithDevErrorState(String devId, String errorId, Object errorMsg, JSONObject originalData) {
        if (this.notifyListenerHashMap != null) {
            for (Integer key : this.notifyListenerHashMap.keySet()) {
                OnDevStateNotifyListener onDevStateNotifyListener = this.notifyListenerHashMap.get(key);
                if (onDevStateNotifyListener == null) continue;
                onDevStateNotifyListener.onDevErrorState(devId, errorId, errorMsg, originalData);
            }
        }
    }

    private void dealWithDevSleepState(String devId, Object value, JSONObject originalData) {
        if (this.notifyListenerHashMap != null) {
            for (Integer key : this.notifyListenerHashMap.keySet()) {
                OnDevStateNotifyListener onDevStateNotifyListener = this.notifyListenerHashMap.get(key);
                if (onDevStateNotifyListener == null) continue;
                onDevStateNotifyListener.onDevSleepState(devId, value, originalData);
            }
        }
    }

    private void dealWithDevFunState(String devId, String funId, Object value, JSONObject originalData) {
        if (this.notifyListenerHashMap != null) {
            for (Integer key : this.notifyListenerHashMap.keySet()) {
                OnDevStateNotifyListener onDevStateNotifyListener = this.notifyListenerHashMap.get(key);
                if (onDevStateNotifyListener == null) continue;
                onDevStateNotifyListener.onDevFunState(devId, funId, value, originalData);
            }
        }
    }

    public void connectWebSocket() {
        if (xmWebSocketManager != null) {
            xmWebSocketManager.connectWebSocket(DEV_STATE_NOTIFY_URL);
        }
    }

    public synchronized void startReConnect() {
        if (this.reConnectHandler == null) {
            return;
        }
        this.reConnectHandler.postDelayed(new Runnable(){

            @Override
            public void run() {
                if (xmWebSocketManager != null) {
                    LogUtils.debugInfo("[APP_WEB_SOCKET]->", "\u5f00\u59cb\u91cd\u8fde");
                    if (!xmWebSocketManager.isWebSocketConnected()) {
                        xmWebSocketManager.connectWebSocket(DEV_STATE_NOTIFY_URL);
                    }
                }
            }
        }, this.reConnectPeriod * 1000);
    }

    public synchronized void closeReConnect() {
        if (this.reConnectHandler == null) {
            return;
        }
        this.reConnectHandler.removeCallbacksAndMessages(null);
        LogUtils.debugInfo("[APP_WEB_SOCKET]->", "\u5173\u95ed\u91cd\u8fde");
    }

    public void subscribeByGroup(List<String> devIds, String groupId, String userId) {
        if (xmWebSocketManager != null) {
            if (!xmWebSocketManager.isWebSocketConnected()) {
                this.connectWebSocket();
            } else {
                ArrayList<String> topicDataList = new ArrayList<String>();
                topicDataList.addAll(devIds);
                if (!TextUtils.isEmpty((CharSequence)groupId)) {
                    topicDataList.add(groupId);
                }
                if (!TextUtils.isEmpty((CharSequence)userId)) {
                    topicDataList.add(userId);
                }
                if (topicDataList.isEmpty()) {
                    return;
                }
                JSONObject topic = new JSONObject();
                topic.put("topic", (Object)topicDataList.toArray());
                this.sendWebSocketData("subscribe", topic);
            }
        }
    }

    public void unSubscribe(List<String> devIds, String groupId, String userId) {
        if (xmWebSocketManager != null) {
            if (!xmWebSocketManager.isWebSocketConnected()) {
                this.connectWebSocket();
            } else {
                ArrayList<String> topicDataList = new ArrayList<String>();
                topicDataList.addAll(devIds);
                if (!TextUtils.isEmpty((CharSequence)groupId)) {
                    topicDataList.add(groupId);
                }
                if (!TextUtils.isEmpty((CharSequence)userId)) {
                    topicDataList.add(userId);
                }
                JSONObject topic = new JSONObject();
                topic.put("topic", (Object)topicDataList.toArray());
                this.sendWebSocketData("unsubscribe", topic);
            }
        }
    }

    public void sendWebSocketData(String command, Object data) {
        if (xmWebSocketManager != null) {
            if (!xmWebSocketManager.isWebSocketConnected()) {
                LogUtils.debugInfo("[APP_WEB_SOCKET]->", "connectWebSocket");
                this.connectWebSocket();
            } else {
                JSONObject subscribe = new JSONObject();
                subscribe.put("command", (Object)command);
                subscribe.put("data", data);
                String sendWebSocketData = subscribe.toJSONString();
                LogUtils.debugInfo("[APP_WEB_SOCKET]->", "sendWebSocketData" + sendWebSocketData);
                xmWebSocketManager.sendData(sendWebSocketData);
            }
        }
    }

    private synchronized void startHeartTimer() {
        if (this.heartTimer == null) {
            this.heartTimer = new Timer();
            this.heartTimer.schedule(new TimerTask(){

                @Override
                public void run() {
                    if (xmWebSocketManager != null) {
                        LogUtils.debugInfo("[APP_WEB_SOCKET]->", "\u5f00\u59cb\u4fdd\u6d3b");
                        if (!xmWebSocketManager.isWebSocketConnected()) {
                            DevStateNotifyManager.this.connectWebSocket();
                        } else {
                            xmWebSocketManager.sendData("AndroidHeart");
                        }
                    }
                }
            }, this.heartTimePeriod * 1000, (long)(this.heartTimePeriod * 1000));
        }
    }

    private synchronized void closeHeartTimer() {
        if (this.heartTimer != null) {
            LogUtils.debugInfo("[APP_WEB_SOCKET]->", "\u5173\u95ed\u4fdd\u6d3b");
            this.heartTimer.cancel();
            this.heartTimer = null;
        }
    }

    public void closeCurrentConnect() {
        if (xmWebSocketManager != null) {
            xmWebSocketManager.closeWebSocket();
        }
        this.closeHeartTimer();
    }

    public void release() {
        this.closeHeartTimer();
        this.closeReConnect();
        if (xmWebSocketManager != null) {
            xmWebSocketManager.release();
            xmWebSocketManager = null;
        }
        if (this.notifyListenerHashMap != null) {
            this.notifyListenerHashMap.clear();
            this.notifyListenerHashMap = null;
        }
        devStateNotifyManager = null;
        this.reConnectHandler = null;
    }

    public void setReConnectPeriod(int reConnectPeriod) {
        this.reConnectPeriod = reConnectPeriod;
    }

    @Override
    public void onWebSocketState(WebSocketInfo webSocketInfo) {
        LogUtils.debugInfo("onsocket", "currentThread " + Thread.currentThread().getName());
        if (devStateNotifyManager == null) {
            return;
        }
        DevStateNotifyManager.devStateNotifyManager.webSocketInfo = webSocketInfo;
        if (webSocketInfo.getState() == 1) {
            LogUtils.debugInfo("[APP_WEB_SOCKET]->", "WebSocket \u5df2\u7ecf\u8fde\u63a5");
            this.closeHeartTimer();
            this.closeReConnect();
            this.startHeartTimer();
            if (this.isReconnecting) {
                this.isReconnecting = false;
                if (this.notifyListenerHashMap != null) {
                    for (Integer key : this.notifyListenerHashMap.keySet()) {
                        OnDevStateNotifyListener onDevStateNotifyListener = this.notifyListenerHashMap.get(key);
                        if (onDevStateNotifyListener == null) continue;
                        onDevStateNotifyListener.onReconnected();
                    }
                }
            } else if (this.notifyListenerHashMap != null) {
                for (Integer key : this.notifyListenerHashMap.keySet()) {
                    OnDevStateNotifyListener onDevStateNotifyListener = this.notifyListenerHashMap.get(key);
                    if (onDevStateNotifyListener == null) continue;
                    onDevStateNotifyListener.onConnected();
                }
            }
        } else if (webSocketInfo.getState() == 0) {
            LogUtils.debugInfo("[APP_WEB_SOCKET]->", "WebSocket \u5df2\u7ecf\u65ad\u5f00");
            this.closeHeartTimer();
            this.startReConnect();
            if (this.notifyListenerHashMap != null) {
                for (Integer key : this.notifyListenerHashMap.keySet()) {
                    OnDevStateNotifyListener onDevStateNotifyListener = this.notifyListenerHashMap.get(key);
                    if (onDevStateNotifyListener == null) continue;
                    onDevStateNotifyListener.onDisconnected();
                }
            }
        } else if (webSocketInfo.getState() == 4) {
            LogUtils.debugInfo("[APP_WEB_SOCKET]->", webSocketInfo.getStrMsg());
            this.webSocketDataParse(webSocketInfo.getStrMsg());
        } else if (webSocketInfo.getState() == 3) {
            this.closeHeartTimer();
            this.isReconnecting = true;
            if (this.notifyListenerHashMap != null) {
                for (Integer key : this.notifyListenerHashMap.keySet()) {
                    OnDevStateNotifyListener onDevStateNotifyListener = this.notifyListenerHashMap.get(key);
                    if (onDevStateNotifyListener == null) continue;
                    onDevStateNotifyListener.onReconnecting();
                }
            }
            this.startReConnect();
        }
    }

    public void webSocketDataParse(String jsonData) {
        if (jsonData == null) {
            return;
        }
        String devId = null;
        JSONObject notifyEventMap = (JSONObject)JSON.parse((String)jsonData);
        if (notifyEventMap != null && !notifyEventMap.isEmpty()) {
            JSONArray eventMap;
            Object eventObj;
            Object snObj;
            if (notifyEventMap.containsKey((Object)"sn") && (snObj = notifyEventMap.get((Object)"sn")) instanceof String) {
                devId = (String)snObj;
            }
            if (notifyEventMap.containsKey((Object)"props") && (eventObj = notifyEventMap.get((Object)"props")) instanceof JSONArray && !(eventMap = (JSONArray)eventObj).isEmpty()) {
                block4: for (int i = 0; i < eventMap.size(); ++i) {
                    Object eventsObj;
                    Object propCodeObj;
                    String propCode = null;
                    Object propValue = null;
                    JSONArray eventArray = null;
                    JSONObject propObj = (JSONObject)eventMap.get(i);
                    if (propObj.containsKey((Object)"propCode") && (propCodeObj = propObj.get((Object)"propCode")) instanceof String) {
                        propCode = (String)propCodeObj;
                    }
                    if (propObj.containsKey((Object)"propValue")) {
                        propValue = propObj.get((Object)"propValue");
                    }
                    if (propObj.containsKey((Object)"events") && (eventsObj = propObj.get((Object)"events")) instanceof JSONArray) {
                        eventArray = (JSONArray)eventsObj;
                        if (propCode != null) {
                            this.dealWithDevErrorState(devId, propCode, eventArray, notifyEventMap);
                        }
                    }
                    if (propCode == null) continue;
                    for (DeviceConstant.DevStateConstant.DevFunStatus devFunStatus : DeviceConstant.DevStateConstant.DevFunStatus.values()) {
                        if (!StringUtils.contrast(devFunStatus.getEventId(), propCode)) continue;
                        switch (devFunStatus.getType()) {
                            case 0: {
                                if (propValue == null) continue block4;
                                this.dealWithDevSleepState(devId, propValue, notifyEventMap);
                                break;
                            }
                            case 1: {
                                if (propValue == null) continue block4;
                                this.dealWithDevFunState(devId, propCode, propValue, notifyEventMap);
                                break;
                            }
                        }
                        continue block4;
                    }
                }
            }
        }
    }

    public void addDelIdentify(String devId) {
        if (this.isSelfDelDevMap != null) {
            this.isSelfDelDevMap.put(devId, true);
        }
    }

    public void removeDelIdentify(String devId) {
        if (this.isSelfDelDevMap != null) {
            this.isSelfDelDevMap.put(devId, false);
        }
    }

    public void addDelGroupIdenify(String userGroupId) {
        if (this.isSelfDelGroupMap != null) {
            this.isSelfDelGroupMap.put(userGroupId, true);
        }
    }

    public void removeDelGroupIdenify(String userGroupId) {
        if (this.isSelfDelGroupMap != null) {
            this.isSelfDelGroupMap.put(userGroupId, false);
        }
    }

    public static interface OnDevStateNotifyListener {
        default public void onDevSleepState(String devId, Object value, JSONObject originalData) {
        }

        default public void onDevFunState(String devId, String funId, Object value, JSONObject originalData) {
        }

        default public void onDevErrorState(String devId, String errorId, Object errorMsg, JSONObject originalData) {
        }

        default public void onReconnecting() {
        }

        default public void onReconnected() {
        }

        default public void onConnected() {
        }

        default public void onDisconnected() {
        }
    }

    private static class ReConnectHandler
    extends Handler {
        WeakReference<Context> contextWeakReference;

        ReConnectHandler(Context context) {
            this.contextWeakReference = new WeakReference<Context>(context);
        }
    }
}

