/*
 * Decompiled with CFR 0.152.
 */
package com.manager.device.config.shadow;

import android.os.Message;
import com.basic.G;
import com.google.gson.Gson;
import com.lib.FunSDK;
import com.lib.IFunSDKResult;
import com.lib.MsgContent;
import com.manager.device.config.shadow.IDevShadowManager;
import com.manager.device.config.shadow.OnDevShadowManagerListener;
import java.util.HashMap;
import java.util.Map;

public class DevShadowManager
implements IDevShadowManager,
IFunSDKResult {
    private static DevShadowManager devShadowManager;
    private int userId = FunSDK.GetId((int)this.userId, (IFunSDKResult)this);
    private int timeout = 5000;
    private Map<Integer, OnDevShadowManagerListener> devShadowManagerListenerMap = new HashMap<Integer, OnDevShadowManagerListener>();

    private DevShadowManager() {
    }

    private void init() {
        this.userId = FunSDK.GetId((int)this.userId, (IFunSDKResult)this);
    }

    public static synchronized DevShadowManager getInstance() {
        if (devShadowManager == null) {
            devShadowManager = new DevShadowManager();
        }
        devShadowManager.init();
        return devShadowManager;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    @Override
    public boolean getDevCfgsFromShadowService(String devId, String ... configNames) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("msg", "getcfg");
        hashMap.put("cfglist", configNames);
        int iRet = FunSDK.GetDevCfgsFromShadowService((int)this.userId, (String)devId, (String)new Gson().toJson(hashMap), (int)this.timeout, (int)0);
        return iRet >= 0;
    }

    @Override
    public boolean setDevOffLineCfgsToShadowService(String devId, HashMap<String, Object> configData) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("msg", "setcfg");
        hashMap.put("cfglist", configData);
        int iRet = FunSDK.SetDevOffLineCfgsToShadowService((int)this.userId, (String)devId, (String)new Gson().toJson(hashMap), (int)this.timeout, (int)0);
        return iRet >= 0;
    }

    @Override
    public boolean startRealTimeDataCallback(String ... devIds) {
        if (devIds == null) {
            return false;
        }
        StringBuilder sb = new StringBuilder();
        for (String devId : devIds) {
            sb.append(devId);
            sb.append(";");
        }
        int iRet = FunSDK.AddShadowServiceListener((int)this.userId, (String)sb.toString(), (int)this.timeout, (int)0);
        return iRet >= 0;
    }

    @Override
    public boolean stopRealTimeDataCallback(String ... devIds) {
        if (devIds == null) {
            return false;
        }
        StringBuilder sb = new StringBuilder();
        for (String devId : devIds) {
            sb.append(devId);
            sb.append(";");
        }
        int iRet = FunSDK.RemoveShadowServiceListener((int)this.userId, (String)sb.toString(), (int)this.timeout, (int)0);
        return iRet >= 0;
    }

    @Override
    public void addDevShadowListener(OnDevShadowManagerListener onDevShadowManagerListener) {
        if (this.devShadowManagerListenerMap != null && onDevShadowManagerListener != null) {
            this.devShadowManagerListenerMap.put(onDevShadowManagerListener.hashCode(), onDevShadowManagerListener);
        }
    }

    @Override
    public void removeDevShadowListener(OnDevShadowManagerListener onDevShadowManagerListener) {
        if (this.devShadowManagerListenerMap != null && onDevShadowManagerListener != null) {
            this.devShadowManagerListenerMap.remove(onDevShadowManagerListener.hashCode());
        }
    }

    @Override
    public void release() {
        if (this.userId != 0) {
            FunSDK.UnRegUser((int)this.userId);
            this.userId = 0;
        }
        if (this.devShadowManagerListenerMap != null) {
            this.devShadowManagerListenerMap.clear();
            this.devShadowManagerListenerMap = null;
        }
    }

    private void dealWithGetConfigCallback(Message message, MsgContent msgContent) {
        String devId = msgContent.str;
        if (this.devShadowManagerListenerMap != null) {
            for (Map.Entry<Integer, OnDevShadowManagerListener> entry : this.devShadowManagerListenerMap.entrySet()) {
                if (entry == null || entry.getValue() == null) continue;
                entry.getValue().onDevShadowConfigResult(devId, msgContent.pData == null ? null : G.ToString((byte[])msgContent.pData), message.arg1);
                entry.getValue().onFunSDKResult(message, msgContent);
            }
        }
    }

    private void dealWithSetConfigCallback(Message message, MsgContent msgContent) {
        String devId = msgContent.str;
        if (this.devShadowManagerListenerMap != null) {
            for (Map.Entry<Integer, OnDevShadowManagerListener> entry : this.devShadowManagerListenerMap.entrySet()) {
                if (entry == null || entry.getValue() == null) continue;
                entry.getValue().onSetDevShadowConfigResult(devId, message.arg1 >= 0, message.arg1);
                entry.getValue().onFunSDKResult(message, msgContent);
            }
        }
    }

    private void dealWithNotifyConfigCallback(Message message, MsgContent msgContent) {
        String devId = msgContent.str;
        if (this.devShadowManagerListenerMap != null) {
            for (Map.Entry<Integer, OnDevShadowManagerListener> entry : this.devShadowManagerListenerMap.entrySet()) {
                if (entry == null || entry.getValue() == null) continue;
                entry.getValue().onDevShadowConfigResult(devId, msgContent.pData == null ? null : G.ToString((byte[])msgContent.pData), message.arg1);
                entry.getValue().onFunSDKResult(message, msgContent);
            }
        }
    }

    private void dealWithLinkCallback(Message message, MsgContent msgContent) {
        String devId = msgContent.str;
        if (this.devShadowManagerListenerMap != null) {
            for (Map.Entry<Integer, OnDevShadowManagerListener> entry : this.devShadowManagerListenerMap.entrySet()) {
                if (entry == null || entry.getValue() == null) continue;
                entry.getValue().onLinkShadow(devId, message.arg1);
                entry.getValue().onFunSDKResult(message, msgContent);
            }
        }
    }

    private void dealWithUnLinkCallback(Message message, MsgContent msgContent) {
        String devId = msgContent.str;
        if (this.devShadowManagerListenerMap != null) {
            for (Map.Entry<Integer, OnDevShadowManagerListener> entry : this.devShadowManagerListenerMap.entrySet()) {
                if (entry == null || entry.getValue() == null) continue;
                entry.getValue().onUnLinkShadow(devId, message.arg1);
                entry.getValue().onFunSDKResult(message, msgContent);
            }
        }
    }

    private void dealWithDisconnectCallback(Message message, MsgContent msgContent) {
        if (this.devShadowManagerListenerMap != null) {
            for (Map.Entry<Integer, OnDevShadowManagerListener> entry : this.devShadowManagerListenerMap.entrySet()) {
                if (entry == null || entry.getValue() == null) continue;
                entry.getValue().onLinkShadowDisconnect();
                entry.getValue().onFunSDKResult(message, msgContent);
            }
        }
    }

    public int OnFunSDKResult(Message message, MsgContent msgContent) {
        switch (message.what) {
            case 8800: {
                this.dealWithGetConfigCallback(message, msgContent);
                break;
            }
            case 8802: {
                this.dealWithNotifyConfigCallback(message, msgContent);
                break;
            }
            case 8801: {
                this.dealWithSetConfigCallback(message, msgContent);
                break;
            }
            case 8803: {
                this.dealWithLinkCallback(message, msgContent);
                break;
            }
            case 8804: {
                this.dealWithUnLinkCallback(message, msgContent);
                break;
            }
            case 8805: {
                this.dealWithDisconnectCallback(message, msgContent);
                break;
            }
        }
        return 0;
    }
}

