/*
 * Decompiled with CFR 0.152.
 */
package com.manager.device;

import android.graphics.Bitmap;
import android.net.DhcpInfo;
import android.os.Bundle;
import android.os.Message;
import android.text.TextUtils;
import android.text.format.Formatter;
import android.util.Log;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.basic.G;
import com.google.gson.Gson;
import com.lib.FunSDK;
import com.lib.IFunSDKResult;
import com.lib.Mps.MpsClient;
import com.lib.Mps.SQueryDevHistoryParams;
import com.lib.MsgContent;
import com.lib.sdk.bean.DSTimeBean;
import com.lib.sdk.bean.DayLightTimeBean;
import com.lib.sdk.bean.DefaultConfigBean;
import com.lib.sdk.bean.EncyptChipInfoBean;
import com.lib.sdk.bean.HandleConfigData;
import com.lib.sdk.bean.LocationBean;
import com.lib.sdk.bean.PtzCtrlInfoBean;
import com.lib.sdk.bean.StringUtils;
import com.lib.sdk.bean.SystemFunctionBean;
import com.lib.sdk.bean.SystemInfoBean;
import com.lib.sdk.bean.SystemInfoExBean;
import com.lib.sdk.bean.TimeZoneBean;
import com.lib.sdk.bean.VideoWidgetBean;
import com.lib.sdk.struct.SDBDeviceInfo;
import com.lib.sdk.struct.SDK_CONFIG_NET_COMMON_V2;
import com.lib.sdk.struct.SDK_ChannelNameConfigAll;
import com.manager.base.BaseManager;
import com.manager.db.DevDataCenter;
import com.manager.db.XMDevInfo;
import com.manager.device.IDeviceManager;
import com.manager.device.bind.qrcode.presenter.QRConfigResultManager;
import com.manager.device.config.DevConfigInfo;
import com.manager.device.config.DevConfigManager;
import com.manager.device.config.preset.IPresetManager;
import com.manager.device.config.preset.PresetManager;
import com.manager.device.fisheye.FishEyeConfig;
import com.manager.device.idr.IDRManagerCallBack;
import com.manager.device.idr.IDRWake;
import com.manager.device.media.attribute.PlayerAttribute;
import com.manager.device.media.attribute.RecordPlayerAttribute;
import com.manager.device.media.monitor.MonitorManager;
import com.manager.device.media.playback.CloudRecordManager;
import com.manager.device.media.playback.DevRecordManager;
import com.manager.device.media.playback.RecordManager;
import com.utils.XUtils;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;

public class DeviceManager
extends BaseManager
implements IDeviceManager,
IFunSDKResult,
DevDataCenter.OnDevDataCenterListener {
    public static final int OPERA_LOGIN_DEV = 0;
    public static final int OPERA_GET_CONFIG_DEV = 1;
    public static final int OPERA_SET_CONFIG_DEV = 2;
    public static final int OPERA_CMD = 3;
    public static final int OPERA_WAKE_UP_DEV = 4;
    public static final int DEVICE_LINK_ROUTER_SUCCESS = 244;
    public static final int RECEIVE_ROUTER_INFORMATION_SUCCESS = 1;
    public static final int UPGRADE_TYPE_NONE = 0;
    public static final int UPGRADE_TYPE_CLOUD = 1;
    public static final int UPGRADE_TYPE_FILE_DOWNLOAD = 2;
    public static final int UPGRADE_TYPE_LOCAL_FILE = 3;
    private static DeviceManager instance;
    private DevDataCenter devDataCenter = DevDataCenter.getInstance(this);
    private List<XMDevInfo> lanDevList;
    private HashMap<Integer, String> devIdMap;
    private ConcurrentHashMap<String, DevConfigInfo> listenerMap;
    private int userId = FunSDK.GetId((int)this.userId, (IFunSDKResult)this);
    private int defaultTimeOut = 5000;
    private int loginTimeOut = 15000;
    private OnSearchLocalDevListener onSearchLocalDevListener;
    private OnQuickSetWiFiListener onQuickSetWiFiListener;
    private OnDevWiFiSetListener onDevWiFiSetListener;
    private OnDevUpgradeListener onDevUpgradeListener;

    private DeviceManager() {
        this.devIdMap = new HashMap();
        this.listenerMap = new ConcurrentHashMap();
    }

    public static DeviceManager getInstance() {
        if (null == instance) {
            instance = new DeviceManager();
        }
        return instance;
    }

    @Override
    public boolean init() {
        this.userId = FunSDK.GetId((int)this.userId, (IFunSDKResult)this);
        return true;
    }

    @Override
    public void unInit() {
        FunSDK.UnRegUser((int)this.userId);
        this.userId = -1;
    }

    @Override
    public boolean loginDevByLowPower(final String devId, final OnDevManagerListener listener) {
        if (null == devId) {
            throw new RuntimeException("The devId can't be empty!");
        }
        this.init();
        if (DevDataCenter.getInstance().isLowPowerDev(devId)) {
            new IDRWake(devId).wakeUp(new IDRManagerCallBack(){

                @Override
                public void onStartWakeUp() {
                }

                @Override
                public void onError(Message msg, MsgContent ex) {
                    if (listener != null) {
                        listener.onFailed(devId, msg.what, null, msg.arg1);
                    }
                }

                @Override
                public void onFail(int status) {
                }

                public void onSuccess(Object obj) {
                    DeviceManager.this.loginDev(devId, DevConfigInfo.create(listener, new String[0]));
                }
            });
            return true;
        }
        return this.loginDev(devId, DevConfigInfo.create(listener, new String[0]));
    }

    @Override
    public boolean loginDevByLowPower(String devId, @NotNull String userName, @NotNull String password, OnDevManagerListener listener) {
        if (null == devId) {
            throw new RuntimeException("The devId can't be empty!");
        }
        this.init();
        if (!this.devDataCenter.isDevExist(devId)) {
            Log.w((String)this.getClass().getSimpleName(), (String)"\u5efa\u8bae\u8bf7\u5148\u767b\u5f55\u8d26\u53f7\u5e76\u786e\u4fdd\u5df2\u7ecf\u6dfb\u52a0\u8fc7\u8bbe\u5907");
            SDBDeviceInfo sdbDeviceInfo = new SDBDeviceInfo();
            G.SetValue((byte[])sdbDeviceInfo.st_0_Devmac, (String)devId);
            if (!TextUtils.isEmpty((CharSequence)userName)) {
                G.SetValue((byte[])sdbDeviceInfo.st_4_loginName, (String)userName);
            }
            G.SetValue((byte[])sdbDeviceInfo.st_5_loginPsw, (String)password);
            XMDevInfo xmDevInfo = new XMDevInfo();
            xmDevInfo.sdbDevInfoToXMDevInfo(sdbDeviceInfo);
            DevDataCenter.getInstance().addDev(xmDevInfo);
        }
        if (!TextUtils.isEmpty((CharSequence)userName)) {
            FunSDK.DevSetLocalPwd((String)devId, (String)userName, (String)password);
        }
        return this.loginDevByLowPower(devId, listener);
    }

    @Override
    public boolean wakeUpAndSendCtrl(final String devId, String jsonData, final OnDevManagerListener listener) {
        if (null == devId) {
            throw new RuntimeException("The devId can't be empty!");
        }
        this.init();
        new IDRWake(devId).wakeUpAndSendCtrl(jsonData, false, new IDRManagerCallBack(){

            @Override
            public void onStartWakeUp() {
            }

            @Override
            public void onError(Message msg, MsgContent ex) {
                if (listener != null) {
                    listener.onFailed(devId, msg.what, null, msg.arg1);
                }
            }

            @Override
            public void onFail(int status) {
            }

            public void onSuccess(Object obj) {
                if (listener != null) {
                    listener.onSuccess(devId, 4, obj);
                }
            }
        });
        return true;
    }

    @Override
    public boolean loginDev(String devId, OnDevManagerListener listener) {
        if (null == devId) {
            throw new RuntimeException("The devId can't be empty!");
        }
        this.init();
        return this.loginDev(devId, DevConfigInfo.create(listener, new String[0]));
    }

    @Override
    public boolean loginDev(@NotNull String devId, @NotNull String userName, @NotNull String password, OnDevManagerListener listener) {
        if (TextUtils.isEmpty((CharSequence)devId)) {
            throw new RuntimeException("The devId can't be empty!");
        }
        this.init();
        if (!this.devDataCenter.isDevExist(devId)) {
            Log.w((String)this.getClass().getSimpleName(), (String)"\u5efa\u8bae\u8bf7\u5148\u767b\u5f55\u8d26\u53f7\u5e76\u786e\u4fdd\u5df2\u7ecf\u6dfb\u52a0\u8fc7\u8bbe\u5907");
            SDBDeviceInfo sdbDeviceInfo = new SDBDeviceInfo();
            G.SetValue((byte[])sdbDeviceInfo.st_0_Devmac, (String)devId);
            if (!TextUtils.isEmpty((CharSequence)userName)) {
                G.SetValue((byte[])sdbDeviceInfo.st_4_loginName, (String)userName);
            }
            G.SetValue((byte[])sdbDeviceInfo.st_5_loginPsw, (String)password);
            XMDevInfo xmDevInfo = new XMDevInfo();
            xmDevInfo.sdbDevInfoToXMDevInfo(sdbDeviceInfo);
            DevDataCenter.getInstance().addDev(xmDevInfo);
        }
        if (!TextUtils.isEmpty((CharSequence)userName)) {
            FunSDK.DevSetLocalPwd((String)devId, (String)userName, (String)password);
        }
        return this.loginDev(devId, listener);
    }

    private boolean loginDev(String devId, DevConfigInfo devConfigInfo2) {
        if (TextUtils.isEmpty((CharSequence)devId)) {
            throw new RuntimeException("The devId can't be empty!");
        }
        if (devConfigInfo2 == null) {
            return false;
        }
        this.init();
        this.listenerMap.put("DevLogin" + devId, devConfigInfo2);
        int seq = devId.hashCode();
        this.devIdMap.put(seq, devId);
        FunSDK.DevGetConfigByJson((int)this.userId, (String)devId, (String)"SystemInfo", (int)1024, (int)-1, (int)this.loginTimeOut, (int)seq);
        return true;
    }

    @Override
    public void logoutDev(String devId) {
        if (TextUtils.isEmpty((CharSequence)devId)) {
            throw new RuntimeException("The devId can't be empty!");
        }
        this.init();
        this.listenerMap.remove("DevLogin" + devId);
        int seq = devId.hashCode();
        this.devIdMap.put(seq, devId);
        FunSDK.DevLogout((int)this.userId, (String)devId, (int)seq);
    }

    @Override
    public void getChannelInfo(String devId, OnDevManagerListener listener) {
        if (null == devId) {
            throw new RuntimeException("The devId can't be empty!");
        }
        this.init();
        this.listenerMap.put("DevGetChannelInfo" + devId, DevConfigInfo.create(listener, new String[0]));
        int seq = devId.hashCode();
        this.devIdMap.put(seq, devId);
        FunSDK.DevGetChnName((int)this.userId, (String)devId, (String)"", (String)"", (int)seq);
    }

    @Override
    public int getChannelCount(String devId) {
        if (null == devId) {
            return 0;
        }
        return FunSDK.GetDevChannelCount((String)devId);
    }

    @Override
    public MonitorManager createMonitorPlayer(@NotNull ViewGroup playView) {
        return new MonitorManager(playView, new PlayerAttribute());
    }

    @Override
    public MonitorManager createMonitorPlayer(@NotNull ViewGroup playView, String devId) {
        return new MonitorManager(playView, new PlayerAttribute(devId));
    }

    @Override
    public MonitorManager createMonitorPlayer(@NotNull ViewGroup playView, PlayerAttribute attribute) {
        if (attribute == null) {
            return null;
        }
        return new MonitorManager(playView, attribute);
    }

    @Override
    public MonitorManager[] createMonitorPlayers(@NotNull ViewGroup[] playViews, PlayerAttribute[] attributes, int count) {
        if (count <= 0) {
            return null;
        }
        MonitorManager[] monitorManagers = new MonitorManager[count];
        for (int i = 0; i < count; ++i) {
            monitorManagers[i] = new MonitorManager(playViews[i], attributes[i]);
        }
        return monitorManagers;
    }

    @Override
    public RecordManager createRecordPlayer(@NotNull ViewGroup playView, String devId, int mediaType) {
        if (mediaType == 2) {
            return new CloudRecordManager(playView, new RecordPlayerAttribute(devId));
        }
        return new DevRecordManager(playView, new RecordPlayerAttribute(devId));
    }

    @Override
    public void setLocalDevUserPwd(@NonNull String devId, @NonNull String devUser, @NonNull String pwd) {
        XMDevInfo xmDevInfo;
        if (TextUtils.isEmpty((CharSequence)devId) || TextUtils.isEmpty((CharSequence)devUser)) {
            return;
        }
        int iRet = FunSDK.DevSetLocalPwd((String)devId, (String)devUser, (String)pwd);
        if (iRet >= 0 && (xmDevInfo = DevDataCenter.getInstance().getDevInfo(devId)) != null) {
            xmDevInfo.setDevUserName(devUser);
            xmDevInfo.setDevPassword(pwd);
        }
    }

    @Override
    @Deprecated
    public void setLocalDevPwd(@NonNull String devId, @NonNull String pwd) {
        this.setLocalDevUserPwd(devId, "admin", pwd);
    }

    @Override
    public void setLocalDevLoginInfo(@NonNull String devId, @NonNull String devUser, @NonNull String pwd, @NonNull String token) {
        XMDevInfo xmDevInfo;
        int iRet = FunSDK.DevSetDevInfoToLocal((String)devId, (String)devUser, (String)pwd, (String)token);
        if (iRet >= 0 && (xmDevInfo = DevDataCenter.getInstance().getDevInfo(devId)) != null) {
            xmDevInfo.setDevUserName(devUser);
            xmDevInfo.setDevPassword(pwd);
            xmDevInfo.setDevToken(token);
        }
    }

    @Override
    public void modifyDevPwd(String devId, String userName, String oldPwd, String newPwd, OnDevManagerListener listener) {
        this.init();
        DevConfigInfo resultInfo = DevConfigInfo.create(listener, new String[0]);
        Bundle bundle = new Bundle();
        bundle.putString("userName", userName);
        bundle.putString("password", newPwd);
        resultInfo.setCfgInfo(bundle);
        this.listenerMap.put("ModifyPassword" + devId, resultInfo);
        oldPwd = FunSDK.DevMD5Encrypt((String)oldPwd);
        newPwd = FunSDK.DevMD5Encrypt((String)newPwd);
        JSONObject json = new JSONObject();
        json.put("EncryptType", (Object)"MD5");
        json.put("NewPassWord", (Object)newPwd);
        json.put("PassWord", (Object)oldPwd);
        json.put("SessionID", (Object)"0x6E472E78");
        json.put("UserName", (Object)"admin");
        if (json != null) {
            int seq = devId.hashCode();
            this.devIdMap.put(seq, devId);
            FunSDK.DevSetConfigByJson((int)this.userId, (String)devId, (String)"ModifyPassword", (String)json.toJSONString(), (int)-1, (int)10000, (int)seq);
        }
    }

    public void modifyDevName(String devId, String devName, OnDevManagerListener listener) {
        this.init();
        if (listener != null) {
            DevConfigInfo resultInfo = DevConfigInfo.create(listener, new String[0]);
            resultInfo.setCfgInfo(devName);
            resultInfo.setLastConfig(false);
            this.listenerMap.put("ModifyDevName" + devId, resultInfo);
            int seq = devId.hashCode();
            this.devIdMap.put(seq, devId);
            FunSDK.DevGetConfigByJson((int)this.userId, (String)devId, (String)"AVEnc.VideoWidget", (int)1024, (int)-1, (int)this.defaultTimeOut, (int)seq);
        }
    }

    @Override
    public DevConfigManager getDevConfigManager(String devId) {
        return DevConfigManager.create(devId);
    }

    @Override
    public int getDevType(String devId) {
        this.init();
        return this.devDataCenter.getDevType(devId);
    }

    @Override
    public String getSerialNo(String devId) {
        this.init();
        return this.devDataCenter.getSerialNo(devId);
    }

    @Override
    public String getBuildTime(String devId, OnDevManagerListener listener) {
        this.init();
        return this.devDataCenter.getBuildTime(devId, listener);
    }

    @Override
    public String getHardWare(String devId, OnDevManagerListener listener) {
        this.init();
        return this.devDataCenter.getHardWare(devId, listener);
    }

    @Override
    public int getDigChannel(String devId, OnDevManagerListener listener) {
        this.init();
        return this.devDataCenter.getDigChannel(devId, listener);
    }

    @Override
    public int getExtraChannel(String devId, OnDevManagerListener listener) {
        this.init();
        return this.devDataCenter.getExtraChannel(devId, listener);
    }

    @Override
    public int getVideoInChannel(String devId, OnDevManagerListener listener) {
        this.init();
        return this.devDataCenter.getVideoInChannel(devId, listener);
    }

    @Override
    public int getTalkInChannel(String devId, OnDevManagerListener listener) {
        this.init();
        return this.devDataCenter.getTalkInChannel(devId, listener);
    }

    @Override
    public int getAlarmInChannel(String devId, OnDevManagerListener listener) {
        this.init();
        return this.devDataCenter.getAlarmInChannel(devId, listener);
    }

    @Override
    public int getAlarmOutChannel(String devId, OnDevManagerListener listener) {
        this.init();
        return this.devDataCenter.getAlarmOutChannel(devId, listener);
    }

    @Override
    public int getCombineSwitch(String devId, OnDevManagerListener listener) {
        this.init();
        return this.devDataCenter.getCombineSwitch(devId, listener);
    }

    @Override
    public int getVideoOutChannel(String devId, OnDevManagerListener listener) {
        this.init();
        return this.devDataCenter.getVideoOutChannel(devId, listener);
    }

    @Override
    public int getAudioInChannel(String devId, OnDevManagerListener listener) {
        this.init();
        return this.devDataCenter.getAudioInChannel(devId, listener);
    }

    @Override
    public int getTalkOutChannel(String devId, OnDevManagerListener listener) {
        this.init();
        return this.devDataCenter.getTalkOutChannel(devId, listener);
    }

    @Override
    public String getUpdataTime(String devId, OnDevManagerListener listener) {
        this.init();
        return this.devDataCenter.getUpdataTime(devId, listener);
    }

    @Override
    public String getEncryptVersion(String devId, OnDevManagerListener listener) {
        this.init();
        return this.devDataCenter.getEncryptVersion(devId, listener);
    }

    @Override
    public String getDeviceRunTime(String devId, OnDevManagerListener listener) {
        this.init();
        return this.devDataCenter.getDeviceRunTime(devId, listener);
    }

    @Override
    public String getHardWareVersion(String devId, OnDevManagerListener listener) {
        this.init();
        return this.devDataCenter.getHardWareVersion(devId, listener);
    }

    @Override
    public String getSoftWareVersion(String devId, OnDevManagerListener listener) {
        this.init();
        return this.devDataCenter.getSoftWareVersion(devId, listener);
    }

    @Override
    public String getDeviceModel(String devId, OnDevManagerListener listener) {
        this.init();
        return this.devDataCenter.getDeviceModel(devId, listener);
    }

    @Override
    public String getMcuVersion(String devId, OnDevManagerListener listener) {
        this.init();
        return this.devDataCenter.getMcuVersion(devId, listener);
    }

    @Override
    public int getEncyptChipInfo(String devId, OnDevManagerListener listener) {
        this.init();
        return this.devDataCenter.getEncyptChipInfo(devId, listener);
    }

    @Override
    public int getNetConnectMode(String devId, OnDevManagerListener listener) {
        this.init();
        return this.devDataCenter.getNetConnectMode(devId, listener);
    }

    @Override
    public boolean isDontDewarpDevice(String devId) {
        String hardWare = this.devDataCenter.getHardWare(devId, null);
        String buildTime = this.devDataCenter.getBuildTime(devId, null);
        if (StringUtils.isStringNULL(hardWare) || StringUtils.isStringNULL(buildTime)) {
            return false;
        }
        for (String info : FishEyeConfig.dontDewarpDeviceInfo) {
            if (!info.contains(hardWare) || !info.contains(buildTime)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean getDevAbility(String devId, OnDevManagerListener listener, String ... field) {
        this.init();
        return this.devDataCenter.getSystemFunctionItemValue(devId, listener, field);
    }

    @Override
    public void getDevAllAbility(String devId, OnDevManagerListener<SystemFunctionBean> listener) {
        this.init();
        this.devDataCenter.getSystemFunction(devId, listener);
    }

    @Override
    public void searchLanDevice(OnSearchLocalDevListener listener) {
        this.init();
        this.onSearchLocalDevListener = listener;
        FunSDK.DevSearchDevice((int)this.userId, (int)0, (int)0);
    }

    @Override
    public void startQuickSetWiFi(String ssid, String pwd, String capabilities, DhcpInfo dhcpInfo, int timeOut, OnQuickSetWiFiListener listener) {
        if (TextUtils.isEmpty((CharSequence)ssid)) {
            return;
        }
        this.init();
        this.onQuickSetWiFiListener = listener;
        int pwdType = 0;
        if (!StringUtils.isStringNULL(pwd)) {
            pwdType = capabilities != null ? XUtils.getEncrypPasswordType(capabilities) : 1;
        }
        if (pwdType == 3 && (pwd.length() == 10 || pwd.length() == 26)) {
            pwd = XUtils.asciiToString(pwd);
        }
        StringBuffer data = new StringBuffer();
        data.append("S:").append(ssid).append("P:").append(pwd).append("T:").append(pwdType);
        String submask = "255.255.255.0";
        String gateway = "";
        String ip = "";
        String dns1 = "";
        String dns2 = "";
        String mac = "";
        if (dhcpInfo != null) {
            gateway = Formatter.formatIpAddress((int)dhcpInfo.gateway);
            ip = Formatter.formatIpAddress((int)dhcpInfo.ipAddress);
            dns1 = Formatter.formatIpAddress((int)dhcpInfo.dns1);
            dns2 = Formatter.formatIpAddress((int)dhcpInfo.dns2);
            if (dhcpInfo.netmask != 0) {
                submask = Formatter.formatIpAddress((int)dhcpInfo.netmask);
            }
        }
        mac = XUtils.getWiFiMacAddress();
        StringBuffer info = new StringBuffer();
        info.append("gateway:").append(gateway).append(" ").append("ip:").append(ip).append(" ").append("submask:").append(submask).append(" ").append("dns1:").append(dns1).append(" ").append("dns2:").append(dns2).append(" ").append("mac:").append(mac).append(" ");
        int nGetType = 2;
        FunSDK.Log((String)("startQuickSetWiFi:" + info.toString()));
        int iret = FunSDK.DevStartAPConfig((int)this.userId, (int)nGetType, (String)ssid, (String)data.toString(), (String)info.toString(), (String)gateway, (int)pwdType, (int)0, (String)mac, (int)timeOut);
        FunSDK.Log((String)("startQuickSetWiFi:" + iret));
    }

    @Override
    public void startQuickSetWiFiSimple(String ssid, String pwd, int pwdType, int timeOut, OnQuickSetWiFiListener listener) {
        this.init();
        this.onQuickSetWiFiListener = listener;
        StringBuffer data = new StringBuffer();
        data.append("S:").append(ssid).append("P:").append(pwd).append("T:").append(0);
        int nGetType = 2;
        int iret = FunSDK.DevStartAPConfig((int)this.userId, (int)nGetType, (String)ssid, (String)data.toString(), (String)"", (String)"", (int)pwdType, (int)0, (String)"02:00:00:00:00:00", (int)timeOut);
        FunSDK.Log((String)("startQuickSetWiFi:" + iret));
    }

    @Override
    public void startQuickSetWiFiByDevLogin(String devId, String ssid, String pwd, int timeOut, OnDevWiFiSetListener listener) {
        this.init();
        this.onDevWiFiSetListener = listener;
        FunSDK.DevStartWifiConfigByAPLogin((int)this.userId, (String)devId, (String)ssid, (String)pwd, (int)-1);
    }

    @Override
    public void startQuickSetWiFi(String ssid, String pwd, int timeOut) {
        this.init();
        StringBuffer data = new StringBuffer();
        data.append("S:").append(ssid).append("P:").append(pwd).append("T:");
        FunSDK.DevStartAPConfig((int)this.userId, (int)2, (String)ssid, (String)data.toString(), (String)"", (String)"", (int)0, (int)0, (String)"", (int)timeOut);
    }

    @Override
    public void stopQuickSetWiFi() {
        this.init();
        FunSDK.Log((String)"stopQuickSetWiFi:1");
        FunSDK.DevStopAPConfig();
        FunSDK.Log((String)"stopQuickSetWiFi:2");
    }

    @Override
    public Bitmap initDevToRouterByQrCode(String ssid, String wifiPwd, int pwdType, String macAddress, String ipAddress, OnDevWiFiSetListener listener) {
        return this.initDevToRouterByQrCode("https://pairing.xmcsrv.net/api/", ssid, wifiPwd, pwdType, macAddress, ipAddress, listener);
    }

    @Override
    public Bitmap initDevToRouterByQrCode(String serverUrl, String ssid, String wifiPwd, int pwdType, String macAddress, String ipAddress, OnDevWiFiSetListener listener) {
        try {
            QRConfigResultManager qrConfigResultManager = QRConfigResultManager.getInstance();
            qrConfigResultManager.initQrConfigServer(serverUrl);
            qrConfigResultManager.setOnDevWiFiSetListener(listener);
            String randomUuid = qrConfigResultManager.getQRConfigRandomUuid();
            if (pwdType == 3 && (wifiPwd.length() == 10 || wifiPwd.length() == 26)) {
                wifiPwd = XUtils.asciiToString(wifiPwd);
            }
            String[] result = ipAddress.split("\\.");
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("S:").append(ssid).append("\n").append("P:").append(wifiPwd).append("\n").append("E:").append(pwdType).append("\n").append("M:").append(macAddress).append("\n").append("I:").append(result[result.length - 1]).append("\n").append("B:").append(randomUuid).append("\n");
            String qrCodeInfo = stringBuilder.toString();
            return XUtils.createQRCodeBitmap(G.ToString((byte[])qrCodeInfo.getBytes("UTF-8"), (String)"ISO-8859-1"), 800, null);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public void startDevToRouterByQrCode() {
        QRConfigResultManager qrConfigResultManager = QRConfigResultManager.getInstance();
        String randomUuid = qrConfigResultManager.getQRConfigRandomUuid();
        qrConfigResultManager.getQRConfigDevInfo(randomUuid);
    }

    @Override
    public void stopDevToRouterByQrCode() {
        QRConfigResultManager.getInstance().stopGetQRConfigDevInfo();
    }

    @Override
    public void unInitDevToRouterByQrCode() {
        QRConfigResultManager.getInstance().releaseGetQRConfigDevInfo();
    }

    @Override
    public List<XMDevInfo> getLanDevice() {
        return this.lanDevList;
    }

    @Override
    public boolean devPTZControl(PtzCtrlInfoBean ptzCtrlInfoBean, OnDevManagerListener listener) {
        if (ptzCtrlInfoBean != null) {
            int result = FunSDK.DevPTZControl((int)this.userId, (String)ptzCtrlInfoBean.getDevId(), (int)ptzCtrlInfoBean.getChnId(), (int)ptzCtrlInfoBean.getPtzCommandId(), (int)(ptzCtrlInfoBean.isStop() ? 1 : 0), (int)ptzCtrlInfoBean.getSpeed(), (int)ptzCtrlInfoBean.getSeq());
            return result == 1;
        }
        return false;
    }

    @Override
    public void syncDevTimeZone(String devId, int timeZone, OnDevManagerListener listener) {
        this.init();
        if (listener != null) {
            DevConfigInfo resultInfo = DevConfigInfo.create(listener, new String[0]);
            resultInfo.setLastConfig(false);
            this.listenerMap.put("SyncDevTimeZone" + devId, resultInfo);
            int seq = devId.hashCode();
            this.devIdMap.put(seq, devId);
            TimeZoneBean timeZoneBean = new TimeZoneBean();
            timeZoneBean.timeMin = timeZone;
            timeZoneBean.FirstUserTimeZone = 0;
            FunSDK.DevSetConfigByJson((int)this.userId, (String)devId, (String)"System.TimeZone", (String)HandleConfigData.getSendData("System.TimeZone", "0x1", timeZoneBean), (int)-1, (int)this.defaultTimeOut, (int)seq);
        }
    }

    @Override
    public void syncDevTime(String devId, String time, OnDevManagerListener listener) {
        this.init();
        if (listener != null) {
            int seq = devId.hashCode();
            this.devIdMap.put(seq, devId);
            this.listenerMap.put("OPTimeSetting" + devId, DevConfigInfo.create(listener, new String[0]));
            FunSDK.DevSetConfigByJson((int)this.userId, (String)devId, (String)"OPTimeSetting", (String)HandleConfigData.getSendData("OPTimeSetting", "0x00000001", time), (int)-1, (int)this.defaultTimeOut, (int)seq);
        }
    }

    @Override
    public boolean resetDevConfig(String devId, OnDevManagerListener listener) {
        DefaultConfigBean defaultConfigBean = new DefaultConfigBean();
        defaultConfigBean.setAllConfig(true);
        String jsonData = HandleConfigData.getSendData("OPDefaultConfig", "0x1", defaultConfigBean);
        return this.resetDevConfigByJson(devId, jsonData, listener);
    }

    @Override
    public boolean resetDevConfigByJson(String devId, String jsonData, OnDevManagerListener listener) {
        if (TextUtils.isEmpty((CharSequence)jsonData) || devId == null) {
            return false;
        }
        this.init();
        if (listener != null) {
            int seq = devId.hashCode();
            this.devIdMap.put(seq, devId);
            this.listenerMap.put("OPDefaultConfig" + devId, DevConfigInfo.create(listener, new String[0]));
            FunSDK.DevSetConfigByJson((int)this.userId, (String)devId, (String)"OPDefaultConfig", (String)jsonData, (int)-1, (int)20000, (int)seq);
        }
        return true;
    }

    @Override
    public void checkDevUpgrade(String devId, OnDevUpgradeListener listener) {
        this.init();
        if (listener != null) {
            int seq = devId.hashCode();
            this.devIdMap.put(seq, devId);
            this.onDevUpgradeListener = listener;
            FunSDK.DevCheckUpgradeAllNet((int)this.userId, (String)devId, (int)seq);
        }
    }

    @Override
    public void startDevUpgrade(String devId, int upgradeType, OnDevUpgradeListener listener) {
        this.init();
        if (listener != null) {
            int seq = devId.hashCode();
            this.devIdMap.put(seq, devId);
            this.onDevUpgradeListener = listener;
            FunSDK.DevStartUpgrade((int)this.userId, (String)devId, (int)upgradeType, (int)seq);
        }
    }

    @Override
    public void startDevUpgradeByLocalFile(String devId, String fileName, OnDevUpgradeListener listener) {
        this.init();
        if (listener != null) {
            int seq = devId.hashCode();
            this.devIdMap.put(seq, devId);
            this.onDevUpgradeListener = listener;
            FunSDK.DevStartUpgradeByFile((int)this.userId, (String)devId, (String)fileName, (int)seq);
        }
    }

    @Override
    public void stopDevUpgrade(String devId, OnDevUpgradeListener listener) {
        this.init();
        if (listener != null) {
            int seq = devId.hashCode();
            this.devIdMap.put(seq, devId);
            this.onDevUpgradeListener = listener;
            FunSDK.DevStopUpgrade((int)this.userId, (String)devId, (int)seq);
        }
    }

    @Override
    public void switchDevNetworkMode(String devId, String action, OnDevManagerListener listener) {
        this.init();
        if (listener != null) {
            int seq = devId.hashCode();
            this.devIdMap.put(seq, devId);
            this.listenerMap.put("OPNetModeSwitch" + devId, DevConfigInfo.create(listener, new String[0]));
            JSONObject jsonObj = new JSONObject();
            JSONObject subJsonObj = new JSONObject();
            subJsonObj.put("Action", (Object)action);
            jsonObj.put("Name", (Object)"OPNetModeSwitch");
            jsonObj.put("OPNetModeSwitch", (Object)subJsonObj);
            FunSDK.DevCmdGeneral((int)this.userId, (String)devId, (int)1450, (String)"OPNetModeSwitch", (int)-1, (int)this.defaultTimeOut, (byte[])jsonObj.toJSONString().getBytes(), (int)0, (int)seq);
        }
    }

    @Override
    public void setTimeOut(int defaultTimeOut) {
        this.defaultTimeOut = defaultTimeOut;
    }

    @Override
    public void rebootDev(String devId, OnDevManagerListener listener) {
        JSONObject obj = new JSONObject();
        obj.put("Action", (Object)"Reboot");
        FunSDK.DevCmdGeneral((int)this.userId, (String)devId, (int)1450, (String)"OPMachine", (int)-1, (int)this.defaultTimeOut, (byte[])HandleConfigData.getSendData("OPMachine", "0x08", obj).getBytes(), (int)-1, (int)0);
    }

    @Override
    public void captureFromDevAndSaveToDev(String devId, int chnId, OnDevManagerListener listener) {
        if (listener != null) {
            this.listenerMap.put("StoreSnap" + devId, DevConfigInfo.create(listener, new String[0]));
        }
        int seq = devId.hashCode();
        HashMap<String, Object> sendMap = new HashMap<String, Object>();
        HashMap<String, Integer> storeSnapMap = new HashMap<String, Integer>();
        storeSnapMap.put("Channle", chnId);
        sendMap.put("Name", "StoreSnap");
        sendMap.put("StoreSnap", storeSnapMap);
        String sendJson = new Gson().toJson(sendMap);
        FunSDK.DevCmdGeneral((int)this.userId, (String)devId, (int)2028, (String)"StoreSnap", (int)-1, (int)this.defaultTimeOut, (byte[])sendJson.getBytes(), (int)-1, (int)seq);
    }

    @Override
    public IPresetManager createPresetManager(String devId, OnDevManagerListener onDevManagerListener) {
        return new PresetManager(devId, onDevManagerListener);
    }

    @Override
    public boolean queryDevsStatusHistoryRecord(SQueryDevHistoryParams queryDevHistoryParams, OnDevManagerListener listener, String ... devIds) {
        if (queryDevHistoryParams == null || devIds == null) {
            return false;
        }
        if (listener != null) {
            this.listenerMap.put("QueryDevsStatusHistoryRecord", DevConfigInfo.create(listener, new String[0]));
        }
        int seq = queryDevHistoryParams.hashCode();
        StringBuffer sbDevIds = new StringBuffer();
        for (String devId : devIds) {
            sbDevIds.append(devId);
            sbDevIds.append(";");
        }
        int iRet = MpsClient.QueryDevsStatusHistoryRecord((int)this.userId, (String)sbDevIds.toString(), (byte[])G.ObjToBytes((Object)queryDevHistoryParams), (int)seq);
        return iRet >= 0;
    }

    @Override
    public boolean getDevRandomUserPwd(XMDevInfo xmDevInfo, final OnDevManagerListener onDevManagerListener) {
        if (xmDevInfo == null) {
            return false;
        }
        DevConfigInfo devConfigInfo2 = DevConfigInfo.create(new OnDevManagerListener(){

            public void onSuccess(String devId, int operationType, Object result) {
                System.out.println("result:" + result);
                String jsonData = (String)result;
                String tempUserName = "admin";
                String tempPwd = "";
                if (!TextUtils.isEmpty((CharSequence)jsonData)) {
                    try {
                        JSONObject randomUser;
                        JSONObject jsonObject = JSON.parseObject((String)jsonData);
                        if (jsonObject != null && (randomUser = jsonObject.getJSONObject("GetRandomUser")) != null) {
                            String[] split;
                            String info = randomUser.getString("Info");
                            String tempUserPwd = FunSDK.DecDevRandomUserInfo((String)devId, (String)info);
                            System.out.println("tempUserPwd\uff1a" + tempUserPwd);
                            if (!StringUtils.isStringNULL(tempUserPwd) && (split = tempUserPwd.split(" ")).length >= 2) {
                                tempUserName = split[0].split(":")[1];
                                tempPwd = split[1].split(":")[1];
                            }
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    String devToken = FunSDK.DevGetLocalEncToken((String)devId);
                    if (StringUtils.isStringNULL(devToken)) {
                        DeviceManager.getInstance().setLocalDevUserPwd(devId, tempUserName, tempPwd);
                    } else {
                        DeviceManager.getInstance().setLocalDevLoginInfo(devId, tempUserName, tempPwd, devToken);
                    }
                    if (onDevManagerListener != null) {
                        onDevManagerListener.onSuccess(devId, operationType, new String[]{tempUserName, tempPwd});
                    }
                }
            }

            @Override
            public void onFailed(String devId, int msgId, String jsonName, int errorId) {
                if (onDevManagerListener != null) {
                    onDevManagerListener.onFailed(devId, msgId, jsonName, errorId);
                }
            }
        }, new String[0]);
        devConfigInfo2.setChnId(-1);
        devConfigInfo2.setJsonName("GetRandomUser");
        devConfigInfo2.setCmdId(1660);
        devConfigInfo2.setNotLogin(true);
        DevConfigManager.create(xmDevInfo.getDevId()).getDevConfig(devConfigInfo2);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void getConfigFromDev(String devId, OnDevManagerListener listener, String jsonName, String ... field) {
        this.init();
        ConcurrentHashMap<String, DevConfigInfo> concurrentHashMap = this.listenerMap;
        synchronized (concurrentHashMap) {
            if (this.listenerMap.containsKey(jsonName + devId)) {
                DevConfigInfo devConfigInfo2 = this.listenerMap.get(jsonName + devId);
                if (devConfigInfo2 != null) {
                    devConfigInfo2.addListener(listener, field);
                }
            } else if (StringUtils.contrast(jsonName, "EncyptChipInfo")) {
                this.listenerMap.put(jsonName + devId, DevConfigInfo.create(listener, field));
                int seq = devId.hashCode();
                this.devIdMap.put(seq, devId);
                FunSDK.DevCmdGeneral((int)this.userId, (String)devId, (int)1020, (String)"EncyptChipInfo", (int)-1, (int)this.defaultTimeOut, null, (int)0, (int)seq);
            } else if (StringUtils.contrast(jsonName, "SystemInfoEx")) {
                this.listenerMap.put(jsonName + devId, DevConfigInfo.create(listener, field));
                int seq = devId.hashCode();
                this.devIdMap.put(seq, devId);
                FunSDK.DevCmdGeneral((int)this.userId, (String)devId, (int)1020, (String)"SystemInfoEx", (int)-1, (int)this.defaultTimeOut, null, (int)0, (int)seq);
            } else {
                this.listenerMap.put(jsonName + devId, DevConfigInfo.create(listener, field));
                int seq = devId.hashCode();
                this.devIdMap.put(seq, devId);
                FunSDK.DevGetConfigByJson((int)this.userId, (String)devId, (String)jsonName, (int)1024, (int)-1, (int)this.defaultTimeOut, (int)seq);
            }
        }
    }

    @Override
    public void clearDevConfigs() {
        if (this.listenerMap != null) {
            this.listenerMap.clear();
        }
    }

    @Override
    public void clearDevConfig(String devId) {
        if (this.listenerMap != null) {
            for (String key : this.listenerMap.keySet()) {
                if (!key.contains(devId)) continue;
                this.listenerMap.remove(key);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int OnFunSDKResult(Message msg, MsgContent ex) {
        try {
            String devId = this.devIdMap.get(ex.seq);
            switch (msg.what) {
                case 5139: {
                    DevConfigInfo resultInfo = this.listenerMap.get("DevLogin" + devId);
                    if (null == resultInfo) return 0;
                    OnDevManagerListener onDevManagerListener = resultInfo.getListener();
                    if (onDevManagerListener == null) return 0;
                    if (msg.arg1 >= 0) {
                        onDevManagerListener.onSuccess(devId, 0, null);
                        return 0;
                    }
                    if (msg.arg1 == -10005 && resultInfo.isNeedTryAgain()) {
                        this.loginDev(devId, resultInfo);
                        return 0;
                    }
                    onDevManagerListener.onFailed(devId, msg.what, "DevLogin", msg.arg1);
                    return 0;
                }
                case 5100: {
                    DevConfigInfo resultInfo = this.listenerMap.get("DevGetChannelInfo" + devId);
                    if (null != resultInfo) {
                        OnDevManagerListener onDevManagerListener = resultInfo.getListener();
                        this.listenerMap.remove("DevGetChannelInfo" + devId);
                        if (msg.arg1 >= 0) {
                            SDBDeviceInfo sdbDeviceInfo;
                            SDK_ChannelNameConfigAll channelNameConfigAll = new SDK_ChannelNameConfigAll();
                            G.BytesToObj((Object)channelNameConfigAll, (byte[])ex.pData);
                            channelNameConfigAll.nChnCount = ex.arg3;
                            XMDevInfo xmDevInfo = DevDataCenter.getInstance().getDevInfo(devId);
                            if (xmDevInfo != null && (sdbDeviceInfo = xmDevInfo.getSdbDevInfo()) != null) {
                                sdbDeviceInfo.setChannel(channelNameConfigAll);
                            }
                            if (onDevManagerListener == null) return 0;
                            onDevManagerListener.onSuccess(devId, 1, channelNameConfigAll);
                            return 0;
                        }
                        if (onDevManagerListener == null) return 0;
                        onDevManagerListener.onFailed(devId, msg.what, "DevGetChannelInfo", msg.arg1);
                        return 0;
                    }
                    this.listenerMap.remove("DevGetChannelInfo" + devId);
                    return 0;
                }
                case 5128: {
                    ConcurrentHashMap<String, DevConfigInfo> resultInfo = this.listenerMap;
                    synchronized (resultInfo) {
                        if (StringUtils.contrast(ex.str, "SystemInfo")) {
                            if (msg.arg1 >= 0) {
                                HandleConfigData data = new HandleConfigData();
                                data.getDataObj(G.ToString((byte[])ex.pData), SystemInfoBean.class);
                                SystemInfoBean infoBean = (SystemInfoBean)data.getObj();
                                if (infoBean == null) return 0;
                                infoBean.setNetConnectMode(msg.arg2);
                                this.devDataCenter.setSystemInfo(devId, infoBean);
                                DevConfigInfo resultInfo2 = this.listenerMap.get("DevLogin" + devId);
                                if (resultInfo2 != null) {
                                    OnDevManagerListener onDevManagerListener = resultInfo2.getListener();
                                    this.listenerMap.remove("DevLogin" + devId);
                                    if (onDevManagerListener == null) return 0;
                                    onDevManagerListener.onSuccess(devId, 1, infoBean);
                                } else {
                                    this.dealWithResultToListener(devId, this.listenerMap.get("SystemInfo" + devId), infoBean);
                                }
                            } else {
                                DevConfigInfo resultInfo3 = this.listenerMap.get("DevLogin" + devId);
                                if (resultInfo3 != null) {
                                    if (msg.arg1 == -10005 && resultInfo3.isNeedTryAgain()) {
                                        this.loginDev(devId, resultInfo3);
                                    } else {
                                        OnDevManagerListener onDevManagerListener = resultInfo3.getListener();
                                        this.listenerMap.remove("DevLogin" + devId);
                                        if (onDevManagerListener == null) return 0;
                                        onDevManagerListener.onFailed(devId, msg.what, "SystemInfo", msg.arg1);
                                    }
                                } else {
                                    resultInfo3 = this.listenerMap.get("SystemInfo" + devId);
                                    if (null != resultInfo3) {
                                        OnDevManagerListener onDevManagerListener = resultInfo3.getListener();
                                        this.listenerMap.remove("SystemInfo" + devId);
                                        if (onDevManagerListener == null) return 0;
                                        onDevManagerListener.onFailed(devId, msg.what, "SystemInfo", msg.arg1);
                                    } else {
                                        this.listenerMap.remove("SystemInfo" + devId);
                                    }
                                }
                            }
                        } else if (StringUtils.contrast(ex.str, "SystemFunction")) {
                            if (msg.arg1 >= 0) {
                                HandleConfigData data = new HandleConfigData();
                                data.getDataObj(G.ToString((byte[])ex.pData), SystemFunctionBean.class);
                                SystemFunctionBean infoBean = (SystemFunctionBean)data.getObj();
                                this.devDataCenter.setSystemFunction(devId, infoBean);
                                this.dealWithResultToListener(devId, this.listenerMap.get("SystemFunction" + devId), infoBean);
                            } else {
                                DevConfigInfo resultInfo4 = this.listenerMap.get("SystemFunction" + devId);
                                if (null != resultInfo4) {
                                    OnDevManagerListener onDevManagerListener = resultInfo4.getListener();
                                    this.listenerMap.remove("SystemFunction" + devId);
                                    if (onDevManagerListener == null) return 0;
                                    onDevManagerListener.onFailed(devId, msg.what, "SystemFunction", msg.arg1);
                                } else {
                                    this.listenerMap.remove("SystemFunction" + devId);
                                }
                            }
                        } else if (StringUtils.contrast(ex.str, "AVEnc.VideoWidget") && this.listenerMap.containsKey("ModifyDevName" + devId)) {
                            List beans;
                            HandleConfigData data;
                            DevConfigInfo resultInfo5;
                            if (msg.arg1 >= 0 && (resultInfo5 = this.listenerMap.get("ModifyDevName" + devId)) != null && (data = new HandleConfigData()).getDataObj(G.ToString((byte[])ex.pData), VideoWidgetBean.class) && (beans = (List)data.getObj()) != null) {
                                ((VideoWidgetBean)beans.get(0)).getChannelTitle().setName((String)resultInfo5.getCfgInfo());
                                FunSDK.DevSetConfigByJson((int)this.userId, (String)devId, (String)ex.str, (String)data.getSendData(ex.str, beans), (int)resultInfo5.getChnId(), (int)this.defaultTimeOut, (int)ex.seq);
                                FunSDK.DevCmdGeneral((int)this.userId, (String)devId, (int)1048, (String)"ChannelTitle", (int)-1, (int)this.defaultTimeOut, null, (int)10, (int)ex.seq);
                                return 0;
                            }
                            resultInfo5 = this.listenerMap.get("ModifyDevName" + devId);
                            if (null != resultInfo5) {
                                OnDevManagerListener onDevManagerListener = resultInfo5.getListener();
                                this.listenerMap.remove("ModifyDevName" + devId);
                                if (onDevManagerListener == null) return 0;
                                onDevManagerListener.onFailed(devId, msg.what, "ModifyDevName", msg.arg1);
                            } else {
                                this.listenerMap.remove("ModifyDevName" + devId);
                            }
                        } else {
                            DevConfigInfo resultInfo6;
                            if (!StringUtils.contrast(ex.str, "General.Location") || !this.listenerMap.containsKey("SyncDevTimeZone" + devId) || (resultInfo6 = this.listenerMap.get("SyncDevTimeZone" + devId)) == null) return 0;
                            resultInfo6.setLastConfig(true);
                            if (msg.arg1 >= 0) {
                                LocationBean locationBean;
                                HandleConfigData data = new HandleConfigData();
                                if (!data.getDataObj(G.ToString((byte[])ex.pData), LocationBean.class) || (locationBean = (LocationBean)data.getObj()) == null) return 0;
                                DayLightTimeBean dayLightTimeBean = XUtils.getDayLightTimeInfo(TimeZone.getDefault());
                                if (dayLightTimeBean.useDLT) {
                                    locationBean.setdSTRule("On");
                                    DSTimeBean dstStart = new DSTimeBean();
                                    dstStart.setYear(dayLightTimeBean.year);
                                    dstStart.setMonth(dayLightTimeBean.beginMonth);
                                    dstStart.setDay(dayLightTimeBean.beginDay);
                                    DSTimeBean dstEnd = new DSTimeBean();
                                    dstEnd.setYear(dayLightTimeBean.beginMonth > dayLightTimeBean.endMonth ? dayLightTimeBean.year + 1 : dayLightTimeBean.year);
                                    dstEnd.setMonth(dayLightTimeBean.endMonth);
                                    dstEnd.setDay(dayLightTimeBean.endDay);
                                    locationBean.setdSTStart(dstStart);
                                    locationBean.setdSTEnd(dstEnd);
                                } else {
                                    locationBean.setdSTRule("Off");
                                }
                                FunSDK.DevSetConfigByJson((int)this.userId, (String)devId, (String)"General.Location", (String)HandleConfigData.getSendData("General.Location", "0x02", locationBean), (int)-1, (int)this.defaultTimeOut, (int)ex.seq);
                            } else {
                                OnDevManagerListener onDevManagerListener = resultInfo6.getListener();
                                this.listenerMap.remove("SyncDevTimeZone" + devId);
                                if (onDevManagerListener == null) return 0;
                                onDevManagerListener.onFailed(devId, msg.what, "SyncDevTimeZone", msg.arg1);
                            }
                        }
                        return 0;
                    }
                }
                case 5129: {
                    if (StringUtils.contrast(ex.str, "ModifyPassword")) {
                        DevConfigInfo resultInfo = this.listenerMap.get(ex.str + devId);
                        if (resultInfo != null) {
                            OnDevManagerListener onDevManagerListener = resultInfo.getListener();
                            this.listenerMap.remove("ModifyPassword" + devId);
                            if (onDevManagerListener == null) return 0;
                            if (msg.arg1 >= 0) {
                                Bundle bundle = (Bundle)resultInfo.getCfgInfo();
                                if (bundle != null) {
                                    String userName = bundle.getString("userName");
                                    String password = bundle.getString("password");
                                    if (!TextUtils.isEmpty((CharSequence)userName)) {
                                        FunSDK.DevSetLocalPwd((String)devId, (String)userName, (String)password);
                                    }
                                }
                                onDevManagerListener.onSuccess(devId, 2, 0);
                                return 0;
                            }
                            onDevManagerListener.onFailed(devId, msg.what, "ModifyPassword", msg.arg1);
                            return 0;
                        }
                        this.listenerMap.remove("ModifyPassword" + devId);
                        return 0;
                    }
                    if (StringUtils.contrast(ex.str, "System.TimeZone") && this.listenerMap.containsKey("SyncDevTimeZone" + devId)) {
                        DevConfigInfo resultInfo = this.listenerMap.get("SyncDevTimeZone" + devId);
                        if (resultInfo == null) return 0;
                        OnDevManagerListener onDevManagerListener = resultInfo.getListener();
                        if (msg.arg1 >= 0) {
                            if (resultInfo.isLastConfig()) {
                                this.listenerMap.remove("SyncDevTimeZone" + devId);
                                if (onDevManagerListener == null) return 0;
                                onDevManagerListener.onSuccess(devId, 2, 0);
                                return 0;
                            }
                            FunSDK.DevGetConfigByJson((int)this.userId, (String)devId, (String)"General.Location", (int)1024, (int)-1, (int)this.defaultTimeOut, (int)devId.hashCode());
                            return 0;
                        }
                        this.listenerMap.remove("SyncDevTimeZone" + devId);
                        if (onDevManagerListener == null) return 0;
                        onDevManagerListener.onFailed(devId, msg.what, "SyncDevTimeZone", msg.arg1);
                        return 0;
                    }
                    if (StringUtils.contrast(ex.str, "General.Location") && this.listenerMap.containsKey("SyncDevTimeZone" + devId)) {
                        DevConfigInfo resultInfo = this.listenerMap.get("SyncDevTimeZone" + devId);
                        if (resultInfo == null) return 0;
                        OnDevManagerListener onDevManagerListener = resultInfo.getListener();
                        if (!resultInfo.isLastConfig() || onDevManagerListener == null) return 0;
                        this.listenerMap.remove("SyncDevTimeZone" + devId);
                        if (msg.arg1 >= 0) {
                            onDevManagerListener.onSuccess(devId, 2, 0);
                            return 0;
                        }
                        onDevManagerListener.onFailed(devId, msg.what, "SyncDevTimeZone", msg.arg1);
                        return 0;
                    }
                    if (StringUtils.contrast(ex.str, "OPTimeSetting")) {
                        DevConfigInfo resultInfo = this.listenerMap.get("OPTimeSetting" + devId);
                        if (resultInfo != null) {
                            OnDevManagerListener onDevManagerListener = resultInfo.getListener();
                            this.listenerMap.remove("OPTimeSetting" + devId);
                            if (onDevManagerListener == null) return 0;
                            if (msg.arg1 >= 0) {
                                onDevManagerListener.onSuccess(devId, 2, 0);
                                return 0;
                            }
                            onDevManagerListener.onFailed(devId, msg.what, "OPTimeSetting", msg.arg1);
                            return 0;
                        }
                        this.listenerMap.remove("OPTimeSetting" + devId);
                        return 0;
                    }
                    DevConfigInfo resultInfo = this.listenerMap.get(ex.str + devId);
                    if (resultInfo != null) {
                        OnDevManagerListener onDevManagerListener = resultInfo.getListener();
                        this.listenerMap.remove(ex.str + devId);
                        if (onDevManagerListener == null) return 0;
                        if (msg.arg1 >= 0) {
                            onDevManagerListener.onSuccess(devId, 2, 0);
                            return 0;
                        }
                        onDevManagerListener.onFailed(devId, msg.what, ex.str, msg.arg1);
                        return 0;
                    }
                    this.listenerMap.remove(ex.str + devId);
                    return 0;
                }
                case 5131: {
                    if (StringUtils.contrast(ex.str, "ChannelTitle") && this.listenerMap.containsKey("ModifyDevName" + devId)) {
                        OnDevManagerListener onDevManagerListener;
                        DevConfigInfo resultInfo = this.listenerMap.get("ModifyDevName" + devId);
                        if (msg.arg1 >= 0 && ex.pData != null && resultInfo != null) {
                            if (!resultInfo.isLastConfig()) {
                                List list;
                                resultInfo.setLastConfig(true);
                                HandleConfigData data = new HandleConfigData();
                                if (data.getDataObj(G.ToString((byte[])ex.pData), String.class) && (list = (List)data.getObj()) != null) {
                                    list.set(resultInfo.getChnId(), (String)resultInfo.getCfgInfo());
                                    FunSDK.DevCmdGeneral((int)this.userId, (String)devId, (int)1048, (String)"ChannelTitle", (int)-1, (int)this.defaultTimeOut, (byte[])data.getSendData("ChannelTitle", list).getBytes(), (int)-1, (int)ex.seq);
                                    return 0;
                                }
                            } else {
                                OnDevManagerListener onDevManagerListener2 = resultInfo.getListener();
                                this.listenerMap.remove("ModifyDevName" + devId);
                                if (onDevManagerListener2 == null) return 0;
                                onDevManagerListener2.onSuccess(devId, 2, resultInfo.getCfgInfo());
                                return 0;
                            }
                        }
                        if (null != resultInfo && (onDevManagerListener = resultInfo.getListener()) != null) {
                            onDevManagerListener.onFailed(devId, msg.what, "ModifyDevName", msg.arg1);
                        }
                        this.listenerMap.remove("ModifyDevName" + devId);
                        return 0;
                    }
                    if (StringUtils.contrast(ex.str, "EncyptChipInfo")) {
                        DevConfigInfo resultInfo = this.listenerMap.get("EncyptChipInfo" + devId);
                        if (msg.arg1 >= 0) {
                            EncyptChipInfoBean encyptChipInfoBean;
                            HandleConfigData data;
                            if (resultInfo != null && (data = new HandleConfigData()).getDataObj(G.ToString((byte[])ex.pData), EncyptChipInfoBean.class) && (encyptChipInfoBean = (EncyptChipInfoBean)data.getObj()) != null) {
                                resultInfo.getListener().onSuccess(devId, 1020, encyptChipInfoBean.getoEMID());
                            }
                        } else if (resultInfo != null) {
                            resultInfo.getListener().onFailed(devId, 1020, "EncyptChipInfo", msg.arg1);
                        }
                        this.listenerMap.remove("EncyptChipInfo" + devId);
                        return 0;
                    }
                    if (StringUtils.contrast(ex.str, "SystemInfoEx")) {
                        if (msg.arg1 >= 0) {
                            HandleConfigData data = new HandleConfigData();
                            data.getDataObj(G.ToString((byte[])ex.pData), SystemInfoExBean.class);
                            SystemInfoExBean infoBean = (SystemInfoExBean)data.getObj();
                            this.devDataCenter.setSystemExInfo(devId, infoBean);
                            this.dealWithResultToListener(devId, this.listenerMap.get("SystemInfoEx" + devId), infoBean);
                        } else {
                            DevConfigInfo resultInfo = this.listenerMap.get("SystemInfoEx" + devId);
                            if (null != resultInfo) {
                                resultInfo.getListener().onFailed(devId, msg.what, "SystemInfoEx", msg.arg1);
                            }
                        }
                        this.listenerMap.remove("SystemInfoEx" + devId);
                        return 0;
                    }
                    DevConfigInfo resultInfo = this.listenerMap.get(ex.str + devId);
                    this.listenerMap.remove(ex.str + devId);
                    if (resultInfo == null) return 0;
                    if (msg.arg1 >= 0) {
                        resultInfo.getListener().onSuccess(devId, 3, 0);
                        return 0;
                    }
                    resultInfo.getListener().onFailed(devId, msg.what, ex.str, msg.arg1);
                    return 0;
                }
                case 5126: {
                    int length = msg.arg2;
                    if (length > 0) {
                        Object[] searchResult = new SDK_CONFIG_NET_COMMON_V2[length];
                        for (int i = 0; i < searchResult.length; ++i) {
                            searchResult[i] = new SDK_CONFIG_NET_COMMON_V2();
                        }
                        G.BytesToObj((Object[])searchResult, (byte[])ex.pData);
                        this.lanDevList = new ArrayList<XMDevInfo>();
                        for (Object devinfo : searchResult) {
                            if (devinfo == null) continue;
                            XMDevInfo xmDevInfo = new XMDevInfo();
                            xmDevInfo.lanDevInfoToXMDevInfo((SDK_CONFIG_NET_COMMON_V2)devinfo);
                            this.lanDevList.add(xmDevInfo);
                        }
                    } else {
                        this.lanDevList = null;
                    }
                    if (this.onSearchLocalDevListener == null) return 0;
                    this.onSearchLocalDevListener.onSearchLocalDevResult(this.lanDevList);
                    return 0;
                }
                case 5106: {
                    XMDevInfo xmDevInfo = null;
                    if (msg.arg1 >= 0) {
                        SDK_CONFIG_NET_COMMON_V2 common = new SDK_CONFIG_NET_COMMON_V2();
                        G.BytesToObj((Object)common, (byte[])ex.pData);
                        xmDevInfo = new XMDevInfo();
                        xmDevInfo.lanDevInfoToXMDevInfo(common);
                        FunSDK.DevSetDevInfoToLocal((String)xmDevInfo.getDevId(), (String)"admin", (String)"", (String)"");
                        new Thread(new Runnable(){

                            @Override
                            public void run() {
                                DeviceManager.this.stopQuickSetWiFi();
                            }
                        }).start();
                        if (this.onQuickSetWiFiListener == null) return 0;
                        this.onQuickSetWiFiListener.onQuickSetResult(xmDevInfo, 0);
                        return 0;
                    }
                    if (this.onQuickSetWiFiListener == null) return 0;
                    this.onQuickSetWiFiListener.onQuickSetResult(null, msg.arg1);
                    return 0;
                }
                case 5127: {
                    if (msg.arg1 == 244) {
                        SDK_CONFIG_NET_COMMON_V2 common = new SDK_CONFIG_NET_COMMON_V2();
                        G.BytesToObj((Object)common, (byte[])ex.pData);
                        XMDevInfo xmDevInfo = new XMDevInfo();
                        xmDevInfo.lanDevInfoToXMDevInfo(common);
                        FunSDK.DevSetDevInfoToLocal((String)xmDevInfo.getDevId(), (String)"admin", (String)"", (String)"");
                        new Thread(new Runnable(){

                            @Override
                            public void run() {
                                DeviceManager.this.stopQuickSetWiFi();
                            }
                        }).start();
                        if (this.onDevWiFiSetListener == null) return 0;
                        this.onDevWiFiSetListener.onDevWiFiSetResult(xmDevInfo);
                        return 0;
                    }
                    if (this.onDevWiFiSetListener == null) return 0;
                    this.onDevWiFiSetListener.onDevWiFiSetState(msg.arg1);
                    return 0;
                }
                case 5125: {
                    if (this.onDevUpgradeListener == null) return 0;
                    this.onDevUpgradeListener.onCheckUpgradeResult(msg.arg1, ex.str, msg.arg1);
                    return 0;
                }
                case 5119: {
                    if (this.onDevUpgradeListener == null) return 0;
                    this.onDevUpgradeListener.onUpgradeProgress(0, 0, msg.arg1, "");
                    return 0;
                }
                case 5120: {
                    if (this.onDevUpgradeListener == null) return 0;
                    this.onDevUpgradeListener.onUpgradeProgress(msg.arg1, msg.arg2, msg.arg2, ex.str);
                    return 0;
                }
                case 5121: {
                    if (this.onDevUpgradeListener == null) return 0;
                    this.onDevUpgradeListener.onUpgradeProgress(4, 0, msg.arg1, "");
                    return 0;
                }
                case 5103: 
                case 5114: {
                    if (this.onDevUpgradeListener == null) return 0;
                    this.onDevUpgradeListener.onUpgradeProgress(-1, 0, -1, "");
                    return 0;
                }
                case 6024: {
                    DevConfigInfo resultInfo = this.listenerMap.get("QueryDevsStatusHistoryRecord");
                    if (null == resultInfo) return 0;
                    if (msg.arg1 < 0) {
                        resultInfo.getListener().onFailed(devId, msg.what, "QueryDevsStatusHistoryRecord", msg.arg1);
                        return 0;
                    }
                    resultInfo.getListener().onSuccess(null, msg.what, G.ToString((byte[])ex.pData));
                    return 0;
                }
            }
            return 0;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return 0;
    }

    private void dealWithResultToListener(String devId, DevConfigInfo resultInfo, Object obj) {
        if (null != resultInfo && null != obj) {
            Class<?> _class = obj.getClass();
            try {
                String[][] fields = resultInfo.getFields();
                if (fields != null) {
                    for (String[] field : fields) {
                        OnDevManagerListener listener = resultInfo.getListener(field);
                        if (field == null || listener == null) continue;
                        this.dealWithField(devId, obj, field, _class, listener);
                    }
                }
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
        }
    }

    private void dealWithField(String devId, Object obj, String[] fieldNames, Class<?> _class, OnDevManagerListener listener) throws NoSuchMethodException {
        block20: {
            if (fieldNames.length == 1) {
                if (fieldNames[0].startsWith("is") || fieldNames[0].startsWith("get")) {
                    Method method = _class.getMethod(fieldNames[0], null);
                    if (method != null) {
                        try {
                            Object result = method.invoke(obj, new Object[0]);
                            listener.onSuccess(devId, 0, result);
                            return;
                        }
                        catch (IllegalAccessException e) {
                            e.printStackTrace();
                        }
                        catch (InvocationTargetException e) {
                            e.printStackTrace();
                        }
                    }
                } else {
                    try {
                        Field field = _class.getField(fieldNames[0]);
                        if (null != field && field.getType() == Boolean.TYPE) {
                            try {
                                Boolean result = (Boolean)field.get(obj);
                                listener.onSuccess(devId, 0, result);
                                return;
                            }
                            catch (IllegalAccessException e) {
                                e.printStackTrace();
                                break block20;
                            }
                        }
                        listener.onSuccess(devId, 0, obj);
                    }
                    catch (NoSuchFieldException e) {
                        e.printStackTrace();
                    }
                }
            } else if (fieldNames.length > 1) {
                try {
                    Field field = _class.getField(fieldNames[0]);
                    if (!(field.getClass() instanceof Class)) break block20;
                    try {
                        Object _obj = field.get(obj);
                        if (null != _obj && null != (field = (_class = _obj.getClass()).getField(fieldNames[1])) && field.getType() == Boolean.TYPE) {
                            Object result = field.get(_obj);
                            listener.onSuccess(devId, 0, result);
                            return;
                        }
                    }
                    catch (IllegalAccessException e) {
                        e.printStackTrace();
                    }
                }
                catch (NoSuchFieldException e) {
                    e.printStackTrace();
                }
            } else {
                listener.onSuccess(devId, 0, obj);
            }
        }
    }

    public static interface OnDevUpgradeListener {
        public void onCheckUpgradeResult(int var1, String var2, int var3);

        public void onUpgradeProgress(int var1, int var2, int var3, String var4);
    }

    public static interface OnDevWiFiSetListener {
        public void onDevWiFiSetState(int var1);

        public void onDevWiFiSetResult(XMDevInfo var1);
    }

    public static interface OnQuickSetWiFiListener {
        public void onQuickSetResult(XMDevInfo var1, int var2);
    }

    public static interface OnSearchLocalDevListener {
        public void onSearchLocalDevResult(List<XMDevInfo> var1);
    }

    public static interface OnDevManagerListener<T> {
        public void onSuccess(String var1, int var2, T var3);

        public void onFailed(String var1, int var2, String var3, int var4);
    }
}

