/*
 * Decompiled with CFR 0.152.
 */
package com.manager.base.http;

import com.manager.XMFunSDKManager;
import com.manager.db.Define;
import java.io.IOException;
import java.util.List;
import okhttp3.HttpUrl;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;

public class MoreBaseUrlInterceptor
implements Interceptor {
    public Response intercept(Interceptor.Chain chain) throws IOException {
        Request originalRequest = chain.request();
        HttpUrl oldUrl = originalRequest.url();
        Request.Builder builder = originalRequest.newBuilder();
        List urlnameList = originalRequest.headers("urlname");
        if (urlnameList.size() > 0) {
            builder.removeHeader("urlname");
            String urlname = (String)urlnameList.get(0);
            HttpUrl baseURL = null;
            if ("rsserver".equals(urlname)) {
                Define.REQUEST_URL = Define.RS_BASE_URL;
                baseURL = HttpUrl.parse((String)Define.RS_BASE_URL);
            } else if ("fdbsserver".equals(urlname)) {
                baseURL = HttpUrl.parse((String)"https://fdbs.xmcsrv.net/");
                Define.REQUEST_URL = "https://fdbs.xmcsrv.net/";
            } else if ("jlinkserver".equals(urlname)) {
                Define.REQUEST_URL = "https://jvss.xmcsrv.net/";
                baseURL = HttpUrl.parse((String)"https://jvss.xmcsrv.net/");
            } else if ("jlinktestserver".equals(urlname)) {
                Define.REQUEST_URL = "https://jvss-core-pre.xmcsrv.net/";
                baseURL = HttpUrl.parse((String)"https://jvss-core-pre.xmcsrv.net/");
            }
            HttpUrl newHttpUrl = oldUrl.newBuilder().scheme(baseURL.scheme()).host(baseURL.host()).port(baseURL.port()).build();
            String header = originalRequest.header("NoToken");
            if (header == null) {
                builder.addHeader("uuid", XMFunSDKManager.instance.getAppUuid()).addHeader("appKey", XMFunSDKManager.instance.getAppKey()).addHeader("X-Requested-With", "XMLHttpRequest");
            }
            Request newRequest = builder.url(newHttpUrl).build();
            return chain.proceed(newRequest);
        }
        return chain.proceed(originalRequest);
    }
}

