/*
 * Decompiled with CFR 0.152.
 */
package com.manager.base;

import android.text.TextUtils;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.lib.sdk.bean.StringUtils;
import com.manager.base.BaseManager;
import com.manager.base.http.MoreBaseUrlInterceptor;
import com.manager.base.http.SecureInterceptor;
import com.manager.db.Define;
import com.manager.db.DevDataCenter;
import com.utils.LogUtils;
import com.utils.XUtils;
import java.io.IOException;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.TimeUnit;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.logging.HttpLoggingInterceptor;
import okio.Buffer;
import okio.BufferedSink;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.converter.gson.GsonConverterFactory;

public abstract class BaseUrlManager
extends BaseManager {
    public static final int TIMEOUT = 5;
    protected Retrofit mRetrofit;

    protected boolean initRetrofit() {
        String loginToken = DevDataCenter.getInstance().getAccessToken();
        if (StringUtils.isStringNULL(loginToken)) {
            LogUtils.debugInfo("loginToken", "loginToken null");
            return false;
        }
        OkHttpClient.Builder builder = new OkHttpClient.Builder();
        HttpLoggingInterceptor logging = new HttpLoggingInterceptor();
        logging.setLevel(HttpLoggingInterceptor.Level.BODY);
        Interceptor mAuthorization = chain -> {
            Request original = chain.request();
            Request request = original.newBuilder().addHeader("Content-Type", "application/json").addHeader("Authorization", TextUtils.isEmpty((CharSequence)loginToken) ? "" : loginToken).addHeader("Accept-Language", XUtils.getLanguage()).method(original.method(), original.body()).build();
            return chain.proceed(request);
        };
        OkHttpClient okHttpClient = builder.connectTimeout(5L, TimeUnit.SECONDS).readTimeout(5L, TimeUnit.SECONDS).writeTimeout(5L, TimeUnit.SECONDS).addInterceptor(mAuthorization).addInterceptor((Interceptor)new MoreBaseUrlInterceptor()).addInterceptor((Interceptor)new SecureInterceptor()).addInterceptor((Interceptor)logging).build();
        this.mRetrofit = new Retrofit.Builder().baseUrl(Define.REQUEST_URL).client(okHttpClient).addConverterFactory((Converter.Factory)GsonConverterFactory.create((Gson)new GsonBuilder().setLenient().create())).build();
        return true;
    }

    public static String parseParams(RequestBody body) {
        try {
            if (body == null) {
                return "";
            }
            Buffer requestBuffer = new Buffer();
            body.writeTo((BufferedSink)requestBuffer);
            Charset charset = StandardCharsets.UTF_8;
            MediaType contentType = body.contentType();
            if (contentType != null) {
                charset = contentType.charset(charset);
            }
            String text = requestBuffer.readString(charset);
            if (contentType != null && !"json".equals(contentType.subtype())) {
                text = URLDecoder.decode(text, BaseUrlManager.convertCharset(charset));
            }
            return text;
        }
        catch (IOException e) {
            return "{\"error\": \"" + e.getMessage() + "\"}";
        }
    }

    private static String convertCharset(Charset charset) {
        String s = charset.toString();
        int i = s.indexOf("[");
        if (i == -1) {
            return s;
        }
        return s.substring(i + 1, s.length() - 1);
    }
}

