/*
 * Decompiled with CFR 0.152.
 */
package com.manager.account.share;

import android.content.Context;
import androidx.annotation.NonNull;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.lib.FunSDK;
import com.lib.sdk.bean.StringUtils;
import com.lib.sdk.bean.share.OtherShareDevUserBean;
import com.manager.XMFunSDKManager;
import com.manager.account.serverinteraction.ShareManagerServerInteraction;
import com.manager.account.share.ShareInfo;
import com.manager.base.BaseUrlManager;
import com.manager.base.http.ResponseCallback;
import com.manager.db.DevDataCenter;
import com.utils.LogUtils;
import com.utils.SignatureUtil;
import com.utils.TimeMillisUtil;
import com.utils.TimeUtils;
import java.net.URLDecoder;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;
import okhttp3.RequestBody;
import okhttp3.ResponseBody;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

public class ShareManager
extends BaseUrlManager {
    public static String DEVICE_PERMISSION_INTERCOM = "DP_Intercom";
    public static String DEVICE_PERMISSION_PTZ = "DP_PTZ";
    public static String DEVICE_PERMISSION_LOCAL_STORAGE = "DP_LocalStorage";
    public static String DEVICE_PERMISSION_MODIFY_CONFIG = "DP_ModifyConfig";
    public static String DEVICE_PERMISSION_ALARM_PUSH = "DP_AlarmPush";
    public static String DEVICE_PERMISSION_VIEW_CLOUD_VIDEO = "DP_ViewCloudVideo";
    public static String DEVICE_PERMISSION_CLOUD_SERVER = "DP_CloudServer";
    public static String DEVICE_PERMISSION_MODIFY_PWD = "DP_ModifyPwd";
    public static String DEVICE_PERMISSION_DELETE_CLOUD_VIDEO = "DP_DeleteCloudVideo";
    public static String DEVICE_PERMISSION_DELETE_ALARM_INFO = "DP_DeleteAlarmInfo";
    public static final String POWERS_DEV_INFO_KEY = "devInfo";
    private static final int TIME_OUT = 30;
    private int movedCard;
    private String uuid;
    private String appKey;
    private String appSecret;
    private String version = "v1";
    private ShareManagerServerInteraction serverInteraction;
    private Map<Integer, OnShareManagerListener> shareManagerListenerMap;
    private static ShareManager shareManager;

    private ShareManager(@NonNull Context context) {
        if (DevDataCenter.getInstance().isLoginByAccount()) {
            this.uuid = XMFunSDKManager.getInstance().getAppUuid();
            this.appKey = XMFunSDKManager.getInstance().getAppKey();
            this.appSecret = XMFunSDKManager.getInstance().getAppSecret();
            this.movedCard = XMFunSDKManager.getInstance().getAppMovecard();
        }
    }

    public static synchronized ShareManager getInstance(@NonNull Context context) {
        if (shareManager == null) {
            shareManager = new ShareManager(context);
        }
        return shareManager;
    }

    public void addShareManagerListener(OnShareManagerListener onShareManagerListener) {
        if (onShareManagerListener != null && this.shareManagerListenerMap != null) {
            this.shareManagerListenerMap.put(onShareManagerListener.hashCode(), onShareManagerListener);
        }
    }

    public void removeShareManagerListener(OnShareManagerListener onShareManagerListener) {
        if (onShareManagerListener != null && this.shareManagerListenerMap != null) {
            this.shareManagerListenerMap.remove(onShareManagerListener.hashCode());
        }
    }

    @Override
    public boolean init() {
        if (this.isInit) {
            return true;
        }
        this.isInit = this.initRetrofit();
        if (this.isInit) {
            this.serverInteraction = (ShareManagerServerInteraction)this.mRetrofit.create(ShareManagerServerInteraction.class);
            this.shareManagerListenerMap = new HashMap<Integer, OnShareManagerListener>();
        }
        return this.isInit;
    }

    @Override
    public void unInit() {
        this.isInit = false;
        this.mRetrofit = null;
        this.serverInteraction = null;
        this.shareManagerListenerMap = null;
    }

    private Callback<ResponseBody> createCallback(final OPERATING shareOperating) {
        return new Callback<ResponseBody>(){

            public void onResponse(Call<ResponseBody> call, Response<ResponseBody> response) {
                ShareInfo shareInfo;
                block10: {
                    ResponseBody responseBody;
                    shareInfo = new ShareInfo(false, null, shareOperating);
                    if (response != null && (responseBody = (ResponseBody)response.body()) != null) {
                        try {
                            JSONObject jsonObject;
                            String jsonResult = URLDecoder.decode(responseBody.string(), "UTF-8");
                            RequestBody requestBody = call.request().body();
                            String strBody = BaseUrlManager.parseParams(requestBody);
                            String requestLog = call.request().url().toString();
                            if (!StringUtils.isStringNULL(strBody)) {
                                requestLog = requestLog + "\nBody----->" + strBody;
                            }
                            LogUtils.debugInfo("APP_HTTP", "Http-request:" + requestLog);
                            LogUtils.debugInfo("APP_HTTP", "Http-response:" + jsonResult);
                            if (jsonResult == null || (jsonObject = JSON.parseObject((String)jsonResult)) == null || !jsonObject.containsKey((Object)"code")) break block10;
                            int code = jsonObject.getIntValue("code");
                            if (code == 2000) {
                                String jsonData = jsonObject.getString("data");
                                if (jsonData != null) {
                                    shareInfo = new ShareInfo(true, jsonData, shareOperating);
                                    ShareManager.this.dealWithCallback(shareInfo);
                                    return;
                                }
                                break block10;
                            }
                            switch (code) {
                                case 4101: {
                                    shareInfo = new ShareInfo(HTTP_ERROR.CAN_NOT_ADD_DEV_FOR_YOURSELF, null, shareOperating);
                                    break;
                                }
                                case 4124: {
                                    shareInfo = new ShareInfo(HTTP_ERROR.DELETE_FROM_SHARED, null, shareOperating);
                                    break;
                                }
                                default: {
                                    shareInfo = new ShareInfo(false, null, shareOperating);
                                }
                            }
                            ShareManager.this.dealWithCallback(shareInfo);
                            return;
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
                ShareManager.this.dealWithCallback(shareInfo);
            }

            public void onFailure(Call<ResponseBody> call, Throwable throwable) {
                FunSDK.Log((String)("Http-request:[" + TimeUtils.showNormalFormat((Long)System.currentTimeMillis()) + "]" + (Object)((Object)shareOperating) + "----->" + call.request().url()));
                FunSDK.Log((String)("Http-response:[" + TimeUtils.showNormalFormat((Long)System.currentTimeMillis()) + "]" + (Object)((Object)shareOperating) + "----->onFailure:" + throwable.getMessage()));
                ShareInfo shareInfo = throwable instanceof UnknownHostException ? new ShareInfo(HTTP_ERROR.NETWORK, null, shareOperating) : new ShareInfo(false, null, shareOperating);
                ShareManager.this.dealWithCallback(shareInfo);
            }
        };
    }

    public void userQuery(String searchUserName) {
        if (!this.init()) {
            return;
        }
        String timeMillis = TimeMillisUtil.getTimMillis();
        try {
            String secret = SignatureUtil.getEncryptStr(this.uuid, this.appKey, this.appSecret, timeMillis, this.movedCard);
            Call<ResponseBody> call = this.serverInteraction.userQuery(this.version, timeMillis, secret, searchUserName);
            call.enqueue(this.createCallback(OPERATING.SEARCH_USER));
        }
        catch (Exception e) {
            e.printStackTrace();
            this.dealWithCallback(new ShareInfo(false, null, OPERATING.SEARCH_USER));
        }
    }

    public void shareDev(String devId, String userId, String loginName, String devPwd, int devType, String permissions) {
        if (!this.init()) {
            return;
        }
        String timeMillis = TimeMillisUtil.getTimMillis();
        try {
            String secret = SignatureUtil.getEncryptStr(this.uuid, this.appKey, this.appSecret, timeMillis, this.movedCard);
            String devInfo = FunSDK.EncDevInfo((String)devId, (String)loginName, (String)devPwd, (int)devType);
            JSONObject powersObj = new JSONObject();
            powersObj.put(POWERS_DEV_INFO_KEY, (Object)devInfo);
            String powersJson = powersObj.toJSONString();
            Call<ResponseBody> call = this.serverInteraction.shareDev(this.version, timeMillis, secret, devId, userId, powersJson, StringUtils.isStringNULL(permissions) ? "" : permissions);
            call.enqueue(this.createCallback(OPERATING.SHARE_DEV));
        }
        catch (Exception e) {
            e.printStackTrace();
            this.dealWithCallback(new ShareInfo(false, null, OPERATING.SHARE_DEV));
        }
    }

    public void cancelShare(String shareId) {
        if (!this.init()) {
            return;
        }
        String timeMillis = TimeMillisUtil.getTimMillis();
        try {
            String secret = SignatureUtil.getEncryptStr(this.uuid, this.appKey, this.appSecret, timeMillis, this.movedCard);
            Call<ResponseBody> call = this.serverInteraction.cancelShare(this.version, timeMillis, secret, shareId);
            call.enqueue(this.createCallback(OPERATING.CANCEL_SHARE));
        }
        catch (Exception e) {
            e.printStackTrace();
            this.dealWithCallback(new ShareInfo(false, null, OPERATING.CANCEL_SHARE));
        }
    }

    public void getMyShareDevList() {
        if (!this.init()) {
            return;
        }
        String timeMillis = TimeMillisUtil.getTimMillis();
        try {
            String secret = SignatureUtil.getEncryptStr(this.uuid, this.appKey, this.appSecret, timeMillis, this.movedCard);
            Call<ResponseBody> call = this.serverInteraction.getMySharedDevList(this.version, timeMillis, secret);
            call.enqueue(this.createCallback(OPERATING.GET_MY_SHARE_DEV_USER_LIST));
        }
        catch (Exception e) {
            e.printStackTrace();
            this.dealWithCallback(new ShareInfo(false, null, OPERATING.GET_MY_SHARE_DEV_USER_LIST));
        }
    }

    public void getMyShareDevUserList(String devId) {
        if (!this.init()) {
            return;
        }
        String timeMillis = TimeMillisUtil.getTimMillis();
        try {
            String secret = SignatureUtil.getEncryptStr(this.uuid, this.appKey, this.appSecret, timeMillis, this.movedCard);
            Call<ResponseBody> call = this.serverInteraction.getMyShareUserList(this.version, timeMillis, secret, devId);
            call.enqueue(this.createCallback(OPERATING.GET_MY_SHARE_DEV_USER_LIST));
        }
        catch (Exception e) {
            e.printStackTrace();
            this.dealWithCallback(new ShareInfo(false, null, OPERATING.GET_MY_SHARE_DEV_USER_LIST));
        }
    }

    public void getOtherShareDevList() {
        if (!this.init()) {
            return;
        }
        String timeMillis = TimeMillisUtil.getTimMillis();
        try {
            String secret = SignatureUtil.getEncryptStr(this.uuid, this.appKey, this.appSecret, timeMillis, this.movedCard);
            Call<ResponseBody> call = this.serverInteraction.getOtherShareDevList(this.version, timeMillis, secret);
            call.enqueue(this.createCallback(OPERATING.GET_OTHER_SHARE_DEV_USER_LIST));
        }
        catch (Exception e) {
            e.printStackTrace();
            this.dealWithCallback(new ShareInfo(false, null, OPERATING.GET_OTHER_SHARE_DEV_USER_LIST));
        }
    }

    public void acceptShare(OtherShareDevUserBean shareDevUserBean) {
        if (!this.init()) {
            return;
        }
        if (shareDevUserBean == null) {
            return;
        }
        String timeMillis = TimeMillisUtil.getTimMillis();
        try {
            String secret = SignatureUtil.getEncryptStr(this.uuid, this.appKey, this.appSecret, timeMillis, this.movedCard);
            Call<ResponseBody> call = this.serverInteraction.accpetShare(this.version, timeMillis, secret, shareDevUserBean.getShareId());
            call.enqueue(this.createCallback(OPERATING.ACCPET_SHARE));
        }
        catch (Exception e) {
            e.printStackTrace();
            this.dealWithCallback(new ShareInfo(false, null, OPERATING.ACCPET_SHARE));
        }
    }

    public void rejectShare(OtherShareDevUserBean shareDevUserBean) {
        if (!this.init()) {
            return;
        }
        if (shareDevUserBean == null) {
            return;
        }
        String timeMillis = TimeMillisUtil.getTimMillis();
        try {
            String secret = SignatureUtil.getEncryptStr(this.uuid, this.appKey, this.appSecret, timeMillis, this.movedCard);
            Call<ResponseBody> call = this.serverInteraction.rejectShare(this.version, timeMillis, secret, shareDevUserBean.getShareId());
            call.enqueue(this.createCallback(OPERATING.REJECT_SHARE));
        }
        catch (Exception e) {
            e.printStackTrace();
            this.dealWithCallback(new ShareInfo(false, null, OPERATING.REJECT_SHARE));
        }
    }

    public void addDevFromShared(String devId, String userId, String loginName, String devPwd, int devType, String permissions) {
        if (!this.init()) {
            return;
        }
        String timeMillis = TimeMillisUtil.getTimMillis();
        try {
            String secret = SignatureUtil.getEncryptStr(this.uuid, this.appKey, this.appSecret, timeMillis, this.movedCard);
            String devInfo = FunSDK.EncDevInfo((String)devId, (String)loginName, (String)devPwd, (int)devType);
            JSONObject powersObj = new JSONObject();
            powersObj.put(POWERS_DEV_INFO_KEY, (Object)devInfo);
            String powersJson = powersObj.toJSONString();
            Call<ResponseBody> call = this.serverInteraction.addDevFromShared(this.version, timeMillis, secret, devId, userId, powersJson, permissions == null ? "" : permissions);
            call.enqueue(this.createCallback(OPERATING.ADD_DEVICE_FROM_SHARED));
        }
        catch (Exception e) {
            e.printStackTrace();
            this.dealWithCallback(new ShareInfo(false, null, OPERATING.SHARE_DEV));
        }
    }

    public void setDevSharePermission(String shareId, String permission) {
        if (!this.init()) {
            return;
        }
        String timeMillis = TimeMillisUtil.getTimMillis();
        try {
            String secret = SignatureUtil.getEncryptStr(this.uuid, this.appKey, this.appSecret, timeMillis, this.movedCard);
            Call<ResponseBody> call = this.serverInteraction.setSharePermission(this.version, timeMillis, secret, shareId, permission);
            call.enqueue(this.createCallback(OPERATING.SET_DEVICE_SHARE_PERMISSION));
        }
        catch (Exception e) {
            e.printStackTrace();
            this.dealWithCallback(new ShareInfo(false, null, OPERATING.SET_DEVICE_SHARE_PERMISSION));
        }
    }

    private void dealWithCallback(ShareInfo shareInfo) {
        if (this.shareManagerListenerMap != null) {
            for (Map.Entry<Integer, OnShareManagerListener> shareManagerListenerEntry : this.shareManagerListenerMap.entrySet()) {
                OnShareManagerListener shareManagerListener;
                if (shareManagerListenerEntry == null || (shareManagerListener = shareManagerListenerEntry.getValue()) == null) continue;
                shareManagerListener.onShareResult(shareInfo);
            }
        }
    }

    public void shareDevice(HashMap<String, Object> requestBody, ResponseCallback.ICallback callback) {
        String timeMill = TimeMillisUtil.getTimMillis();
        String sign = "";
        try {
            sign = SignatureUtil.getEncryptStr(this.uuid, this.appKey, this.appSecret, timeMill, this.movedCard);
        }
        catch (Exception e) {
            e.printStackTrace();
            LogUtils.debugInfo("[APP_JVSS->]", "Failed to generate sign");
        }
        this.serverInteraction.shareDevice(timeMill, sign, requestBody).enqueue((Callback)new ResponseCallback(callback));
    }

    public void getSharedDeviceList(HashMap<String, Object> requestBody, ResponseCallback.ICallback callback) {
        String timeMill = TimeMillisUtil.getTimMillis();
        String sign = "";
        try {
            sign = SignatureUtil.getEncryptStr(this.uuid, this.appKey, this.appSecret, timeMill, this.movedCard);
        }
        catch (Exception e) {
            e.printStackTrace();
            LogUtils.debugInfo("[APP_JVSS->]", "Failed to generate sign");
        }
        this.serverInteraction.getSharedDeviceList(timeMill, sign, requestBody).enqueue((Callback)new ResponseCallback(callback));
    }

    public void getShareRecInfo(ResponseCallback.ICallback callback) {
        String timeMill = TimeMillisUtil.getTimMillis();
        String sign = "";
        try {
            sign = SignatureUtil.getEncryptStr(this.uuid, this.appKey, this.appSecret, timeMill, this.movedCard);
        }
        catch (Exception e) {
            e.printStackTrace();
            LogUtils.debugInfo("[APP_JVSS->]", "Failed to generate sign");
        }
        this.serverInteraction.getShareRecInfo(timeMill, sign).enqueue((Callback)new ResponseCallback(callback));
    }

    public void acceptOrRefuseShare(HashMap<String, Object> requestBody, ResponseCallback.ICallback callback) {
        String timeMill = TimeMillisUtil.getTimMillis();
        String sign = "";
        try {
            sign = SignatureUtil.getEncryptStr(this.uuid, this.appKey, this.appSecret, timeMill, this.movedCard);
        }
        catch (Exception e) {
            e.printStackTrace();
            LogUtils.debugInfo("[APP_JVSS->]", "Failed to generate sign");
        }
        this.serverInteraction.acceptOrRefuseShare(timeMill, sign, requestBody).enqueue((Callback)new ResponseCallback(callback));
    }

    public void queryDevShareList(HashMap<String, Object> requestBody, ResponseCallback.ICallback callback) {
        String timeMill = TimeMillisUtil.getTimMillis();
        String sign = "";
        try {
            sign = SignatureUtil.getEncryptStr(this.uuid, this.appKey, this.appSecret, timeMill, this.movedCard);
        }
        catch (Exception e) {
            e.printStackTrace();
            LogUtils.debugInfo("[APP_JVSS->]", "Failed to generate sign");
        }
        this.serverInteraction.queryDevShareList(timeMill, sign, requestBody).enqueue((Callback)new ResponseCallback(callback));
    }

    public void delSharedRecByAdmin(HashMap<String, Object> requestBody, ResponseCallback.ICallback callback) {
        String timeMill = TimeMillisUtil.getTimMillis();
        String sign = "";
        try {
            sign = SignatureUtil.getEncryptStr(this.uuid, this.appKey, this.appSecret, timeMill, this.movedCard);
        }
        catch (Exception e) {
            e.printStackTrace();
            LogUtils.debugInfo("[APP_JVSS->]", "Failed to generate sign");
        }
        this.serverInteraction.delSharedRecByAdmin(timeMill, sign, requestBody).enqueue((Callback)new ResponseCallback(callback));
    }

    public void delSharedRecByMember(HashMap<String, Object> requestBody, ResponseCallback.ICallback callback) {
        String timeMill = TimeMillisUtil.getTimMillis();
        String sign = "";
        try {
            sign = SignatureUtil.getEncryptStr(this.uuid, this.appKey, this.appSecret, timeMill, this.movedCard);
        }
        catch (Exception e) {
            e.printStackTrace();
            LogUtils.debugInfo("[APP_JVSS->]", "Failed to generate sign");
        }
        this.serverInteraction.delSharedRecByMember(timeMill, sign, requestBody).enqueue((Callback)new ResponseCallback(callback));
    }

    public void searchCanSharePrivileges(HashMap<String, Object> requestBody, ResponseCallback.ICallback callback) {
        String timeMill = TimeMillisUtil.getTimMillis();
        String sign = "";
        try {
            sign = SignatureUtil.getEncryptStr(this.uuid, this.appKey, this.appSecret, timeMill, this.movedCard);
        }
        catch (Exception e) {
            e.printStackTrace();
            LogUtils.debugInfo("[APP_JVSS->]", "Failed to generate sign");
        }
        this.serverInteraction.searchCanSharePrivileges(timeMill, sign, requestBody).enqueue((Callback)new ResponseCallback(callback));
    }

    public void createDevShareCode(HashMap<String, Object> requestBody, ResponseCallback.ICallback callback) {
        String timeMill = TimeMillisUtil.getTimMillis();
        String sign = "";
        try {
            sign = SignatureUtil.getEncryptStr(this.uuid, this.appKey, this.appSecret, timeMill, this.movedCard);
        }
        catch (Exception e) {
            e.printStackTrace();
            LogUtils.debugInfo("[APP_JVSS->]", "Failed to generate sign");
        }
        this.serverInteraction.createDevShareCode(timeMill, sign, requestBody).enqueue((Callback)new ResponseCallback(callback));
    }

    public void decodeDevShareCode(HashMap<String, Object> requestBody, ResponseCallback.ICallback callback) {
        String timeMill = TimeMillisUtil.getTimMillis();
        String sign = "";
        try {
            sign = SignatureUtil.getEncryptStr(this.uuid, this.appKey, this.appSecret, timeMill, this.movedCard);
        }
        catch (Exception e) {
            e.printStackTrace();
            LogUtils.debugInfo("[APP_JVSS->]", "Failed to generate sign");
        }
        this.serverInteraction.decodeDevShareCode(timeMill, sign, requestBody).enqueue((Callback)new ResponseCallback(callback));
    }

    public void acceptShareByCode(HashMap<String, Object> requestBody, ResponseCallback.ICallback callback) {
        String timeMill = TimeMillisUtil.getTimMillis();
        String sign = "";
        try {
            sign = SignatureUtil.getEncryptStr(this.uuid, this.appKey, this.appSecret, timeMill, this.movedCard);
        }
        catch (Exception e) {
            e.printStackTrace();
            LogUtils.debugInfo("[APP_JVSS->]", "Failed to generate sign");
        }
        this.serverInteraction.acceptShareByCode(timeMill, sign, requestBody).enqueue((Callback)new ResponseCallback(callback));
    }

    public static interface OnShareManagerListener {
        public void onShareResult(ShareInfo var1);
    }

    public static enum HTTP_ERROR {
        NETWORK,
        CAN_NOT_ADD_DEV_FOR_YOURSELF,
        DELETE_FROM_SHARED;

    }

    public static enum OPERATING {
        SEARCH_USER,
        SHARE_DEV,
        CANCEL_SHARE,
        GET_MY_SHARE_DEV_USER_LIST,
        GET_OTHER_SHARE_DEV_USER_LIST,
        ACCPET_SHARE,
        REJECT_SHARE,
        ADD_DEVICE_FROM_SHARED,
        SET_DEVICE_SHARE_PERMISSION;

    }
}

