/*
 * Decompiled with CFR 0.152.
 */
package com.manager;

import android.app.Application;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.content.res.AssetManager;
import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.Nullable;
import com.basic.G;
import com.lib.FunSDK;
import com.lib.sdk.bean.StringUtils;
import com.lib.sdk.struct.SInitParam;
import com.manager.base.BaseManager;
import com.manager.db.Define;
import com.manager.db.DevDataCenter;
import com.utils.FileUtils;
import com.utils.LogUtils;
import com.utils.PathUtils;
import com.utils.SignatureUtil;
import java.io.File;
import java.util.Locale;

public class XMFunSDKManager
extends BaseManager {
    public static XMFunSDKManager instance;
    public static String LIBXMFUNSDK_VERSION;
    private String appFilePath;
    private String passwordPath;
    private String configPath;
    private String upgradeFilesPath;
    private String filesTempPath;
    private boolean isXMStatusBar;
    private String appUuid;
    private String appKey;
    private String appSecret;
    private int appMovecard;
    private int connectDevTryAgainNum = 0;

    private XMFunSDKManager() {
        this.initLib();
        Log.d((String)"[APP_SDK_VERSION]->", (String)("[FunSDK Version]->" + FunSDK.GetVersionInfo() + " [LibXMFunSDK Version]->" + LIBXMFUNSDK_VERSION));
    }

    private XMFunSDKManager(int customPwdType, String customPwd, String customServerAddr, int customPort) {
        this.initLib(customPwdType, customPwd, customServerAddr, customPort);
    }

    public static XMFunSDKManager getInstance() {
        if (null == instance) {
            instance = new XMFunSDKManager();
        }
        return instance;
    }

    public static XMFunSDKManager getInstance(int customPwdType, String customPwd, String customServerAddr, int customPort) {
        if (null == instance) {
            instance = new XMFunSDKManager(customPwdType, customPwd, customServerAddr, customPort);
        }
        return instance;
    }

    private void initLib() {
        this.initLib(0, null, null, 0);
    }

    private void initLib(int customPwdType, String customPwd, String customServerAddr, int customPort) {
        SInitParam param = new SInitParam();
        param.st_0_nAppType = 5;
        String country = Locale.getDefault().getCountry();
        String language = Locale.getDefault().getLanguage();
        if (language.equalsIgnoreCase("zh") && (country.equalsIgnoreCase("TW") || country.equalsIgnoreCase("HK"))) {
            G.SetValue((byte[])param.st_2_language, (String)country.toLowerCase());
        } else {
            G.SetValue((byte[])param.st_2_language, (String)Locale.getDefault().getLanguage());
        }
        if (customServerAddr != null || customPwd != null) {
            FunSDK.InitExV2((int)0, (byte[])G.ObjToBytes((Object)param), (int)customPwdType, (String)customPwd, (String)customServerAddr, (int)customPort);
        } else {
            FunSDK.Init((int)0, (byte[])G.ObjToBytes((Object)param));
        }
    }

    @Override
    public boolean init() {
        if (!this.isInit) {
            FunSDK.MyInitNetSDK();
            this.isInit = true;
        }
        return true;
    }

    @Override
    public void unInit() {
        if (this.isInit) {
            FunSDK.MyUnInitNetSDK();
            this.isInit = false;
        }
    }

    private void initPathConfig(String appFilePath) {
        this.configPath = appFilePath + File.separator + ".ConfigPath/";
        this.upgradeFilesPath = appFilePath + File.separator + ".UpgradeFiles/";
        this.filesTempPath = appFilePath + File.separator + ".FilesTemp/";
        this.passwordPath = appFilePath + File.separator + ".password.txt";
        File file = new File(this.configPath);
        if (!file.exists()) {
            this.makeAppFileRootDirectory(this.configPath);
        }
        if (!(file = new File(this.upgradeFilesPath)).exists()) {
            this.makeAppFileRootDirectory(this.upgradeFilesPath);
        }
        if (!(file = new File(this.filesTempPath)).exists()) {
            this.makeAppFileRootDirectory(this.filesTempPath);
        }
        FunSDK.SetFunStrAttr((int)3, (String)this.upgradeFilesPath);
        FunSDK.SetFunStrAttr((int)2, (String)this.configPath);
        FunSDK.SetFunStrAttr((int)9, (String)this.filesTempPath);
        FunSDK.SetFunStrAttr((int)10, (String)this.passwordPath);
    }

    private boolean makeAppFileRootDirectory(String filePath) {
        File file = null;
        String newPath = null;
        if (filePath == null || !filePath.startsWith(this.appFilePath)) {
            return false;
        }
        String[] path = filePath.split(File.separator);
        for (int i = 0; i < path.length; ++i) {
            if (StringUtils.isStringNULL(newPath = newPath == null ? path[i] : newPath + File.separator + path[i]) || this.appFilePath.contains(newPath) || (file = new File(newPath)).exists() || file.mkdir()) continue;
            return false;
        }
        return true;
    }

    public XMFunSDKManager initLog(@Nullable String logPath) {
        this.init();
        if (logPath == null) {
            logPath = this.appFilePath + File.separator + ".log.txt";
        }
        FunSDK.LogInit((int)0, (String)"", (int)0, (String)logPath, (int)3);
        LogUtils.debugInfo("[APP_SDK_VERSION]->", "[FunSDK Version]->" + FunSDK.GetVersionInfo() + " [LibXMFunSDK Version]->" + LIBXMFUNSDK_VERSION);
        return instance;
    }

    public XMFunSDKManager initLog() {
        return this.initLog(null);
    }

    public static void initLanguage(Application application, AssetManager assets, String lan) {
        FunSDK.SetApplication((Application)application);
        FunSDK.InitLanguage((AssetManager)assets, (String)lan);
    }

    public static void initLanguage(AssetManager assets, String lan) {
        FunSDK.InitLanguage((AssetManager)assets, (String)lan);
    }

    @Deprecated
    public XMFunSDKManager initXMCloudPlatform(Context context) {
        return this.initXMCloudPlatform(context, true);
    }

    @Deprecated
    public XMFunSDKManager initXMCloudPlatform(Context context, boolean isUseDefaultConfigPath) {
        if (context == null) {
            return instance;
        }
        try {
            ApplicationInfo appInfo = context.getPackageManager().getApplicationInfo(context.getPackageName(), 128);
            String errorTips = "XM\u4e91\u5e73\u53f0\u521d\u59cb\u5316\uff08\u5fc5\u987b\u8c03\u7528\uff0c\u5426\u5219\u65e0\u6cd5\u6b63\u5e38\u4f7f\u7528SDK\uff09\\n \" +\n                        \"\u524d\u5f80\uff08https://oppf.xmcsrv.com/#/docs?md=readGuide\uff09 \u65b0\u4eba\u6307\u5357\uff0c\u6ce8\u518c\u7533\u8bf7\u6210\u4e3a\u5f00\u653e\u5e73\u53f0\u5f00\u53d1\u8005\uff0c\" +\n                        \"\u7136\u540e\u5230\u3010\u63a7\u5236\u53f0\u3011-\u3010\u521b\u5efa\u5e94\u7528\u9875\u9762\u3011\u4e2d\u521b\u5efaAndroid\u5e94\u7528\uff0c\u7b49\u5e94\u7528\u5ba1\u6838\u901a\u8fc7\u540e\u5c31\u53ef\u4ee5\u83b7\u53d6\u5230AppKey\u3001\" +\n                        \"movedCard\u548cAppSecret\u7b49\u4fe1\u606f\u3002\" +\n                        \"\u5e76\u4e14\u8981\u5728AndroidManifest.xml\u52a0\u4e0a\u7533\u8bf7\u5230\u7684AppKey\u3001movedCard\u548cAppSecret\u7b49\u4fe1\u606f\" +\n                        \"<meta-data\\n\" +\n                        \"     android:name=\\\"APP_UUID\\\"\\n\" +\n                        \"     android:value=\\\"\u9700\u8981\u66ff\u6362\u7684\u5185\u5bb9\\\" />\" +\n                        \"<meta-data\\n\" +\n                        \"     android:name=\\\"APP_KEY\\\"\\n\" +\n                        \"     android:value=\\\"\u9700\u8981\u66ff\u6362\u7684\u5185\u5bb9\\\" />\" +\n                        \"<meta-data\\n\" +\n                        \"     android:name=\\\"APP_SECRET\\\"\\n\" +\n                        \"     android:value=\\\"\u9700\u8981\u66ff\u6362\u7684\u5185\u5bb9\\\" />\" +\n                        \"<meta-data\\n\" +\n                        \"     android:name=\\\"APP_MOVECARD\\\"\\n\" +\n                        \"     android:value=\\\"\u9700\u8981\u66ff\u6362\u7684\u5185\u5bb9\\\" />";
            if (!(appInfo.metaData != null && appInfo.metaData.containsKey("APP_UUID") && appInfo.metaData.containsKey("APP_KEY") && appInfo.metaData.containsKey("APP_SECRET") && appInfo.metaData.containsKey("APP_MOVECARD"))) {
                throw new RuntimeException(errorTips);
            }
            this.appUuid = appInfo.metaData.getString("APP_UUID");
            this.appKey = appInfo.metaData.getString("APP_KEY");
            this.appSecret = appInfo.metaData.getString("APP_SECRET");
            this.appMovecard = appInfo.metaData.getInt("APP_MOVECARD");
            if (StringUtils.isStringNULL(this.appUuid) || StringUtils.isStringNULL(this.appKey) || StringUtils.isStringNULL(this.appSecret)) {
                throw new RuntimeException(errorTips);
            }
            this.appUuid = this.appUuid.trim();
            this.appKey = this.appKey.trim();
            this.appSecret = this.appSecret.trim();
            int appLoginOemType = appInfo.metaData.getInt("APP_LOGIN_OEM_TYPE", 1);
            int iret = FunSDK.XMCloundPlatformInit((String)this.appUuid, (String)this.appKey, (String)this.appSecret, (int)this.appMovecard);
            DevDataCenter.getInstance().setAppLoginOemType(appLoginOemType);
            System.out.println("XMCloundPlatformInit:" + iret);
            if (isUseDefaultConfigPath) {
                String result;
                String appName = result = SignatureUtil.md5Hex((this.appUuid + this.appKey).getBytes());
                if (result != null && result.length() > 16) {
                    appName = result.substring(0, 15);
                }
                this.appFilePath = PathUtils.getDataPath(context) + File.separator + appName;
                File file = new File(this.appFilePath);
                if (!file.exists()) {
                    this.makeAppFileRootDirectory(this.appFilePath);
                }
                this.initPathConfig(this.appFilePath);
            }
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }
        return instance;
    }

    public XMFunSDKManager initXMCloudPlatform(Context context, String appUuid, String appKey, String appSecret, int appMovecard, boolean isUseDefaultConfigPath) {
        if (context == null) {
            return instance;
        }
        try {
            String errorTips = "\u4e91\u5e73\u53f0\u521d\u59cb\u5316\uff08\u5fc5\u987b\u8c03\u7528\uff0c\u5426\u5219\u65e0\u6cd5\u6b63\u5e38\u4f7f\u7528SDK\uff09\\n \" +\n                        \"\u524d\u5f80\uff08https://oppf.xmcsrv.com/#/docs?md=readGuide\uff09 \u65b0\u4eba\u6307\u5357\uff0c\u6ce8\u518c\u7533\u8bf7\u6210\u4e3a\u5f00\u653e\u5e73\u53f0\u5f00\u53d1\u8005\uff0c\" +\n                        \"\u7136\u540e\u5230\u3010\u63a7\u5236\u53f0\u3011-\u3010\u521b\u5efa\u5e94\u7528\u9875\u9762\u3011\u4e2d\u521b\u5efaAndroid\u5e94\u7528\uff0c\u7b49\u5e94\u7528\u5ba1\u6838\u901a\u8fc7\u540e\u5c31\u53ef\u4ee5\u83b7\u53d6\u5230AppKey\u3001\" +\n                        \"movedCard\u548cAppSecret\u7b49\u4fe1\u606f\u3002\" +";
            if (TextUtils.isEmpty((CharSequence)appUuid) || TextUtils.isEmpty((CharSequence)appKey) || TextUtils.isEmpty((CharSequence)appSecret)) {
                throw new RuntimeException(errorTips);
            }
            if (StringUtils.isStringNULL(appUuid) || StringUtils.isStringNULL(appKey) || StringUtils.isStringNULL(appSecret)) {
                throw new RuntimeException(errorTips);
            }
            this.appUuid = appUuid.trim();
            this.appKey = appKey.trim();
            this.appSecret = appSecret.trim();
            this.appMovecard = appMovecard;
            int iret = FunSDK.XMCloundPlatformInit((String)appUuid, (String)appKey, (String)appSecret, (int)appMovecard);
            System.out.println("XMCloundPlatformInit:" + iret);
            if (isUseDefaultConfigPath) {
                String result;
                String appName = result = SignatureUtil.md5Hex((appUuid + appKey).getBytes());
                if (result != null && result.length() > 16) {
                    appName = result.substring(0, 15);
                }
                this.appFilePath = PathUtils.getDataPath(context) + File.separator + appName;
                File file = new File(this.appFilePath);
                if (!file.exists()) {
                    this.makeAppFileRootDirectory(this.appFilePath);
                }
                this.initPathConfig(this.appFilePath);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return instance;
    }

    public XMFunSDKManager setXMStatusBar(boolean isXMStatusBar) {
        this.isXMStatusBar = isXMStatusBar;
        return instance;
    }

    public XMFunSDKManager sysSetServerIPPort(String serverKey, String serverIpOrDomain, int serverPort) {
        FunSDK.SysSetServerIPPort((String)serverKey, (String)serverIpOrDomain, (int)serverPort);
        if ("MI_SERVER".equalsIgnoreCase(serverKey)) {
            Define.REQUEST_URL = Define.RS_BASE_URL = serverIpOrDomain;
        }
        return instance;
    }

    public boolean isXMStatusBar() {
        return this.isXMStatusBar;
    }

    public String getAppUuid() {
        return this.appUuid;
    }

    public String getAppKey() {
        return this.appKey;
    }

    public String getAppSecret() {
        return this.appSecret;
    }

    public int getAppMovecard() {
        return this.appMovecard;
    }

    public void clearConfigPath() {
        FileUtils.deleteFiles(new File(this.configPath));
    }

    public void clearUpgradeFilesPath() {
        FileUtils.deleteFiles(new File(this.upgradeFilesPath));
    }

    public void clearFilesTempPath() {
        FileUtils.deleteFiles(new File(this.filesTempPath));
    }

    public void clearPasswordPath() {
        FileUtils.deleteFiles(new File(this.passwordPath));
    }

    public String getAppFilePath() {
        return this.appFilePath;
    }

    public int getConnectDevTryAgainNum() {
        return this.connectDevTryAgainNum;
    }

    public void setConnectDevTryAgainNum(int connectDevTryAgainNum) {
        this.connectDevTryAgainNum = connectDevTryAgainNum;
    }

    public String getVersion() {
        return LIBXMFUNSDK_VERSION;
    }

    static {
        LIBXMFUNSDK_VERSION = "4.6.2(2024-04-22)";
    }
}

