/*
 * Decompiled with CFR 0.152.
 */
package com.lib.sdk.bean.cloudmedia;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.JSONObject;
import com.lib.sdk.bean.StringUtils;
import com.lib.sdk.bean.cloudmedia.CloudMediaFileInfoBean;
import com.lib.sdk.struct.H264_DVR_FILE_DATA;
import com.utils.TimeUtils;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;

public class CloudMediaFilesBean {
    public Calendar searchCalendar;
    public int fileNum;
    public int chnId;
    public byte[] timeData = new byte[720];
    public List<CloudMediaFileInfoBean> fileList;
    public List<CloudMediaFileInfoBean> tempFileList;

    public CloudMediaFilesBean() {
        this.fileList = new ArrayList<CloudMediaFileInfoBean>();
    }

    public CloudMediaFilesBean(Calendar searchCalendar) {
        this.searchCalendar = searchCalendar;
        this.fileList = new ArrayList<CloudMediaFileInfoBean>();
    }

    public boolean parseJson(String json) {
        try {
            if (StringUtils.isStringNULL(json)) {
                return false;
            }
            JSONObject jObj = JSON.parseObject((String)json);
            if (null == jObj) {
                return false;
            }
            JSONObject alarmCenterObj = jObj.getJSONObject("AlarmCenter");
            if (null == alarmCenterObj) {
                return false;
            }
            if (alarmCenterObj.containsKey((Object)"Body")) {
                JSONObject bodyObj = alarmCenterObj.getJSONObject("Body");
                if (bodyObj.containsKey((Object)"VideoArray")) {
                    this.tempFileList = JSON.parseArray((String)bodyObj.getString("VideoArray"), CloudMediaFileInfoBean.class);
                    if (null != this.tempFileList && !this.tempFileList.isEmpty()) {
                        this.fileNum += this.tempFileList.size();
                        this.fileList.addAll(this.tempFileList);
                        return true;
                    }
                } else if (bodyObj.containsKey((Object)"TimeAxis")) {
                    this.tempFileList = JSON.parseArray((String)bodyObj.getString("TimeAxis"), CloudMediaFileInfoBean.class);
                    if (null != this.tempFileList && !this.tempFileList.isEmpty()) {
                        this.fileNum += this.tempFileList.size();
                        this.fileList.addAll(this.tempFileList);
                        return true;
                    }
                }
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return false;
    }

    public CloudMediaFileInfoBean getFirstFile() {
        if (this.tempFileList == null || this.tempFileList.isEmpty()) {
            return null;
        }
        Collections.sort(this.tempFileList, new Comparator<CloudMediaFileInfoBean>(){

            @Override
            public int compare(CloudMediaFileInfoBean object1, CloudMediaFileInfoBean object2) {
                return object1.getStartTimeByYear().compareTo(object2.getStartTimeByYear());
            }
        });
        return this.tempFileList.get(0);
    }

    public List<H264_DVR_FILE_DATA> cloudMediaInfoToH264FileData() {
        ArrayList<H264_DVR_FILE_DATA> list = new ArrayList<H264_DVR_FILE_DATA>();
        try {
            if (this.fileList != null) {
                for (CloudMediaFileInfoBean info : this.fileList) {
                    H264_DVR_FILE_DATA data = new H264_DVR_FILE_DATA();
                    data.downloadType = 1;
                    Date sDate = info.getStartTimeByYear();
                    Date eDate = info.getEndTimeByYear();
                    data.st_3_beginTime.st_0_year = sDate.getYear() + 1900;
                    data.st_3_beginTime.st_1_month = sDate.getMonth() + 1;
                    data.st_3_beginTime.st_2_day = sDate.getDate();
                    data.st_3_beginTime.st_4_hour = sDate.getHours();
                    data.st_3_beginTime.st_5_minute = sDate.getMinutes();
                    data.st_3_beginTime.st_6_second = sDate.getSeconds();
                    data.st_4_endTime.st_0_year = eDate.getYear() + 1900;
                    data.st_4_endTime.st_1_month = eDate.getMonth() + 1;
                    data.st_4_endTime.st_2_day = eDate.getDate();
                    data.st_4_endTime.st_4_hour = eDate.getHours();
                    data.st_4_endTime.st_5_minute = eDate.getMinutes();
                    data.st_4_endTime.st_6_second = eDate.getSeconds();
                    data.st_2_fileName = info.getIndexFile().getBytes();
                    data.st_0_ch = this.chnId;
                    data.setAlarmExFileInfo(JSON.toJSONString((Object)info));
                    list.add(data);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return list;
    }

    public Calendar getSearchCalendar() {
        return this.searchCalendar;
    }

    public void setSearchCalendar(Calendar searchCalendar) {
        this.searchCalendar = searchCalendar;
    }

    public int getFileNum() {
        return this.fileNum;
    }

    public List<CloudMediaFileInfoBean> getFileList() {
        return this.fileList;
    }

    public CloudMediaFileInfoBean getContain(String time) {
        if (StringUtils.isStringNULL(time) || this.fileList == null || this.fileList.isEmpty()) {
            return null;
        }
        Calendar searchCalendar = TimeUtils.getNormalFormatCalender((String)time);
        long searchTime = searchCalendar.getTimeInMillis();
        for (CloudMediaFileInfoBean info : this.fileList) {
            if (info == null) continue;
            long sTime = info.getStartTimeByYear().getTime();
            long eTime = info.getEndTimeByYear().getTime();
            if (searchTime < sTime || searchTime > eTime) continue;
            return info;
        }
        return this.fileList.get(0);
    }

    public void clearData() {
        if (this.fileList != null) {
            this.fileList.clear();
        }
        this.fileNum = 0;
        this.timeData = new byte[720];
    }

    public byte[] getTimeData() {
        return this.timeData;
    }

    public List<CloudMediaFileInfoBean> getTempFileList() {
        return this.tempFileList;
    }
}

