/*
 * Decompiled with CFR 0.152.
 */
package com.lib.sdk.bean;

import android.content.Context;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.JSONObject;
import com.lib.sdk.bean.StringUtils;
import com.lib.sdk.bean.SystemInfoBean;
import java.util.HashMap;
import java.util.Map;

public class SysDevAbilityInfoBean {
    public static final int CLOUD_STATE_UNKOWN = -1;
    public static final int CLOUD_STATE_NOT_SUPPORT = 0;
    public static final int CLOUD_STATE_NORMAL = 1;
    public static final int CLOUD_STATE_EXPIRE = 2;
    public static final int CLOUD_STATE_NOT_OPENED = 3;
    public static final int CLOUD_FLOW_RUN_OUT = 4;
    public static final String XMC_CSS_VID_NORMAL = "xmc.css.vid.normal";
    public static final String XMC_CSS_VID_EXPIRATIONTIME = "xmc.css.vid.expirationtime";
    public static final String XMC_CSS_PIC_SUPPORT = "xmc.css.pic.support";
    public static final String XMC_CSS_VID_SUPPORT = "xmc.css.vid.support";
    public static final String XMC_CSS_VID_ENABLE = "xmc.css.vid.enable";
    public static final String XMC_CSS_VID_KEEPDAYS = "xmc.css.vid.keepdays";
    public static final String XMC_CSS_VID_OUTSVR = "xmc.css.vid.outsvr";
    public static final String SYS_ABILITY_SERVICE_SUPPORT = "xmc.service.support";
    public static final String SYS_ABILITY_SERVICE_NORMAL = "xmc.service.normal";
    public static final String SYS_ABILITY_SERVICE_ENABLE = "xmc.service.enable";
    public static final String SYS_ABILITY_SERVICE = "xmc.service";
    public static final String SYS_ABILITY_ALLOWED = "caps.allowed";
    public static final String XMC_NET_CELLULAR_SUPPORT = "net.cellular.support";
    public static final String XMC_NET_CELLULAR_ENABLE = "net.cellular.enable";
    public static final String XMC_NET_CELLULAR_EXPIRATIONTIME = "net.cellular.expirationtime";
    public static final String XMC_NET_CELLULAR_USED = "net.cellular.used";
    public static final String XMC_NET_CELLULAR_STORAGESPACE = "net.cellular.storagespace";
    public static final String XMC_NET_CELLULAR_NORMAL = "net.cellular.normal";
    public static final String EXT_ALIELE = "ext.aliele";
    public static final String EXT_ALIELE_SUPPORT = "ext.aliele.support";
    public static final String EXT_ALIELE_OUT_SRV = "ext.aliele.outsrv";
    public static final String EXT_ALIELE_ENABLE = "ext.aliele.enable";
    public static final String EXT_ALIELE_EXPIRATION_TIME = "ext.aliele.expirationtime";
    public static final String XMC_VOES_SUPPORT = "xmc.voes.support";
    public static final String XMC_VOES_ENABLE = "xmc.voes.enable";
    public static final String XMC_VOES_EXPIRATION_TIME = "xmc.voes.expirationtime";
    public static final String XMC_VOES_CYCLE_DAYS = "xmc.voes.cycledays";
    public static final String XMC_VOES_CREDIT_MINS = "xmc.voes.creditmins";
    public static final String XMC_VOES_OUT_SRV = "xmc.voes.outsrv";
    public static final String XMC_VOES_TOTAL_MINS = "xmc.voes.totalmins";
    public static final String XMC_VOES_USER = "xmc.voes.user";
    public static final String PMS_VOES_SUPPORT = "pms.voes.support";
    public static final String PMS_VOES_AVAILABLE = "pms.voes.available";
    public static final String PMS_VOES_CYCLE_DAYS = "pms.voes.cycledays";
    public static final String PMS_VOES_ENABLE = "pms.voes.enable";
    public static final String PMS_VOES_EXPIRATION_TIME = "pms.voes.expirationtime";
    public static final String PMS_VOES_USED = "pms.voes.used";
    public static final String PMS_VOES_USER = "pms.voes.user";
    public static final String PMS_SMS_SUPPORT = "pms.sms.support";
    public static final String PMS_SMS_AVAILABLE = "pms.sms.available";
    public static final String PMS_SMS_CYCLE_DAYS = "pms.sms.cycledays";
    public static final String PMS_SMS_ENABLE = "pms.sms.enable";
    public static final String PMS_SMS_EXPIRATION_TIME = "pms.sms.expirationtime";
    public static final String PMS_SMS_USED = "pms.sms.used";
    public static final String PMS_SMS_USER = "pms.sms.user";
    public static final String SYS_ABILITY_DEV_FUN_LOWPOWER = "dev.func.lowpower";
    public static final String XMC_CSS_VID_EXPIRATION_TIME_CHN = "xmc.css.vid.expirationtime.channels";
    public static final String XMC_CSS_VID_ENABLE_CHN = "xmc.css.vid.enable.channels";
    public static final String XMC_CSS_PIC_ENABLE_CHN = "xmc.css.pic.enable.channels";
    public static final String XMC_CSS_PIC_EXPIRATION_TIME_CHN = "xmc.css.pic.expirationtime.channels";
    public static final String XMC_CSS_MAX_CHANNEL = "xmc.css.maxchannel";
    private HashMap<String, Object> devAbilityMap = new HashMap();
    private SystemInfoBean sysInfo;
    private String sn;
    private int devType;
    private String[] devAbilityNames;
    private int localFlowState = -1;
    private String mfrsOemId;
    private String forceOemId;
    private String packageName;

    public SysDevAbilityInfoBean(SystemInfoBean sysInfo, String sn, int devType) {
        this.sysInfo = sysInfo;
        this.sn = sn;
        this.devType = devType;
    }

    public SysDevAbilityInfoBean(String sn) {
        this.sn = sn;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public String getSendJson(Context context, String ... devAbilityNames) {
        if (this.sn == null) {
            return "";
        }
        if (devAbilityNames == null || devAbilityNames.length == 0) {
            devAbilityNames = new String[]{SYS_ABILITY_SERVICE};
        }
        this.devAbilityNames = devAbilityNames;
        JSONObject sendObj = new JSONObject();
        try {
            if (this.sysInfo != null) {
                sendObj.put("hw", (Object)this.sysInfo.getHardWare());
                sendObj.put("sw", (Object)this.sysInfo.getSoftWareVersion());
            }
            sendObj.put("ver", (Object)2);
            sendObj.put("tp", (Object)this.devType);
            sendObj.put("sn", (Object)this.sn);
            sendObj.put("caps", (Object)devAbilityNames);
            if (!StringUtils.isStringNULL(this.packageName)) {
                sendObj.put("appType", (Object)this.packageName);
            }
            for (String devAbilityName : devAbilityNames) {
                this.devAbilityMap.put(devAbilityName, false);
            }
            this.devAbilityMap.put("devId", this.sn);
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
        System.out.println("sysDevAbility:" + sendObj.toString());
        return sendObj.toString();
    }

    public boolean parseJson(String sysDevAbilityJson) {
        if (StringUtils.isStringNULL(sysDevAbilityJson)) {
            return false;
        }
        try {
            JSONObject jObj = JSON.parseObject((String)sysDevAbilityJson);
            if (jObj == null) {
                return false;
            }
            if (jObj.containsKey((Object)"mfrsOemId")) {
                this.setMfrsOemId(jObj.getString("mfrsOemId"));
            }
            if (jObj.containsKey((Object)"forceOemId")) {
                this.setForceOemId(jObj.getString("forceOemId"));
            }
            if (jObj.containsKey((Object)"caps")) {
                long expirationTime;
                Object result;
                JSONObject object = jObj.getJSONObject("caps");
                this.devAbilityMap.putAll((Map<String, Object>)object);
                this.devAbilityMap.put(XMC_CSS_VID_NORMAL, false);
                if (this.devAbilityMap.containsKey(XMC_CSS_VID_ENABLE) && (result = this.devAbilityMap.get(XMC_CSS_VID_ENABLE)) instanceof Boolean && ((Boolean)result).booleanValue() && this.devAbilityMap.containsKey(XMC_CSS_VID_EXPIRATIONTIME) && (expirationTime = Long.parseLong((result = this.devAbilityMap.get(XMC_CSS_VID_EXPIRATIONTIME)).toString())) - System.currentTimeMillis() / 1000L > 0L) {
                    this.devAbilityMap.put(XMC_CSS_VID_NORMAL, true);
                }
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public boolean isConfigSupport() {
        if (this.devAbilityNames == null) {
            return false;
        }
        if (this.devAbilityMap == null || !this.devAbilityMap.containsKey(this.devAbilityNames[0])) {
            return false;
        }
        Object object = this.devAbilityMap.get(this.devAbilityNames[0]);
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        return false;
    }

    public boolean isConfigSupport(String key) {
        return this.isConfigSupport(key, false);
    }

    public boolean isConfigSupport(String key, boolean isDefaultEnable) {
        try {
            if (null == this.devAbilityMap || !this.devAbilityMap.containsKey(key)) {
                return isDefaultEnable;
            }
            Object object = this.devAbilityMap.get(key);
            if (object instanceof Boolean) {
                return (Boolean)object;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return isDefaultEnable;
    }

    public Object getConfig(String key) {
        return this.getConfig(key, false);
    }

    public Object getConfig(String key, Object defaultValue) {
        try {
            if (null == this.devAbilityMap || !this.devAbilityMap.containsKey(key)) {
                return defaultValue;
            }
            Object object = this.devAbilityMap.get(key);
            return object;
        }
        catch (Exception e) {
            e.printStackTrace();
            return defaultValue;
        }
    }

    public Map<String, Object> getConfigSupports() {
        return this.devAbilityMap;
    }

    public String getDevId() {
        return this.sn;
    }

    public int getDevType() {
        return this.devType;
    }

    public String getMfrsOemId() {
        return this.mfrsOemId;
    }

    public void setMfrsOemId(String mfrsOemId) {
        this.mfrsOemId = mfrsOemId;
    }

    public String getForceOemId() {
        return this.forceOemId;
    }

    public void setForceOemId(String forceOemId) {
        this.forceOemId = forceOemId;
    }

    public int getLocalFlowState() {
        if (this.localFlowState != -1) {
            return this.localFlowState;
        }
        try {
            float flowTotal;
            float flowUsed;
            Object value;
            long flowExpired;
            boolean isAllowed = this.isConfigSupport(SYS_ABILITY_ALLOWED, true);
            if (!isAllowed) {
                this.localFlowState = 2;
                return this.localFlowState;
            }
            this.localFlowState = this.isConfigSupport(XMC_NET_CELLULAR_SUPPORT, false) ? (this.isConfigSupport(XMC_NET_CELLULAR_ENABLE, false) ? ((flowExpired = Long.parseLong((value = this.getConfig(XMC_NET_CELLULAR_EXPIRATIONTIME, "0")).toString())) <= 0L || flowExpired - System.currentTimeMillis() / 1000L > 0L ? ((flowUsed = SysDevAbilityInfoBean.getUsedFlow(this)) < (flowTotal = SysDevAbilityInfoBean.getTotalFlow(this)) ? 1 : 4) : 2) : 3) : 0;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.localFlowState;
    }

    public static float getUsedFlow(SysDevAbilityInfoBean sysDevAbilityInfoBean) {
        float flowUsed = 0.0f;
        Object used = sysDevAbilityInfoBean.getConfig(XMC_NET_CELLULAR_USED, 0);
        if (used instanceof String && !StringUtils.isStringNULL((String)used)) {
            try {
                flowUsed = Float.parseFloat((String)used);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return flowUsed;
    }

    public static float getTotalFlow(SysDevAbilityInfoBean sysDevAbilityInfoBean) {
        float flowTotal = 0.0f;
        Object total = sysDevAbilityInfoBean.getConfig(XMC_NET_CELLULAR_STORAGESPACE, 0);
        if (total instanceof String && !StringUtils.isStringNULL((String)total)) {
            try {
                flowTotal = Float.parseFloat((String)total);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return flowTotal;
    }

    public static float getUsedFlow(Map<String, Object> isSupports) {
        Object used;
        float flowUsed = 0.0f;
        if (isSupports.containsKey(XMC_NET_CELLULAR_USED) && (used = isSupports.get(XMC_NET_CELLULAR_USED)) instanceof String && !StringUtils.isStringNULL((String)used)) {
            try {
                flowUsed = Float.parseFloat((String)used);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return flowUsed;
    }

    public static float getTotalFlow(Map<String, Object> isSupports) {
        Object total;
        float flowTotal = 0.0f;
        if (isSupports.containsKey(XMC_NET_CELLULAR_STORAGESPACE) && (total = isSupports.get(XMC_NET_CELLULAR_STORAGESPACE)) instanceof String && !StringUtils.isStringNULL((String)total)) {
            try {
                flowTotal = Float.parseFloat((String)total);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return flowTotal;
    }
}

