/*
 * Decompiled with CFR 0.152.
 */
package com.inuker.bluetooth.library.receiver;

import android.content.Context;
import android.content.Intent;
import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import com.inuker.bluetooth.library.BluetoothContext;
import com.inuker.bluetooth.library.receiver.IReceiverDispatcher;
import com.inuker.bluetooth.library.receiver.listener.BluetoothReceiverListener;
import com.inuker.bluetooth.library.utils.ListUtils;
import java.util.Collections;
import java.util.List;

public abstract class AbsBluetoothReceiver {
    protected Context mContext;
    protected Handler mHandler;
    protected IReceiverDispatcher mDispatcher;

    protected AbsBluetoothReceiver(IReceiverDispatcher dispatcher) {
        this.mDispatcher = dispatcher;
        this.mContext = BluetoothContext.get();
        this.mHandler = new Handler(Looper.getMainLooper());
    }

    boolean containsAction(String action) {
        List<String> actions = this.getActions();
        if (!ListUtils.isEmpty(actions) && !TextUtils.isEmpty((CharSequence)action)) {
            return actions.contains(action);
        }
        return false;
    }

    protected List<BluetoothReceiverListener> getListeners(Class<?> clazz) {
        List listeners = this.mDispatcher.getListeners(clazz);
        return listeners != null ? listeners : Collections.EMPTY_LIST;
    }

    abstract List<String> getActions();

    abstract boolean onReceive(Context var1, Intent var2);
}

