/*
 * Decompiled with CFR 0.152.
 */
package com.inuker.bluetooth.library.model;

import android.bluetooth.BluetoothGattCharacteristic;
import android.os.Parcel;
import android.os.ParcelUuid;
import android.os.Parcelable;
import com.inuker.bluetooth.library.model.BleGattCharacter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public class BleGattService
implements Parcelable,
Comparable {
    private ParcelUuid uuid;
    private List<BleGattCharacter> characters;
    public static final Parcelable.Creator<BleGattService> CREATOR = new Parcelable.Creator<BleGattService>(){

        public BleGattService createFromParcel(Parcel in) {
            return new BleGattService(in);
        }

        public BleGattService[] newArray(int size) {
            return new BleGattService[size];
        }
    };

    public BleGattService(UUID uuid, Map<UUID, BluetoothGattCharacteristic> characters) {
        this.uuid = new ParcelUuid(uuid);
        for (BluetoothGattCharacteristic characteristic : characters.values()) {
            this.getCharacters().add(new BleGattCharacter(characteristic));
        }
    }

    protected BleGattService(Parcel in) {
        this.uuid = (ParcelUuid)in.readParcelable(ParcelUuid.class.getClassLoader());
        this.characters = in.createTypedArrayList(BleGattCharacter.CREATOR);
    }

    public UUID getUUID() {
        return this.uuid.getUuid();
    }

    public List<BleGattCharacter> getCharacters() {
        if (this.characters == null) {
            this.characters = new ArrayList<BleGattCharacter>();
        }
        return this.characters;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("Service: %s\n", this.uuid));
        List<BleGattCharacter> characters = this.getCharacters();
        int size = characters.size();
        for (int i = 0; i < size; ++i) {
            sb.append(String.format(">>> Character: %s", characters.get(i)));
            if (i == size - 1) continue;
            sb.append("\n");
        }
        return sb.toString();
    }

    public int compareTo(Object another) {
        if (another == null) {
            return 1;
        }
        BleGattService anotherService = (BleGattService)another;
        return this.getUUID().compareTo(anotherService.getUUID());
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeParcelable((Parcelable)this.uuid, flags);
        dest.writeTypedList(this.characters);
    }
}

