/*
 * Decompiled with CFR 0.152.
 */
package tp.xmaihh.serialport.stick;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.List;
import tp.xmaihh.serialport.stick.AbsStickPackageHelper;

public class VariableLenStickPackageHelper
implements AbsStickPackageHelper {
    private int offset = 0;
    private int lenIndex = 0;
    private int lenSize = 2;
    private ByteOrder byteOrder = ByteOrder.BIG_ENDIAN;
    private List<Byte> mBytes;
    private int lenStartIndex;
    private int lenEndIndex;

    public VariableLenStickPackageHelper(ByteOrder byteOrder, int lenSize, int lenIndex, int offset) {
        this.byteOrder = byteOrder;
        this.lenSize = lenSize;
        this.offset = offset;
        this.lenIndex = lenIndex;
        this.mBytes = new ArrayList<Byte>();
        this.lenStartIndex = lenIndex;
        this.lenEndIndex = lenIndex + lenSize - 1;
        if (this.lenStartIndex > this.lenEndIndex) {
            throw new IllegalStateException("lenStartIndex>lenEndIndex");
        }
    }

    private int getLen(byte[] src, ByteOrder order) {
        int re = 0;
        if (order == ByteOrder.BIG_ENDIAN) {
            for (byte b : src) {
                re = re << 8 | b & 0xFF;
            }
        } else {
            for (int i = src.length - 1; i >= 0; --i) {
                re = re << 8 | src[i] & 0xFF;
            }
        }
        return re;
    }

    @Override
    public byte[] execute(InputStream is) {
        this.mBytes.clear();
        int count = 0;
        int len = -1;
        int msgLen = -1;
        byte[] lenField = new byte[this.lenSize];
        try {
            while ((len = is.read()) != -1) {
                byte temp = (byte)len;
                if (count >= this.lenStartIndex && count <= this.lenEndIndex) {
                    lenField[count - this.lenStartIndex] = temp;
                    if (count == this.lenEndIndex) {
                        msgLen = this.getLen(lenField, this.byteOrder);
                    }
                }
                ++count;
                this.mBytes.add(temp);
                if (msgLen == -1) continue;
                if (count == msgLen + this.offset) break;
                if (count <= msgLen + this.offset) continue;
                len = -1;
                break;
            }
            if (len == -1) {
                return null;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        byte[] result = new byte[this.mBytes.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = this.mBytes.get(i);
        }
        return result;
    }
}

