/*
 * Decompiled with CFR 0.152.
 */
package tp.xmaihh.serialport.stick;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import tp.xmaihh.serialport.stick.AbsStickPackageHelper;

public class SpecifiedStickPackageHelper
implements AbsStickPackageHelper {
    private byte[] head;
    private byte[] tail;
    private List<Byte> bytes;
    private int headLen;
    private int tailLen;

    public SpecifiedStickPackageHelper(byte[] head, byte[] tail) {
        this.head = head;
        this.tail = tail;
        if (head == null || tail == null) {
            throw new IllegalStateException(" head or tail ==null");
        }
        if (head.length == 0 && tail.length == 0) {
            throw new IllegalStateException(" head and tail length==0");
        }
        this.headLen = head.length;
        this.tailLen = tail.length;
        this.bytes = new ArrayList<Byte>();
    }

    private boolean endWith(Byte[] src, byte[] target) {
        if (src.length < target.length) {
            return false;
        }
        for (int i = 0; i < target.length; ++i) {
            if (target[target.length - i - 1] == src[src.length - i - 1]) continue;
            return false;
        }
        return true;
    }

    private byte[] getRangeBytes(List<Byte> list, int start, int end) {
        Byte[] temps = Arrays.copyOfRange(list.toArray(new Byte[0]), start, end);
        byte[] result = new byte[temps.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = temps[i];
        }
        return result;
    }

    @Override
    public byte[] execute(InputStream is) {
        this.bytes.clear();
        int len = -1;
        int startIndex = -1;
        byte[] result = null;
        boolean isFindStart = false;
        boolean isFindEnd = false;
        try {
            while ((len = is.read()) != -1) {
                byte temp = (byte)len;
                this.bytes.add(temp);
                Byte[] byteArray = this.bytes.toArray(new Byte[0]);
                if (this.headLen == 0 || this.tailLen == 0) {
                    if (!this.endWith(byteArray, this.head) && !this.endWith(byteArray, this.tail)) continue;
                    if (startIndex == -1) {
                        startIndex = this.bytes.size() - this.headLen;
                        continue;
                    }
                    result = this.getRangeBytes(this.bytes, startIndex, this.bytes.size());
                    break;
                }
                if (!isFindStart) {
                    if (!this.endWith(byteArray, this.head)) continue;
                    startIndex = this.bytes.size() - this.headLen;
                    isFindStart = true;
                    continue;
                }
                if (isFindEnd || !this.endWith(byteArray, this.tail) || startIndex + this.headLen > this.bytes.size() - this.tailLen) continue;
                isFindEnd = true;
                result = this.getRangeBytes(this.bytes, startIndex, this.bytes.size());
                break;
            }
            if (len == -1) {
                return null;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        return result;
    }
}

