/*
 * Decompiled with CFR 0.152.
 */
package com.hujiang.gradle.plugin.android.aspectjx;

import com.android.build.api.transform.QualifiedContent;
import com.android.build.api.transform.Transform;
import com.android.build.api.transform.TransformInvocation;
import com.android.build.gradle.LibraryPlugin;
import com.android.build.gradle.api.BaseVariant;
import com.android.build.gradle.internal.pipeline.TransformManager;
import com.hujiang.gradle.plugin.android.aspectjx.AJXExtension;
import com.hujiang.gradle.plugin.android.aspectjx.AndroidConfig;
import com.hujiang.gradle.plugin.android.aspectjx.LoggerHolder;
import com.hujiang.gradle.plugin.android.aspectjx.compat.AgpApiCompat;
import com.hujiang.gradle.plugin.android.aspectjx.internal.procedure.AbsProcedure;
import com.hujiang.gradle.plugin.android.aspectjx.internal.procedure.DoAspectProcedure;
import com.hujiang.gradle.plugin.android.aspectjx.internal.procedure.PrepareProcedure;
import com.hujiang.gradle.plugin.android.aspectjx.internal.procedure.ProcedureChain;
import com.hujiang.gradle.plugin.android.aspectjx.internal.procedure.ProcedureContext;
import com.hujiang.gradle.plugin.android.aspectjx.internal.utils.AJXUtils;
import java.io.File;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.aspectj.org.eclipse.jdt.internal.compiler.batch.ClasspathJar;
import org.gradle.api.Project;
import org.gradle.api.logging.Logger;
import org.gradle.api.tasks.compile.JavaCompile;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u0000 %2\u00020\u0001:\u0001%B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u000e\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0016J\u0010\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\b\u0010\u0017\u001a\u00020\u000bH\u0016J\u0014\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00190\nH\u0016J\u0010\u0010\u001a\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u001c0\u001bH\u0016J\u0010\u0010\u001d\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u001c0\u001bH\u0016J\b\u0010\u001e\u001a\u00020\bH\u0016J\u0018\u0010\u001f\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010 \u001a\u00020\u000bH\u0002J\u0010\u0010!\u001a\u00020\u000e2\u0006\u0010\"\u001a\u00020\u0006H\u0002J\u0010\u0010#\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0010\u0010$\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u0016H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lcom/hujiang/gradle/plugin/android/aspectjx/AJXTransform;", "Lcom/android/build/api/transform/Transform;", "project", "Lorg/gradle/api/Project;", "(Lorg/gradle/api/Project;)V", "ajxExtension", "Lcom/hujiang/gradle/plugin/android/aspectjx/AJXExtension;", "isLibrary", "", "variantCompileOptions", "", "", "Lcom/hujiang/gradle/plugin/android/aspectjx/internal/procedure/ProcedureContext$CompileOptions;", "createVariantCompileOptions", "", "androidConfig", "Lcom/hujiang/gradle/plugin/android/aspectjx/AndroidConfig;", "getInputTypes", "", "Lcom/android/build/api/transform/QualifiedContent$ContentType;", "getLogPrefix", "transformInvocation", "Lcom/android/build/api/transform/TransformInvocation;", "getName", "getParameterInputs", "", "getReferencedScopes", "", "Lcom/android/build/api/transform/QualifiedContent$Scope;", "getScopes", "isIncremental", "logQuiet", "msg", "optimizeExtension", "extension", "process", "transform", "Companion", "aspectjx"})
public final class AJXTransform
extends Transform {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean isLibrary;
    @NotNull
    private final Map<String, ProcedureContext.CompileOptions> variantCompileOptions;
    private AJXExtension ajxExtension;
    @NotNull
    public static final String TAG = "ajx";

    public AJXTransform(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.isLibrary = project.getPlugins().hasPlugin(LibraryPlugin.class);
        this.variantCompileOptions = new LinkedHashMap();
        project.afterEvaluate(arg_0 -> AJXTransform._init_$lambda-0(this, project, arg_0));
    }

    private final void optimizeExtension(AJXExtension extension) {
        AJXExtension aJXExtension;
        AJXExtension $this$optimizeExtension_u24lambda_u2d1 = aJXExtension = extension;
        boolean bl = false;
        if ($this$optimizeExtension_u24lambda_u2d1.getExcludes().contains("*") || $this$optimizeExtension_u24lambda_u2d1.getExcludes().contains("**")) {
            $this$optimizeExtension_u24lambda_u2d1.setEnabled(false);
        }
        if (!$this$optimizeExtension_u24lambda_u2d1.getEnabled()) {
            $this$optimizeExtension_u24lambda_u2d1.getIncludes().clear();
            $this$optimizeExtension_u24lambda_u2d1.getExcludes().clear();
            $this$optimizeExtension_u24lambda_u2d1.getAjcArgs().clear();
        } else {
            if ($this$optimizeExtension_u24lambda_u2d1.getIncludes().contains("*") || $this$optimizeExtension_u24lambda_u2d1.getIncludes().contains("**")) {
                $this$optimizeExtension_u24lambda_u2d1.getIncludes().clear();
            }
            CollectionsKt.sort($this$optimizeExtension_u24lambda_u2d1.getIncludes());
            CollectionsKt.sort($this$optimizeExtension_u24lambda_u2d1.getExcludes());
            CollectionsKt.sort($this$optimizeExtension_u24lambda_u2d1.getAjcArgs());
        }
    }

    private final void createVariantCompileOptions(AndroidConfig androidConfig) {
        for (BaseVariant variant : androidConfig.getVariants()) {
            String string;
            String string2;
            Object object = new ProcedureContext.CompileOptions();
            ProcedureContext.CompileOptions $this$createVariantCompileOptions_u24lambda_u2d2 = object;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)variant, (String)"variant");
            JavaCompile javaCompile = AgpApiCompat.INSTANCE.getJavaCompile(variant);
            String string3 = string2 = javaCompile.getOptions().getEncoding();
            if (string3 == null) {
                string = "UTF-8";
            } else {
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"javaCompile.options.encoding ?: \"UTF-8\"");
                string = string2;
            }
            $this$createVariantCompileOptions_u24lambda_u2d2.setEncoding(string);
            String string4 = javaCompile.getSourceCompatibility();
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"javaCompile.sourceCompatibility");
            $this$createVariantCompileOptions_u24lambda_u2d2.setSourceCompatibility(string4);
            String string5 = javaCompile.getTargetCompatibility();
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"javaCompile.targetCompatibility");
            $this$createVariantCompileOptions_u24lambda_u2d2.setTargetCompatibility(string5);
            Iterable iterable = androidConfig.getBootClasspath();
            String string6 = File.pathSeparator;
            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"pathSeparator");
            $this$createVariantCompileOptions_u24lambda_u2d2.setBootClassPath(CollectionsKt.joinToString$default((Iterable)iterable, (CharSequence)string6, null, null, (int)0, null, null, (int)62, null));
            ProcedureContext.CompileOptions compileOptions = object;
            object = this.variantCompileOptions;
            String string7 = variant.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"variant.name");
            object.put(string7, compileOptions);
        }
    }

    @NotNull
    public String getName() {
        return TAG;
    }

    @NotNull
    public Set<QualifiedContent.ContentType> getInputTypes() {
        Set set = TransformManager.CONTENT_CLASS;
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"CONTENT_CLASS");
        return set;
    }

    @NotNull
    public Set<? super QualifiedContent.Scope> getScopes() {
        Set set;
        if (this.isLibrary) {
            Set set2 = TransformManager.PROJECT_ONLY;
            set = set2;
            Intrinsics.checkNotNullExpressionValue((Object)set2, (String)"PROJECT_ONLY");
        } else {
            Set set3 = TransformManager.SCOPE_FULL_PROJECT;
            set = set3;
            Intrinsics.checkNotNullExpressionValue((Object)set3, (String)"SCOPE_FULL_PROJECT");
        }
        return set;
    }

    @NotNull
    public Set<? super QualifiedContent.Scope> getReferencedScopes() {
        Object[] objectArray = new QualifiedContent.Scope[]{QualifiedContent.Scope.PROJECT, QualifiedContent.Scope.SUB_PROJECTS, QualifiedContent.Scope.EXTERNAL_LIBRARIES, QualifiedContent.Scope.PROVIDED_ONLY};
        return SetsKt.mutableSetOf((Object[])objectArray);
    }

    public boolean isIncremental() {
        return true;
    }

    @NotNull
    public Map<String, Object> getParameterInputs() {
        Pair[] pairArray = new Pair[1];
        AJXExtension aJXExtension = this.ajxExtension;
        if (aJXExtension == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"ajxExtension");
            aJXExtension = null;
        }
        String string = AJXUtils.INSTANCE.optToJsonString(aJXExtension);
        Intrinsics.checkNotNull((Object)string);
        pairArray[0] = TuplesKt.to((Object)"AJXExtension", (Object)string);
        return MapsKt.mutableMapOf((Pair[])pairArray);
    }

    public void transform(@NotNull TransformInvocation transformInvocation) {
        Intrinsics.checkNotNullParameter((Object)transformInvocation, (String)"transformInvocation");
        long startTime = System.currentTimeMillis();
        this.logQuiet(transformInvocation, "transform start.[isIncrement=" + transformInvocation.isIncremental() + ']');
        ClasspathJar.closeAllOpenedArchives(this.getLogPrefix(transformInvocation));
        this.process(transformInvocation);
        ClasspathJar.closeAllOpenedArchives(this.getLogPrefix(transformInvocation));
        this.logQuiet(transformInvocation, "transform finish.[" + (System.currentTimeMillis() - startTime) + "ms]");
    }

    private final void process(TransformInvocation transformInvocation) {
        ProcedureContext.CompileOptions compileOptions;
        ProcedureContext.CompileOptions compileOptions2 = compileOptions = this.variantCompileOptions.get(transformInvocation.getContext().getVariantName());
        Intrinsics.checkNotNull((Object)compileOptions2);
        AJXExtension aJXExtension = this.ajxExtension;
        if (aJXExtension == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"ajxExtension");
            aJXExtension = null;
        }
        ProcedureContext procedureContext = new ProcedureContext(transformInvocation, compileOptions2, aJXExtension);
        new ProcedureChain(procedureContext).with((AbsProcedure)new PrepareProcedure(procedureContext)).with((AbsProcedure)new DoAspectProcedure(procedureContext)).doWorkContinuously(transformInvocation);
    }

    private final void logQuiet(TransformInvocation transformInvocation, String msg) {
        LoggerHolder.INSTANCE.getLogger().quiet(this.getLogPrefix(transformInvocation) + msg);
    }

    private final String getLogPrefix(TransformInvocation transformInvocation) {
        return '[' + transformInvocation.getContext().getPath() + "]: ";
    }

    private static final void _init_$lambda-0(AJXTransform this$0, Project $project, Project it) {
        AJXExtension aJXExtension;
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
        AJXExtension aJXExtension2 = (AJXExtension)$project.getExtensions().findByType(AJXExtension.class);
        if (aJXExtension2 == null) {
            aJXExtension2 = new AJXExtension();
        }
        if ((aJXExtension = (this$0.ajxExtension = aJXExtension2)) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"ajxExtension");
            aJXExtension = null;
        }
        this$0.optimizeExtension(aJXExtension);
        Logger logger = LoggerHolder.INSTANCE.getLogger();
        StringBuilder stringBuilder = new StringBuilder().append("[ajx] AJXExtension after optimize:");
        AJXExtension aJXExtension3 = this$0.ajxExtension;
        if (aJXExtension3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"ajxExtension");
            aJXExtension3 = null;
        }
        logger.quiet(stringBuilder.append(aJXExtension3).toString());
        this$0.createVariantCompileOptions(new AndroidConfig($project));
        System.setProperty("aspectj.multithreaded", "true");
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/hujiang/gradle/plugin/android/aspectjx/AJXTransform$Companion;", "", "()V", "TAG", "", "aspectjx"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

