/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.org.eclipse.jdt.internal.compiler.batch;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.aspectj.org.eclipse.jdt.core.compiler.CharOperation;
import org.aspectj.org.eclipse.jdt.internal.compiler.batch.ClasspathLocation;
import org.aspectj.org.eclipse.jdt.internal.compiler.batch.FileSystem;
import org.aspectj.org.eclipse.jdt.internal.compiler.classfmt.ClassFileReader;
import org.aspectj.org.eclipse.jdt.internal.compiler.classfmt.ClassFormatException;
import org.aspectj.org.eclipse.jdt.internal.compiler.classfmt.ExternalAnnotationDecorator;
import org.aspectj.org.eclipse.jdt.internal.compiler.env.AccessRuleSet;
import org.aspectj.org.eclipse.jdt.internal.compiler.env.IBinaryType;
import org.aspectj.org.eclipse.jdt.internal.compiler.env.IModule;
import org.aspectj.org.eclipse.jdt.internal.compiler.env.NameEnvironmentAnswer;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.BinaryTypeBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.util.ManifestAnalyzer;
import org.aspectj.org.eclipse.jdt.internal.compiler.util.Util;

public class ClasspathJar
extends ClasspathLocation {
    private static int maxOpenArchives = 1000;
    private static final int MAXOPEN_DEFAULT = 1000;
    private static List openArchives = new ArrayList();
    protected File file;
    protected ZipFile zipFile;
    protected ZipFile annotationZipFile;
    protected boolean closeZipFileAtEnd;
    protected Set<String> packageCache;
    protected List<String> annotationPaths;

    public ClasspathJar(File file, boolean closeZipFileAtEnd, AccessRuleSet accessRuleSet, String destinationPath) {
        super(accessRuleSet, destinationPath);
        this.file = file;
        this.closeZipFileAtEnd = closeZipFileAtEnd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<FileSystem.Classpath> fetchLinkedJars(FileSystem.ClasspathSectionProblemReporter problemReporter) {
        InputStream inputStream = null;
        try {
            this.initialize();
            ArrayList<FileSystem.Classpath> result = new ArrayList<FileSystem.Classpath>();
            ZipEntry manifest = this.zipFile.getEntry("META-INF/MANIFEST.MF");
            if (manifest != null) {
                inputStream = this.zipFile.getInputStream(manifest);
                ManifestAnalyzer analyzer = new ManifestAnalyzer();
                boolean success = analyzer.analyzeManifestContents(inputStream);
                List calledFileNames = analyzer.getCalledFileNames();
                if (problemReporter != null) {
                    if (!success || analyzer.getClasspathSectionsCount() == 1 && calledFileNames == null) {
                        problemReporter.invalidClasspathSection(this.getPath());
                    } else if (analyzer.getClasspathSectionsCount() > 1) {
                        problemReporter.multipleClasspathSections(this.getPath());
                    }
                }
                if (calledFileNames != null) {
                    Iterator calledFilesIterator = calledFileNames.iterator();
                    String directoryPath = this.getPath();
                    int lastSeparator = directoryPath.lastIndexOf(File.separatorChar);
                    directoryPath = directoryPath.substring(0, lastSeparator + 1);
                    while (calledFilesIterator.hasNext()) {
                        result.add((FileSystem.Classpath)new ClasspathJar(new File(directoryPath + (String)calledFilesIterator.next()), this.closeZipFileAtEnd, this.accessRuleSet, this.destinationPath));
                    }
                }
            }
            ArrayList<FileSystem.Classpath> arrayList = result;
            return arrayList;
        }
        catch (IOException | IllegalArgumentException e) {
            List<FileSystem.Classpath> list = null;
            return list;
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                    this.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public NameEnvironmentAnswer findClass(char[] typeName, String qualifiedPackageName, String moduleName, String qualifiedBinaryFileName) {
        return this.findClass(typeName, qualifiedPackageName, moduleName, qualifiedBinaryFileName, false);
    }

    public NameEnvironmentAnswer findClass(char[] typeName, String qualifiedPackageName, String moduleName, String qualifiedBinaryFileName, boolean asBinaryOnly) {
        block11: {
            if (!this.isPackage(qualifiedPackageName, moduleName)) {
                return null;
            }
            try {
                char[] modName;
                ClassFileReader reader;
                block12: {
                    this.ensureOpen();
                    reader = ClassFileReader.read((ZipFile)this.zipFile, (String)qualifiedBinaryFileName);
                    if (reader == null) break block11;
                    char[] cArray = modName = this.module == null ? null : this.module.name();
                    if (reader instanceof ClassFileReader) {
                        ClassFileReader classReader = reader;
                        if (classReader.moduleName == null) {
                            classReader.moduleName = modName;
                        } else {
                            modName = classReader.moduleName;
                        }
                    }
                    if (this.annotationPaths != null) {
                        String qualifiedClassName = qualifiedBinaryFileName.substring(0, qualifiedBinaryFileName.length() - "CLASS".length() - 1);
                        for (String annotationPath : this.annotationPaths) {
                            try {
                                if (this.annotationZipFile == null) {
                                    this.annotationZipFile = ExternalAnnotationDecorator.getAnnotationZipFile((String)annotationPath, null);
                                }
                                if ((reader = ExternalAnnotationDecorator.create((IBinaryType)reader, (String)annotationPath, (String)qualifiedClassName, (ZipFile)this.annotationZipFile)).getExternalAnnotationStatus() != BinaryTypeBinding.ExternalAnnotationStatus.TYPE_IS_ANNOTATED) continue;
                                break block12;
                            }
                            catch (IOException iOException) {
                            }
                        }
                        reader = new ExternalAnnotationDecorator((IBinaryType)reader, null);
                    }
                }
                return new NameEnvironmentAnswer((IBinaryType)reader, this.fetchAccessRestriction(qualifiedBinaryFileName), modName);
            }
            catch (IOException | ClassFormatException throwable) {
                // empty catch block
            }
        }
        return null;
    }

    public boolean hasAnnotationFileFor(String qualifiedTypeName) {
        return this.zipFile.getEntry(qualifiedTypeName + ".eea") != null;
    }

    public char[][][] findTypeNames(String qualifiedPackageName, String moduleName) {
        if (!this.isPackage(qualifiedPackageName, moduleName)) {
            return null;
        }
        char[] packageArray = qualifiedPackageName.toCharArray();
        ArrayList<char[][]> answers = new ArrayList<char[][]>();
        try {
            this.ensureOpen();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            return null;
        }
        Enumeration<? extends ZipEntry> e = this.zipFile.entries();
        while (e.hasMoreElements()) {
            int indexOfDot;
            String packageName;
            String fileName = e.nextElement().getName();
            int last = fileName.lastIndexOf(47);
            if (last <= 0 || !qualifiedPackageName.equals(packageName = fileName.substring(0, last)) || (indexOfDot = fileName.lastIndexOf(46)) == -1) continue;
            String typeName = fileName.substring(last + 1, indexOfDot);
            answers.add(CharOperation.arrayConcat((char[][])CharOperation.splitOn((char)'/', (char[])packageArray), (char[])typeName.toCharArray()));
        }
        int size = answers.size();
        if (size != 0) {
            char[][][] result = new char[size][][];
            answers.toArray((T[])result);
            return result;
        }
        return null;
    }

    public void initialize() throws IOException {
        this.ensureOpen();
        if (this.zipFile == null) {
            this.zipFile = new ZipFile(this.file);
        }
    }

    void acceptModule(ClassFileReader reader) {
        if (reader != null) {
            this.acceptModule((IModule)reader.getModuleDeclaration());
        }
    }

    void acceptModule(byte[] content) {
        if (content == null) {
            return;
        }
        ClassFileReader reader = null;
        try {
            reader = new ClassFileReader(content, "module-info.class".toCharArray());
        }
        catch (ClassFormatException e) {
            e.printStackTrace();
        }
        if (reader != null && reader.getModuleDeclaration() != null) {
            this.acceptModule(reader);
        }
    }

    protected void addToPackageCache(String fileName, boolean endsWithSep) {
        int last;
        int n = last = endsWithSep ? fileName.length() : fileName.lastIndexOf(47);
        while (last > 0) {
            String packageName = fileName.substring(0, last);
            if (this.packageCache.contains(packageName)) {
                return;
            }
            this.packageCache.add(packageName);
            last = packageName.lastIndexOf(47);
        }
    }

    public synchronized char[][] getModulesDeclaringPackage(String qualifiedPackageName, String moduleName) {
        if (this.packageCache != null) {
            return this.singletonModuleNameIf(this.packageCache.contains(qualifiedPackageName));
        }
        try {
            this.ensureOpen();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            return this.singletonModuleNameIf(false);
        }
        this.packageCache = new HashSet<String>(41);
        this.packageCache.add(Util.EMPTY_STRING);
        Enumeration<? extends ZipEntry> e = this.zipFile.entries();
        while (e.hasMoreElements()) {
            String fileName = e.nextElement().getName();
            this.addToPackageCache(fileName, false);
        }
        return this.singletonModuleNameIf(this.packageCache.contains(qualifiedPackageName));
    }

    public boolean hasCompilationUnit(String qualifiedPackageName, String moduleName) {
        qualifiedPackageName = qualifiedPackageName + '/';
        Enumeration<? extends ZipEntry> e = this.zipFile.entries();
        while (e.hasMoreElements()) {
            String tail;
            String fileName = e.nextElement().getName();
            if (!fileName.startsWith(qualifiedPackageName) || fileName.length() <= qualifiedPackageName.length() || (tail = fileName.substring(qualifiedPackageName.length())).indexOf(47) != -1 || !tail.toLowerCase().endsWith(".class")) continue;
            return true;
        }
        return false;
    }

    public char[][] listPackages() {
        HashSet<String> packageNames = new HashSet<String>();
        Enumeration<? extends ZipEntry> e = this.zipFile.entries();
        while (e.hasMoreElements()) {
            String fileName = e.nextElement().getName();
            int lastSlash = fileName.lastIndexOf(47);
            if (lastSlash == -1 || !fileName.toLowerCase().endsWith(".class")) continue;
            packageNames.add(fileName.substring(0, lastSlash).replace('/', '.'));
        }
        return (char[][])packageNames.stream().map(String::toCharArray).toArray(x$0 -> new char[x$0][]);
    }

    public void reset() {
        super.reset();
        if (this.closeZipFileAtEnd) {
            if (this.zipFile != null) {
                this.close();
            }
            if (this.annotationZipFile != null) {
                try {
                    this.annotationZipFile.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.annotationZipFile = null;
            }
        }
        this.packageCache = null;
        this.annotationPaths = null;
    }

    public String toString() {
        return "Classpath for jar file " + this.file.getPath();
    }

    public char[] normalizedPath() {
        if (this.normalizedPath == null) {
            String path2 = this.getPath();
            char[] rawName = path2.toCharArray();
            if (File.separatorChar == '\\') {
                CharOperation.replace((char[])rawName, (char)'\\', (char)'/');
            }
            this.normalizedPath = CharOperation.subarray((char[])rawName, (int)0, (int)CharOperation.lastIndexOf((char)'.', (char[])rawName));
        }
        return this.normalizedPath;
    }

    public String getPath() {
        if (this.path == null) {
            try {
                this.path = this.file.getCanonicalPath();
            }
            catch (IOException e) {
                this.path = this.file.getAbsolutePath();
            }
        }
        return this.path;
    }

    public int getMode() {
        return 2;
    }

    public IModule getModule() {
        return this.module;
    }

    private void ensureOpen() throws IOException {
        if (this.zipFile != null) {
            return;
        }
        this.zipFile = new ZipFile(this.file);
    }

    private void closeSomeArchives(int n) {
        for (int i = n - 1; i >= 0; --i) {
            ClasspathJar zf = (ClasspathJar)((Object)openArchives.get(0));
            zf.close();
        }
    }

    public void close() {
        if (this.zipFile == null) {
            return;
        }
        this.zipFile = null;
    }

    private static String getSystemPropertyWithoutSecurityException(String aPropertyName, String aDefaultValue) {
        try {
            return System.getProperty(aPropertyName, aDefaultValue);
        }
        catch (SecurityException ex) {
            return aDefaultValue;
        }
    }

    static {
        String openarchivesString = ClasspathJar.getSystemPropertyWithoutSecurityException("org.aspectj.weaver.openarchives", Integer.toString(1000));
        maxOpenArchives = Integer.parseInt(openarchivesString);
        if (maxOpenArchives < 20) {
            maxOpenArchives = 1000;
        }
    }
}

