/*
 * Decompiled with CFR 0.152.
 */
package io.github.wimdeblauwe.errorhandlingspringbootstarter.handler;

import io.github.wimdeblauwe.errorhandlingspringbootstarter.ApiErrorResponse;
import io.github.wimdeblauwe.errorhandlingspringbootstarter.ApiFieldError;
import io.github.wimdeblauwe.errorhandlingspringbootstarter.ApiGlobalError;
import io.github.wimdeblauwe.errorhandlingspringbootstarter.handler.AbstractApiExceptionHandler;
import io.github.wimdeblauwe.errorhandlingspringbootstarter.mapper.ErrorCodeMapper;
import io.github.wimdeblauwe.errorhandlingspringbootstarter.mapper.ErrorMessageMapper;
import io.github.wimdeblauwe.errorhandlingspringbootstarter.mapper.HttpStatusMapper;
import java.util.List;
import java.util.Optional;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.validation.FieldError;
import org.springframework.web.method.annotation.HandlerMethodValidationException;

public class HandlerMethodValidationExceptionHandler
extends AbstractApiExceptionHandler {
    public HandlerMethodValidationExceptionHandler(HttpStatusMapper httpStatusMapper, ErrorCodeMapper errorCodeMapper, ErrorMessageMapper errorMessageMapper) {
        super(httpStatusMapper, errorCodeMapper, errorMessageMapper);
    }

    @Override
    public boolean canHandle(Throwable exception) {
        return exception instanceof HandlerMethodValidationException;
    }

    @Override
    public ApiErrorResponse handle(Throwable ex) {
        ApiErrorResponse response = new ApiErrorResponse((HttpStatusCode)HttpStatus.BAD_REQUEST, this.getErrorCode(ex), this.getErrorMessage(ex));
        HandlerMethodValidationException validationException = (HandlerMethodValidationException)ex;
        List errors = validationException.getAllErrors();
        errors.forEach(error -> {
            if (error instanceof FieldError) {
                FieldError fieldError = (FieldError)error;
                ApiFieldError apiFieldError = new ApiFieldError(this.errorCodeMapper.getErrorCode(fieldError.getCode()), fieldError.getField(), this.errorMessageMapper.getErrorMessage(fieldError.getCode(), fieldError.getDefaultMessage()), fieldError.getRejectedValue(), null);
                response.addFieldError(apiFieldError);
            } else {
                String lastCode = Optional.ofNullable(error.getCodes()).filter(codes -> ((String[])codes).length > 0).map(codes -> codes[((String[])codes).length - 1]).orElse(null);
                ApiGlobalError apiGlobalErrorMessage = new ApiGlobalError(this.errorCodeMapper.getErrorCode(lastCode), this.errorMessageMapper.getErrorMessage(lastCode, error.getDefaultMessage()));
                response.addGlobalError(apiGlobalErrorMessage);
            }
        });
        return response;
    }
}

