/*
 * Decompiled with CFR 0.152.
 */
package io.github.wimdeblauwe.errorhandlingspringbootstarter;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.github.wimdeblauwe.errorhandlingspringbootstarter.ApiErrorResponse;
import io.github.wimdeblauwe.errorhandlingspringbootstarter.mapper.ErrorCodeMapper;
import io.github.wimdeblauwe.errorhandlingspringbootstarter.mapper.ErrorMessageMapper;
import io.github.wimdeblauwe.errorhandlingspringbootstarter.mapper.HttpStatusMapper;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.web.AuthenticationEntryPoint;

public class UnauthorizedEntryPoint
implements AuthenticationEntryPoint {
    protected final HttpStatusMapper httpStatusMapper;
    protected final ErrorCodeMapper errorCodeMapper;
    protected final ErrorMessageMapper errorMessageMapper;
    protected final ObjectMapper objectMapper;

    public UnauthorizedEntryPoint(HttpStatusMapper httpStatusMapper, ErrorCodeMapper errorCodeMapper, ErrorMessageMapper errorMessageMapper, ObjectMapper objectMapper) {
        this.httpStatusMapper = httpStatusMapper;
        this.errorCodeMapper = errorCodeMapper;
        this.errorMessageMapper = errorMessageMapper;
        this.objectMapper = objectMapper;
    }

    public void commence(HttpServletRequest request, HttpServletResponse response, AuthenticationException authException) throws JsonProcessingException, IOException {
        ApiErrorResponse errorResponse = this.createResponse(authException);
        response.setStatus(errorResponse.getHttpStatus().value());
        response.getWriter().write(this.objectMapper.writeValueAsString((Object)errorResponse));
    }

    public ApiErrorResponse createResponse(AuthenticationException exception) {
        HttpStatusCode httpStatus = this.httpStatusMapper.getHttpStatus((Throwable)exception, HttpStatus.UNAUTHORIZED);
        String code = this.errorCodeMapper.getErrorCode((Throwable)exception);
        String message = this.errorMessageMapper.getErrorMessage((Throwable)exception);
        return new ApiErrorResponse(httpStatus, code, message);
    }
}

