/*
 * Decompiled with CFR 0.152.
 */
package io.github.wimdeblauwe.errorhandlingspringbootstarter;

import io.github.wimdeblauwe.errorhandlingspringbootstarter.ApiErrorResponse;
import io.github.wimdeblauwe.errorhandlingspringbootstarter.ErrorHandlingProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.logging.LogLevel;
import org.springframework.http.HttpStatusCode;

public class LoggingService {
    private static final Logger LOGGER = LoggerFactory.getLogger(LoggingService.class);
    private final ErrorHandlingProperties properties;

    public LoggingService(ErrorHandlingProperties properties) {
        this.properties = properties;
    }

    public void logException(ApiErrorResponse errorResponse, Throwable exception) {
        HttpStatusCode httpStatus = errorResponse.getHttpStatus();
        if (this.properties.getFullStacktraceClasses().contains(exception.getClass())) {
            this.logAccordingToRequestedLogLevel(httpStatus, exception, true);
        } else if (!this.properties.getFullStacktraceHttpStatuses().isEmpty()) {
            boolean alreadyLogged = this.logFullStacktraceIfNeeded(httpStatus, exception);
            if (!alreadyLogged) {
                this.doStandardFallbackLogging(httpStatus, exception);
            }
        } else {
            this.doStandardFallbackLogging(httpStatus, exception);
        }
    }

    private void logAccordingToRequestedLogLevel(HttpStatusCode httpStatus, Throwable exception, boolean includeStacktrace) {
        String httpStatusValue = String.valueOf(httpStatus.value());
        if (this.properties.getLogLevels().get(httpStatusValue) != null) {
            this.doLogOnLogLevel(this.properties.getLogLevels().get(httpStatusValue), exception, includeStacktrace);
        } else if (this.properties.getLogLevels().get(LoggingService.getStatusWithLastNumberAsWildcard(httpStatusValue)) != null) {
            this.doLogOnLogLevel(this.properties.getLogLevels().get(LoggingService.getStatusWithLastNumberAsWildcard(httpStatusValue)), exception, includeStacktrace);
        } else if (this.properties.getLogLevels().get(LoggingService.getStatusWithLastTwoNumbersAsWildcard(httpStatusValue)) != null) {
            this.doLogOnLogLevel(this.properties.getLogLevels().get(LoggingService.getStatusWithLastTwoNumbersAsWildcard(httpStatusValue)), exception, includeStacktrace);
        } else {
            LOGGER.error(exception.getMessage(), exception);
        }
    }

    private void doLogOnLogLevel(LogLevel logLevel, Throwable exception, boolean includeStacktrace) {
        if (includeStacktrace) {
            switch (logLevel) {
                case TRACE: {
                    LOGGER.trace(exception.getMessage(), exception);
                    break;
                }
                case DEBUG: {
                    LOGGER.debug(exception.getMessage(), exception);
                    break;
                }
                case INFO: {
                    LOGGER.info(exception.getMessage(), exception);
                    break;
                }
                case WARN: {
                    LOGGER.warn(exception.getMessage(), exception);
                    break;
                }
                case ERROR: 
                case FATAL: {
                    LOGGER.error(exception.getMessage(), exception);
                    break;
                }
            }
        } else {
            switch (logLevel) {
                case TRACE: {
                    LOGGER.trace(exception.getMessage());
                    break;
                }
                case DEBUG: {
                    LOGGER.debug(exception.getMessage());
                    break;
                }
                case INFO: {
                    LOGGER.info(exception.getMessage());
                    break;
                }
                case WARN: {
                    LOGGER.warn(exception.getMessage());
                    break;
                }
                case ERROR: 
                case FATAL: {
                    LOGGER.error(exception.getMessage());
                    break;
                }
            }
        }
    }

    private void doStandardFallbackLogging(HttpStatusCode httpStatus, Throwable exception) {
        switch (this.properties.getExceptionLogging()) {
            case WITH_STACKTRACE: {
                this.logAccordingToRequestedLogLevel(httpStatus, exception, true);
                break;
            }
            case MESSAGE_ONLY: {
                this.logAccordingToRequestedLogLevel(httpStatus, exception, false);
            }
        }
    }

    private boolean logFullStacktraceIfNeeded(HttpStatusCode httpStatus, Throwable exception) {
        String httpStatusValue = String.valueOf(httpStatus.value());
        if (this.properties.getFullStacktraceHttpStatuses().contains(httpStatusValue)) {
            this.logAccordingToRequestedLogLevel(httpStatus, exception, true);
            return true;
        }
        if (this.properties.getFullStacktraceHttpStatuses().contains(LoggingService.getStatusWithLastNumberAsWildcard(httpStatusValue))) {
            this.logAccordingToRequestedLogLevel(httpStatus, exception, true);
            return true;
        }
        if (this.properties.getFullStacktraceHttpStatuses().contains(LoggingService.getStatusWithLastTwoNumbersAsWildcard(httpStatusValue))) {
            this.logAccordingToRequestedLogLevel(httpStatus, exception, true);
            return true;
        }
        return false;
    }

    private static String getStatusWithLastTwoNumbersAsWildcard(String httpStatusValue) {
        return httpStatusValue.replaceFirst("\\d\\d$", "xx");
    }

    private static String getStatusWithLastNumberAsWildcard(String httpStatusValue) {
        return httpStatusValue.replaceFirst("\\d$", "x");
    }
}

