/*
 * Decompiled with CFR 0.152.
 */
package com.watayouxiang.wallet.widget;

import android.content.Context;
import android.graphics.Color;
import android.os.Bundle;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.databinding.ObservableField;
import com.watayouxiang.androidutils.utils.ClickUtils;
import com.watayouxiang.androidutils.widget.dialog2.BaseBindingDialog;
import com.watayouxiang.androidutils.widget.dialog2.BaseDialog;
import com.watayouxiang.wallet.R;
import com.watayouxiang.wallet.databinding.WalletRedpaperDialogBinding;
import com.watayouxiang.wallet.feature.paperdetail.PaperDetailActivity;
import com.watayouxiang.wallet.widget.RedPaperVo;
import java.util.Locale;

public class RedPaperDialog
extends BaseBindingDialog<WalletRedpaperDialogBinding> {
    public final ObservableField<String> fromInfo = new ObservableField((Object)"\u5c0f\u751f\u7684\u7ea2\u5305");
    public final ObservableField<String> gift = new ObservableField((Object)"\u606d\u559c\u53d1\u8d22\uff0c\u5927\u5409\u5927\u5229");
    public final ObservableField<Boolean> showDetail = new ObservableField((Object)true);
    private final RedPaperVo redPaperVo;
    private OnRedPaperListener onRedPaperListener;

    public RedPaperDialog(@NonNull Context context, RedPaperVo redPaperVo) {
        super(context);
        this.redPaperVo = redPaperVo;
    }

    @NonNull
    public BaseDialog.Builder getBuilder() {
        return super.getBuilder().setAnimationsResId(Integer.valueOf(R.style.tio_dialog_anim));
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        ((WalletRedpaperDialogBinding)this.binding).setView(this);
        if (this.redPaperVo == null) {
            return;
        }
        ((WalletRedpaperDialogBinding)this.binding).ivAvatar.loadUrlStatic_asCircle_border(this.redPaperVo.avatar, Color.parseColor((String)"#FFF9AD55"), 1.0f);
        this.fromInfo.set((Object)String.format(Locale.getDefault(), "%s\u7684\u7ea2\u5305", this.redPaperVo.name));
        this.gift.set((Object)this.redPaperVo.gift);
        this.showDetail.set((Object)this.redPaperVo.isSendMsg);
    }

    public int getLayoutId() {
        return R.layout.wallet_redpaper_dialog;
    }

    public void clickOpen(View v) {
        if (ClickUtils.isViewSingleClick((View)v) && this.onRedPaperListener != null) {
            this.onRedPaperListener.onReceiveRedPaper();
        }
    }

    public void clickCancel(View v) {
        this.dismiss();
    }

    public void clickShowDetail(View v) {
        if (ClickUtils.isViewSingleClick((View)v)) {
            if (this.redPaperVo != null) {
                PaperDetailActivity.start(v.getContext(), this.redPaperVo.serialNumber);
            }
            this.dismiss();
        }
    }

    public void setOnRedPaperListener(OnRedPaperListener l) {
        this.onRedPaperListener = l;
    }

    public static interface OnRedPaperListener {
        public void onReceiveRedPaper();
    }
}

