/*
 * Decompiled with CFR 0.152.
 */
package com.watayouxiang.wallet.feature.withdraw_result;

import androidx.lifecycle.ViewModel;
import com.watayouxiang.androidutils.widget.TioToast;
import com.watayouxiang.httpclient.TioHttpClient;
import com.watayouxiang.httpclient.callback.TioCallback;
import com.watayouxiang.httpclient.model.request.PayWithholdQueryReq;
import com.watayouxiang.httpclient.model.response.PayWithholdQueryResp;
import com.watayouxiang.httpclient.preferences.HttpCache;
import com.watayouxiang.wallet.feature.withdraw_result.WithdrawFragment;
import com.watayouxiang.wallet.feature.withdraw_result.WithdrawResult;
import com.watayouxiang.wallet.feature.withdraw_result.WithdrawResultActivity;
import com.watayouxiang.wallet.tools.MoneyUtils;
import java.math.BigDecimal;
import java.util.Locale;

public class WithdrawResultViewModel
extends ViewModel {
    private WithdrawResult withdrawResult;

    public void getWithholdQuery(String serialNumber, final WithdrawResultActivity activity) {
        PayWithholdQueryReq withholdQueryReq = new PayWithholdQueryReq(serialNumber);
        withholdQueryReq.setCancelTag((Object)this);
        withholdQueryReq.get((TioCallback)new TioCallback<PayWithholdQueryResp>(){

            public void onTioSuccess(PayWithholdQueryResp resp) {
                WithdrawResultViewModel.this.processWithholdQuery(resp, activity);
            }

            public void onTioError(String msg) {
                TioToast.showShort((CharSequence)msg);
            }
        });
    }

    private void processWithholdQuery(PayWithholdQueryResp resp, WithdrawResultActivity activity) {
        String amount = MoneyUtils.fen2yuan(resp.getArrivalAmount());
        String fee = MoneyUtils.fen2yuan(new BigDecimal(resp.getAmount()).subtract(new BigDecimal(resp.getArrivalAmount())));
        String bankIcon = HttpCache.getResUrl((String)resp.getBankicon());
        String bankInfo = String.format(Locale.getDefault(), "%s(%s)", resp.getBankname(), this.getBankCardNo(resp.getBankcardnumber()));
        this.withdrawResult = new WithdrawResult(amount, bankInfo, bankIcon, fee);
        WithdrawFragment fragment = new WithdrawFragment();
        activity.replaceFragment(fragment);
    }

    private String getBankCardNo(String bankcardnumber) {
        if (bankcardnumber != null && bankcardnumber.length() >= 4) {
            return bankcardnumber.substring(bankcardnumber.length() - 4);
        }
        return "";
    }

    protected void onCleared() {
        super.onCleared();
        TioHttpClient.cancel((Object)((Object)this));
    }

    public WithdrawResult getWithdrawResult() {
        return this.withdrawResult;
    }
}

