/*
 * Decompiled with CFR 0.152.
 */
package com.watayouxiang.wallet.feature.withdraw_record.mvp;

import com.blankj.utilcode.util.StringUtils;
import com.watayouxiang.androidutils.widget.TioToast;
import com.watayouxiang.httpclient.callback.TioCallback;
import com.watayouxiang.httpclient.model.request.PayWithholdListReq;
import com.watayouxiang.httpclient.model.response.PayWithholdListResp;
import com.watayouxiang.wallet.feature.withdraw_record.adapter.ListModel;
import com.watayouxiang.wallet.feature.withdraw_record.adapter.NormalItem;
import com.watayouxiang.wallet.feature.withdraw_record.mvp.Contract;
import com.watayouxiang.wallet.feature.withdraw_record.mvp.Model;
import com.watayouxiang.wallet.tools.MoneyUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public class Presenter
extends Contract.Presenter {
    private int pageNumber;

    public Presenter(Contract.View view) {
        super(new Model(), view, false);
    }

    @Override
    public void init() {
        ((Contract.View)this.getView()).resetUI();
        this.refreshData();
    }

    @Override
    public void refreshData() {
        this.getWithholdList(1);
    }

    @Override
    public void loadMoreData() {
        this.getWithholdList(++this.pageNumber);
    }

    private void getWithholdList(final int pageNumber) {
        this.pageNumber = pageNumber;
        PayWithholdListReq withholdListReq = new PayWithholdListReq(pageNumber + "");
        withholdListReq.setCancelTag((Object)this);
        withholdListReq.get((TioCallback)new TioCallback<PayWithholdListResp>(){

            public void onTioSuccess(PayWithholdListResp resp) {
                List list = resp.getList();
                boolean firstPage = resp.isFirstPage();
                boolean lastPage = resp.isLastPage();
                ArrayList models = Presenter.this.getModels(list);
                if (firstPage) {
                    ((Contract.View)Presenter.this.getView()).setRefreshData(true, models);
                    if (lastPage) {
                        ((Contract.View)Presenter.this.getView()).setLoadMoreData(true, true, null);
                    }
                } else {
                    ((Contract.View)Presenter.this.getView()).setLoadMoreData(true, lastPage, models);
                }
            }

            public void onTioError(String msg) {
                TioToast.showShort((CharSequence)msg);
                if (pageNumber <= 1) {
                    ((Contract.View)Presenter.this.getView()).setRefreshData(false, null);
                } else {
                    ((Contract.View)Presenter.this.getView()).setLoadMoreData(false, false, null);
                }
            }
        });
    }

    private ArrayList<ListModel> getModels(List<PayWithholdListResp.ListBean> list) {
        if (list == null) {
            list = new ArrayList<PayWithholdListResp.ListBean>();
        }
        int size = list.size();
        ArrayList<ListModel> models = new ArrayList<ListModel>();
        for (int i = 0; i < size; ++i) {
            PayWithholdListResp.ListBean bean = list.get(i);
            NormalItem item = new NormalItem();
            item.setTitleTxt(String.format(Locale.getDefault(), "\u63d0\u73b0 \u5230%s\uff08%s\uff09", bean.getBankname(), this.getBankCardNo(bean.getBankcardnumber())));
            item.setSubtitleTxt(StringUtils.null2Length0((String)bean.getBizcreattime()));
            item.setMoney(MoneyUtils.fen2yuan(bean.getArrivalamount() + ""));
            item.setStatus(bean.getStatus());
            models.add(new ListModel(item, bean));
        }
        return models;
    }

    private String getBankCardNo(String bankcardnumber) {
        if (bankcardnumber != null && bankcardnumber.length() >= 4) {
            return bankcardnumber.substring(bankcardnumber.length() - 4);
        }
        return "";
    }
}

