/*
 * Decompiled with CFR 0.152.
 */
package com.watayouxiang.wallet.feature.withdraw_record;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.blankj.utilcode.util.CollectionUtils;
import com.watayouxiang.androidutils.page.BindingLightActivity;
import com.watayouxiang.androidutils.utils.ClickUtils;
import com.watayouxiang.httpclient.model.response.PayWithholdListResp;
import com.watayouxiang.wallet.R;
import com.watayouxiang.wallet.databinding.WalletWithdrawRecordActivityBinding;
import com.watayouxiang.wallet.feature.withdraw_detail.WithdrawDetailActivity;
import com.watayouxiang.wallet.feature.withdraw_detail.WithdrawDetailVo;
import com.watayouxiang.wallet.feature.withdraw_record.adapter.ListAdapter;
import com.watayouxiang.wallet.feature.withdraw_record.adapter.ListModel;
import com.watayouxiang.wallet.feature.withdraw_record.mvp.Contract;
import com.watayouxiang.wallet.feature.withdraw_record.mvp.Presenter;
import java.util.List;

public class WithdrawRecordActivity
extends BindingLightActivity<WalletWithdrawRecordActivityBinding>
implements Contract.View {
    private Presenter presenter;
    private ListAdapter listAdapter;

    public static void start(Context context) {
        Intent starter = new Intent(context, WithdrawRecordActivity.class);
        context.startActivity(starter);
    }

    protected Integer background_color() {
        return -1;
    }

    @NonNull
    protected View statusBar_holder() {
        return ((WalletWithdrawRecordActivityBinding)this.binding).statusBar;
    }

    protected int getContentViewId() {
        return R.layout.wallet_withdraw_record_activity;
    }

    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        ((WalletWithdrawRecordActivityBinding)this.binding).setData(this);
        this.presenter = new Presenter(this);
        this.presenter.init();
    }

    protected void onDestroy() {
        super.onDestroy();
        this.presenter.detachView();
    }

    @Override
    public void resetUI() {
        ((WalletWithdrawRecordActivityBinding)this.binding).recyclerView.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager((Context)this));
        this.listAdapter = new ListAdapter(null);
        this.listAdapter.setOnLoadMoreListener(() -> this.presenter.loadMoreData(), ((WalletWithdrawRecordActivityBinding)this.binding).recyclerView);
        this.listAdapter.setOnItemClickListener((adapter, view, position) -> {
            PayWithholdListResp.ListBean original = ((ListModel)this.listAdapter.getData().get(position)).getOriginal();
            if (ClickUtils.isViewSingleClick((View)view)) {
                WithdrawDetailVo vo = WithdrawDetailVo.getInstance(original);
                WithdrawDetailActivity.start((Context)this.getActivity(), vo);
            }
        });
        ((WalletWithdrawRecordActivityBinding)this.binding).recyclerView.setAdapter((RecyclerView.Adapter)this.listAdapter);
        ((WalletWithdrawRecordActivityBinding)this.binding).swipeRefreshLayout.setOnRefreshListener(() -> this.presenter.refreshData());
    }

    @Override
    public void setRefreshData(boolean ok, List<ListModel> models) {
        if (ok) {
            this.listAdapter.setNewData(models);
            if (CollectionUtils.isEmpty(models)) {
                View notDataView = this.getLayoutInflater().inflate(R.layout.wallet_withdraw_record_list_empty, (ViewGroup)((WalletWithdrawRecordActivityBinding)this.binding).recyclerView.getParent(), false);
                this.listAdapter.setEmptyView(notDataView);
            }
        }
        ((WalletWithdrawRecordActivityBinding)this.binding).swipeRefreshLayout.setRefreshing(false);
    }

    @Override
    public void setLoadMoreData(boolean ok, boolean lastPage, List<ListModel> models) {
        if (ok) {
            if (models != null) {
                this.listAdapter.addData(models);
            }
            if (lastPage) {
                this.listAdapter.loadMoreEnd();
            } else {
                this.listAdapter.loadMoreComplete();
            }
        } else {
            this.listAdapter.loadMoreFail();
        }
    }
}

