/*
 * Decompiled with CFR 0.152.
 */
package com.watayouxiang.wallet.feature.withdraw_detail;

import android.graphics.Color;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.databinding.ObservableField;
import com.watayouxiang.androidutils.page.TioFragment;
import com.watayouxiang.httpclient.model.vo.WithholdStatus;
import com.watayouxiang.wallet.R;
import com.watayouxiang.wallet.databinding.WalletWithdrawDetailFragmentBinding;
import com.watayouxiang.wallet.feature.withdraw_detail.WithdrawDetailActivity;
import com.watayouxiang.wallet.feature.withdraw_detail.WithdrawDetailVo;
import java.util.Locale;

public class WithdrawDetailFragment
extends TioFragment {
    private WalletWithdrawDetailFragmentBinding binding;
    public final ObservableField<String> brief = new ObservableField((Object)"\u63d0\u73b0\u5230-\u6c11\u751f\u94f6\u884c(2934)");
    public final ObservableField<String> money_receive = new ObservableField((Object)"9.90");
    public final ObservableField<String> money_total = new ObservableField((Object)"\u00a510.00");
    public final ObservableField<String> money_fee = new ObservableField((Object)"\u00a50.01");
    public final ObservableField<String> serialNumber = new ObservableField((Object)"DE1897277FDDS17376GGF");
    public final ObservableField<String> bankInfo = new ObservableField((Object)"\u6c11\u751f\u94f6\u884c(2349)");
    public final ObservableField<String> submitTime = new ObservableField((Object)"2020-9-10  13:00:00");
    public final ObservableField<String> lastItem_key = new ObservableField((Object)"\u5230\u8d26\u65f6\u95f4");
    public final ObservableField<String> lastItem_value = new ObservableField((Object)"2020-9-10  13:00:00");

    @Nullable
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        this.binding = WalletWithdrawDetailFragmentBinding.inflate(inflater, container, false);
        return this.binding.getRoot();
    }

    public void onActivityCreated(@Nullable Bundle savedInstanceState) {
        super.onActivityCreated(savedInstanceState);
        this.binding.setData(this);
        this.resetUI();
        this.initUI();
    }

    private void initUI() {
        WithdrawDetailVo vo = this.getWithdrawDetailActivity().getDetailVo();
        this.brief.set((Object)String.format(Locale.getDefault(), "\u63d0\u73b0\u5230-%s(%s)", vo.bankName, vo.bankCardLast4No));
        this.money_receive.set((Object)vo.money_receive);
        this.money_total.set((Object)("\u00a5" + vo.money_total));
        this.money_fee.set((Object)("\u00a5" + vo.money_fee));
        this.serialNumber.set((Object)vo.serialNumber);
        this.bankInfo.set((Object)String.format(Locale.getDefault(), "%s(%s)", vo.bankName, vo.bankCardLast4No));
        this.submitTime.set((Object)vo.submitTime);
        if (WithholdStatus.isSuccess((String)vo.status)) {
            this.lastItem_key.set((Object)"\u5230\u8d26\u65f6\u95f4");
            this.lastItem_value.set((Object)vo.finishTime);
        } else {
            this.lastItem_key.set((Object)"\u63d0\u73b0\u5931\u8d25");
            this.lastItem_value.set((Object)vo.failedReason);
        }
        this.binding.tivBankIcon.loadUrl(vo.bankIcon);
        if ("SUCCESS".equals(vo.status)) {
            this.setStatus(1);
        } else if ("PROCESS".equals(vo.status)) {
            this.setStatus(2);
        } else {
            this.setStatus(3);
        }
    }

    private void resetUI() {
        this.brief.set((Object)"");
        this.money_receive.set((Object)"");
        this.money_total.set((Object)"");
        this.money_fee.set((Object)"");
        this.serialNumber.set((Object)"");
        this.bankInfo.set((Object)"");
        this.submitTime.set((Object)"");
        this.lastItem_key.set((Object)"");
        this.lastItem_value.set((Object)"");
        this.binding.tivBankIcon.loadUrl(null);
        this.setStatus(1);
    }

    public WithdrawDetailActivity getWithdrawDetailActivity() {
        return (WithdrawDetailActivity)this.getActivity();
    }

    private void setStatus(int status) {
        if (status == 1) {
            this.binding.ivPoint1.setImageResource(R.drawable.wallet_process_point_blue_light);
            this.binding.ivPoint2.setImageResource(R.drawable.wallet_process_point_blue_light);
            this.binding.ivPoint3.setImageResource(R.drawable.wallet_process_point_blue);
            this.binding.vLine1.setBackgroundColor(Color.parseColor((String)"#AFCFFF"));
            this.binding.vLine2.setBackgroundColor(Color.parseColor((String)"#AFCFFF"));
            this.binding.tvText1.setTextColor(Color.parseColor((String)"#888888"));
            this.binding.tvText2.setTextColor(Color.parseColor((String)"#888888"));
            this.binding.tvText3.setTextColor(Color.parseColor((String)"#333333"));
            this.binding.tvText1.setText((CharSequence)"\u63d0\u73b0\u7533\u8bf7");
            this.binding.tvText2.setText((CharSequence)"\u94f6\u884c\u5904\u7406\u4e2d");
            this.binding.tvText3.setText((CharSequence)"\u63d0\u73b0\u6210\u529f");
        } else if (status == 2) {
            this.binding.ivPoint1.setImageResource(R.drawable.wallet_process_point_blue_light);
            this.binding.ivPoint2.setImageResource(R.drawable.wallet_process_point_blue);
            this.binding.ivPoint3.setImageResource(R.drawable.wallet_process_point_gray);
            this.binding.vLine1.setBackgroundColor(Color.parseColor((String)"#AFCFFF"));
            this.binding.vLine2.setBackgroundColor(Color.parseColor((String)"#F1F1F1"));
            this.binding.tvText1.setTextColor(Color.parseColor((String)"#888888"));
            this.binding.tvText2.setTextColor(Color.parseColor((String)"#333333"));
            this.binding.tvText3.setTextColor(Color.parseColor((String)"#888888"));
            this.binding.tvText1.setText((CharSequence)"\u63d0\u73b0\u7533\u8bf7");
            this.binding.tvText2.setText((CharSequence)"\u94f6\u884c\u5904\u7406\u4e2d");
            this.binding.tvText3.setText((CharSequence)"\u63d0\u73b0\u6210\u529f");
        } else if (status == 3) {
            this.binding.ivPoint1.setImageResource(R.drawable.wallet_process_point_blue_light);
            this.binding.ivPoint2.setImageResource(R.drawable.wallet_process_point_blue_light);
            this.binding.ivPoint3.setImageResource(R.drawable.wallet_process_point_red);
            this.binding.vLine1.setBackgroundColor(Color.parseColor((String)"#AFCFFF"));
            this.binding.vLine2.setBackgroundColor(Color.parseColor((String)"#AFCFFF"));
            this.binding.tvText1.setTextColor(Color.parseColor((String)"#888888"));
            this.binding.tvText2.setTextColor(Color.parseColor((String)"#888888"));
            this.binding.tvText3.setTextColor(Color.parseColor((String)"#333333"));
            this.binding.tvText1.setText((CharSequence)"\u63d0\u73b0\u7533\u8bf7");
            this.binding.tvText2.setText((CharSequence)"\u94f6\u884c\u5904\u7406\u4e2d");
            this.binding.tvText3.setText((CharSequence)"\u63d0\u73b0\u5931\u8d25");
        }
    }
}

