/*
 * Decompiled with CFR 0.152.
 */
package com.watayouxiang.wallet.feature.withdraw.mvp;

import android.app.Activity;
import android.content.Context;
import com.blankj.utilcode.util.KeyboardUtils;
import com.ehking.sdk.wepay.interfaces.WalletPay;
import com.ehking.sdk.wepay.net.bean.AuthType;
import com.watayouxiang.androidutils.mvp.BaseModel;
import com.watayouxiang.androidutils.widget.TioToast;
import com.watayouxiang.httpclient.model.response.PayGetWalletInfoResp;
import com.watayouxiang.httpclient.model.response.PayWithholdResp;
import com.watayouxiang.wallet.feature.withdraw.mvp.Contract;
import com.watayouxiang.wallet.feature.withdraw.mvp.Model;
import com.watayouxiang.wallet.feature.withdraw_result.WithdrawResultActivity;
import com.watayouxiang.wallet.tools.MoneyUtils;

public class Presenter
extends Contract.Presenter {
    public Presenter(Contract.View view) {
        super(new Model(), view, false);
    }

    @Override
    public void init() {
        ((Contract.View)this.getView()).resetUI();
        this.getWalletInfo();
    }

    @Override
    public void getWalletInfo(final boolean withdrawAll) {
        ((Contract.Model)this.getModel()).getWalletInfo(new BaseModel.DataProxy<PayGetWalletInfoResp>(){

            public void onSuccess(PayGetWalletInfoResp resp) {
                super.onSuccess((Object)resp);
                String balance = resp.getBalance();
                String format = MoneyUtils.fen2yuan(balance);
                if (format == null) {
                    return;
                }
                ((Contract.View)Presenter.this.getView()).onMoneyResp(format);
                if (withdrawAll) {
                    ((Contract.View)Presenter.this.getView()).onWithdrawAllResp(format);
                }
            }

            public void onFailure(String msg) {
                super.onFailure(msg);
            }
        });
    }

    @Override
    public void getWalletInfo() {
        this.getWalletInfo(false);
    }

    @Override
    public void postWithdraw(String amount) {
        final String points = MoneyUtils.yuan2fen(amount);
        if (points == null) {
            TioToast.showShort((CharSequence)"\u91d1\u989d\u8f6c\u6362\u9519\u8bef");
            return;
        }
        ((Contract.Model)this.getModel()).postWithhold(new BaseModel.DataProxy<PayWithholdResp>(){

            public void onSuccess(PayWithholdResp payWithholdResp) {
                super.onSuccess((Object)payWithholdResp);
                Presenter.this.postWithhold$SDK(payWithholdResp, points);
            }

            public void onFailure(String msg) {
                super.onFailure(msg);
                TioToast.showShort((CharSequence)msg);
            }
        }, points);
    }

    private void postWithhold$SDK(PayWithholdResp resp, String points) {
        String merchantId = resp.getMerchantId();
        String walletId = resp.getWalletId();
        String token = resp.getToken();
        String serialNumber = resp.getSerialnumber();
        WalletPay walletPay = WalletPay.Companion.getInstance();
        walletPay.init(((Contract.View)this.getView()).getActivity());
        walletPay.setWalletPayCallback((source, status, errorMessage) -> {
            if ("SUCCESS".equals(status) || "PROCESS".equals(status)) {
                ((Contract.View)this.getView()).finish();
                WithdrawResultActivity.start((Context)((Contract.View)this.getView()).getActivity(), serialNumber);
                KeyboardUtils.hideSoftInput((Activity)((Contract.View)this.getView()).getActivity());
            } else {
                TioToast.showShort((CharSequence)errorMessage);
            }
        });
        walletPay.evoke(merchantId, walletId, token, AuthType.WITHHOLDING.name());
    }
}

