/*
 * Decompiled with CFR 0.152.
 */
package com.watayouxiang.wallet.feature.withdraw;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.graphics.Color;
import android.os.Bundle;
import android.text.Editable;
import android.text.InputFilter;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.view.View;
import android.widget.EditText;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.databinding.ObservableField;
import com.blankj.utilcode.util.KeyboardUtils;
import com.watayouxiang.androidutils.listener.SimpleTextWatcher;
import com.watayouxiang.androidutils.page.BindingLightActivity;
import com.watayouxiang.androidutils.utils.ClickUtils;
import com.watayouxiang.wallet.R;
import com.watayouxiang.wallet.databinding.WalletWithdrawActivityBinding;
import com.watayouxiang.wallet.feature.withdraw.mvp.Contract;
import com.watayouxiang.wallet.feature.withdraw.mvp.Presenter;
import com.watayouxiang.wallet.feature.withdraw_record.WithdrawRecordActivity;
import com.watayouxiang.wallet.tools.MoneyInputFilter;
import java.util.Locale;

public class WithdrawActivity
extends BindingLightActivity<WalletWithdrawActivityBinding>
implements Contract.View {
    public final ObservableField<String> amount = new ObservableField((Object)"");
    public final ObservableField<String> remainingRmb = new ObservableField((Object)"");
    private Presenter presenter;

    public static void start(Context context) {
        Intent starter = new Intent(context, WithdrawActivity.class);
        context.startActivity(starter);
    }

    @NonNull
    protected View statusBar_holder() {
        return ((WalletWithdrawActivityBinding)this.binding).statusBar;
    }

    protected int getContentViewId() {
        return R.layout.wallet_withdraw_activity;
    }

    protected Integer background_color() {
        return Color.parseColor((String)"#F8F8F8");
    }

    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        ((WalletWithdrawActivityBinding)this.binding).setData(this);
        this.presenter = new Presenter(this);
        this.presenter.init();
    }

    public void onResume(int count) {
        super.onResume(count);
        if (count > 1) {
            this.presenter.getWalletInfo();
        }
    }

    protected void onDestroy() {
        super.onDestroy();
        this.presenter.detachView();
    }

    private void clickWithdrawRecord(View view) {
        if (ClickUtils.isViewSingleClick((View)view)) {
            KeyboardUtils.hideSoftInput((Activity)this);
            WithdrawRecordActivity.start((Context)this);
        }
    }

    public void clickWithdrawAll(View view) {
        this.presenter.getWalletInfo(true);
    }

    public void clickWithdraw(View view) {
        if (ClickUtils.isViewSingleClick((View)view)) {
            this.presenter.postWithdraw((String)this.amount.get());
        }
    }

    public void clickClear(View view) {
        ((WalletWithdrawActivityBinding)this.binding).etAmount.setText((CharSequence)"");
    }

    @Override
    public void resetUI() {
        ((WalletWithdrawActivityBinding)this.binding).ivClear.setVisibility(8);
        ((WalletWithdrawActivityBinding)this.binding).etAmount.addTextChangedListener((TextWatcher)new SimpleTextWatcher(){

            public void onTextChanged(CharSequence s, int start, int before, int count) {
                super.onTextChanged(s, start, before, count);
                ((WalletWithdrawActivityBinding)((WithdrawActivity)WithdrawActivity.this).binding).ivClear.setVisibility(TextUtils.isEmpty((CharSequence)s) ? 8 : 0);
            }
        });
        ((WalletWithdrawActivityBinding)this.binding).etAmount.setFilters(new InputFilter[]{new MoneyInputFilter((EditText)((WalletWithdrawActivityBinding)this.binding).etAmount)});
        ((WalletWithdrawActivityBinding)this.binding).titleBar.getTvRight().setOnClickListener(this::clickWithdrawRecord);
        this.remainingRmb.set((Object)"\u5f53\u524d\u4f59\u989d--\u5143");
        KeyboardUtils.showSoftInput((View)((WalletWithdrawActivityBinding)this.binding).etAmount);
    }

    @Override
    public void onMoneyResp(String money) {
        this.remainingRmb.set((Object)String.format(Locale.getDefault(), "\u5f53\u524d\u4f59\u989d%s\u5143", money));
    }

    @Override
    public void onWithdrawAllResp(String money) {
        this.amount.set((Object)money);
        ((WalletWithdrawActivityBinding)this.binding).etAmount.postDelayed(() -> {
            int length = 0;
            Editable text = ((WalletWithdrawActivityBinding)this.binding).etAmount.getText();
            if (text != null) {
                length = text.length();
            }
            ((WalletWithdrawActivityBinding)this.binding).etAmount.setSelection(length);
        }, 100L);
    }
}

