/*
 * Decompiled with CFR 0.152.
 */
package com.watayouxiang.wallet.feature.wallet.mvp;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import com.blankj.utilcode.util.ToastUtils;
import com.ehking.sdk.wepay.interfaces.WalletPay;
import com.watayouxiang.androidutils.mvp.BaseModel;
import com.watayouxiang.androidutils.widget.TioToast;
import com.watayouxiang.httpclient.callback.TioCallback;
import com.watayouxiang.httpclient.model.request.PayGetClientTokenReq;
import com.watayouxiang.httpclient.model.request.PayOpenFlagReq;
import com.watayouxiang.httpclient.model.response.PayGetClientTokenResp;
import com.watayouxiang.httpclient.model.response.PayGetWalletInfoResp;
import com.watayouxiang.httpclient.model.response.PayOpenFlagResp;
import com.watayouxiang.wallet.feature.open.OpenWalletActivity;
import com.watayouxiang.wallet.feature.wallet.WalletActivity;
import com.watayouxiang.wallet.feature.wallet.mvp.Contract;
import com.watayouxiang.wallet.feature.wallet.mvp.Model;
import com.watayouxiang.wallet.tools.MoneyUtils;
import java.util.ArrayList;

public class Presenter
extends Contract.Presenter {
    private static final boolean isOnlySupportBalance = false;
    private WalletPay walletPay;

    public Presenter(Contract.View view) {
        super(new Model(), view, false);
    }

    public static void openWalletActivity(final Activity activity) {
        PayOpenFlagReq openFlagReq = new PayOpenFlagReq();
        openFlagReq.setCancelTag((Object)activity);
        openFlagReq.get((TioCallback)new TioCallback<PayOpenFlagResp>(){

            public void onTioSuccess(PayOpenFlagResp payOpenFlagResp) {
                int openflag = payOpenFlagResp.getOpenflag();
                if (openflag == 1) {
                    Intent starter = new Intent((Context)activity, WalletActivity.class);
                    activity.startActivity(starter);
                } else {
                    OpenWalletActivity.start(activity);
                }
            }

            public void onTioError(String msg) {
                ToastUtils.showShort((CharSequence)msg);
            }
        });
    }

    @Override
    public void init() {
        ((Contract.View)this.getView()).resetUI();
        this.initWalletPay();
        this.getWalletInfo();
    }

    private void initWalletPay() {
        this.walletPay = WalletPay.Companion.getInstance();
        this.walletPay.setDebug(false);
        this.walletPay.destroy();
        this.walletPay.init(((Contract.View)this.getView()).getActivity());
        this.walletPay.setIsRandomKeyboard(true);
        this.walletPay.setColor("#4C94FF");
        this.walletPay.setOnlySupportBalance(false, new ArrayList());
        this.walletPay.setWalletPayCallback((source, status, errorMessage) -> {
            if ("FAILURE".equals(status)) {
                if (errorMessage != null) {
                    TioToast.showShort((CharSequence)errorMessage);
                }
            } else if ("PROCESS".equals(status) || "SUCCESS".equals(status) || "CANCEL".equals(status)) {
                // empty if block
            }
        });
    }

    @Override
    public void query$ShowMoney() {
        this.getWalletInfo(true);
    }

    @Override
    public void getWalletInfo() {
        this.getWalletInfo(false);
    }

    private void getWalletInfo(final boolean mustShowMoney) {
        ((Contract.Model)this.getModel()).getWalletInfo(new BaseModel.DataProxy<PayGetWalletInfoResp>(){

            public void onSuccess(PayGetWalletInfoResp resp) {
                String balance;
                String format;
                super.onSuccess((Object)resp);
                if ((mustShowMoney || ((Contract.View)Presenter.this.getView()).isMoneyVisibility()) && (format = MoneyUtils.fen2yuan(balance = resp.getBalance())) != null) {
                    ((Contract.View)Presenter.this.getView()).showMoney(format);
                }
            }

            public void onFailure(String msg) {
                super.onFailure(msg);
                ToastUtils.showShort((CharSequence)msg);
            }
        });
    }

    @Override
    public void getClientToken(final @PayGetClientTokenReq.BizType String bizType) {
        ((Contract.Model)this.getModel()).getGetClientToken(bizType, new BaseModel.DataProxy<PayGetClientTokenResp>(){

            public void onSuccess(PayGetClientTokenResp payGetClientTokenResp) {
                super.onSuccess((Object)payGetClientTokenResp);
                Presenter.this.evoke$SDK(bizType, payGetClientTokenResp);
            }

            public void onFailure(String msg) {
                super.onFailure(msg);
                TioToast.showShort((CharSequence)msg);
            }
        });
    }

    private void evoke$SDK(String bizType, PayGetClientTokenResp resp) {
        this.walletPay.init(((Contract.View)this.getView()).getActivity());
        String merchantId = "894420924";
        String walletId = resp.getWalletId();
        String token = resp.getToken();
        this.walletPay.evoke(merchantId, walletId, token, bizType);
    }
}

