/*
 * Decompiled with CFR 0.152.
 */
package com.watayouxiang.wallet.feature.wallet;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.view.View;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.blankj.utilcode.util.SpanUtils;
import com.watayouxiang.androidutils.page.BindingDarkActivity;
import com.watayouxiang.androidutils.utils.ClickUtils;
import com.watayouxiang.wallet.R;
import com.watayouxiang.wallet.databinding.WalletWalletActivityBinding;
import com.watayouxiang.wallet.feature.account.AccountActivity;
import com.watayouxiang.wallet.feature.bill.BillActivity;
import com.watayouxiang.wallet.feature.recharge.RechargeActivity;
import com.watayouxiang.wallet.feature.redpacket.RedPacketActivity;
import com.watayouxiang.wallet.feature.wallet.mvp.Contract;
import com.watayouxiang.wallet.feature.wallet.mvp.Presenter;
import com.watayouxiang.wallet.feature.withdraw.WithdrawActivity;
import java.util.Locale;

public class WalletActivity
extends BindingDarkActivity<WalletWalletActivityBinding>
implements Contract.View {
    private Presenter presenter;

    public static void start(Activity activity) {
        Presenter.openWalletActivity(activity);
    }

    @NonNull
    protected View statusBar_holder() {
        return ((WalletWalletActivityBinding)this.binding).statusBar;
    }

    protected Integer background_color() {
        return -1;
    }

    protected int getContentViewId() {
        return R.layout.wallet_wallet_activity;
    }

    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        ((WalletWalletActivityBinding)this.binding).setView(this);
        this.presenter = new Presenter(this);
        this.presenter.init();
    }

    public void onResume(int count) {
        super.onResume(count);
        if (count > 1) {
            this.presenter.getWalletInfo();
        }
    }

    protected void onDestroy() {
        super.onDestroy();
        this.presenter.detachView();
    }

    public void clickEye(View v) {
        boolean moneyVisibility = this.isMoneyVisibility();
        if (moneyVisibility) {
            this.hideMoney();
        } else {
            this.presenter.query$ShowMoney();
        }
    }

    public void clickWithdraw(View v) {
        if (ClickUtils.isViewSingleClick((View)v)) {
            WithdrawActivity.start((Context)this);
        }
    }

    public void clickRecharge(View v) {
        if (ClickUtils.isViewSingleClick((View)v)) {
            RechargeActivity.start((Context)this);
        }
    }

    public void clickAccountDetail(View v) {
        if (ClickUtils.isViewSingleClick((View)v)) {
            AccountActivity.start((Context)this);
        }
    }

    public void clickWalletDetail(View v) {
        if (ClickUtils.isViewSingleClick((View)v)) {
            BillActivity.start((Context)this);
        }
    }

    public void clickRedPaperRecord(View v) {
        if (ClickUtils.isViewSingleClick((View)v)) {
            RedPacketActivity.start((Context)this);
        }
    }

    public void clickBank(View v) {
        if (ClickUtils.isGlobalSingleClick()) {
            this.presenter.getClientToken("ACCESS_CARDlIST");
        }
    }

    public void clickSafe(View v) {
        if (ClickUtils.isGlobalSingleClick()) {
            this.presenter.getClientToken("ACCESS_SAFETY");
        }
    }

    public void clickHelp(View v) {
    }

    @Override
    public void resetUI() {
        ((WalletWalletActivityBinding)this.binding).tvBottomInfo.setText((CharSequence)String.format(Locale.getDefault(), "\u672c\u670d\u52a1\u7531%s\u63d0\u4f9b", "\u9996\u4fe1\u6613\u652f\u4ed8"));
        this.hideMoney();
        ((WalletWalletActivityBinding)this.binding).rlHelp.setVisibility(8);
    }

    @Override
    public boolean isMoneyVisibility() {
        return ((WalletWalletActivityBinding)this.binding).tvMoneyEye.isSelected();
    }

    @Override
    public void hideMoney() {
        ((WalletWalletActivityBinding)this.binding).tvMoneyEye.setSelected(false);
        SpanUtils.with((TextView)((WalletWalletActivityBinding)this.binding).tvMoney).append((CharSequence)"******").setFontSize(26, true).create();
    }

    @Override
    public void showMoney(String money) {
        ((WalletWalletActivityBinding)this.binding).tvMoneyEye.setSelected(true);
        SpanUtils.with((TextView)((WalletWalletActivityBinding)this.binding).tvMoney).append((CharSequence)"\u00a5 ").setFontSize(16, true).append((CharSequence)money).setFontSize(26, true).create();
    }
}

