/*
 * Decompiled with CFR 0.152.
 */
package com.watayouxiang.wallet.feature.redpaper.feature.single;

import android.app.Activity;
import androidx.lifecycle.ViewModel;
import com.ehking.sdk.wepay.interfaces.WalletPay;
import com.ehking.sdk.wepay.net.bean.AuthType;
import com.watayouxiang.androidutils.widget.TioToast;
import com.watayouxiang.httpclient.callback.TioCallback;
import com.watayouxiang.httpclient.model.request.PaySendRedPacketReq;
import com.watayouxiang.httpclient.model.response.PaySendRedPacketResp;
import com.watayouxiang.wallet.feature.redpaper.RedPaperActivity;
import com.watayouxiang.wallet.feature.redpaper.feature.single.SingleFragment;
import com.watayouxiang.wallet.tools.MoneyUtils;
import java.math.BigDecimal;

public class SingleViewModel
extends ViewModel {
    public void postSendRedPacket(final SingleFragment fragment) {
        RedPaperActivity activity = fragment.getRedPaperActivity();
        String packetType = "1";
        String chatlinkid = activity.getRedPaperVo().chatlinkid;
        String singleAmount = MoneyUtils.yuan2fen((String)fragment.money.get());
        String packetCount = (String)fragment.amount.get();
        String amount = this.getAmount(singleAmount, packetCount);
        String remark = fragment.getGiftTxt();
        PaySendRedPacketReq paySendRedPacketReq = new PaySendRedPacketReq(packetType, amount, chatlinkid, singleAmount, packetCount, remark);
        paySendRedPacketReq.setCancelTag((Object)activity);
        paySendRedPacketReq.post((TioCallback)new TioCallback<PaySendRedPacketResp>(){

            public void onTioSuccess(PaySendRedPacketResp paySendRedPacketResp) {
                SingleViewModel.this.evoke$SDK(paySendRedPacketResp, fragment);
            }

            public void onTioError(String msg) {
                TioToast.showShort((CharSequence)msg);
            }
        });
    }

    private void evoke$SDK(PaySendRedPacketResp resp, SingleFragment fragment) {
        String merchantId = resp.getMerchantId();
        String walletId = resp.getWalletId();
        String token = resp.getToken();
        WalletPay walletPay = WalletPay.Companion.getInstance();
        walletPay.init((Activity)fragment.getRedPaperActivity());
        walletPay.setWalletPayCallback((source, status, errorMessage) -> {
            if ("SUCCESS".equals(status) || "PROCESS".equals(status)) {
                fragment.finish();
            } else {
                TioToast.showShort((CharSequence)errorMessage);
            }
        });
        walletPay.evoke(merchantId, walletId, token, AuthType.REDPACKET.name());
    }

    private String getAmount(String singleAmount, String packetCount) {
        BigDecimal _singleAmount = new BigDecimal(singleAmount);
        BigDecimal _packetCount = new BigDecimal(packetCount);
        BigDecimal temp = _singleAmount.multiply(_packetCount);
        return temp.toString();
    }
}

