/*
 * Decompiled with CFR 0.152.
 */
package com.watayouxiang.wallet.feature.redpaper.feature.pin;

import android.app.Activity;
import androidx.lifecycle.ViewModel;
import com.ehking.sdk.wepay.interfaces.WalletPay;
import com.ehking.sdk.wepay.net.bean.AuthType;
import com.watayouxiang.androidutils.widget.TioToast;
import com.watayouxiang.httpclient.callback.TioCallback;
import com.watayouxiang.httpclient.model.request.PaySendRedPacketReq;
import com.watayouxiang.httpclient.model.response.PaySendRedPacketResp;
import com.watayouxiang.wallet.feature.redpaper.RedPaperActivity;
import com.watayouxiang.wallet.feature.redpaper.feature.pin.PinFragment;
import com.watayouxiang.wallet.tools.MoneyUtils;

public class PinViewModel
extends ViewModel {
    public void postSendRedPacket(final PinFragment fragment) {
        try {
            double _totalMoney = Double.parseDouble((String)fragment.money.get()) * 100.0;
            double _amount = Double.parseDouble((String)fragment.amount.get());
            if (_totalMoney < _amount * 1.0) {
                TioToast.showShort((CharSequence)"\u8fd9\u70b9\u513f\u7ea2\u5305\u4e0d\u591f\u4ed6\u4eec\u5206\u7684");
                return;
            }
        }
        catch (Exception _totalMoney) {
            // empty catch block
        }
        String packetType = "2";
        String amount = MoneyUtils.yuan2fen((String)fragment.money.get());
        RedPaperActivity activity = fragment.getRedPaperActivity();
        String chatlinkid = activity.getRedPaperVo().chatlinkid;
        String singleAmount = null;
        String packetCount = (String)fragment.amount.get();
        String remark = fragment.getGiftTxt();
        PaySendRedPacketReq paySendRedPacketReq = new PaySendRedPacketReq(packetType, amount, chatlinkid, singleAmount, packetCount, remark);
        paySendRedPacketReq.setCancelTag((Object)activity);
        paySendRedPacketReq.post((TioCallback)new TioCallback<PaySendRedPacketResp>(){

            public void onTioSuccess(PaySendRedPacketResp paySendRedPacketResp) {
                PinViewModel.this.evoke$SDK(paySendRedPacketResp, fragment);
            }

            public void onTioError(String msg) {
                TioToast.showShort((CharSequence)msg);
            }
        });
    }

    private void evoke$SDK(PaySendRedPacketResp resp, PinFragment fragment) {
        String merchantId = resp.getMerchantId();
        String walletId = resp.getWalletId();
        String token = resp.getToken();
        WalletPay walletPay = WalletPay.Companion.getInstance();
        walletPay.init((Activity)fragment.getRedPaperActivity());
        walletPay.setWalletPayCallback((source, status, errorMessage) -> {
            if ("SUCCESS".equals(status) || "PROCESS".equals(status)) {
                fragment.finish();
            } else {
                TioToast.showShort((CharSequence)errorMessage);
            }
        });
        walletPay.evoke(merchantId, walletId, token, AuthType.REDPACKET.name());
    }
}

