/*
 * Decompiled with CFR 0.152.
 */
package com.watayouxiang.wallet.feature.redpaper.feature.p2p;

import android.os.Bundle;
import android.text.InputFilter;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.databinding.ObservableField;
import com.watayouxiang.androidutils.page.TioFragment;
import com.watayouxiang.androidutils.utils.ClickUtils;
import com.watayouxiang.imclient.TioIMClient;
import com.watayouxiang.imclient.model.body.wx.WxChatItemInfoReq;
import com.watayouxiang.imclient.model.body.wx.WxChatItemInfoResp;
import com.watayouxiang.imclient.packet.TioPacket;
import com.watayouxiang.imclient.packet.TioPacketBuilder;
import com.watayouxiang.wallet.databinding.WalletRedpaperP2pFragmentBinding;
import com.watayouxiang.wallet.feature.redpaper.RedPaperActivity;
import com.watayouxiang.wallet.feature.redpaper.feature.p2p.P2PViewModel;
import com.watayouxiang.wallet.tools.MoneyInputFilter;
import java.util.Locale;
import org.greenrobot.eventbus.Subscribe;
import org.greenrobot.eventbus.ThreadMode;

public class P2PFragment
extends TioFragment {
    public final ObservableField<String> money = new ObservableField((Object)"");
    public final ObservableField<String> moneyHint = new ObservableField((Object)"\u8f93\u5165\u603b\u91d1\u989d");
    public final ObservableField<String> gift = new ObservableField((Object)"");
    public final ObservableField<String> giftHint = new ObservableField((Object)"\u606d\u559c\u53d1\u8d22\uff0c\u5409\u7965\u5982\u610f");
    public final ObservableField<String> toWhoInfo = new ObservableField((Object)"\u53d1\u7ed9 \u5c0f\u751f");
    private WalletRedpaperP2pFragmentBinding binding;
    private P2PViewModel viewModel;
    private String chatLinkId;

    public static P2PFragment newInstance() {
        return new P2PFragment();
    }

    public View onCreateView(@NonNull LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        this.binding = WalletRedpaperP2pFragmentBinding.inflate(inflater, container, false);
        return this.binding.getRoot();
    }

    public void onActivityCreated(@Nullable Bundle savedInstanceState) {
        super.onActivityCreated(savedInstanceState);
        TioIMClient.getInstance().getEventEngine().register((Object)this);
        this.binding.setData(this);
        this.viewModel = (P2PViewModel)this.newViewModel(P2PViewModel.class);
        this.binding.etMoney.setFilters(new InputFilter[]{new MoneyInputFilter(this.binding.etMoney)});
        this.toWhoInfo.set((Object)"");
        this.getChatInfo(this.getRedPaperActivity().getRedPaperVo().chatlinkid);
    }

    public void onDestroyView() {
        super.onDestroyView();
        TioIMClient.getInstance().getEventEngine().unregister((Object)this);
    }

    private void getChatInfo(String chatLinkId) {
        this.chatLinkId = chatLinkId;
        TioPacket wxChatItemInfoReq = TioPacketBuilder.getWxChatItemInfoReq((WxChatItemInfoReq)new WxChatItemInfoReq(chatLinkId));
        TioIMClient.getInstance().sendPacket(wxChatItemInfoReq);
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void onChatInfoResp(WxChatItemInfoResp resp) {
        if (!resp.chatlinkid.equals(this.chatLinkId)) {
            return;
        }
        WxChatItemInfoResp.DataBean data = resp.data;
        this.toWhoInfo.set((Object)String.format(Locale.getDefault(), "\u53d1\u7ed9 %s", data.name));
    }

    public void clickOkBtn(View view) {
        if (ClickUtils.isViewSingleClick((View)view)) {
            this.viewModel.postSendRedPacket(this);
        }
    }

    public RedPaperActivity getRedPaperActivity() {
        return (RedPaperActivity)this.getActivity();
    }

    public String getGiftTxt() {
        String _gift = (String)this.gift.get();
        String _giftHint = (String)this.giftHint.get();
        if (!TextUtils.isEmpty((CharSequence)_gift)) {
            return _gift;
        }
        return _giftHint;
    }
}

