/*
 * Decompiled with CFR 0.152.
 */
package com.watayouxiang.wallet.feature.redpacket.feature.send;

import androidx.lifecycle.ViewModel;
import com.blankj.utilcode.util.StringUtils;
import com.watayouxiang.androidutils.widget.TioToast;
import com.watayouxiang.httpclient.callback.TioCallback;
import com.watayouxiang.httpclient.model.request.PaySendRedPacketListReq;
import com.watayouxiang.httpclient.model.request.PaySendRedPacketStatReq;
import com.watayouxiang.httpclient.model.response.PaySendRedPacketListResp;
import com.watayouxiang.httpclient.model.response.PaySendRedPacketStatResp;
import com.watayouxiang.wallet.feature.redpacket.RedPacketActivity;
import com.watayouxiang.wallet.feature.redpacket.feature.send.SendFragment;
import com.watayouxiang.wallet.feature.redpacket.feature.send.adapter.PacketItem;
import com.watayouxiang.wallet.feature.redpacket.feature.send.adapter.SendModel;
import com.watayouxiang.wallet.tools.MoneyUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public class SendViewModel
extends ViewModel {
    private int pageNumber;

    public void refreshData(SendFragment fragment) {
        this.getSendRedPacketList(fragment, 1);
        this.getSendRedPacketStat(fragment);
    }

    public void loadMoreData(SendFragment fragment) {
        this.getSendRedPacketList(fragment, ++this.pageNumber);
    }

    private void getSendRedPacketStat(final SendFragment fragment) {
        RedPacketActivity activity = fragment.getRedPacketActivity();
        String period = activity.getPeriod();
        PaySendRedPacketStatReq sendRedPacketStatReq = new PaySendRedPacketStatReq(period);
        sendRedPacketStatReq.setCancelTag((Object)this);
        sendRedPacketStatReq.get((TioCallback)new TioCallback<PaySendRedPacketStatResp>(){

            public void onTioSuccess(PaySendRedPacketStatResp resp) {
                fragment.onHeaderInfoResp(resp);
            }

            public void onTioError(String msg) {
                TioToast.showShort((CharSequence)msg);
            }
        });
    }

    private void getSendRedPacketList(final SendFragment fragment, final int pageNumber) {
        this.pageNumber = pageNumber;
        RedPacketActivity activity = fragment.getRedPacketActivity();
        String period = activity.getPeriod();
        PaySendRedPacketListReq sendRedPacketListReq = new PaySendRedPacketListReq(pageNumber + "", period);
        sendRedPacketListReq.setCancelTag((Object)fragment.getRedPacketActivity());
        sendRedPacketListReq.get((TioCallback)new TioCallback<PaySendRedPacketListResp>(){

            public void onTioSuccess(PaySendRedPacketListResp resp) {
                List list = resp.getList();
                int size = list.size();
                boolean firstPage = resp.isFirstPage();
                boolean lastPage = resp.isLastPage();
                ArrayList<PacketItem> items = new ArrayList<PacketItem>(size);
                for (int i = 0; i < size; ++i) {
                    PaySendRedPacketListResp.ListBean bean = (PaySendRedPacketListResp.ListBean)list.get(i);
                    PacketItem item = new PacketItem();
                    item.setTitleTxt(bean.getMode() == 2 ? "\u62fc\u4eba\u54c1\u7ea2\u5305" : "\u666e\u901a\u7ea2\u5305");
                    item.setSubtitleTxt(StringUtils.null2Length0((String)bean.getBizcreattime()));
                    item.setAmountInfoTxt(String.format(Locale.getDefault(), "%d/%d\u4e2a", bean.getReceivedcount(), bean.getPacketcount()));
                    item.setMoneyInfoTxt(String.format(Locale.getDefault(), "%s\u5143", MoneyUtils.fen2yuan(bean.getAmount() + "")));
                    item.setTimeoutRed("TIMEOUT".equals(bean.getStatus()));
                    items.add(item);
                }
                List models = SendViewModel.this.items2Models(items);
                if (firstPage) {
                    fragment.setRefreshData(models);
                    fragment.binding.swipeRefreshLayout.setRefreshing(false);
                } else {
                    fragment.listAdapter.addData(models);
                }
                if (lastPage) {
                    fragment.listAdapter.loadMoreEnd();
                } else {
                    fragment.listAdapter.loadMoreComplete();
                }
            }

            public void onTioError(String msg) {
                TioToast.showShort((CharSequence)msg);
                if (pageNumber <= 1) {
                    fragment.binding.swipeRefreshLayout.setRefreshing(false);
                } else {
                    fragment.listAdapter.loadMoreFail();
                }
            }
        });
    }

    private List<SendModel> items2Models(List<PacketItem> packetItems) {
        ArrayList<SendModel> models = new ArrayList<SendModel>();
        for (int i = 0; i < packetItems.size(); ++i) {
            PacketItem packetItem = packetItems.get(i);
            SendModel sendModel = new SendModel(packetItem);
            models.add(sendModel);
        }
        return models;
    }
}

