/*
 * Decompiled with CFR 0.152.
 */
package com.watayouxiang.wallet.feature.redpacket.feature.send;

import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.databinding.ObservableField;
import androidx.lifecycle.ViewModelProvider;
import androidx.lifecycle.ViewModelStoreOwner;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import androidx.swiperefreshlayout.widget.SwipeRefreshLayout;
import com.blankj.utilcode.util.CollectionUtils;
import com.blankj.utilcode.util.StringUtils;
import com.watayouxiang.androidutils.page.TioFragment;
import com.watayouxiang.httpclient.model.response.PaySendRedPacketStatResp;
import com.watayouxiang.httpclient.preferences.HttpCache;
import com.watayouxiang.wallet.R;
import com.watayouxiang.wallet.databinding.WalletRedpacketSendFragmentBinding;
import com.watayouxiang.wallet.feature.redpacket.RedPacketActivity;
import com.watayouxiang.wallet.feature.redpacket.feature.send.SendViewModel;
import com.watayouxiang.wallet.feature.redpacket.feature.send.adapter.SendListAdapter;
import com.watayouxiang.wallet.feature.redpacket.feature.send.adapter.SendModel;
import com.watayouxiang.wallet.tools.MoneyUtils;
import java.util.List;
import java.util.Locale;

public class SendFragment
extends TioFragment
implements SwipeRefreshLayout.OnRefreshListener {
    public WalletRedpacketSendFragmentBinding binding;
    public SendListAdapter listAdapter;
    private SendViewModel viewModel;
    public final ObservableField<String> userInfo = new ObservableField((Object)"\u674e\u6e1d\u5171\u53d1\u51fa");
    public final ObservableField<String> money = new ObservableField((Object)"83.05");
    public final ObservableField<String> packetAmount = new ObservableField((Object)"152\u4e2a");

    public static SendFragment newInstance() {
        return new SendFragment();
    }

    public View onCreateView(@NonNull LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        this.binding = WalletRedpacketSendFragmentBinding.inflate(inflater, container, false);
        return this.binding.getRoot();
    }

    public void onActivityCreated(@Nullable Bundle savedInstanceState) {
        super.onActivityCreated(savedInstanceState);
        this.binding.setData(this);
        this.viewModel = (SendViewModel)new ViewModelProvider((ViewModelStoreOwner)this).get(SendViewModel.class);
        this.resetUI();
        this.onRefresh();
    }

    private void resetUI() {
        this.binding.recyclerView.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager(this.getContext()));
        this.listAdapter = new SendListAdapter(null);
        this.listAdapter.setOnLoadMoreListener(() -> this.viewModel.loadMoreData(this), this.binding.recyclerView);
        this.binding.recyclerView.setAdapter((RecyclerView.Adapter)this.listAdapter);
        this.binding.swipeRefreshLayout.setOnRefreshListener((SwipeRefreshLayout.OnRefreshListener)this);
        this.getRedPacketActivity().setOnSpinnerSelectedListener(this::onRefresh);
        this.binding.ivAvatar.loadUrlStatic_radius(null, 6.0f);
        this.userInfo.set((Object)"");
        this.money.set((Object)"");
        this.packetAmount.set((Object)"");
    }

    public void onRefresh() {
        this.viewModel.refreshData(this);
    }

    public void setRefreshData(List<SendModel> models) {
        this.listAdapter.setNewData(models);
        if (CollectionUtils.isEmpty(models)) {
            View notDataView = this.getLayoutInflater().inflate(R.layout.wallet_redpacket_list_empty, (ViewGroup)this.binding.recyclerView.getParent(), false);
            this.listAdapter.setEmptyView(notDataView);
        }
    }

    public RedPacketActivity getRedPacketActivity() {
        return (RedPacketActivity)this.getActivity();
    }

    public void onHeaderInfoResp(PaySendRedPacketStatResp resp) {
        int amount = resp.getAmount();
        String redNum = resp.getNum();
        String nick = resp.getNick();
        this.money.set((Object)MoneyUtils.fen2yuan(amount + ""));
        this.packetAmount.set((Object)String.format(Locale.getDefault(), "%s\u4e2a", StringUtils.null2Length0((String)redNum)));
        this.userInfo.set((Object)String.format(Locale.getDefault(), "%s\u5171\u53d1\u51fa", StringUtils.null2Length0((String)nick)));
        this.binding.ivAvatar.loadUrlStatic_radius(HttpCache.getResUrl((String)resp.getAvatar()), 6.0f);
    }
}

