/*
 * Decompiled with CFR 0.152.
 */
package com.watayouxiang.wallet.feature.redpacket.feature.receive;

import androidx.lifecycle.ViewModel;
import com.blankj.utilcode.util.StringUtils;
import com.watayouxiang.androidutils.widget.TioToast;
import com.watayouxiang.httpclient.callback.TioCallback;
import com.watayouxiang.httpclient.model.request.PayGrabRedPacketListReq;
import com.watayouxiang.httpclient.model.request.PayGrabRedPacketStatReq;
import com.watayouxiang.httpclient.model.response.PayGrabRedPacketListResp;
import com.watayouxiang.httpclient.model.response.PayGrabRedPacketStatResp;
import com.watayouxiang.httpclient.preferences.HttpCache;
import com.watayouxiang.wallet.feature.redpacket.RedPacketActivity;
import com.watayouxiang.wallet.feature.redpacket.feature.receive.ReceiveFragment;
import com.watayouxiang.wallet.feature.redpacket.feature.receive.adapter.PacketItem;
import com.watayouxiang.wallet.feature.redpacket.feature.receive.adapter.ReceiveModel;
import com.watayouxiang.wallet.tools.MoneyUtils;
import java.util.ArrayList;
import java.util.List;

public class ReceiveViewModel
extends ViewModel {
    private int pageNumber;

    public void refreshData(ReceiveFragment fragment) {
        this.getGrabRedPacketList(fragment, 1);
        this.getGrabRedPacketStat(fragment);
    }

    private void getGrabRedPacketStat(final ReceiveFragment fragment) {
        RedPacketActivity activity = fragment.getRedPacketActivity();
        String period = activity.getPeriod();
        PayGrabRedPacketStatReq grabRedPacketStatReq = new PayGrabRedPacketStatReq(period);
        grabRedPacketStatReq.setCancelTag((Object)this);
        grabRedPacketStatReq.get((TioCallback)new TioCallback<PayGrabRedPacketStatResp>(){

            public void onTioSuccess(PayGrabRedPacketStatResp resp) {
                fragment.onHeaderInfoResp(resp);
            }

            public void onTioError(String msg) {
                TioToast.showShort((CharSequence)msg);
            }
        });
    }

    public void loadMoreData(ReceiveFragment fragment) {
        this.getGrabRedPacketList(fragment, ++this.pageNumber);
    }

    private void getGrabRedPacketList(final ReceiveFragment fragment, final int pageNumber) {
        this.pageNumber = pageNumber;
        RedPacketActivity activity = fragment.getRedPacketActivity();
        String period = activity.getPeriod();
        PayGrabRedPacketListReq grabRedPacketListReq = new PayGrabRedPacketListReq(String.valueOf(pageNumber), period);
        grabRedPacketListReq.setCancelTag((Object)activity);
        grabRedPacketListReq.get((TioCallback)new TioCallback<PayGrabRedPacketListResp>(){

            public void onTioSuccess(PayGrabRedPacketListResp resp) {
                List list = resp.getList();
                int size = list.size();
                boolean firstPage = resp.isFirstPage();
                boolean lastPage = resp.isLastPage();
                ArrayList<PacketItem> items = new ArrayList<PacketItem>();
                for (int i = 0; i < size; ++i) {
                    PayGrabRedPacketListResp.ListBean bean = (PayGrabRedPacketListResp.ListBean)list.get(i);
                    PacketItem item = new PacketItem();
                    item.setTitleTxt(StringUtils.null2Length0((String)bean.getNick()));
                    item.setSubtitleTxt(StringUtils.null2Length0((String)bean.getBizcompletetime()));
                    item.setMoneyInfoTxt(MoneyUtils.fen2yuan(bean.getAmount() + "") + "\u5143");
                    item.setPin(bean.getMode() == 2);
                    item.setAvatarUrl(HttpCache.getResUrl((String)bean.getAvatar()));
                    items.add(item);
                }
                List models = ReceiveViewModel.this.items2Models(items);
                if (firstPage) {
                    fragment.setRefreshData(models);
                    fragment.binding.swipeRefreshLayout.setRefreshing(false);
                } else {
                    fragment.listAdapter.addData(models);
                }
                if (lastPage) {
                    fragment.listAdapter.loadMoreEnd();
                } else {
                    fragment.listAdapter.loadMoreComplete();
                }
            }

            public void onTioError(String msg) {
                TioToast.showShort((CharSequence)msg);
                if (pageNumber <= 1) {
                    fragment.binding.swipeRefreshLayout.setRefreshing(false);
                } else {
                    fragment.listAdapter.loadMoreFail();
                }
            }
        });
    }

    private List<ReceiveModel> items2Models(List<PacketItem> packetItems) {
        int size = packetItems.size();
        ArrayList<ReceiveModel> models = new ArrayList<ReceiveModel>(size);
        for (int i = 0; i < size; ++i) {
            PacketItem packetItem = packetItems.get(i);
            ReceiveModel receiveModel = new ReceiveModel(packetItem);
            models.add(receiveModel);
        }
        return models;
    }
}

