/*
 * Decompiled with CFR 0.152.
 */
package com.watayouxiang.wallet.feature.redpacket;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.view.View;
import android.widget.AdapterView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.viewpager.widget.PagerAdapter;
import com.blankj.utilcode.util.ArrayUtils;
import com.blankj.utilcode.util.TimeUtils;
import com.watayouxiang.androidutils.page.BindingDarkActivity;
import com.watayouxiang.wallet.R;
import com.watayouxiang.wallet.databinding.WalletRedpacketActivityBinding;
import com.watayouxiang.wallet.feature.redpacket.adapter.RedPacketFragmentAdapter;
import com.watayouxiang.wallet.feature.redpacket.adapter.RedPacketTabAdapter;
import java.util.ArrayList;
import java.util.List;

public class RedPacketActivity
extends BindingDarkActivity<WalletRedpacketActivityBinding> {
    private String spinnerValue;
    private final List<OnSpinnerSelectedListener> listeners = new ArrayList<OnSpinnerSelectedListener>(2);

    public static void start(Context context) {
        Intent starter = new Intent(context, RedPacketActivity.class);
        context.startActivity(starter);
    }

    protected Integer background_color() {
        return -1;
    }

    @NonNull
    protected View statusBar_holder() {
        return ((WalletRedpacketActivityBinding)this.binding).statusBar;
    }

    public Integer statusBar_color() {
        return this.getResources().getColor(R.color.red_ff5e5e);
    }

    protected int getContentViewId() {
        return R.layout.wallet_redpacket_activity;
    }

    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        ((WalletRedpacketActivityBinding)this.binding).setData(this);
        this.resetUI();
    }

    protected void onDestroy() {
        super.onDestroy();
        this.listeners.clear();
    }

    private void resetUI() {
        String[] spinnerItems = this.getSpinnerItems();
        if (ArrayUtils.isEmpty((Object)spinnerItems)) {
            return;
        }
        ((WalletRedpacketActivityBinding)this.binding).vpPager.setAdapter((PagerAdapter)new RedPacketFragmentAdapter(this.getSupportFragmentManager()));
        RedPacketTabAdapter tabAdapter = new RedPacketTabAdapter(((WalletRedpacketActivityBinding)this.binding).rvIndicator);
        tabAdapter.setViewPager(((WalletRedpacketActivityBinding)this.binding).vpPager);
        this.spinnerValue = spinnerItems[0];
        ((WalletRedpacketActivityBinding)this.binding).titleBar.setSpinnerRight_data(spinnerItems);
        ((WalletRedpacketActivityBinding)this.binding).titleBar.setSpinnerRight_onItemSelectedListener(new AdapterView.OnItemSelectedListener(){

            public void onItemSelected(AdapterView<?> adapterView, View view, int position, long id2) {
                RedPacketActivity.this.spinnerValue = adapterView.getItemAtPosition(position).toString();
                for (OnSpinnerSelectedListener l : RedPacketActivity.this.listeners) {
                    l.onItemSelected();
                }
            }

            public void onNothingSelected(AdapterView<?> adapterView) {
            }
        });
    }

    private String[] getSpinnerItems() {
        int currYear = TimeUtils.getValueByCalendarField((int)1);
        ArrayList<String> yearArr = new ArrayList<String>();
        for (int i = 0; i < 5; ++i) {
            int _year = currYear - i;
            if (_year < 2020) continue;
            yearArr.add(_year + "\u5e74");
        }
        return yearArr.toArray(new String[0]);
    }

    public String getPeriod() {
        if (this.spinnerValue != null) {
            return this.spinnerValue.replace("\u5e74", "");
        }
        return null;
    }

    public void setOnSpinnerSelectedListener(OnSpinnerSelectedListener l) {
        this.listeners.add(l);
    }

    public static interface OnSpinnerSelectedListener {
        public void onItemSelected();
    }
}

