/*
 * Decompiled with CFR 0.152.
 */
package com.watayouxiang.wallet.feature.recharge_result;

import androidx.lifecycle.ViewModel;
import com.blankj.utilcode.util.StringUtils;
import com.watayouxiang.androidutils.page.TioFragment;
import com.watayouxiang.androidutils.widget.TioToast;
import com.watayouxiang.httpclient.TioHttpClient;
import com.watayouxiang.httpclient.callback.TioCallback;
import com.watayouxiang.httpclient.model.request.PayRechargeQueryReq;
import com.watayouxiang.httpclient.model.response.PayRechargeQueryResp;
import com.watayouxiang.wallet.feature.recharge_result.RechargeResult;
import com.watayouxiang.wallet.feature.recharge_result.RechargeResultActivity;
import com.watayouxiang.wallet.feature.recharge_result.fragment.FailedFragment;
import com.watayouxiang.wallet.feature.recharge_result.fragment.ProcessFragment;
import com.watayouxiang.wallet.feature.recharge_result.fragment.SuccessFragment;
import com.watayouxiang.wallet.tools.MoneyUtils;

public class RechargeResultViewModel
extends ViewModel {
    private RechargeResult rechargeResult;

    public void getRechargeQuery(String serialNumber, final RechargeResultActivity activity) {
        PayRechargeQueryReq rechargeQueryReq = new PayRechargeQueryReq(serialNumber);
        rechargeQueryReq.setCancelTag((Object)this);
        rechargeQueryReq.get((TioCallback)new TioCallback<PayRechargeQueryResp>(){

            public void onTioSuccess(PayRechargeQueryResp resp) {
                RechargeResultViewModel.this.processRechargeQuery(resp, activity);
            }

            public void onTioError(String msg) {
                TioToast.showShort((CharSequence)msg);
            }
        });
    }

    private void processRechargeQuery(PayRechargeQueryResp resp, RechargeResultActivity activity) {
        TioFragment fragment;
        RechargeResult rechargeResult;
        String status = resp.getStatus();
        String amount = MoneyUtils.fen2yuan(resp.getAmount());
        String orderErrorMsg = StringUtils.null2Length0((String)resp.getOrdererrormsg());
        if ("SUCCESS".equals(status)) {
            rechargeResult = RechargeResult.getSuccess(amount);
            fragment = new SuccessFragment();
        } else if ("PROCESS".equals(status)) {
            rechargeResult = RechargeResult.getProcess(amount);
            fragment = new ProcessFragment();
        } else if ("FAIL".equals(status)) {
            rechargeResult = RechargeResult.getFailed(amount, orderErrorMsg);
            fragment = new FailedFragment();
        } else {
            rechargeResult = RechargeResult.getFailed("", "\u672a\u77e5\u5145\u503c\u7ed3\u679c");
            fragment = new FailedFragment();
        }
        this.rechargeResult = rechargeResult;
        activity.replaceFragment(fragment);
    }

    protected void onCleared() {
        super.onCleared();
        TioHttpClient.cancel((Object)((Object)this));
    }

    public RechargeResult getRechargeResult() {
        return this.rechargeResult;
    }
}

